/* persona-store.c generated by valac 0.24.0.66-d728a, the Vala compiler
 * generated from persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks-internal.h>


#define FOLKS_TYPE_PERSONA_STORE_TRUST (folks_persona_store_trust_get_type ())

#define FOLKS_TYPE_PERSONA_DETAIL (folks_persona_detail_get_type ())

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
typedef struct _FolksPersonaStorePrivate FolksPersonaStorePrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_TYPE_MAYBE_BOOL (folks_maybe_bool_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON (folks_group_details_change_reason_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksPersonaStoreFlushData FolksPersonaStoreFlushData;

typedef enum  {
	FOLKS_PERSONA_STORE_TRUST_NONE,
	FOLKS_PERSONA_STORE_TRUST_PARTIAL,
	FOLKS_PERSONA_STORE_TRUST_FULL
} FolksPersonaStoreTrust;

/**
 * Errors from {@link PersonaStore}s.
 */
typedef enum  {
	FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT,
	FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER,
	FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE,
	FOLKS_PERSONA_STORE_ERROR_READ_ONLY,
	FOLKS_PERSONA_STORE_ERROR_PERMISSION_DENIED,
	FOLKS_PERSONA_STORE_ERROR_REMOVE_FAILED,
	FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_NON_USER
} FolksPersonaStoreError;
#define FOLKS_PERSONA_STORE_ERROR folks_persona_store_error_quark ()
typedef enum  {
	FOLKS_PERSONA_DETAIL_INVALID = -1,
	FOLKS_PERSONA_DETAIL_ALIAS = 0,
	FOLKS_PERSONA_DETAIL_AVATAR,
	FOLKS_PERSONA_DETAIL_BIRTHDAY,
	FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_FULL_NAME,
	FOLKS_PERSONA_DETAIL_GENDER,
	FOLKS_PERSONA_DETAIL_IM_ADDRESSES,
	FOLKS_PERSONA_DETAIL_IS_FAVOURITE,
	FOLKS_PERSONA_DETAIL_LOCAL_IDS,
	FOLKS_PERSONA_DETAIL_LOCATION,
	FOLKS_PERSONA_DETAIL_NICKNAME,
	FOLKS_PERSONA_DETAIL_NOTES,
	FOLKS_PERSONA_DETAIL_PHONE_NUMBERS,
	FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES,
	FOLKS_PERSONA_DETAIL_ROLES,
	FOLKS_PERSONA_DETAIL_STRUCTURED_NAME,
	FOLKS_PERSONA_DETAIL_URLS,
	FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES,
	FOLKS_PERSONA_DETAIL_GROUPS,
	FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT,
	FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME,
	FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT,
	FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME,
	FOLKS_PERSONA_DETAIL_ANTI_LINKS
} FolksPersonaDetail;

typedef enum  {
	FOLKS_MAYBE_BOOL_UNSET = 0,
	FOLKS_MAYBE_BOOL_FALSE = 1,
	FOLKS_MAYBE_BOOL_TRUE = 2
} FolksMaybeBool;

struct _FolksPersonaStore {
	GObject parent_instance;
	FolksPersonaStorePrivate * priv;
};

struct _FolksPersonaStoreClass {
	GObjectClass parent_class;
	void (*prepare) (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*flush) (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*flush_finish) (FolksPersonaStore* self, GAsyncResult* _res_);
	void (*add_persona_from_details) (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
	FolksPersona* (*add_persona_from_details_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	void (*remove_persona) (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_persona_finish) (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_type_id) (FolksPersonaStore* self);
	GeeMap* (*get_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_add_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_alias_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_group_personas) (FolksPersonaStore* self);
	FolksMaybeBool (*get_can_remove_personas) (FolksPersonaStore* self);
	gboolean (*get_is_prepared) (FolksPersonaStore* self);
	gboolean (*get_is_quiescent) (FolksPersonaStore* self);
	gchar** (*get_always_writeable_properties) (FolksPersonaStore* self, int* result_length1);
};

struct _FolksPersonaStorePrivate {
	gchar* _display_name;
	gchar* _id;
	gboolean _is_writeable;
	FolksPersonaStoreTrust _trust_level;
	gboolean _is_primary_store;
	gboolean _is_user_set_default;
};

typedef enum  {
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUP_DETAILS_CHANGE_REASON_SEPARATED = 11
} FolksGroupDetailsChangeReason;

struct _FolksPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksPersonaStore* self;
};


static gpointer folks_persona_store_parent_class = NULL;

GType folks_persona_store_trust_get_type (void) G_GNUC_CONST;
GQuark folks_persona_store_error_quark (void);
GType folks_persona_detail_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_maybe_bool_get_type (void) G_GNUC_CONST;
#define FOLKS_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStorePrivate))
enum  {
	FOLKS_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_PERSONA_STORE_TYPE_ID,
	FOLKS_PERSONA_STORE_DISPLAY_NAME,
	FOLKS_PERSONA_STORE_ID,
	FOLKS_PERSONA_STORE_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_PERSONA_STORE_IS_PREPARED,
	FOLKS_PERSONA_STORE_IS_QUIESCENT,
	FOLKS_PERSONA_STORE_IS_WRITEABLE,
	FOLKS_PERSONA_STORE_TRUST_LEVEL,
	FOLKS_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	FOLKS_PERSONA_STORE_IS_PRIMARY_STORE,
	FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT
};
const gchar* folks_persona_store_get_id (FolksPersonaStore* self);
const gchar* folks_persona_store_detail_key (FolksPersonaDetail detail);
GType folks_group_details_change_reason_get_type (void) G_GNUC_CONST;
void _folks_persona_store_emit_personas_changed (FolksPersonaStore* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
static void folks_persona_store_real_flush_data_free (gpointer _data);
static void folks_persona_store_real_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_);
static gboolean folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* _data_);
void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error);
FolksPersonaStore* folks_persona_store_construct (GType object_type);
const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self);
const gchar* folks_persona_store_get_display_name (FolksPersonaStore* self);
static void folks_persona_store_set_display_name (FolksPersonaStore* self, const gchar* value);
static void folks_persona_store_set_id (FolksPersonaStore* self, const gchar* value);
GeeMap* folks_persona_store_get_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_add_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_alias_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_group_personas (FolksPersonaStore* self);
FolksMaybeBool folks_persona_store_get_can_remove_personas (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_prepared (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_quiescent (FolksPersonaStore* self);
gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self);
void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value);
FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self);
void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value);
gchar** folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self, int* result_length1);
gboolean folks_persona_store_get_is_primary_store (FolksPersonaStore* self);
void folks_persona_store_set_is_primary_store (FolksPersonaStore* self, gboolean value);
gboolean folks_persona_store_get_is_user_set_default (FolksPersonaStore* self);
void folks_persona_store_set_is_user_set_default (FolksPersonaStore* self, gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * folks_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_persona_store_finalize (GObject* obj);
static void _vala_folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* FOLKS_PERSONA_STORE__PERSONA_DETAIL[24] = {"alias", "avatar", "birthday", "email-addresses", "full-name", "gender", "im-addresses", "is-favourite", "local-ids", "location", "nickname", "notes", "phone-numbers", "postal-addresses", "roles", "structured-name", "urls", "web-service-addresses", "groups", "im-interaction-count", "last-im-interaction-datetime", "call-interaction-count", "last-call-interaction-datetime", "anti-links"};

/**
 * Trust level for a {@link PersonaStore}'s {@link Persona}s for linking
 * purposes.
 *
 * Trust levels are set internally by the backends, and must not be modified by
 * clients.
 *
 * @since 0.1.13
 */
GType folks_persona_store_trust_get_type (void) {
	static volatile gsize folks_persona_store_trust_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_store_trust_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_PERSONA_STORE_TRUST_NONE, "FOLKS_PERSONA_STORE_TRUST_NONE", "none"}, {FOLKS_PERSONA_STORE_TRUST_PARTIAL, "FOLKS_PERSONA_STORE_TRUST_PARTIAL", "partial"}, {FOLKS_PERSONA_STORE_TRUST_FULL, "FOLKS_PERSONA_STORE_TRUST_FULL", "full"}, {0, NULL, NULL}};
		GType folks_persona_store_trust_type_id;
		folks_persona_store_trust_type_id = g_enum_register_static ("FolksPersonaStoreTrust", values);
		g_once_init_leave (&folks_persona_store_trust_type_id__volatile, folks_persona_store_trust_type_id);
	}
	return folks_persona_store_trust_type_id__volatile;
}


GQuark folks_persona_store_error_quark (void) {
	return g_quark_from_static_string ("folks_persona_store_error-quark");
}


/**
 * Definition of the available fields to be looked up with
 * {@link PersonaStore.detail_key}.
 *
 * @since 0.5.0
 */
GType folks_persona_detail_get_type (void) {
	static volatile gsize folks_persona_detail_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_detail_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_PERSONA_DETAIL_INVALID, "FOLKS_PERSONA_DETAIL_INVALID", "invalid"}, {FOLKS_PERSONA_DETAIL_ALIAS, "FOLKS_PERSONA_DETAIL_ALIAS", "alias"}, {FOLKS_PERSONA_DETAIL_AVATAR, "FOLKS_PERSONA_DETAIL_AVATAR", "avatar"}, {FOLKS_PERSONA_DETAIL_BIRTHDAY, "FOLKS_PERSONA_DETAIL_BIRTHDAY", "birthday"}, {FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES, "FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES", "email-addresses"}, {FOLKS_PERSONA_DETAIL_FULL_NAME, "FOLKS_PERSONA_DETAIL_FULL_NAME", "full-name"}, {FOLKS_PERSONA_DETAIL_GENDER, "FOLKS_PERSONA_DETAIL_GENDER", "gender"}, {FOLKS_PERSONA_DETAIL_IM_ADDRESSES, "FOLKS_PERSONA_DETAIL_IM_ADDRESSES", "im-addresses"}, {FOLKS_PERSONA_DETAIL_IS_FAVOURITE, "FOLKS_PERSONA_DETAIL_IS_FAVOURITE", "is-favourite"}, {FOLKS_PERSONA_DETAIL_LOCAL_IDS, "FOLKS_PERSONA_DETAIL_LOCAL_IDS", "local-ids"}, {FOLKS_PERSONA_DETAIL_LOCATION, "FOLKS_PERSONA_DETAIL_LOCATION", "location"}, {FOLKS_PERSONA_DETAIL_NICKNAME, "FOLKS_PERSONA_DETAIL_NICKNAME", "nickname"}, {FOLKS_PERSONA_DETAIL_NOTES, "FOLKS_PERSONA_DETAIL_NOTES", "notes"}, {FOLKS_PERSONA_DETAIL_PHONE_NUMBERS, "FOLKS_PERSONA_DETAIL_PHONE_NUMBERS", "phone-numbers"}, {FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES, "FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES", "postal-addresses"}, {FOLKS_PERSONA_DETAIL_ROLES, "FOLKS_PERSONA_DETAIL_ROLES", "roles"}, {FOLKS_PERSONA_DETAIL_STRUCTURED_NAME, "FOLKS_PERSONA_DETAIL_STRUCTURED_NAME", "structured-name"}, {FOLKS_PERSONA_DETAIL_URLS, "FOLKS_PERSONA_DETAIL_URLS", "urls"}, {FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES, "FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES", "web-service-addresses"}, {FOLKS_PERSONA_DETAIL_GROUPS, "FOLKS_PERSONA_DETAIL_GROUPS", "groups"}, {FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT, "FOLKS_PERSONA_DETAIL_IM_INTERACTION_COUNT", "im-interaction-count"}, {FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME, "FOLKS_PERSONA_DETAIL_LAST_IM_INTERACTION_DATETIME", "last-im-interaction-datetime"}, {FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT, "FOLKS_PERSONA_DETAIL_CALL_INTERACTION_COUNT", "call-interaction-count"}, {FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME, "FOLKS_PERSONA_DETAIL_LAST_CALL_INTERACTION_DATETIME", "last-call-interaction-datetime"}, {FOLKS_PERSONA_DETAIL_ANTI_LINKS, "FOLKS_PERSONA_DETAIL_ANTI_LINKS", "anti-links"}, {0, NULL, NULL}};
		GType folks_persona_detail_type_id;
		folks_persona_detail_type_id = g_enum_register_static ("FolksPersonaDetail", values);
		g_once_init_leave (&folks_persona_detail_type_id__volatile, folks_persona_detail_type_id);
	}
	return folks_persona_detail_type_id__volatile;
}


/**
   * Returns the key corresponding to @detail, for use in
   * the details param of {@link PersonaStore.add_persona_from_details}.
   *
   * @param detail the {@link PersonaDetail} to lookup
   * @return the corresponding property name, or ``null`` if ``detail`` is
   * invalid
   *
   * @since 0.5.0
   */
const gchar* folks_persona_store_detail_key (FolksPersonaDetail detail) {
	const gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	FolksPersonaDetail _tmp1_ = 0;
	FolksPersonaDetail _tmp3_ = 0;
	const gchar* _tmp4_ = NULL;
	_tmp1_ = detail;
	if (_tmp1_ == FOLKS_PERSONA_DETAIL_INVALID) {
		_tmp0_ = TRUE;
	} else {
		FolksPersonaDetail _tmp2_ = 0;
		_tmp2_ = detail;
		_tmp0_ = _tmp2_ >= G_N_ELEMENTS (FOLKS_PERSONA_STORE__PERSONA_DETAIL);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = detail;
	_tmp4_ = FOLKS_PERSONA_STORE__PERSONA_DETAIL[_tmp3_];
	result = _tmp4_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void _folks_persona_store_emit_personas_changed (FolksPersonaStore* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeSet* _added = NULL;
	GeeSet* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	GeeSet* _removed = NULL;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GeeSet* _tmp6_ = NULL;
	const gchar* _tmp19_ = NULL;
	GeeSet* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	GeeSet* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GeeSet* _tmp26_ = NULL;
	GeeSet* _tmp27_ = NULL;
	GeeSet* _tmp28_ = NULL;
	GeeSet* _tmp29_ = NULL;
	GeeSet* _tmp30_ = NULL;
	GeeSet* _tmp31_ = NULL;
	GeeSet* _tmp32_ = NULL;
	GeeSet* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	FolksPersona* _tmp35_ = NULL;
	FolksGroupDetailsChangeReason _tmp36_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_added = _tmp1_;
	_tmp2_ = removed;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_removed = _tmp3_;
	_tmp6_ = added;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp7_ = added;
		_tmp8_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_SET, GeeSet));
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == 0;
	}
	if (_tmp5_) {
		gboolean _tmp10_ = FALSE;
		GeeSet* _tmp11_ = NULL;
		_tmp11_ = removed;
		if (_tmp11_ == NULL) {
			_tmp10_ = TRUE;
		} else {
			GeeSet* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			_tmp12_ = removed;
			_tmp13_ = gee_collection_get_size ((GeeCollection*) G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_SET, GeeSet));
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == 0;
		}
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_g_object_unref0 (_removed);
		_g_object_unref0 (_added);
		return;
	} else {
		GeeSet* _tmp15_ = NULL;
		_tmp15_ = added;
		if (_tmp15_ == NULL) {
			GeeHashSet* _tmp16_ = NULL;
			_tmp16_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (_added);
			_added = (GeeSet*) _tmp16_;
		} else {
			GeeSet* _tmp17_ = NULL;
			_tmp17_ = removed;
			if (_tmp17_ == NULL) {
				GeeHashSet* _tmp18_ = NULL;
				_tmp18_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_removed);
				_removed = (GeeSet*) _tmp18_;
			}
		}
	}
	_tmp19_ = self->priv->_id;
	_tmp20_ = _added;
	_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _removed;
	_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	folks_internal_profiling_point ("emitting PersonaStore::personas-changed " "(ID: %s, count: %u)", _tmp19_, _tmp22_ + _tmp25_);
	_tmp26_ = _added;
	_tmp27_ = gee_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_SET, GeeSet));
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp30_ = _removed;
	_tmp31_ = gee_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_SET, GeeSet));
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_;
	_tmp34_ = message;
	_tmp35_ = actor;
	_tmp36_ = reason;
	g_signal_emit_by_name (self, "personas-changed", _tmp29_, _tmp33_, _tmp34_, _tmp35_, _tmp36_);
	_g_object_unref0 (_tmp33_);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (_removed);
	_g_object_unref0 (_added);
}


void folks_persona_store_prepare (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare (self, _callback_, _user_data_);
}


void folks_persona_store_prepare_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->prepare_finish (self, _res_, error);
}


static void folks_persona_store_real_flush_data_free (gpointer _data) {
	FolksPersonaStoreFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPersonaStoreFlushData, _data_);
}


static void folks_persona_store_real_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksPersonaStoreFlushData* _data_;
	FolksPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_persona_store_real_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_persona_store_real_flush_co (_data_);
}


static void folks_persona_store_real_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_) {
	FolksPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Flush any pending changes to the PersonaStore's backing store.
   *
   * PersonaStores may (transparently) implement caching or I/O queueing which
   * means that changes to their {@link Persona}s may not be immediately written
   * to the PersonaStore's backing store. Calling this function will force all
   * pending changes to be flushed to the backing store.
   *
   * This must not be called before {@link PersonaStore.prepare}.
   *
   * @since 0.1.17
   */
static gboolean folks_persona_store_real_flush_co (FolksPersonaStoreFlushData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_persona_store_flush (FolksPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->flush (self, _callback_, _user_data_);
}


void folks_persona_store_flush_finish (FolksPersonaStore* self, GAsyncResult* _res_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->flush_finish (self, _res_);
}


void folks_persona_store_add_persona_from_details (FolksPersonaStore* self, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details (self, details, _callback_, _user_data_);
}


FolksPersona* folks_persona_store_add_persona_from_details_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->add_persona_from_details_finish (self, _res_, error);
}


void folks_persona_store_remove_persona (FolksPersonaStore* self, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona (self, persona, _callback_, _user_data_);
}


void folks_persona_store_remove_persona_finish (FolksPersonaStore* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PERSONA_STORE_GET_CLASS (self)->remove_persona_finish (self, _res_, error);
}


FolksPersonaStore* folks_persona_store_construct (GType object_type) {
	FolksPersonaStore * self = NULL;
	self = (FolksPersonaStore*) g_object_new (object_type, NULL);
	return self;
}


const gchar* folks_persona_store_get_type_id (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_type_id (self);
}


const gchar* folks_persona_store_get_display_name (FolksPersonaStore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


static void folks_persona_store_set_display_name (FolksPersonaStore* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* folks_persona_store_get_id (FolksPersonaStore* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void folks_persona_store_set_id (FolksPersonaStore* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp1_;
	g_object_notify ((GObject *) self, "id");
}


GeeMap* folks_persona_store_get_personas (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_add_personas (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, 0);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_add_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_alias_personas (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, 0);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_alias_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_group_personas (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, 0);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_group_personas (self);
}


FolksMaybeBool folks_persona_store_get_can_remove_personas (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, 0);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_can_remove_personas (self);
}


gboolean folks_persona_store_get_is_prepared (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_is_prepared (self);
}


gboolean folks_persona_store_get_is_quiescent (FolksPersonaStore* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_is_quiescent (self);
}


gboolean folks_persona_store_get_is_writeable (FolksPersonaStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_writeable;
	result = _tmp0_;
	return result;
}


void folks_persona_store_set_is_writeable (FolksPersonaStore* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_writeable = _tmp0_;
	g_object_notify ((GObject *) self, "is-writeable");
}


FolksPersonaStoreTrust folks_persona_store_get_trust_level (FolksPersonaStore* self) {
	FolksPersonaStoreTrust result;
	FolksPersonaStoreTrust _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_trust_level;
	result = _tmp0_;
	return result;
}


void folks_persona_store_set_trust_level (FolksPersonaStore* self, FolksPersonaStoreTrust value) {
	FolksPersonaStoreTrust _tmp0_ = 0;
	FolksPersonaStoreTrust _tmp1_ = 0;
	FolksPersonaStoreTrust _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = folks_persona_store_get_trust_level (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ > _tmp2_) {
		FolksPersonaStoreTrust _tmp3_ = 0;
		_tmp3_ = value;
		self->priv->_trust_level = _tmp3_;
		g_object_notify ((GObject*) self, "trust-level");
	} else {
		g_debug ("persona-store.vala:649: Unable to lower Persona Store trust_level");
	}
	g_object_notify ((GObject *) self, "trust-level");
}


gchar** folks_persona_store_get_always_writeable_properties (FolksPersonaStore* self, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_PERSONA_STORE_GET_CLASS (self)->get_always_writeable_properties (self, result_length1);
}


gboolean folks_persona_store_get_is_primary_store (FolksPersonaStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_primary_store;
	result = _tmp0_;
	return result;
}


void folks_persona_store_set_is_primary_store (FolksPersonaStore* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_primary_store = _tmp0_;
	g_object_notify ((GObject *) self, "is-primary-store");
}


gboolean folks_persona_store_get_is_user_set_default (FolksPersonaStore* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_user_set_default;
	result = _tmp0_;
	return result;
}


void folks_persona_store_set_is_user_set_default (FolksPersonaStore* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_user_set_default = _tmp0_;
	g_object_notify ((GObject *) self, "is-user-set-default");
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (gpointer data1, gpointer arg_1, gpointer arg_2, const char* arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_string (param_values + 3), g_value_get_object (param_values + 4), g_value_get_enum (param_values + 5), data2);
}


static GObject * folks_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksPersonaStore * self;
	const gchar* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	_tmp0_ = self->priv->_id;
	g_debug ("persona-store.vala:330: Constructing PersonaStore ‘%s’ (%p)", _tmp0_, self);
	return obj;
}


static void folks_persona_store_class_init (FolksPersonaStoreClass * klass) {
	folks_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->flush = folks_persona_store_real_flush;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush_finish = folks_persona_store_real_flush_finish;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_persona_store_finalize;
	/**
	   * The type of PersonaStore this is.
	   *
	   * This is the same for all PersonaStores provided by a given {@link Backend}.
	   *
	   * This is guaranteed to always be available; even before
	   * {@link PersonaStore.prepare} is called. It is immutable over the life of
	   * the {@link PersonaStore}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * The human-readable, service-specific name used to represent the
	   * PersonaStore to the user.
	   *
	   * For example: ``foo@@xmpp.example.org``.
	   *
	   * This should be used whenever the user needs to be presented with a
	   * familiar, service-specific name. For instance, in a prompt for the user to
	   * select a specific IM account from which to initiate a chat.
	   *
	   * This is not guaranteed to be unique even within this PersonaStore's
	   * {@link Backend}. Its value may change throughout the life of the store.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The instance identifier for this PersonaStore.
	   *
	   * Since each {@link Backend} can provide multiple different PersonaStores
	   * for different accounts or servers (for example), they each need an ID
	   * which is unique within the backend.
	   *
	   * It is immutable over the life of the {@link PersonaStore}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can add {@link Persona}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can set the alias of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can set the groups of {@link Persona}s.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} can remove {@link Persona}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, FOLKS_MAYBE_BOOL_UNSET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether {@link PersonaStore.prepare} has successfully completed for this
	   * store.
	   *
	   * It’s guaranteed that this will only ever change from ``false`` to ``true``
	   * in the lifetime of the {@link PersonaStore}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the store has reached a quiescent state. This will happen at some
	   * point after {@link PersonaStore.prepare} has successfully completed for the
	   * store. A store is in a quiescent state when all the {@link Persona}s that
	   * it originally knows about have been loaded.
	   *
	   * It's guaranteed that this property's value will only ever change after
	   * {@link IndividualAggregator.is_prepared} has changed to ``true``.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether the PersonaStore is writeable.
	   *
	   * Only if a PersonaStore is writeable will its {@link Persona}s be updated by
	   * changes to the {@link Individual}s containing them, and those changes then
	   * be written out to the relevant backing store.
	   *
	   * If this property is ``false``, it doesn't mean that {@link Persona}s in
	   * this persona store aren't writeable at all. If their properties are updated
	   * through the {@link Persona}, rather than through the {@link Individual}
	   * containing that persona, changes may be propagated to the backing store.
	   *
	   * PersonaStores must not set this property themselves; it will be set as
	   * appropriate by the {@link IndividualAggregator}.
	   *
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_WRITEABLE, g_param_spec_boolean ("is-writeable", "is-writeable", "is-writeable", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The trust level of the PersonaStore for linking.
	   *
	   * Each {@link PersonaStore} is assigned a trust level by the
	   * IndividualAggregator, designating whether to trust the properties of its
	   * {@link Persona}s for linking to produce {@link Individual}s.
	   *
	   * This value may change throughout the life of the {@link PersonaStore}.
	   *
	   * The trust level may be queried by clients, but must not be set by them. The
	   * setter for this property is for libfolks internal use only.
	   *
	   * @see PersonaStoreTrust
	   * @since 0.1.13
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_TRUST_LEVEL, g_param_spec_enum ("trust-level", "trust-level", "trust-level", FOLKS_TYPE_PERSONA_STORE_TRUST, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The names of the properties of the {@link Persona}s in this store which are
	   * always writeable.
	   *
	   * If a property name is in this list, setting the property on a persona
	   * should result in the updated value being stored in the backend's permanent
	   * storage (unless it gets rejected due to being invalid, or a different error
	   * occurs).
	   *
	   * This property value is guaranteed to be constant for a given persona store,
	   * but may vary between persona stores in the same backend. It's guaranteed
	   * that this will always be a subset of the value of
	   * {@link Persona.writeable_properties} for the personas in this persona
	   * store.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this {@link PersonaStore} is the primary store to be used for
	   * linking {@link Persona}s.
	   *
	   * @since 0.6.3
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_PRIMARY_STORE, g_param_spec_boolean ("is-primary-store", "is-primary-store", "is-primary-store", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Whether this {@link PersonaStore} is marked as the default in its backend
	   * by the user.
	   *
	   * i.e. A {@link PersonaStore} for the EDS backend would set this to ``true``
	   * if it represents the user’s default address book.
	   *
	   * @since 0.6.3
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT, g_param_spec_boolean ("is-user-set-default", "is-user-set-default", "is-user-set-default", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Emitted when one or more {@link Persona}s are added to or removed from
	   * the store.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   *
	   * @param added a set of {@link Persona}s which have been removed
	   * @param removed a set of {@link Persona}s which have been removed
	   * @param message a string message from the backend, if any
	   * @param actor the {@link Persona} who made the change, if known
	   * @param reason the reason for the change
	   *
	   * @since 0.5.1
	   */
	g_signal_new ("personas_changed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_STRING_OBJECT_ENUM, G_TYPE_NONE, 5, GEE_TYPE_SET, GEE_TYPE_SET, G_TYPE_STRING, FOLKS_TYPE_PERSONA, FOLKS_GROUP_DETAILS_TYPE_CHANGE_REASON);
	/**
	   * Emitted when the backing store for this PersonaStore has been removed.
	   *
	   * At this point, the PersonaStore and all its {@link Persona}s are invalid,
	   * so any client referencing it should unreference it.
	   *
	   * This will not be emitted until after {@link PersonaStore.prepare} has been
	   * called.
	   */
	g_signal_new ("removed", FOLKS_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void folks_persona_store_instance_init (FolksPersonaStore * self) {
	self->priv = FOLKS_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_is_writeable = FALSE;
	self->priv->_trust_level = FOLKS_PERSONA_STORE_TRUST_NONE;
	self->priv->_is_primary_store = FALSE;
	self->priv->_is_user_set_default = FALSE;
}


static void folks_persona_store_finalize (GObject* obj) {
	FolksPersonaStore * self;
	const gchar* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	_tmp0_ = self->priv->_id;
	g_debug ("persona-store.vala:335: Destroying PersonaStore ‘%s’ (%p)", _tmp0_, self);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_persona_store_parent_class)->finalize (obj);
}


/**
 * A store for {@link Persona}s.
 *
 * After creating a PersonaStore instance, you must connect to the
 * {@link PersonaStore.personas_changed} signal, //then// call
 * {@link PersonaStore.prepare}, otherwise a race condition may occur between
 * emission of {@link PersonaStore.personas_changed} and your code connecting to
 * it.
 */
GType folks_persona_store_get_type (void) {
	static volatile gsize folks_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPersonaStore), 0, (GInstanceInitFunc) folks_persona_store_instance_init, NULL };
		GType folks_persona_store_type_id;
		folks_persona_store_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPersonaStore", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_persona_store_type_id__volatile, folks_persona_store_type_id);
	}
	return folks_persona_store_type_id__volatile;
}


static void _vala_folks_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME:
		g_value_set_string (value, folks_persona_store_get_display_name (self));
		break;
		case FOLKS_PERSONA_STORE_ID:
		g_value_set_string (value, folks_persona_store_get_id (self));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE:
		g_value_set_boolean (value, folks_persona_store_get_is_writeable (self));
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL:
		g_value_set_enum (value, folks_persona_store_get_trust_level (self));
		break;
		case FOLKS_PERSONA_STORE_IS_PRIMARY_STORE:
		g_value_set_boolean (value, folks_persona_store_get_is_primary_store (self));
		break;
		case FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT:
		g_value_set_boolean (value, folks_persona_store_get_is_user_set_default (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore);
	switch (property_id) {
		case FOLKS_PERSONA_STORE_DISPLAY_NAME:
		folks_persona_store_set_display_name (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_ID:
		folks_persona_store_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_PERSONA_STORE_IS_WRITEABLE:
		folks_persona_store_set_is_writeable (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE_TRUST_LEVEL:
		folks_persona_store_set_trust_level (self, g_value_get_enum (value));
		break;
		case FOLKS_PERSONA_STORE_IS_PRIMARY_STORE:
		folks_persona_store_set_is_primary_store (self, g_value_get_boolean (value));
		break;
		case FOLKS_PERSONA_STORE_IS_USER_SET_DEFAULT:
		folks_persona_store_set_is_user_set_default (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



