/********************************************************************************
 *   Jabberoo/Judo -- C++ Jabber Library                                        *
 *                                                                              * 
 *   Copyright (C) 1999-2000 Dave Smith (dave@jabber.org)                       *
 *                                                                              *
 *   This library is free software; you can redistribute it and/or              *
 *   modify it under the terms of the GNU Lesser General Public                 *
 *   License as published by the Free Software Foundation; either               *
 *   version 2.1 of the License, or (at your option) any later version.         *
 *                                                                              *
 *   This library is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
 *   Lesser General Public License for more details.                            *
 *                                                                              *
 *   You should have received a copy of the GNU Lesser General Public           *
 *   License along with this library; if not, write to the Free Software        *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 ********************************************************************************
 */

#include <jabberoo.hh>
using namespace jabberoo;

Packet::Packet(const string& name)
     : _base(name)
{}

Packet::Packet(const Tag& t)
     : _base(t)
{}

const string Packet::getFrom() const
{
     return _base.getAttrib("from");
}

const string Packet::getTo() const
{
     return _base.getAttrib("to");
}

const string Packet::toXML() const
{
     return _base.getXML();
}

const Tag& Packet::getBaseTag() const
{
     return _base;
}

Tag& Packet::addX()
{
     return _base.addTag("x");
}

Tag& Packet::getBaseTag()
{
     return _base;
}
