/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */
#ifndef INCL_AGENT_BROWSER
#define INCL_AGENT_BROWSER

#include "BaseGabberWindow.hh"

class AgentBrowser
     : public BaseGabberDialog
{
public:
     static void execute();
protected:
     AgentBrowser(const string& server, jabberoo::AgentList a);
     virtual ~AgentBrowser() {}
     // Event handlers
     void on_info_clicked();
     void on_register_clicked();
     void on_browse_clicked();
     void on_search_clicked();
     void on_close_clicked();
     void on_tree_expand(Gtk::CTree::Row r);
     void on_tree_collapse(Gtk::CTree::Row r);
     int  on_tree_button(GdkEventButton* e);
     void on_tree_select(Gtk::CTree::Row r, int col);
     void on_tree_unselect(Gtk::CTree::Row r, int col);
     void on_agent_fetch_complete(bool successful, GtkCTreeNode* agentnode, GtkCTreeNode* dummynode);
     gint on_key_pressed(GdkEventKey* e);
     // Static IQ Callback
     void handle_agents_IQ(const Tag& iq);
     static void handle_agents_IQ_s(const Tag& iq);
     // Agent render
     void render_agent(jabberoo::Agent& a, GtkCTreeNode* parent = NULL);
private:
     jabberoo::AgentList _agent_list;
     jabberoo::Agent*    _current_agent;
     Gtk::Button*        _infoBtn;
     Gtk::Button*        _registerBtn;
     Gtk::Button*        _searchBtn;
     Gtk::CTree*         _agent_tree;
     Gtk::Entry*         _serverTxt;
};

class AgentRegisterDruid
     : public BaseGabberWindow
{
public:
     AgentRegisterDruid(jabberoo::Agent& a);
     virtual ~AgentRegisterDruid() {}
protected:
     void handle_request_reply(const Tag& iq);
     void on_register_reply(const Tag& iq);
     void on_Fields_prepare();
     bool on_Fields_next();
     void on_Registered_prepare();
     bool on_Registered_back();
     void on_finish();
     void on_cancel();
private:
     typedef list<Gtk::Entry *> EntryList;
     typedef list<string> StringList;

     Gnome::Druid* _druid;
     Gtk::VBox*    _fields_vbox;
     Gtk::Label*   _instr_lbl;

     Gtk::Label*   _lblRegistered;
     Gnome::DruidPage* _RDruid_loading;
     Gnome::DruidPage* _RDruid_fields;
     Gnome::DruidPage* _RDruid_registering;
     Gnome::DruidPage* _RDruid_registered;
     Gnome::AppBar* _barStatus;
     string _key;
     EntryList _entrys;
     StringList _field_names;
     jabberoo::Agent& _agent;
     bool _init_interface;
};

#endif
