/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_CONFIG_MANAGER_HH
#define INCL_CONFIG_MANAGER_HH

#include "Gabber.hh"
#include "MessageManager.hh"

#ifdef GNOME_WINICON_SUPPORT
#define GABBER_WINICON
#endif

using namespace std;

class ConfigManager
{
public:
     ConfigManager(const char* name);
     void setProfile(const string& profile);
     ~ConfigManager();
public:
     // Hard-coded value interfaces
     static const char*  get_PACKAGE();
     static const char*  get_VERSION();
     static const char*  get_GLADEDIR();
     static const char*  get_SHAREDIR();
     static const char*  get_CONFIG();
     static const char*  get_PIXPATH();
     static const string get_CSSFILE();
     // Sync
     void sync();
     // Value setters
     void putValue(const char* name, bool value, bool useprofile=true);
     void putValue(const char* name, const char* value, bool useprofile=true);
     void putPrivValue(const char* name, const char* value, bool useprofile=true);
     void putValue(const char* name, string value, bool useprofile=true) { putValue(name, value.c_str()); }
     void putPrivValue(const char* name, string value, bool useprofile=true) { putPrivValue(name, value.c_str()); }
     void putValue(const char* name, int value, bool useprofile=true);
     void putValue(const char* name, float value, bool useprofile=true);
     void saveEntryHistory(Gnome::Entry* gentry);
     // Value retrievers
     string      getStrValue(const char* name, bool useprofile=true);
     string      getStrValue(const string& name, bool useprofile=true) { return getStrValue(name.c_str()); };
     string      getPrivStrValue(const char* name, bool useprofile=true);
     const char* getCStrValue(const char* name, bool useprofile=true) { return getStrValue(name).c_str(); }
     bool        getBoolValue(const char* name, bool useprofile=true);
     int         getIntValue(const char* name, bool useprofile=true);
     float       getFloatValue(const char* name, bool useprofile=true);
     void        loadEntryHistory(Gnome::Entry* gentry);
     // Soft-coded value interfaces
     void set_nick(const string& nick) { _nick = nick; }
     void set_show(jabberoo::Presence::Show show) { _show = show; }
     void set_status(const string& status) { _status = status; }
     void set_priority(int priority) { _priority = priority; }
     string get_nick() { return _nick; }
     jabberoo::Presence::Show get_show() { return _show; }
     string get_status() { return _status; }
     int    get_priority() { return _priority; }
     // Presence pixmap/color cache
     void        initPresenceCache(const Gdk_Drawable& window);
     GdkPixmap*  getPresencePixmap(const string& status);
     GdkBitmap*  getPresenceBitmap(const string& status);
     GdkColor*   getPresenceColor(const string& status);
     // Event pixmap cache
     void        initEventCache(const Gdk_Drawable& window);
     GdkPixmap*  getEventPixmap(const MessageManager::Event& event);
     GdkBitmap*  getEventBitmap(const MessageManager::Event& event);
     GdkColor*   getFlashEventColor(const MessageManager::Event& event);
private:
     string              _CfgName;
     string              _CfgProfile;

     // Values
     string _nick;
     jabberoo::Presence::Show _show;
     string _status;
     int    _priority;

     // Presence pixmap/color cache structures
     struct PresenceInfo {
	  Gdk_Color  _color;
	  Gdk_Pixmap _pixmap;
          Gdk_Bitmap _bitmap;
	  PresenceInfo(const string& status, const Gdk_Drawable& window, ConfigManager& cfgm, const string& status);
     };
     map<string, PresenceInfo> _PICache; // Presence info cache

     struct EventInfo {
          Gdk_Color  _color;
          Gdk_Pixmap _pixmap;
          Gdk_Bitmap _bitmap;
          EventInfo(const Gdk_Drawable& window, ConfigManager& cfgm, const string& event, const string& pixmap, const string& defaultcolor);
     };
     map<MessageManager::Event, EventInfo> _EICache; // Event info cache
};

#endif;
