/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#ifndef INCL_CONTACT_INFO_INTERFACE_HH
#define INCL_CONTACT_INFO_INTERFACE_HH

#include "BaseGabberWindow.hh"
#include "GabberUtility.hh"
#include "GabberGPG.hh"

class ContactInfoDlg : 
     public BaseGabberDialog
{
public:
     static void display(const string& jid);
     static void display(const string& jid, const jabberoo::Roster::Subscription& type);
protected:
     ContactInfoDlg(const string& jid);
     ContactInfoDlg(const string& jid, const jabberoo::Roster::Subscription& type);
     void init(const string& jid);
private:
     void get_resources();
     void send_vcard_request();
     void parse_vcard(const Tag& t);
     void send_version_request();
     void parse_version(const Tag& t);
     void send_time_request();
     void parse_time(const Tag& t);    
     void get_status();
     // Event handlers
     void on_ok_clicked();
     void on_apply_clicked();
     void on_close_clicked();
     void on_help_clicked();
     void on_changed();
     void on_resource_selected(int selected);
     int on_GPGInfo_press_event(GdkEventButton* e);
     // Members
     string _pix_path;
     string _share_dir;
     Gtk::Entry* _entJID;
     Gtk::Entry* _entNickname;
     Gtk::Button* _btnApply;
     Gtk::Label* _lblShow;
     Gtk::Label* _lblStatus;
     Gnome::Pixmap* _pixShow;
     Gnome::Pixmap* _pixS10n;
     jabberoo::Roster::Item _item;
     bool _onroster;
     MenuBuilder _menuResource;
     vector<string> _resourcelist;
     string _resource;
     Gtk::Tooltips _tips;
     GabberGPG::GPGInfo _gpgInfo;
};

class MyContactInfoWin
     : public BaseGabberDialog
{
public:
     static void execute();
     MyContactInfoWin();
     ~MyContactInfoWin();
     // Non-static manipulators
     void manage_query(const string& jid);
     void get_key(const Tag& t);
     void get_info(const string& jid);
     void get_vCard(const Tag& t);
     void set_info(const string& jid);
     void loadconfig();
     void saveconfig(gint page_num);
     void changed();
     void on_name_changed();
     void on_apply(gint page_num);
     void on_help(gint page_num);
     void on_destroy();
public:
     // Signals
     Signal1<void, judo::Tag&> evtCompleted;
private:
     static MyContactInfoWin* _Dialog;
     string _key;
     bool _keyUsed;
     Gnome::PropertyBox* userinfo;
     // JUD
     Gtk::CheckButton* _chkNoJUD;
     // Basic Info
     Gtk::Entry* _entNickname;
     Gtk::Entry* _entFirstName;
     Gtk::Entry* _entLastName;
     Gtk::Entry* _entFullName;
     Gtk::Entry* _entEMail;
     Gtk::Entry* _entCountry;
     string _old_email;
     string _old_country;
};

class AgentInfoDlg :
     public BaseGabberDialog
{
public:
     AgentInfoDlg(const jabberoo::Agent& cur_agent);
     AgentInfoDlg(const string& jid);
private:
     string _jid;
     string _pix_path;
     string _share_dir;
     void on_ok_clicked();
     void on_register_clicked();
     void on_search_clicked();
     void on_browse_clicked();
     void on_cancel_clicked();

     jabberoo::Agent* _agent;
     Gtk::Entry*      _entNickname;
     Gnome::Pixmap*   _pixS10n;
};

#endif



