/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2000 Dave Smith & Julian Missig
 */


#ifndef INCL_GABBER_APP_HH
#define INCL_GABBER_APP_HH

#include "Gabber.hh"
#include "TCPTransmitter.hh"

class GabberWin;
class GabberLogger;
class MessageManager;
class GabberGPG;

class GabberApp
     : public SigC::Object
{
public:
     GabberApp(int argc, char** argv);
     ~GabberApp();
public:
     void init_win();
     void run();
     void quit();
     GladeXML* load_resource(const char* name);
     GladeXML* load_resource(const char* name, const char* filename);
public:
     // Accessors
     jabberoo::Session& getSession()       { return *_Session; }
     ConfigManager&     getCfg()           { return *_Cfg; }
     TCPTransmitter&    getTransmitter()   { return *_Transmitter; }
     MessageManager&    getMessageManager() { return *_MessageManager; }
     GabberGPG& 	getGPG()  	   { return *_GabberGPG; }
     GabberLogger&      getLogger()	   { return *_Logger; }
     void login();
     bool isGroupChatID(const string& jid);
     bool isTransport(const string& jid);
     const char* getLogFile(const string& jid) const;
     void setLogDir(const string& dir);
     void setLogging(bool onoff);
     void setLogHTML(bool html);
     bool manage_groups;
protected:
     GabberWin* _MainWindow;
     // Session events
     void on_session_message(const jabberoo::Message& m);
     void on_session_auth_error(int ErrorCode, const char* ErrorMessage);
     void on_session_presence_request(const jabberoo::Presence& p);
     void on_agent_reply(const judo::Tag& iq);
     void on_agents_reply(const judo::Tag& iq);
     void on_session_unknown_packet(const judo::Tag& t);
     void on_session_roster(const judo::Tag& t);
     void on_session_disconnected();
     void on_session_version(string& name, string& version, string& os);
     void on_session_presence(const jabberoo::Presence& p, jabberoo::Presence::Type prev);
     // Transmitter events
     void on_transmitter_connected();
     void on_auth_type_received(const judo::Tag& iq);
     void on_transmitter_disconnected();
     void on_transmitter_error(TCPTransmitter::Error e);
     // Other sundry events 
     void transmit_XML(const char* XML);
     void recv_XML(const char* XML);
     void transmit_packet(const jabberoo::Packet& p);
     // Dialog handlers
     void handle_create_user_dlg(int result);
     // Misc
     void init_log();
private:
     Gnome::Main        _GnomeApp;
     string             _LOGDIR;
     string             _SourceDir;
     TCPTransmitter*    _Transmitter;
     jabberoo::Session* _Session;
     GabberLogger*      _Logger;
     ConfigManager*     _Cfg;
     ConfigManager*     _DefaultCfg;
     ofstream           _Log;
     string             _share_dir;
     string             _pix_path;
     bool               _logging;
     set<string>        _GroupChatIDs;
     string             _nickname;
     MessageManager*	_MessageManager;
     GabberGPG*		_GabberGPG;
     bool               _createUser;
     string             _current_agent_host;
     string             _current_agent_jid;
};

extern GabberApp* G_App;

#endif

