/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2000 Dave Smith & Julian Missig
 */


#ifndef INCL_GABBER_WIN_H
#define INCL_GABBER_WIN_H

#include "GabberUtility.hh"
#include "BaseGabberWindow.hh"

using namespace jabberoo;

class MessageManager;
class RosterView;

class GabberWin : public BaseGabberWindow
{
public:
     GabberWin();
     void         display_status(jabberoo::Presence::Show show, const string& current_status, int priority);
     void         display_toolbars(bool displaytoolbar, bool displaystatusbar);
     void         save_size();
     void         toggle_visibility();
     void         refresh_roster();
     void         logging_in();
     // show and clear message events
     void         roster_event(const string& jid, MessageManager::Event event);
     void	  clear_event(const string& jid);
     Presence::Show translate_show(int show_index);
     // Needed to show/hide appropriate Menu Items for User Popup
     void         toggle_roster_popup(bool inlist);
     // Accessors
     Gtk::Menu*   get_menuUser() { return _menuUser; }
     Gtk::Menu*   get_menuAgent() { return _menuAgent; }
     Gtk::Menu*   get_menuDocklet() { return _menuDocklet; }
     Gnome::App*  get_MainWin() { return MainWin; }
     Gnome::AppBar* get_StatusBar() { return StatusBar; }
     bool         connected;
     Signal3<void, jabberoo::Presence::Show, const string&, int> evtMyPresence;
protected:
     MenuBuilder  create_showas_menu();
     virtual gint on_window_delete(GdkEventAny* e);
     void         on_AddUser_activate();
     void         on_BlankMessage_activate();
     void         on_About_activate();
     void         on_Manual_activate();
     void         on_Show_selected(int show_index);
     void         on_HideOfflineUsers_toggled();
     void         on_ShowHeadlines_toggled();
     void         on_Exit_activate();

     // Session event handlers
     void         on_session_connected(const Tag& t);
     void         on_transmitter_disconnected();
     void         on_disconnect();
     void         handle_disconnect_qry(int code);
private:
     Gnome::App*         MainWin;
     BaseGabberWidget*   _baseMU;
     BaseGabberWidget*   _baseMA;
     BaseGabberWidget*   _baseD;
     Gtk::Menu*          _menuUser;
     Gtk::Menu*          _menuAgent;
     Gtk::Menu*          _menuDocklet;
     Gnome::AppBar*      StatusBar;
     string              _pix_path;
     RosterView*         _roster;
     Gtk::OptionMenu*    _optShow;
     MenuBuilder         _menuShow;
     MenuBuilder         _menuGabberShow;
     MenuBuilder         _menuDockletShow;
     Gnome::DockItem*    _dockToolbar;
     Gnome::DockItem*    _dockStatusbar;
     int                 _curShow;
     string              _curStatus;
     int                 _curPriority;
     Gtk::MenuItem*      _m_Showas;
     Gtk::MenuItem*      _m_Login;
     Gtk::MenuItem*      _m_Logout;
     Gtk::MenuItem*      _m_Agents;
     Gtk::MenuItem*      _m_UserInfo;
     Gtk::MenuItem*      _m_Roster;
     Gtk::CheckMenuItem* _m_HideOffline;
     Gtk::CheckMenuItem* _m_HideAgents;
     Gtk::CheckMenuItem* _m_ShowHeadlines;
     Gtk::MenuItem*      _md_Showas;
     Gtk::MenuItem*      _md_Login;
     Gtk::MenuItem*      _md_Logout;
     Gtk::MenuItem*      _md_Show;
     Gtk::MenuItem*      _md_Hide;
     int                 _gwin_width;
     int                 _gwin_height;
     int                 _gwin_x;
     int                 _gwin_y;
};

extern GabberWin* G_Win;

#endif
