/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2000 Dave Smith & Julian Missig
 */

#ifndef INCL_MESSAGE_VIEWS_HH
#define INCL_MESSAGE_VIEWS_HH

#include "Gabber.hh"
#include "BaseGabberWindow.hh"
#include "GabberUtility.hh"
#include "GabberGPG.hh"

class MessageView
{
public:
     MessageView(const jabberoo::Message& m, ViewMap& vm);
     MessageView(const string& jid, ViewMap& vm);
     virtual ~MessageView();
     virtual void render(const jabberoo::Message& m) = 0;
protected:
     string _jid;
private:
     ViewMap& _registrar;
};

typedef list<jabberoo::Message> MessageQueue;

class NormalMessageView
     : public MessageView, public BaseGabberWindow
{
public:
     // Basic MessageView ops
     NormalMessageView(const jabberoo::Message& m, ViewMap& vm);
     NormalMessageView(const string& jid, ViewMap& vm);
     ~NormalMessageView();
     void render(const jabberoo::Message& m);
protected:
     void init();
     void get_update_info(const Tag& t);
     // Handlers
     void on_Send_clicked();
     void on_Cancel_clicked();
     void on_OK_clicked();
     gint on_window_delete(GdkEventAny* e);
     void on_Next_clicked();
     gint on_window_key_press(GdkEventKey* e);
     void on_AdvncdOpts_toggled();
     void on_Received_toggled();
     void set_received(bool has_received);
     void on_SendTo_changed();
     void on_Quote_clicked();
     void on_AddUser_clicked();
     void on_EditUser_clicked();
     void on_History_clicked();
     int  on_GPGInfo_button_press(GdkEventButton* e);
private:
     Gtk::ToggleButton* _tglbtnAdvncdOpts;
     Gtk::ToggleButton* _tglbtnReceived;
     Gtk::Frame*  _frmAdvncdOpts;
     Gtk::Frame*  _frmReceived;
     Gtk::Frame*  _frmReply;
     Gtk::CheckButton* _chkOOOChat;
     Gtk::Entry*  _entSendTo;
     Gtk::Entry*  _entResource;
     Gtk::Combo*  _cboResource;
     Gtk::Entry*  _entSender;
     Gtk::Label*  _lblTimeLbl;
     Gtk::Label*  _lblTime;
     Gtk::Entry*  _entSubject;
     Gtk::Text*   _memIncomingBody;
     Gtk::Text*   _memOutgoingBody;
     Gtk::Button* _btnNext;
     Gtk::Button* _btnQuote;
     Gtk::Button* _btnAddUser;
     Gnome::Pixmap* _pixGPG;
     Gtk::EventBox* _evtGPG;
     MessageQueue _Messages;
     string       _nickname;
     bool         _sendChanged;
     bool         _onRoster;
     bool         _render_message;
     // should GPG be used to sign/encrypt messages for this view?
     bool	  _useGPG;
     GabberGPG::GPGInfo _gpgInfo;
     Gtk::Tooltips _tips;
};

class ChatView;

class ChatMessageView
     : public MessageView, public BaseGabberWindow
{
public:
     // Basic MessageView ops
     ChatMessageView(const jabberoo::Message& m, ViewMap& vm);
     ChatMessageView(const string& jid, ViewMap& vm);
     ~ChatMessageView();
     void render(const jabberoo::Message& m);

protected:
     void init();
     void get_status();
     // Handlers
     void on_Send_clicked();
     void on_Close_clicked();
     gint on_window_delete(GdkEventAny* e);
     void on_AddUser_clicked();
     void on_EditUser_clicked();
     void on_History_clicked();
     gint on_window_key_press(GdkEventKey* e);
     int  on_GPGInfo_button_press(GdkEventButton* e);
     // Presence handler
     void on_presence(const jabberoo::Presence& p, const jabberoo::Presence::Type prev);
private:
     string       _pix_path;
     Gtk::Label*  _lblSender;
     Gtk::Text*   _memMsg;
     Gtk::Entry*  _entResource;
     Gtk::Combo*  _cboResource;
     Gtk::CheckButton* _chkMessage;
     Gtk::Button* _btnAddUser;
     Gnome::Pixmap* _pixGPG;
     Gtk::EventBox* _evtGPG;
     Gnome::Pixmap* _pixShow;
     Gtk::EventBox* _evtShow;
     string       _nickname;
     string       _resource;
     bool         _onRoster;
     GabberGPG::GPGInfo _gpgInfo;
     bool	  _useGPG;
     Gtk::Tooltips _tips;
     // Chat view
     ChatView*    _chatview;
};

class GCMessageView
     : public MessageView, public BaseGabberWindow
{
public:
     // Basic MessageView ops
     GCMessageView(const jabberoo::Message& m, ViewMap& vm);
     GCMessageView(const string& jid, ViewMap& vm);
     ~GCMessageView();
     void render(const jabberoo::Message& m);

     static void join(const string& jid);
protected:
     bool process_command(const string& command);
     void init();

     // Events
     void on_session_disconnected();
     void on_session_presence(const jabberoo::Presence& p, jabberoo::Presence::Type prev);
     void on_presence_changed(jabberoo::Presence::Show show, const string& status, int priority);
     gint on_Subject_key_press(GdkEventKey* e);
     gint on_Message_key_press(GdkEventKey* e);
     void on_Roster_select_row(int row, int col, GdkEvent* e);
     void on_History_clicked();
     void on_Close_clicked();
     void on_Users_toggled();
     jabberoo::Presence::Show translate_show(int show_index);
     void on_Show_selected(int show_index);
     gint on_window_delete(GdkEventAny* e);
private:
     string        _room;
     string        _nick;
     GCompletion*  _completer;
     jabberoo::Presence::Show _current_show;
     // Widget ptrs
     Gtk::Label*   _lblUserCount;
     Gtk::Text*   _memMessage;
     Gtk::Entry*  _entSubject;
     Gtk::CList*  _lstUsers;
     Gtk::Button* _btnHistory;
     Gtk::Button* _btnClose;
     Gtk::ToggleButton* _tglUsers;
     Gtk::Paned* _hpane;
     int _posHpane;
     Gtk::OptionMenu* _optShow;
     MenuBuilder  _menuShow;

     // Chat view ptr
     ChatView* _chatview;
};

class GCJoinDlg
     : public BaseGabberDialog
{
public:
     static void execute();
     GCJoinDlg();
protected:
     // Handlers
     void on_ok_clicked();
     void on_cancel_clicked();
     gint on_key_pressed(GdkEventKey* e);
     void on_protocol_selected(int protocol);
     void changed();
     void on_agents_reply(const Tag& iq);
private:
     int _protocol;
     Gtk::OptionMenu* _optProtocol;
     MenuBuilder    _menuProtocol;
     Gnome::Entry*  _gentNick;
     Gnome::Entry*  _gentRoom;
     Gnome::Entry*  _gentServer;
};

#endif
