/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2000 Dave Smith & Julian Missig
 */

#ifndef INCL_ROSTER_VIEW_HH
#define INCL_ROSTER_VIEW_HH

#include "Gabber.hh"

class RosterView
     : public SigC::Object
{
public:
     enum Filter
     {
	  rvfAll, rvfAllNoAgents, rvfOnlineOnly, rvfOnlineOnlyNoAgents
     };

     RosterView(Gtk::CTree* tree, jabberoo::Session& session);
     void clear();
     void refresh(bool reload_cache = false);
     void save_expanded_groups();
     void load_expanded_groups();
     // Menu handlers
     void on_Message_activate();
     void on_OOOChat_activate();
     void on_S10nRequest_activate();
     void on_EditUser_activate();
     void on_EditGroups_activate();
     void on_History_activate();
     void on_DeleteUser_activate();
     void on_LoginTransport_activate();
     void on_LogoutTransport_activate();
     void on_TransInfo_activate();
     void on_AddUser_activate();
     // Filter
     void set_view_filter(Filter f);
     // Not In List Item
     void addNILItem(jabberoo::Roster::Item& r);
     void clearNILItem(const string& jid);
protected:
     gint on_refresh();
     void on_update_refresh();
     void on_presence(const string& jid, bool available, jabberoo::Presence::Type prev_type);
     // Tree event handlers
     int  on_button_press(GdkEventButton* e);
     void on_tree_expand(Gtk::CTree::Row r);
     void on_tree_collapse(Gtk::CTree::Row r);
     // tree_move handler, Gtk-- doesn't support this yet so we do it through gtk directly
     static void on_tree_move(GtkCTree *ctree, GtkCTreeNode *node, GtkCTreeNode *new_parent, GtkCTreeNode *new_sibling, gpointer data);
     // DnD callbacks
     void on_drag_data_get(GdkDragContext* drag_ctx, GtkSelectionData* data, guint info, guint time);
     void on_drag_data_received(GdkDragContext* drag_ctx, gint x, gint y, GtkSelectionData* data, guint info, guint time);
     void dnd_get_vCard(const Tag& iq);
     static gboolean is_drop_ok(GtkCTree* ctree, GtkCTreeNode* node, GtkCTreeNode* new_parent, GtkCTreeNode* new_sibling);
     // Dialog handlers
     void handle_RemoveUserDlg(int);
     // Rendering helpers
     GtkCTreeNode* get_group_node(const string& groupid, bool available);
     void          render_group_nodes();
     GtkCTreeNode* create_item_node(GtkCTreeNode* groupnode, const jabberoo::Roster::Item& r);
     // Utility
     GdkColor get_style_bg_color();
     GdkColor get_style_fg_color();
     gint FlashEvents();
     Gtk::CTree::Row* findRow(const string& jid);
private:
     set<string>            _expanded_groups;
     map<string, Gdk_Color> _status_colors;
     list<jabberoo::Roster::Item> _nil_roster;
     bool               _event_flash;
     string             _online, _offline, _pix_path;
     Filter             _filter;
     jabberoo::Session& _session;
     Gtk::CTree*        _tree;
     int                _row, _col;
     int                _total_online;
     Gtk::Tooltips      _tips;
     // dnd selection info for when we need to request vcard from server
     GtkSelectionData*  _dnd_data;
     // Timer for roster refresh
     SigC::Connection   _refresh_timer;
     // Constants
     static const int colNickname  = 0;
     static const int colJID       = 1;
};

#endif
