// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_APPLICATION_H
#define _GIOMM_APPLICATION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/applicationcommandline.h>
#include <giomm/file.h>
#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GApplication GApplication;
typedef struct _GApplicationClass GApplicationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class Application_Class; } // namespace Gio
namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%ApplicationFlags operator|(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator&(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator^(ApplicationFlags, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags operator~(ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator|=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator&=(ApplicationFlags&, ApplicationFlags)</tt><br>
 * <tt>%ApplicationFlags& operator^=(ApplicationFlags&, ApplicationFlags)</tt><br>
 */
enum ApplicationFlags
{
  APPLICATION_FLAGS_NONE = 0x0,
  APPLICATION_IS_SERVICE = (1 << 0),
  APPLICATION_IS_LAUNCHER = (1 << 1),
  APPLICATION_HANDLES_OPEN = (1 << 2),
  APPLICATION_HANDLES_COMMAND_LINE = (1 << 3)
};

/** @ingroup giommEnums */
inline ApplicationFlags operator|(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator&(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator^(ApplicationFlags lhs, ApplicationFlags rhs)
  { return static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline ApplicationFlags operator~(ApplicationFlags flags)
  { return static_cast<ApplicationFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator|=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator&=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline ApplicationFlags& operator^=(ApplicationFlags& lhs, ApplicationFlags rhs)
  { return (lhs = static_cast<ApplicationFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


class ActionGroup;

/** Application - Core application class.
 * An Application is the foundation of an application, unique for a given
 * application identifier. The Application class wraps some low-level
 * platform-specific services and is intended to act as the foundation for
 * higher-level application classes such as Gtk::Application or MxApplication.
 * In general, you should not use this class outside of a higher level
 * framework.
 *
 * One of the core features that Application provides is process uniqueness,
 * in the context of a "session". The session concept is platform-dependent,
 * but corresponds roughly to a graphical desktop login. When your application
 * is launched again, its arguments are passed through platform communication
 * to the already running program. The already running instance of the program
 * is called the <i>primary instance</i>.
 *
 * Before using Application, you must choose an "application identifier". The
 * expected form of an application identifier is very close to that of of a
 * <a href="
 * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-names-interface">DBus
 * bus name</a>. Examples include: "com.example.MyApp",
 * "org.example.internal-apps.Calculator". For details on valid application
 * identifiers, see id_is_valid().
 *
 * Application provides convenient life cycle management by maintaining a
 * <i>use count</i> for the primary application instance. The use count can be
 * changed using hold() and release(). If it drops to zero, the application
 * exits.
 *
 * Application also implements the ActionGroup interface and lets you easily
 * export actions by adding them with set_action_group(). When
 * invoking an action by calling Gio::ActionGroup::activate_action() on the
 * application, it is always invoked in the primary instance.
 *
 * There is a number of different entry points into an Application:
 *
 * - via 'Activate' (i.e. just starting the application)
 * - via 'Open' (i.e. opening some files)
 * - via activating an action
 *
 * The signal_startup() signal lets you handle the application initialization
 * for all of these in a single place.
 *
 * See the C API docs for an example.
 *
 * @newin{2,28}
 */

class Application : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Application CppObjectType;
  typedef Application_Class CppClassType;
  typedef GApplication BaseObjectType;
  typedef GApplicationClass BaseClassType;

private:  friend class Application_Class;
  static CppClassType application_class_;

private:
  // noncopyable
  Application(const Application&);
  Application& operator=(const Application&);

protected:
  explicit Application(const Glib::ConstructParams& construct_params);
  explicit Application(GApplication* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Application();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GApplication*       gobj()       { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GApplication* gobj() const { return reinterpret_cast<GApplication*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GApplication* gobj_copy();

private:


protected:
  explicit Application(const Glib::ustring& application_id, ApplicationFlags flags=APPLICATION_FLAGS_NONE);
  

public:
  
  static Glib::RefPtr<Application> create(const Glib::ustring& application_id, ApplicationFlags flags = APPLICATION_FLAGS_NONE);


  /** Checks if @a application_id is a valid application identifier.
   * 
   * A valid ID is required for calls to g_application_new() and
   * g_application_set_application_id().
   * 
   * For convenience, the restrictions on application identifiers are
   * reproduced here:
   * <itemizedlist>
   * <listitem>Application identifiers must contain only the ASCII characters "[A-Z][a-z][0-9]_-" and must not begin with a digit.</listitem>
   * <listitem>Application identifiers must contain at least one '.' (period) character (and thus at least two elements).</listitem>
   * <listitem>Application identifiers must not begin with a '.' (period) character.</listitem>
   * <listitem>Application identifiers must not contain consecutive '.' (period) characters.</listitem>
   * <listitem>Application identifiers must not exceed 255 characters.</listitem>
   * </itemizedlist>
   * @param application_id A potential application identifier.
   * @return <tt>true</tt> if @a application_id is valid.
   */
  static bool id_is_valid(const Glib::ustring& application_id);

  
  /** Gets the unique identifier for @a application.
   * 
   * @newin{2,28}
   * @return The identifier for @a application, owned by @a application.
   */
  Glib::ustring get_id() const;
  
  /** Sets the unique identifier for @a application.
   * 
   * The application id can only be modified if @a application has not yet
   * been registered.
   * 
   * The application id must be valid.  See g_application_id_is_valid().
   * 
   * @newin{2,28}
   * @param application_id The identifier for @a application.
   */
  void set_id(const Glib::ustring& application_id);

  
  /** Gets the current inactivity timeout for the application.
   * 
   * This is the amount of time (in milliseconds) after the last call to
   * g_application_release() before the application stops running.
   * 
   * @newin{2,28}
   * @return The timeout, in milliseconds.
   */
  guint get_inactivity_timeout() const;
  
  /** Sets the current inactivity timeout for the application.
   * 
   * This is the amount of time (in milliseconds) after the last call to
   * g_application_release() before the application stops running.
   * 
   * This call has no side effects of its own.  The value set here is only
   * used for next time g_application_release() drops the use count to
   * zero.  Any timeouts currently in progress are not impacted.
   * 
   * @newin{2,28}
   * @param inactivity_timeout The timeout, in milliseconds.
   * @return The timeout, in milliseconds.
   */
  void set_inactivity_timeout(guint inactivity_timeout);

  
  /** Gets the flags for @a application.
   * 
   * See ApplicationFlags.
   * 
   * @newin{2,28}
   * @return The flags for @a application.
   */
  ApplicationFlags get_flags() const;
  
  /** Sets the flags for @a application.
   * 
   * The flags can only be modified if @a application has not yet been
   * registered.
   * 
   * See ApplicationFlags.
   * 
   * @newin{2,28}
   * @param flags The flags for @a application.
   */
  void set_flags(ApplicationFlags flags);

  
  /** Sets or unsets the group of actions associated with the application.
   * 
   * These actions are the actions that can be remotely invoked.
   * 
   * It is an error to call this function after the application has been
   * registered.
   * 
   * @newin{2,28}
   * @param action_group A ActionGroup, or <tt>0</tt>.
   */
  void set_action_group(const Glib::RefPtr<ActionGroup>& action_group);

  
  /** Checks if @a application is registered.
   * 
   * An application is registered if g_application_register() has been
   * successfully called.
   * 
   * @newin{2,28}
   * @return <tt>true</tt> if @a application is registered.
   */
  bool is_registered() const;
  
  /** Checks if @a application is remote.
   * 
   * If @a application is remote then it means that another instance of
   * application already exists (the 'primary' instance).  Calls to
   * perform actions on @a application will result in the actions being
   * performed by the primary instance.
   * 
   * The value of this property can not be accessed before
   * g_application_register() has been called.  See
   * g_application_get_is_registered().
   * 
   * @newin{2,28}
   * @return <tt>true</tt> if @a application is remote.
   */
  bool is_remote() const;

  //Renamed from register() because that is a C++ keyword.
  
  /** Attempts registration of the application.
   * 
   * This is the point at which the application discovers if it is the
   * primary instance or merely acting as a remote for an already-existing
   * primary instance.  This is implemented by attempting to acquire the
   * application identifier as a uniue bus name on the session bus using
   * GDBus.
   * 
   * Due to the internal architecture of GDBus, method calls can be
   * dispatched at any time (even if a main loop is not running).  For
   * this reason, you must ensure that any object paths that you wish to
   * register are registered before calling this function.
   * 
   * If the application has already been registered then <tt>true</tt> is
   * returned with no work performed.
   * 
   * The Application::startup signal is emitted if registration succeeds
   * and @a application is the primary instance.
   * 
   * In the event of an error (such as @a cancellable being cancelled, or a
   * failure to connect to the session bus), <tt>false</tt> is returned and @a error
   * is set appropriately.
   * 
   * @note the return value of this function is not an indicator that this
   * instance is or is not the primary instance of the application.  See
   * g_application_get_is_remote() for that.
   * 
   * @newin{2,28}
   * @param cancellable A Cancellable, or <tt>0</tt>.
   * @return <tt>true</tt> if registration succeeded.
   */
  bool register_application(const Glib::RefPtr<Gio::Cancellable>& cancellable);

  /// Non-cancellable version of register_application().
  bool register_application();

  
  /** Increases the use count of @a application.
   * 
   * Use this function to indicate that the application has a reason to
   * continue to run.  For example, g_application_hold() is called by GTK+ 
   * when a toplevel window is on the screen.
   * 
   * To cancel the hold, call g_application_release().
   */
  void hold();
  
  /** Decrease the use count of @a application.
   * 
   * When the use count reaches zero, the application will stop running.
   * 
   * Never call this function except to cancel the effect of a previous
   * call to g_application_hold().
   */
  void release();
  
  /** Activates the application.
   * 
   * In essence, this results in the Application::activate() signal being
   * emitted in the primary instance.
   * 
   * The application must be registered before calling this function.
   * 
   * @newin{2,28}
   */
  void activate();

  typedef std::vector< Glib::RefPtr<File> > type_vec_files;

  /* Opens the given files.
   *
   * In essence, this results in the open signal being emitted
   * in the primary instance.
   *
   * @a hint is simply passed through to the open signal.  It is
   * intended to be used by applications that have multiple modes for
   * opening files (eg: "view" vs "edit", etc).
   *
   * The application must be registered before calling this mwethod
   * and it must have the APPLICATION_HANDLES_OPEN flag set.
   *
   * @param files The files to open. This must be non-empty.
   * @param hint A hint.
   *
   * @newin{2,28}
   */
  void open(const type_vec_files& files, const Glib::ustring& hint = Glib::ustring());
  

  /** Runs the application.
   * 
   * This function is intended to be run from main() and its return value
   * is intended to be returned by main().
   * 
   * First, the local_command_line() virtual function is invoked.  This
   * function always runs on the local instance.  If that function returns
   * <tt>false</tt> then the application is registered and the Application::command-line
   * signal is emitted in the primary instance (which may or may not be
   * this instance).
   * 
   * If the application has the APPLICATION_HANDLES_COMMAND_LINE
   * flag set then the default implementation of local_command_line()
   * always returns <tt>false</tt> immediately, resulting in the commandline
   * always being handled in the primary instance.
   * 
   * Otherwise, the default implementation of local_command_line() tries
   * to do a couple of things that are probably reasonable for most
   * applications.  First, g_application_register() is called to attempt
   * to register the application.  If that works, then the command line
   * arguments are inspected.  If no commandline arguments are given, then
   * g_application_activate() is called.  If commandline arguments are
   * given and the APPLICATION_HANDLES_OPEN flag is set then they
   * are assumed to be filenames and g_application_open() is called.
   * 
   * If you are interested in doing more complicated local handling of the
   * commandline then you should implement your own Application subclass
   * and override local_command_line(). See
   * <xref linkend="gapplication-example-cmdline2"/> for an example.
   * 
   * If, after the above is done, the use count of the application is zero
   * then the exit status is returned immediately.  If the use count is
   * non-zero then the mainloop is run until the use count falls to zero,
   * at which point 0 is returned.
   * 
   * If the APPLICATION_IS_SERVICE flag is set, then the exiting at
   * use count of zero is delayed for a while (ie: the instance stays
   * around to provide its <em>service</em> to others).
   * 
   * @newin{2,28}
   * @param argc The argc from main().
   * @param argv The argv from main().
   * @return The exit status.
   */
  int run(int argc, char** argv);
  //TODO: g_application_run_with_arguments)

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The group of actions that the application exports.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_WriteOnly< Glib::RefPtr<ActionGroup> > property_action_group() ;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_application_id() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** The unique identifier for the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_application_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ApplicationFlags> property_flags() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Flags specifying the behaviour of the application.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ApplicationFlags> property_flags() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<guint> property_inactivity_timeout() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Iime (ms) to stay alive after becoming idle.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_inactivity_timeout() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If g_application_register() has been called.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_registered() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** If this application instance is remote.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_is_remote() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


//#m4 __CONVERSION(`const gchar*', `const Glib::ustring&', `Glib::ustring($3)')
//#m4 __CONVERSION(`GVariant*', `const Glib::VariantBase&', `Glib::wrap($3, true)')

  
  /**
   * @par Prototype:
   * <tt>void on_my_%startup()</tt>
   */

  Glib::SignalProxy0< void > signal_startup();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%activate()</tt>
   */

  Glib::SignalProxy0< void > signal_activate();

  
  //We wrap the open signal without _WRAP_SIGNAL(), because we need to change its parameters.
  //See bug https://bugzilla.gnome.org/show_bug.cgi?id=637457
  Glib::SignalProxy2< void,  const type_vec_files&, const Glib::ustring& > signal_open();

 
  /**
   * @par Prototype:
   * <tt>bool on_my_%command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line)</tt>
   */

  Glib::SignalProxy1< bool,const Glib::RefPtr<ApplicationCommandLine>& > signal_command_line();


protected:
  virtual void on_open(const type_vec_files& files, const Glib::ustring& hint);


private:
  /** This is just a way to call Glib::init() (which calls g_type_init()) before
   * calling application_class_.init(), so that 
   * g_application_get_type() will always succeed.
   * See https://bugzilla.gnome.org/show_bug.cgi?id=639925
   */
  const Glib::Class& custom_class_init();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_startup();
  virtual void on_activate();
  virtual bool on_command_line(const Glib::RefPtr<ApplicationCommandLine>& command_line);


};


} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::Application
   */
  Glib::RefPtr<Gio::Application> wrap(GApplication* object, bool take_copy = false);
}


#endif /* _GIOMM_APPLICATION_H */

