// Generated by gmmproc 2.47.6 -- DO NOT MODIFY!
#ifndef _GIOMM_SETTINGSSCHEMASOURCE_H
#define _GIOMM_SETTINGSSCHEMASOURCE_H

#include <giommconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2015 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <giomm/settingsschema.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GSettingsSchemaSource GSettingsSchemaSource;
#endif

namespace Gio
{

//TODO: Add some class documentation, though there is none in the C docs.

/** See SettingsSchema.
 *
 * @newin{2,32}
 */
class SettingsSchemaSource final
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef SettingsSchemaSource CppObjectType;
  typedef GSettingsSchemaSource BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GSettingsSchemaSource*       gobj();

  ///Provides access to the underlying C instance.
  const GSettingsSchemaSource* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GSettingsSchemaSource* gobj_copy() const;

  SettingsSchemaSource() = delete;

  // noncopyable
  SettingsSchemaSource(const SettingsSchemaSource&) = delete;
  SettingsSchemaSource& operator=(const SettingsSchemaSource&) = delete;

protected:
  // Do not derive this.  Gio::SettingsSchemaSource can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:


protected:
  

public:

  
  /** Gets the default system schema source.
   * 
   * This function is not required for normal uses of Settings but it
   * may be useful to authors of plugin management systems or to those who
   * want to introspect the content of schemas.
   * 
   * If no schemas are installed, <tt>nullptr</tt> will be returned.
   * 
   * The returned source may actually consist of multiple schema sources
   * from different directories, depending on which directories were given
   * in `XDG_DATA_DIRS` and `GSETTINGS_SCHEMA_DIR`. For this reason, all
   * lookups performed against the default source should probably be done
   * recursively.
   * 
   * @newin{2,32}
   * 
   * @return The default schema source.
   */
  static Glib::RefPtr<SettingsSchemaSource> get_default();

/* TODO:
GLIB_AVAILABLE_IN_2_32
GSettingsSchemaSource * g_settings_schema_source_new_from_directory     (const gchar            *directory,
                                                                         GSettingsSchemaSource  *parent,
                                                                         gboolean                trusted,
                                                                         GError                **error);
*/

  //Note this doesn't need refreturn because the C function returns a reference.
  //- it is documented as transfer:full
  
  /** Looks up a schema with the identifier @a schema_id in @a source.
   * 
   * This function is not required for normal uses of Settings but it
   * may be useful to authors of plugin management systems or to those who
   * want to introspect the content of schemas.
   * 
   * If the schema isn't found directly in @a source and @a recursive is <tt>true</tt>
   * then the parent sources will also be checked.
   * 
   * If the schema isn't found, <tt>nullptr</tt> is returned.
   * 
   * @newin{2,32}
   * 
   * @param schema_id A schema ID.
   * @param recursive <tt>true</tt> if the lookup should be recursive.
   * @return A new SettingsSchema.
   */
  Glib::RefPtr<SettingsSchema> lookup(const Glib::ustring& schema_id, bool recursive);
  
  /** Looks up a schema with the identifier @a schema_id in @a source.
   * 
   * This function is not required for normal uses of Settings but it
   * may be useful to authors of plugin management systems or to those who
   * want to introspect the content of schemas.
   * 
   * If the schema isn't found directly in @a source and @a recursive is <tt>true</tt>
   * then the parent sources will also be checked.
   * 
   * If the schema isn't found, <tt>nullptr</tt> is returned.
   * 
   * @newin{2,32}
   * 
   * @param schema_id A schema ID.
   * @param recursive <tt>true</tt> if the lookup should be recursive.
   * @return A new SettingsSchema.
   */
  Glib::RefPtr<const SettingsSchema> lookup(const Glib::ustring& schema_id, bool recursive) const;

  //TODO:_WRAP_METHOD(void list_schemas(bool recursive,  gchar*** non_relocatable, gchar*** relocatable), g_settings_schema_source_list_schemas)


};

} // namespace Gio


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::SettingsSchemaSource
   */
  Glib::RefPtr<Gio::SettingsSchemaSource> wrap(GSettingsSchemaSource* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_SETTINGSSCHEMASOURCE_H */

