/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 4 -*- */

#include <config.h>
#include <gnome.h>
#include <bonobo.h>
#include <liboaf/liboaf.h>
#include "gbf-am-project.h"

static void
start_gbf_am (CORBA_Environment *ev)
{
    GbfAmProject *prj;
    OAF_RegistrationResult result;
    
    prj = gbf_am_project_new ();

    gtk_signal_connect (GTK_OBJECT (prj), "destroy",
			GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

    result = oaf_active_server_register ("OAFIID:GNOME_Development_Project_AutoMake",
					 BONOBO_OBJREF (prj));

    switch (result) {
    case OAF_REG_SUCCESS :
	oaf_active_server_unregister ("OAFIID:GNOME_Development_Project_AutoMake",
				      BONOBO_OBJREF (prj));
	return;
    case OAF_REG_NOT_LISTED:
	g_error ("Cannot register the automake backend because it is not listed.");
	return;
    case OAF_REG_ALREADY_ACTIVE:
	g_error ("Cannot register the automake backend because it is already active.");
	return;
    case OAF_REG_ERROR :
    default :
	g_error ("Cannot register the automake backend because of an unknown error.");
	return;
    }
}

int
main (int argc, char *argv[])
{
    CORBA_Environment ev;

    CORBA_exception_init (&ev);

    gnome_init_with_popt_table ("gbf-libgbf-am-backend", VERSION, argc, argv,
				oaf_popt_options, 0, NULL);
    oaf_init (argc, argv);    

    if (!bonobo_init (oaf_orb_get (), NULL, NULL)) 
	g_error (_("Can't initialize bonobo!"));

    start_gbf_am (&ev);
	
    bonobo_main ();

    return 0;
}







