/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gbf-project-tree.h
 *
 * Copyright (C) 2000  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _GBF_PROJECT_TREE_H_
#define _GBF_PROJECT_TREE_H_

#include <gnome.h>
#include <gbf.h>
#include <bonobo/bonobo-event-source.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GBF_TYPE_PROJECT_TREE			(gbf_project_tree_get_type ())
#define GBF_PROJECT_TREE(obj)			(GTK_CHECK_CAST ((obj), GBF_TYPE_PROJECT_TREE, GbfProjectTree))
#define GBF_PROJECT_TREE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GBF_TYPE_PROJECT_TREE, GbfProjectTreeClass))
#define GBF_IS_PROJECT_TREE(obj)			(GTK_CHECK_TYPE ((obj), GBF_TYPE_PROJECT_TREE))
#define GBF_IS_PROJECT_TREE_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GBF_TYPE_PROJECT_TREE))


typedef struct _GbfProjectTree        GbfProjectTree;
typedef struct _GbfProjectTreePrivate GbfProjectTreePrivate;
typedef struct _GbfProjectTreeClass   GbfProjectTreeClass;

struct _GbfProjectTree {
	GtkVBox parent;

	GbfProjectTreePrivate *priv;
};

struct _GbfProjectTreeClass {
	GtkVBoxClass parent_class;
};


GtkType    gbf_project_tree_get_type (void);
GtkWidget *gbf_project_tree_new      (void);

GbfProjectClient *gbf_project_tree_get_project (GbfProjectTree *tree);
void gbf_project_tree_set_project (GbfProjectTree *tree, GbfProjectClient *prj);

BonoboEventSource *gbf_project_tree_get_event_source (GbfProjectTree *tree);

void gbf_project_tree_destroy (GtkObject *obj);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GBF_PROJECT_TREE_H_ */






