/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gbf-project-tree.h
 *
 * Copyright (C) 2000  JP Rosevear
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: JP Rosevear
 */

#ifndef _GBF_TARGET_TREE_H_
#define _GBF_TARGET_TREE_H_

#include <gnome.h>
#include <gbf.h>
#include <bonobo/bonobo-event-source.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GBF_TYPE_TARGET_TREE			(gbf_target_tree_get_type ())
#define GBF_TARGET_TREE(obj)			(GTK_CHECK_CAST ((obj), GBF_TYPE_TARGET_TREE, GbfTargetTree))
#define GBF_TARGET_TREE_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GBF_TYPE_TARGET_TREE, GbfTargetTreeClass))
#define GBF_IS_TARGET_TREE(obj)			(GTK_CHECK_TYPE ((obj), GBF_TYPE_TARGET_TREE))
#define GBF_IS_TARGET_TREE_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GBF_TYPE_TARGET_TREE))


typedef struct _GbfTargetTree        GbfTargetTree;
typedef struct _GbfTargetTreePrivate GbfTargetTreePrivate;
typedef struct _GbfTargetTreeClass   GbfTargetTreeClass;

struct _GbfTargetTree {
	GtkVBox parent;

	GbfTargetTreePrivate *priv;
};

struct _GbfTargetTreeClass {
	GtkVBoxClass parent_class;
};


GtkType    gbf_target_tree_get_type (void);
GtkWidget *gbf_target_tree_new      (void);

GbfProjectClient *gbf_target_tree_get_project (GbfTargetTree *tree);
void gbf_target_tree_set_project (GbfTargetTree *tree, GbfProjectClient *prj);

GBF_Target *gbf_target_tree_get_current_target (GbfTargetTree *tree);
void gbf_target_tree_set_current_target (GbfTargetTree *tree, GBF_Target *new_target);

BonoboEventSource *gbf_target_tree_get_event_source (GbfTargetTree *tree);

void gbf_target_tree_destroy (GtkObject *obj);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _GBF_TARGET_TREE_H_ */






