/* chess-clock.c generated by valac 0.22.0.22-b05f, the Vala compiler
 * generated from chess-clock.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 * Copyright (C) 2013 Michael Catanzaro
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>


#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
typedef struct _ChessClockPrivate ChessClockPrivate;

#define TYPE_COLOR (color_get_type ())
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _ChessClock {
	GObject parent_instance;
	ChessClockPrivate * priv;
};

struct _ChessClockClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessClockPrivate {
	guint _white_initial_ms;
	guint _black_initial_ms;
	guint _white_ms_used;
	guint _black_ms_used;
	Color _active_color;
	GTimer* timer;
	guint expire_timeout_id;
	guint tick_timeout_id;
};


static gpointer chess_clock_parent_class = NULL;

GType chess_clock_get_type (void) G_GNUC_CONST;
GType color_get_type (void) G_GNUC_CONST;
#define CHESS_CLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_CLOCK, ChessClockPrivate))
enum  {
	CHESS_CLOCK_DUMMY_PROPERTY,
	CHESS_CLOCK_WHITE_INITIAL_SECONDS,
	CHESS_CLOCK_BLACK_INITIAL_SECONDS,
	CHESS_CLOCK_WHITE_SECONDS_USED,
	CHESS_CLOCK_BLACK_SECONDS_USED,
	CHESS_CLOCK_ACTIVE_COLOR
};
ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds);
void chess_clock_start (ChessClock* self);
static gboolean chess_clock_get_is_active (ChessClock* self);
static void chess_clock_watch_timer (ChessClock* self);
static gboolean chess_clock_timer_expired_cb (ChessClock* self);
void chess_clock_stop (ChessClock* self);
static gboolean chess_clock_tick_cb (ChessClock* self);
Color chess_clock_get_active_color (ChessClock* self);
static gboolean _chess_clock_tick_cb_gsource_func (gpointer self);
static void chess_clock_stop_checking_timer (ChessClock* self);
void chess_clock_pause (ChessClock* self);
void chess_clock_unpause (ChessClock* self);
static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self);
static guint chess_clock_ms_to_seconds (ChessClock* self, guint ms);
guint chess_clock_get_white_initial_seconds (ChessClock* self);
guint chess_clock_get_black_initial_seconds (ChessClock* self);
guint chess_clock_get_white_seconds_used (ChessClock* self);
guint chess_clock_get_black_seconds_used (ChessClock* self);
void chess_clock_set_active_color (ChessClock* self, Color value);
static void chess_clock_finalize (GObject* obj);
static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds) {
	ChessClock * self = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	self = (ChessClock*) g_object_new (object_type, NULL);
	_tmp0_ = white_initial_seconds;
	self->priv->_white_initial_ms = _tmp0_ * 1000;
	_tmp1_ = black_initial_seconds;
	self->priv->_black_initial_ms = _tmp1_ * 1000;
	return self;
}


ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds) {
	return chess_clock_construct (TYPE_CHESS_CLOCK, white_initial_seconds, black_initial_seconds);
}


void chess_clock_start (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_is_active (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->timer;
	if (_tmp2_ == NULL) {
		GTimer* _tmp3_ = NULL;
		_tmp3_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->timer);
		self->priv->timer = _tmp3_;
	} else {
		GTimer* _tmp4_ = NULL;
		_tmp4_ = self->priv->timer;
		g_timer_start (_tmp4_);
	}
	chess_clock_watch_timer (self);
}


static gboolean chess_clock_timer_expired_cb (ChessClock* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	chess_clock_stop (self);
	g_signal_emit_by_name (self, "expired");
	result = FALSE;
	return result;
}


static gboolean _chess_clock_tick_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_tick_cb (self);
	return result;
}


static gboolean chess_clock_tick_cb (ChessClock* self) {
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint elapsed = 0U;
	GTimer* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	guint used = 0U;
	Color _tmp3_ = 0;
	Color _tmp4_ = 0;
	guint next_tick_time = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->tick_timeout_id;
	if (_tmp0_ != ((guint) 0)) {
		g_signal_emit_by_name (self, "tick");
	}
	_tmp1_ = self->priv->timer;
	_tmp2_ = g_timer_elapsed (_tmp1_, NULL);
	elapsed = (guint) (_tmp2_ * 1000);
	_tmp3_ = chess_clock_get_active_color (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == COLOR_WHITE) {
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		_tmp5_ = self->priv->_white_ms_used;
		_tmp6_ = elapsed;
		used = _tmp5_ + _tmp6_;
	} else {
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		_tmp7_ = self->priv->_black_ms_used;
		_tmp8_ = elapsed;
		used = _tmp7_ + _tmp8_;
	}
	_tmp9_ = used;
	next_tick_time = ((_tmp9_ / 1000) + 1) * 1000;
	_tmp10_ = used;
	_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, next_tick_time - _tmp10_, _chess_clock_tick_cb_gsource_func, g_object_ref (self), g_object_unref);
	self->priv->tick_timeout_id = _tmp11_;
	result = FALSE;
	return result;
}


void chess_clock_stop (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
	guint elapsed = 0U;
	GTimer* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	Color _tmp5_ = 0;
	Color _tmp6_ = 0;
	GTimer* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_is_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->timer;
	g_timer_stop (_tmp2_);
	chess_clock_stop_checking_timer (self);
	_tmp3_ = self->priv->timer;
	_tmp4_ = g_timer_elapsed (_tmp3_, NULL);
	elapsed = (guint) (_tmp4_ * 1000);
	_tmp5_ = chess_clock_get_active_color (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == COLOR_WHITE) {
		guint _tmp7_ = 0U;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		guint _tmp10_ = 0U;
		_tmp7_ = self->priv->_white_ms_used;
		_tmp8_ = elapsed;
		self->priv->_white_ms_used = _tmp7_ + _tmp8_;
		_tmp9_ = self->priv->_white_ms_used;
		_tmp10_ = self->priv->_white_initial_ms;
		if (_tmp9_ > _tmp10_) {
			guint _tmp11_ = 0U;
			_tmp11_ = self->priv->_white_initial_ms;
			self->priv->_white_ms_used = _tmp11_;
		}
	} else {
		guint _tmp12_ = 0U;
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
		_tmp12_ = self->priv->_black_ms_used;
		_tmp13_ = elapsed;
		self->priv->_black_ms_used = _tmp12_ + _tmp13_;
		_tmp14_ = self->priv->_black_ms_used;
		_tmp15_ = self->priv->_black_initial_ms;
		if (_tmp14_ > _tmp15_) {
			guint _tmp16_ = 0U;
			_tmp16_ = self->priv->_black_initial_ms;
			self->priv->_black_ms_used = _tmp16_;
		}
	}
	_tmp17_ = self->priv->timer;
	g_timer_reset (_tmp17_);
}


void chess_clock_pause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GTimer* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_is_active (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->timer;
	g_timer_stop (_tmp2_);
	chess_clock_stop_checking_timer (self);
}


void chess_clock_unpause (ChessClock* self) {
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	GTimer* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timer;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = chess_clock_get_is_active (self);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->timer;
	g_timer_continue (_tmp5_);
	chess_clock_watch_timer (self);
}


static gboolean _chess_clock_timer_expired_cb_gsource_func (gpointer self) {
	gboolean result;
	result = chess_clock_timer_expired_cb (self);
	return result;
}


static void chess_clock_watch_timer (ChessClock* self) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = chess_clock_get_active_color (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == COLOR_WHITE) {
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp2_ = self->priv->_white_initial_ms;
		_tmp3_ = self->priv->_white_ms_used;
		_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp2_ - _tmp3_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->expire_timeout_id = _tmp4_;
	} else {
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		_tmp5_ = self->priv->_black_initial_ms;
		_tmp6_ = self->priv->_black_ms_used;
		_tmp7_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp5_ - _tmp6_, _chess_clock_timer_expired_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->expire_timeout_id = _tmp7_;
	}
	chess_clock_tick_cb (self);
}


static void chess_clock_stop_checking_timer (ChessClock* self) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->expire_timeout_id;
	g_source_remove (_tmp0_);
	self->priv->expire_timeout_id = (guint) 0;
	_tmp1_ = self->priv->tick_timeout_id;
	g_source_remove (_tmp1_);
	self->priv->tick_timeout_id = (guint) 0;
}


static guint chess_clock_ms_to_seconds (ChessClock* self, guint ms) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = ms;
	result = (_tmp0_ + 500) / 1000;
	return result;
}


guint chess_clock_get_white_initial_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_white_initial_ms;
	_tmp1_ = chess_clock_ms_to_seconds (self, _tmp0_);
	result = _tmp1_;
	return result;
}


guint chess_clock_get_black_initial_seconds (ChessClock* self) {
	guint result;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_black_initial_ms;
	_tmp1_ = chess_clock_ms_to_seconds (self, _tmp0_);
	result = _tmp1_;
	return result;
}


guint chess_clock_get_white_seconds_used (ChessClock* self) {
	guint result;
	GTimer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->timer;
	if (_tmp0_ == NULL) {
		result = (guint) 0;
		return result;
	} else {
		Color _tmp1_ = 0;
		Color _tmp2_ = 0;
		_tmp1_ = chess_clock_get_active_color (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ == COLOR_WHITE) {
			guint _tmp3_ = 0U;
			GTimer* _tmp4_ = NULL;
			gdouble _tmp5_ = 0.0;
			guint _tmp6_ = 0U;
			_tmp3_ = self->priv->_white_ms_used;
			_tmp4_ = self->priv->timer;
			_tmp5_ = g_timer_elapsed (_tmp4_, NULL);
			_tmp6_ = chess_clock_ms_to_seconds (self, _tmp3_ + ((guint) (_tmp5_ * 1000)));
			result = _tmp6_;
			return result;
		} else {
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
			_tmp7_ = self->priv->_white_ms_used;
			_tmp8_ = chess_clock_ms_to_seconds (self, _tmp7_);
			result = _tmp8_;
			return result;
		}
	}
}


guint chess_clock_get_black_seconds_used (ChessClock* self) {
	guint result;
	GTimer* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->timer;
	if (_tmp0_ == NULL) {
		result = (guint) 0;
		return result;
	} else {
		Color _tmp1_ = 0;
		Color _tmp2_ = 0;
		_tmp1_ = chess_clock_get_active_color (self);
		_tmp2_ = _tmp1_;
		if (_tmp2_ == COLOR_WHITE) {
			guint _tmp3_ = 0U;
			guint _tmp4_ = 0U;
			_tmp3_ = self->priv->_black_ms_used;
			_tmp4_ = chess_clock_ms_to_seconds (self, _tmp3_);
			result = _tmp4_;
			return result;
		} else {
			guint _tmp5_ = 0U;
			GTimer* _tmp6_ = NULL;
			gdouble _tmp7_ = 0.0;
			guint _tmp8_ = 0U;
			_tmp5_ = self->priv->_black_ms_used;
			_tmp6_ = self->priv->timer;
			_tmp7_ = g_timer_elapsed (_tmp6_, NULL);
			_tmp8_ = chess_clock_ms_to_seconds (self, _tmp5_ + ((guint) (_tmp7_ * 1000)));
			result = _tmp8_;
			return result;
		}
	}
}


Color chess_clock_get_active_color (ChessClock* self) {
	Color result;
	Color _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_active_color;
	result = _tmp0_;
	return result;
}


void chess_clock_set_active_color (ChessClock* self, Color value) {
	Color _tmp0_ = 0;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	Color _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = chess_clock_get_active_color (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		return;
	}
	chess_clock_stop (self);
	_tmp3_ = value;
	self->priv->_active_color = _tmp3_;
	chess_clock_start (self);
	g_object_notify ((GObject *) self, "active-color");
}


static gboolean chess_clock_get_is_active (ChessClock* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	GTimer* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->timer;
	if (_tmp1_ != NULL) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->expire_timeout_id;
		_tmp0_ = _tmp2_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


static void chess_clock_class_init (ChessClockClass * klass) {
	chess_clock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessClockPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_clock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_clock_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_clock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_INITIAL_SECONDS, g_param_spec_uint ("white-initial-seconds", "white-initial-seconds", "white-initial-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_INITIAL_SECONDS, g_param_spec_uint ("black-initial-seconds", "black-initial-seconds", "black-initial-seconds", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_WHITE_SECONDS_USED, g_param_spec_uint ("white-seconds-used", "white-seconds-used", "white-seconds-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_BLACK_SECONDS_USED, g_param_spec_uint ("black-seconds-used", "black-seconds-used", "black-seconds-used", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_CLOCK_ACTIVE_COLOR, g_param_spec_enum ("active-color", "active-color", "active-color", TYPE_COLOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("tick", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("expired", TYPE_CHESS_CLOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_clock_instance_init (ChessClock * self) {
	self->priv = CHESS_CLOCK_GET_PRIVATE (self);
	self->priv->_white_ms_used = (guint) 0;
	self->priv->_black_ms_used = (guint) 0;
	self->priv->_active_color = COLOR_WHITE;
	self->priv->expire_timeout_id = (guint) 0;
	self->priv->tick_timeout_id = (guint) 0;
}


static void chess_clock_finalize (GObject* obj) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_CLOCK, ChessClock);
	_g_timer_destroy0 (self->priv->timer);
	G_OBJECT_CLASS (chess_clock_parent_class)->finalize (obj);
}


GType chess_clock_get_type (void) {
	static volatile gsize chess_clock_type_id__volatile = 0;
	if (g_once_init_enter (&chess_clock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessClockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_clock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessClock), 0, (GInstanceInitFunc) chess_clock_instance_init, NULL };
		GType chess_clock_type_id;
		chess_clock_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessClock", &g_define_type_info, 0);
		g_once_init_leave (&chess_clock_type_id__volatile, chess_clock_type_id);
	}
	return chess_clock_type_id__volatile;
}


static void _vala_chess_clock_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
	switch (property_id) {
		case CHESS_CLOCK_WHITE_INITIAL_SECONDS:
		g_value_set_uint (value, chess_clock_get_white_initial_seconds (self));
		break;
		case CHESS_CLOCK_BLACK_INITIAL_SECONDS:
		g_value_set_uint (value, chess_clock_get_black_initial_seconds (self));
		break;
		case CHESS_CLOCK_WHITE_SECONDS_USED:
		g_value_set_uint (value, chess_clock_get_white_seconds_used (self));
		break;
		case CHESS_CLOCK_BLACK_SECONDS_USED:
		g_value_set_uint (value, chess_clock_get_black_seconds_used (self));
		break;
		case CHESS_CLOCK_ACTIVE_COLOR:
		g_value_set_enum (value, chess_clock_get_active_color (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_clock_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessClock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_CLOCK, ChessClock);
	switch (property_id) {
		case CHESS_CLOCK_ACTIVE_COLOR:
		chess_clock_set_active_color (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



