/* gnome-chess.c generated by valac 0.22.0.43-7c3715, the Vala compiler
 * generated from gnome-chess.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* Workaround for https://bugzilla.gnome.org/show_bug.cgi?id=647122 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <librsvg/rsvg.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define TYPE_APPLICATION (application_get_type ())
#define APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APPLICATION, Application))
#define APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APPLICATION, ApplicationClass))
#define IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APPLICATION))
#define IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APPLICATION))
#define APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APPLICATION, ApplicationClass))

typedef struct _Application Application;
typedef struct _ApplicationClass ApplicationClass;
typedef struct _ApplicationPrivate ApplicationPrivate;

#define TYPE_CHESS_SCENE (chess_scene_get_type ())
#define CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_SCENE, ChessScene))
#define CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_SCENE, ChessSceneClass))
#define IS_CHESS_SCENE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_SCENE))
#define IS_CHESS_SCENE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_SCENE))
#define CHESS_SCENE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_SCENE, ChessSceneClass))

typedef struct _ChessScene ChessScene;
typedef struct _ChessSceneClass ChessSceneClass;

#define TYPE_CHESS_VIEW (chess_view_get_type ())
#define CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW, ChessView))
#define CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW, ChessViewClass))
#define IS_CHESS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW))
#define IS_CHESS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW))
#define CHESS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW, ChessViewClass))

typedef struct _ChessView ChessView;
typedef struct _ChessViewClass ChessViewClass;

#define TYPE_PGN_GAME (pgn_game_get_type ())
#define PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN_GAME, PGNGame))
#define PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN_GAME, PGNGameClass))
#define IS_PGN_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN_GAME))
#define IS_PGN_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN_GAME))
#define PGN_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN_GAME, PGNGameClass))

typedef struct _PGNGame PGNGame;
typedef struct _PGNGameClass PGNGameClass;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;

#define TYPE_AI_PROFILE (ai_profile_get_type ())
#define AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AI_PROFILE, AIProfile))
#define AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AI_PROFILE, AIProfileClass))
#define IS_AI_PROFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AI_PROFILE))
#define IS_AI_PROFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AI_PROFILE))
#define AI_PROFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AI_PROFILE, AIProfileClass))

typedef struct _AIProfile AIProfile;
typedef struct _AIProfileClass AIProfileClass;

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;

#define TYPE_CHESS_ENGINE (chess_engine_get_type ())
#define CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE, ChessEngine))
#define CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE, ChessEngineClass))
#define IS_CHESS_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE))
#define IS_CHESS_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE))
#define CHESS_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE, ChessEngineClass))

typedef struct _ChessEngine ChessEngine;
typedef struct _ChessEngineClass ChessEngineClass;

#define APPLICATION_TYPE_SENSITIVITY_INDEX (application_sensitivity_index_get_type ())

#define APPLICATION_TYPE_PROMOTION_TYPE_SELECTED (application_promotion_type_selected_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pgn_game_unref0(var) ((var == NULL) ? NULL : (var = (pgn_game_unref (var), NULL)))
#define _chess_game_unref0(var) ((var == NULL) ? NULL : (var = (chess_game_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__ai_profile_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__ai_profile_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _ai_profile_unref0(var) ((var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL)))
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_VIEW3_D (chess_view3_d_get_type ())
#define CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW3_D, ChessView3D))
#define CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW3_D, ChessView3DClass))
#define IS_CHESS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW3_D))
#define IS_CHESS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW3_D))
#define CHESS_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW3_D, ChessView3DClass))

typedef struct _ChessView3D ChessView3D;
typedef struct _ChessView3DClass ChessView3DClass;

#define TYPE_CHESS_VIEW2_D (chess_view2_d_get_type ())
#define CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_VIEW2_D, ChessView2D))
#define CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_VIEW2_D, ChessView2DClass))
#define IS_CHESS_VIEW2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_VIEW2_D))
#define IS_CHESS_VIEW2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_VIEW2_D))
#define CHESS_VIEW2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_VIEW2_D, ChessView2DClass))

typedef struct _ChessView2D ChessView2D;
typedef struct _ChessView2DClass ChessView2DClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))
typedef struct _PGNGamePrivate PGNGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;

#define TYPE_CHESS_ENGINE_CECP (chess_engine_cecp_get_type ())
#define CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECP))
#define CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))
#define IS_CHESS_ENGINE_CECP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_CECP))
#define IS_CHESS_ENGINE_CECP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_CECP))
#define CHESS_ENGINE_CECP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_CECP, ChessEngineCECPClass))

typedef struct _ChessEngineCECP ChessEngineCECP;
typedef struct _ChessEngineCECPClass ChessEngineCECPClass;

#define TYPE_CHESS_ENGINE_UCI (chess_engine_uci_get_type ())
#define CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCI))
#define CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))
#define IS_CHESS_ENGINE_UCI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_ENGINE_UCI))
#define IS_CHESS_ENGINE_UCI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_ENGINE_UCI))
#define CHESS_ENGINE_UCI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_ENGINE_UCI, ChessEngineUCIClass))

typedef struct _ChessEngineUCI ChessEngineUCI;
typedef struct _ChessEngineUCIClass ChessEngineUCIClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define TYPE_PGN (pgn_get_type ())
#define PGN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PGN, PGN))
#define PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PGN, PGNClass))
#define IS_PGN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PGN))
#define IS_PGN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PGN))
#define PGN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PGN, PGNClass))

typedef struct _PGN PGN;
typedef struct _PGNClass PGNClass;
typedef struct _PGNPrivate PGNPrivate;
#define _pgn_unref0(var) ((var == NULL) ? NULL : (var = (pgn_unref (var), NULL)))

#define TYPE_GNOME_CHESS (gnome_chess_get_type ())
#define GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GNOME_CHESS, GnomeChess))
#define GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GNOME_CHESS, GnomeChessClass))
#define IS_GNOME_CHESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GNOME_CHESS))
#define IS_GNOME_CHESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GNOME_CHESS))
#define GNOME_CHESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GNOME_CHESS, GnomeChessClass))

typedef struct _GnomeChess GnomeChess;
typedef struct _GnomeChessClass GnomeChessClass;
typedef struct _GnomeChessPrivate GnomeChessPrivate;
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
typedef struct _ParamSpecGnomeChess ParamSpecGnomeChess;

struct _Application {
	GtkApplication parent_instance;
	ApplicationPrivate * priv;
};

struct _ApplicationClass {
	GtkApplicationClass parent_class;
};

struct _ApplicationPrivate {
	GSettings* settings;
	GtkBuilder* builder;
	GtkBuilder* preferences_builder;
	GtkWindow* window;
	GtkInfoBar* info_bar;
	GtkLabel* info_title_label;
	GtkLabel* info_label;
	GtkContainer* view_container;
	ChessScene* scene;
	ChessView* view;
	GtkWidget* save_button;
	GtkWidget* undo_button;
	GtkWidget* pause_button;
	GtkWidget* claim_draw_button;
	GtkWidget* resign_button;
	GtkWidget* fullscreen_button;
	GtkWidget* first_move_button;
	GtkWidget* prev_move_button;
	GtkWidget* next_move_button;
	GtkWidget* last_move_button;
	GtkComboBox* history_combo;
	GtkWidget* white_time_label;
	GtkWidget* black_time_label;
	GtkDialog* preferences_dialog;
	GtkComboBox* side_combo;
	GtkComboBox* difficulty_combo;
	GtkComboBox* duration_combo;
	GtkAdjustment* duration_adjustment;
	GtkContainer* custom_duration_box;
	GtkComboBox* custom_duration_units_combo;
	guint save_duration_timeout;
	GtkFileChooserDialog* open_dialog;
	GtkInfoBar* open_dialog_info_bar;
	GtkLabel* open_dialog_error_label;
	GtkFileChooserDialog* save_dialog;
	GtkInfoBar* save_dialog_info_bar;
	GtkLabel* save_dialog_error_label;
	GtkAboutDialog* about_dialog;
	PGNGame* pgn_game;
	ChessGame* game;
	gboolean in_history;
	gchar* autosave_filename;
	GFile* game_file;
	gboolean game_needs_saving;
	gchar* saved_filename;
	GList* ai_profiles;
	ChessPlayer* opponent;
	ChessPlayer* human_player;
	ChessEngine* opponent_engine;
	gboolean is_fullscreen;
	gboolean widget_sensitivity[8];
};

typedef enum  {
	APPLICATION_SENSITIVITY_INDEX_UNDO,
	APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW,
	APPLICATION_SENSITIVITY_INDEX_RESIGN,
	APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE,
	APPLICATION_SENSITIVITY_INDEX_PREV_MOVE,
	APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE,
	APPLICATION_SENSITIVITY_INDEX_LAST_MOVE,
	APPLICATION_SENSITIVITY_INDEX_HISTORY
} ApplicationSensitivityIndex;

typedef enum  {
	APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN,
	APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT,
	APPLICATION_PROMOTION_TYPE_SELECTED_ROOK,
	APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP
} ApplicationPromotionTypeSelected;

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GTypeClass parent_class;
	void (*finalize) (ChessGame *self);
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _PGNGame {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNGamePrivate * priv;
	GHashTable* tags;
	GList* moves;
};

struct _PGNGameClass {
	GTypeClass parent_class;
	void (*finalize) (PGNGame *self);
};

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

struct _PGN {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PGNPrivate * priv;
	GList* games;
};

struct _PGNClass {
	GTypeClass parent_class;
	void (*finalize) (PGN *self);
};

struct _GnomeChess {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GnomeChessPrivate * priv;
};

struct _GnomeChessClass {
	GTypeClass parent_class;
	void (*finalize) (GnomeChess *self);
};

struct _ParamSpecGnomeChess {
	GParamSpec parent_instance;
};


static gpointer application_parent_class = NULL;
extern gchar* pgn_game_RESULT_WHITE;
extern gchar* pgn_game_RESULT_BLACK;
extern gchar* pgn_game_RESULT_DRAW;
extern gchar* pgn_game_TERMINATE_ABANDONED;
extern gchar* pgn_game_TERMINATE_DEATH;
static gpointer gnome_chess_parent_class = NULL;
static gboolean gnome_chess_show_version;
static gboolean gnome_chess_show_version = FALSE;

void gtk_file_filter_set_name (GtkFileFilter* filter, const gchar* name);
GType application_get_type (void) G_GNUC_CONST;
GType chess_scene_get_type (void) G_GNUC_CONST;
GType chess_view_get_type (void) G_GNUC_CONST;
gpointer pgn_game_ref (gpointer instance);
void pgn_game_unref (gpointer instance);
GParamSpec* param_spec_pgn_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn_game (GValue* value, gpointer v_object);
void value_take_pgn_game (GValue* value, gpointer v_object);
gpointer value_get_pgn_game (const GValue* value);
GType pgn_game_get_type (void) G_GNUC_CONST;
gpointer chess_game_ref (gpointer instance);
void chess_game_unref (gpointer instance);
GParamSpec* param_spec_chess_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_game (GValue* value, gpointer v_object);
void value_take_chess_game (GValue* value, gpointer v_object);
gpointer value_get_chess_game (const GValue* value);
GType chess_game_get_type (void) G_GNUC_CONST;
gpointer ai_profile_ref (gpointer instance);
void ai_profile_unref (gpointer instance);
GParamSpec* param_spec_ai_profile (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_ai_profile (GValue* value, gpointer v_object);
void value_take_ai_profile (GValue* value, gpointer v_object);
gpointer value_get_ai_profile (const GValue* value);
GType ai_profile_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
GType chess_engine_get_type (void) G_GNUC_CONST;
#define APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_APPLICATION, ApplicationPrivate))
enum  {
	APPLICATION_DUMMY_PROPERTY
};
static GType application_sensitivity_index_get_type (void) G_GNUC_UNUSED;
static GType application_promotion_type_selected_get_type (void) G_GNUC_UNUSED;
static void _ai_profile_unref0_ (gpointer var);
static void _g_list_free__ai_profile_unref0_ (GList* self);
void application_preferences_cb (Application* self);
static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_help_cb (Application* self);
static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_about_cb (Application* self);
static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void application_quit_cb (Application* self);
static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Application* application_new (GFile* game_file);
Application* application_construct (GType object_type, GFile* game_file);
gboolean application_on_window_focus_out (Application* self, GdkEventFocus* focus);
void chess_game_pause (ChessGame* self);
gboolean application_on_window_focus_in (Application* self, GdkEventFocus* focus);
void chess_game_unpause (ChessGame* self);
static void application_real_startup (GApplication* base);
static gboolean _application_on_window_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean _application_on_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
ChessScene* chess_scene_new (void);
ChessScene* chess_scene_construct (GType object_type);
static gboolean __lambda2_ (Application* self, ChessPlayer* p);
static gboolean ___lambda2__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self);
static void application_scene_changed_cb (Application* self, ChessScene* scene);
static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self);
GType piece_type_get_type (void) G_GNUC_CONST;
PieceType application_show_promotion_type_selector (Application* self);
static PieceType _application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self);
static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key);
static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
GList* ai_profile_load_ai_profiles (const gchar* filename);
const gchar* ai_profile_get_name (AIProfile* self);
const gchar* ai_profile_get_path (AIProfile* self);
static void application_start_new_game (Application* self);
static void application_load_game (Application* self, GFile* file, GError** error);
void application_show (Application* self);
static void application_real_shutdown (GApplication* base);
void chess_engine_stop (ChessEngine* self);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
const gchar* chess_scene_get_theme_name (ChessScene* self);
static void application_set_piece_image (Application* self, GtkImage* image, const gchar* filename);
void application_quit_game (Application* self);
static gboolean application_save_duration_cb (Application* self);
static void application_autosave (Application* self);
static void application_update_pgn_time_remaining (Application* self);
void pgn_game_write (PGNGame* self, GFile* file, GError** error);
ChessView3D* chess_view3_d_new (void);
ChessView3D* chess_view3_d_construct (GType object_type);
GType chess_view3_d_get_type (void) G_GNUC_CONST;
ChessView2D* chess_view2_d_new (void);
ChessView2D* chess_view2_d_construct (GType object_type);
GType chess_view2_d_get_type (void) G_GNUC_CONST;
void chess_view_set_scene (ChessView* self, ChessScene* value);
static void application_update_history_panel (Application* self);
gint chess_scene_get_move_number (ChessScene* self);
guint chess_game_get_n_moves (ChessGame* self);
GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move);
static void application_start_game (Application* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
gboolean pgn_game_get_set_up (PGNGame* self);
const gchar* pgn_game_get_fen (PGNGame* self);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
const gchar* pgn_game_get_time_control (PGNGame* self);
const gchar* pgn_game_get_white_time_left (PGNGame* self);
const gchar* pgn_game_get_black_time_left (PGNGame* self);
ChessClock* chess_clock_new (guint white_initial_seconds, guint black_initial_seconds);
ChessClock* chess_clock_construct (GType object_type, guint white_initial_seconds, guint black_initial_seconds);
GType chess_clock_get_type (void) G_GNUC_CONST;
void chess_game_set_clock (ChessGame* self, ChessClock* value);
static void application_game_start_cb (Application* self, ChessGame* game);
static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self);
static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player);
static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self);
static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move);
static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self);
static void application_game_undo_cb (Application* self, ChessGame* game);
static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self);
static void application_game_end_cb (Application* self, ChessGame* game);
static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self);
ChessClock* chess_game_get_clock (ChessGame* self);
static void application_game_clock_tick_cb (Application* self, ChessClock* clock);
static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self);
void chess_scene_set_game (ChessScene* self, ChessGame* value);
static void application_update_control_buttons (Application* self);
const gchar* pgn_game_get_white_ai (PGNGame* self);
const gchar* pgn_game_get_white_level (PGNGame* self);
const gchar* pgn_game_get_black_ai (PGNGame* self);
const gchar* pgn_game_get_black_level (PGNGame* self);
static void application_engine_ready_cb (Application* self, ChessEngine* engine);
static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self);
static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move);
static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self);
static void application_engine_resigned_cb (Application* self, ChessEngine* engine);
static void _application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self);
static void application_engine_stopped_cb (Application* self, ChessEngine* engine);
static void _application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self);
static void application_engine_error_cb (Application* self, ChessEngine* engine);
static void _application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self);
static void application_engine_claim_draw_cb (Application* self, ChessEngine* engine);
static void _application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self);
static void application_engine_offer_draw_cb (Application* self, ChessEngine* engine);
static void _application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self);
ChessPlayer* chess_game_get_white (ChessGame* self);
ChessPlayer* chess_game_get_black (ChessGame* self);
static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
gboolean chess_engine_start (ChessEngine* self);
void chess_game_start (ChessGame* self);
void chess_clock_start (ChessClock* self);
gchar** ai_profile_get_easy_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
gchar** ai_profile_get_easy_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
gchar** ai_profile_get_easy_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup4 (gchar** self, int length);
gchar** ai_profile_get_hard_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup5 (gchar** self, int length);
gchar** ai_profile_get_hard_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup6 (gchar** self, int length);
gchar** ai_profile_get_hard_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup7 (gchar** self, int length);
gchar** ai_profile_get_normal_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup8 (gchar** self, int length);
gchar** ai_profile_get_normal_uci_go_options (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup9 (gchar** self, int length);
gchar** ai_profile_get_normal_args (AIProfile* self, int* result_length1);
static gchar** _vala_array_dup10 (gchar** self, int length);
const gchar* ai_profile_get_protocol (AIProfile* self);
const gchar* ai_profile_get_binary (AIProfile* self);
ChessEngineCECP* chess_engine_cecp_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
ChessEngineCECP* chess_engine_cecp_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1);
GType chess_engine_cecp_get_type (void) G_GNUC_CONST;
ChessEngineUCI* chess_engine_uci_new (const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
ChessEngineUCI* chess_engine_uci_construct (GType object_type, const gchar* binary, gchar** args, int args_length1, gchar** options, int options_length1, gchar** go_options, int go_options_length1);
GType chess_engine_uci_get_type (void) G_GNUC_CONST;
static void application_real_activate (GApplication* base);
gboolean chess_engine_get_ready (ChessEngine* self);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
gboolean chess_player_resign (ChessPlayer* self);
static gboolean __lambda3_ (Application* self);
static gboolean ___lambda3__gsource_func (gpointer self);
gboolean chess_player_claim_draw (ChessPlayer* self);
void chess_engine_start_game (ChessEngine* self);
void chess_engine_request_move (ChessEngine* self);
const gchar* chess_scene_get_move_format (ChessScene* self);
gchar* chess_move_get_san (ChessMove* self);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_lan (ChessMove* self);
void chess_engine_report_move (ChessEngine* self, ChessMove* move);
void chess_engine_undo (ChessEngine* self);
void chess_scene_set_move_number (ChessScene* self, gint value);
void pgn_game_set_result (PGNGame* self, const gchar* value);
void pgn_game_set_termination (PGNGame* self, const gchar* value);
gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self);
gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self);
static gboolean application_prompt_save_game (Application* self, const gchar* prompt_text);
static void application_save_game (Application* self, const gchar* cancel_button_label, const gchar* save_button_label);
void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self);
gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
ChessState* chess_game_get_current_state (ChessGame* self);
void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self);
void chess_player_undo (ChessPlayer* self);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static void application_stash_button_sensitivity (Application* self);
static void application_revert_button_sensitivity (Application* self);
void G_MODULE_EXPORT pause_game_button_pressed_cb (GtkWidget* widget, Application* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_game_superpause (ChessGame* self);
gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1);
static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color);
gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self);
guint chess_clock_get_white_initial_seconds (ChessClock* self);
guint chess_clock_get_white_seconds_used (ChessClock* self);
guint chess_clock_get_black_initial_seconds (ChessClock* self);
guint chess_clock_get_black_seconds_used (ChessClock* self);
void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self);
void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self);
static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value);
static void application_set_duration (Application* self, gint duration, gboolean simplify);
static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index);
void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self);
static gint application_get_duration (Application* self);
void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self);
static void application_save_duration (Application* self);
void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self);
static gboolean _application_save_duration_cb_gsource_func (gpointer self);
void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self);
gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self);
void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self);
void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self);
void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self);
static void application_about_response_cb (Application* self, gint response_id);
static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self);
static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label);
static void application_save_file_cb (Application* self);
static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_save_cb (Application* self, gint response_id);
static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void pgn_game_set_white_time_left (PGNGame* self, const gchar* value);
void pgn_game_set_black_time_left (PGNGame* self, const gchar* value);
void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self);
static void application_open_file_cb (Application* self);
static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self);
static void application_open_cb (Application* self, gint response_id);
static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
PGNGame* pgn_game_new (void);
PGNGame* pgn_game_construct (GType object_type);
void pgn_game_set_date (PGNGame* self, const gchar* value);
void pgn_game_set_time (PGNGame* self, const gchar* value);
void pgn_game_set_time_control (PGNGame* self, const gchar* value);
void pgn_game_set_black_ai (PGNGame* self, const gchar* value);
void pgn_game_set_black_level (PGNGame* self, const gchar* value);
void pgn_game_set_white_ai (PGNGame* self, const gchar* value);
void pgn_game_set_white_level (PGNGame* self, const gchar* value);
gpointer pgn_ref (gpointer instance);
void pgn_unref (gpointer instance);
GParamSpec* param_spec_pgn (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_pgn (GValue* value, gpointer v_object);
void value_take_pgn (GValue* value, gpointer v_object);
gpointer value_get_pgn (const GValue* value);
GType pgn_get_type (void) G_GNUC_CONST;
PGN* pgn_new_from_file (GFile* file, GError** error);
PGN* pgn_construct_from_file (GType object_type, GFile* file, GError** error);
static void application_finalize (GObject* obj);
gpointer gnome_chess_ref (gpointer instance);
void gnome_chess_unref (gpointer instance);
GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_gnome_chess (GValue* value, gpointer v_object);
void value_take_gnome_chess (GValue* value, gpointer v_object);
gpointer value_get_gnome_chess (const GValue* value);
GType gnome_chess_get_type (void) G_GNUC_CONST;
enum  {
	GNOME_CHESS_DUMMY_PROPERTY
};
gint gnome_chess_main (gchar** args, int args_length1);
GnomeChess* gnome_chess_new (void);
GnomeChess* gnome_chess_construct (GType object_type);
static void gnome_chess_finalize (GnomeChess* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry APPLICATION_app_entries[4] = {{"preferences", _application_preferences_cb_gsimple_action_activate_callback}, {"help", _application_help_cb_gsimple_action_activate_callback}, {"about", _application_about_cb_gsimple_action_activate_callback}, {"quit", _application_quit_cb_gsimple_action_activate_callback}};
static const gchar* APPLICATION_authors[2] = {"Robert Ancell <robert.ancell@gmail.com>", NULL};
static const gchar* APPLICATION_artists[4] = {"John-Paul Gignac (3D Models)", "Max Froumentin (2D Models)", "Hylke Bons <h.bons@student.rug.nl> (icon)", NULL};
const GOptionEntry GNOME_CHESS_options[2] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &gnome_chess_show_version, "Show release version", NULL}, {NULL}};

static GType application_sensitivity_index_get_type (void) {
	static volatile gsize application_sensitivity_index_type_id__volatile = 0;
	if (g_once_init_enter (&application_sensitivity_index_type_id__volatile)) {
		static const GEnumValue values[] = {{APPLICATION_SENSITIVITY_INDEX_UNDO, "APPLICATION_SENSITIVITY_INDEX_UNDO", "undo"}, {APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW, "APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW", "claim-draw"}, {APPLICATION_SENSITIVITY_INDEX_RESIGN, "APPLICATION_SENSITIVITY_INDEX_RESIGN", "resign"}, {APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE, "APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE", "first-move"}, {APPLICATION_SENSITIVITY_INDEX_PREV_MOVE, "APPLICATION_SENSITIVITY_INDEX_PREV_MOVE", "prev-move"}, {APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE, "APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE", "next-move"}, {APPLICATION_SENSITIVITY_INDEX_LAST_MOVE, "APPLICATION_SENSITIVITY_INDEX_LAST_MOVE", "last-move"}, {APPLICATION_SENSITIVITY_INDEX_HISTORY, "APPLICATION_SENSITIVITY_INDEX_HISTORY", "history"}, {0, NULL, NULL}};
		GType application_sensitivity_index_type_id;
		application_sensitivity_index_type_id = g_enum_register_static ("ApplicationSensitivityIndex", values);
		g_once_init_leave (&application_sensitivity_index_type_id__volatile, application_sensitivity_index_type_id);
	}
	return application_sensitivity_index_type_id__volatile;
}


static GType application_promotion_type_selected_get_type (void) {
	static volatile gsize application_promotion_type_selected_type_id__volatile = 0;
	if (g_once_init_enter (&application_promotion_type_selected_type_id__volatile)) {
		static const GEnumValue values[] = {{APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN, "APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN", "queen"}, {APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT, "APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT", "knight"}, {APPLICATION_PROMOTION_TYPE_SELECTED_ROOK, "APPLICATION_PROMOTION_TYPE_SELECTED_ROOK", "rook"}, {APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP, "APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP", "bishop"}, {0, NULL, NULL}};
		GType application_promotion_type_selected_type_id;
		application_promotion_type_selected_type_id = g_enum_register_static ("ApplicationPromotionTypeSelected", values);
		g_once_init_leave (&application_promotion_type_selected_type_id__volatile, application_promotion_type_selected_type_id);
	}
	return application_promotion_type_selected_type_id__volatile;
}


static void _ai_profile_unref0_ (gpointer var) {
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	(var == NULL) ? NULL : (var = (ai_profile_unref (var), NULL));
#line 851 "gnome-chess.c"
}


static void _g_list_free__ai_profile_unref0_ (GList* self) {
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_list_foreach (self, (GFunc) _ai_profile_unref0_, NULL);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_list_free (self);
#line 860 "gnome-chess.c"
}


static void _application_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_preferences_cb (self);
#line 867 "gnome-chess.c"
}


static void _application_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_help_cb (self);
#line 874 "gnome-chess.c"
}


static void _application_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_about_cb (self);
#line 881 "gnome-chess.c"
}


static void _application_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 82 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_quit_cb (self);
#line 888 "gnome-chess.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self ? g_object_ref (self) : NULL;
#line 895 "gnome-chess.c"
}


Application* application_construct (GType object_type, GFile* game_file) {
	Application * self = NULL;
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
#line 92 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = (Application*) g_object_new (object_type, "application-id", "org.gnome.gnome-chess", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = game_file;
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 93 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp1_;
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self;
#line 915 "gnome-chess.c"
}


Application* application_new (GFile* game_file) {
#line 90 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return application_construct (TYPE_APPLICATION, game_file);
#line 922 "gnome-chess.c"
}


gboolean application_on_window_focus_out (Application* self, GdkEventFocus* focus) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 96 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (focus != NULL, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->pause_button;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_tool_button_get_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 98 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp2_, "gtk-media-pause") == 0) {
#line 943 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 99 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_pause (_tmp3_);
#line 949 "gnome-chess.c"
	}
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 955 "gnome-chess.c"
}


gboolean application_on_window_focus_in (Application* self, GdkEventFocus* focus) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (focus != NULL, FALSE);
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->pause_button;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_tool_button_get_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp2_, "gtk-media-pause") == 0) {
#line 976 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp3_);
#line 982 "gnome-chess.c"
	}
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 988 "gnome-chess.c"
}


static gboolean _application_on_window_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = application_on_window_focus_out (self, event);
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 997 "gnome-chess.c"
}


static gboolean _application_on_window_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = application_on_window_focus_in (self, event);
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1006 "gnome-chess.c"
}


static gboolean __lambda2_ (Application* self, ChessPlayer* p) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (p != NULL, FALSE);
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = p;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->human_player;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = _tmp0_ == _tmp1_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1024 "gnome-chess.c"
}


static gboolean ___lambda2__chess_scene_is_human (ChessScene* _sender, ChessPlayer* player, gpointer self) {
	gboolean result;
	result = __lambda2_ (self, player);
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1033 "gnome-chess.c"
}


static void _application_scene_changed_cb_chess_scene_changed (ChessScene* _sender, gpointer self) {
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_scene_changed_cb (self, _sender);
#line 1040 "gnome-chess.c"
}


static PieceType _application_show_promotion_type_selector_chess_scene_choose_promotion_type (ChessScene* _sender, gpointer self) {
	PieceType result;
	result = application_show_promotion_type_selector (self);
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 1049 "gnome-chess.c"
}


static void _application_settings_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_settings_changed_cb (self, _sender, key);
#line 1056 "gnome-chess.c"
}


static gpointer _ai_profile_ref0 (gpointer self) {
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self ? ai_profile_ref (self) : NULL;
#line 1063 "gnome-chess.c"
}


static void application_real_startup (GApplication* base) {
	Application * self;
	GSettings* _tmp0_ = NULL;
	GFile* data_dir = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GMenuModel* menu = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GMenuModel* _tmp15_ = NULL;
	GtkBuilder* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkWindow* _tmp23_ = NULL;
	GtkBuilder* _tmp24_ = NULL;
	GObject* _tmp25_ = NULL;
	GtkWidget* _tmp26_ = NULL;
	GtkBuilder* _tmp27_ = NULL;
	GObject* _tmp28_ = NULL;
	GtkWidget* _tmp29_ = NULL;
	GtkBuilder* _tmp30_ = NULL;
	GObject* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkWidget* _tmp35_ = NULL;
	GtkBuilder* _tmp36_ = NULL;
	GObject* _tmp37_ = NULL;
	GtkWidget* _tmp38_ = NULL;
	GtkBuilder* _tmp39_ = NULL;
	GObject* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	GtkBuilder* _tmp42_ = NULL;
	GObject* _tmp43_ = NULL;
	GtkWidget* _tmp44_ = NULL;
	GtkBuilder* _tmp45_ = NULL;
	GObject* _tmp46_ = NULL;
	GtkWidget* _tmp47_ = NULL;
	GtkBuilder* _tmp48_ = NULL;
	GObject* _tmp49_ = NULL;
	GtkWidget* _tmp50_ = NULL;
	GtkBuilder* _tmp51_ = NULL;
	GObject* _tmp52_ = NULL;
	GtkWidget* _tmp53_ = NULL;
	GtkBuilder* _tmp54_ = NULL;
	GObject* _tmp55_ = NULL;
	GtkComboBox* _tmp56_ = NULL;
	GtkBuilder* _tmp57_ = NULL;
	GObject* _tmp58_ = NULL;
	GtkWidget* _tmp59_ = NULL;
	GtkBuilder* _tmp60_ = NULL;
	GObject* _tmp61_ = NULL;
	GtkWidget* _tmp62_ = NULL;
	GtkVBox* view_box = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkVBox* _tmp65_ = NULL;
	GtkBuilder* _tmp66_ = NULL;
	GObject* _tmp67_ = NULL;
	GtkContainer* _tmp68_ = NULL;
	GtkBuilder* _tmp69_ = NULL;
	GtkWindow* _tmp70_ = NULL;
	GtkWindow* _tmp71_ = NULL;
	GtkWindow* _tmp72_ = NULL;
	GtkInfoBar* _tmp73_ = NULL;
	GtkContainer* content_area = NULL;
	GtkInfoBar* _tmp74_ = NULL;
	GtkContainer* _tmp75_ = NULL;
	GtkContainer* _tmp76_ = NULL;
	GtkVBox* _tmp77_ = NULL;
	GtkInfoBar* _tmp78_ = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp79_ = NULL;
	GtkBox* _tmp80_ = NULL;
	GtkContainer* _tmp81_ = NULL;
	GtkBox* _tmp82_ = NULL;
	GtkLabel* _tmp83_ = NULL;
	GtkLabel* _tmp84_ = NULL;
	GtkBox* _tmp85_ = NULL;
	GtkLabel* _tmp86_ = NULL;
	GtkBox* _tmp87_ = NULL;
	GtkBox* _tmp88_ = NULL;
	GtkLabel* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	GtkBox* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	ChessScene* _tmp93_ = NULL;
	ChessScene* _tmp94_ = NULL;
	ChessScene* _tmp95_ = NULL;
	ChessScene* _tmp96_ = NULL;
	GSettings* _tmp97_ = NULL;
	ChessScene* _tmp98_ = NULL;
	GSettings* _tmp99_ = NULL;
	ChessScene* _tmp100_ = NULL;
	GSettings* _tmp101_ = NULL;
	ChessScene* _tmp102_ = NULL;
	GSettings* _tmp103_ = NULL;
	ChessScene* _tmp104_ = NULL;
	GSettings* _tmp105_ = NULL;
	ChessScene* _tmp106_ = NULL;
	GSettings* _tmp107_ = NULL;
	ChessScene* _tmp108_ = NULL;
	GSettings* _tmp109_ = NULL;
	GSettings* _tmp110_ = NULL;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	GList* _tmp113_ = NULL;
	GList* _tmp114_ = NULL;
	gchar* _tmp122_ = NULL;
	gchar* _tmp123_ = NULL;
	gchar* _tmp124_ = NULL;
	GFile* _tmp125_ = NULL;
	GFile* _tmp131_ = NULL;
	GtkWindow* _tmp139_ = NULL;
	GSettings* _tmp140_ = NULL;
	gint _tmp141_ = 0;
	GSettings* _tmp142_ = NULL;
	gint _tmp143_ = 0;
	GSettings* _tmp144_ = NULL;
	gboolean _tmp145_ = FALSE;
	GError * _inner_error_ = NULL;
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = (Application*) base;
#line 114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-chess");
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->settings = _tmp0_;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_get_user_data_dir ();
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_build_filename (_tmp1_, "gnome-chess", NULL, NULL);
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	data_dir = _tmp5_;
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = g_file_get_path (data_dir);
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_;
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_mkdir_with_parents (_tmp7_, 0755);
#line 119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp7_);
#line 121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_action_map_add_action_entries ((GActionMap*) self, APPLICATION_app_entries, G_N_ELEMENTS (APPLICATION_app_entries), self);
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = gtk_builder_new ();
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->builder);
#line 123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->builder = _tmp8_;
#line 1233 "gnome-chess.c"
	{
		GtkBuilder* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->builder;
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = g_build_filename (PKGDATADIR, "menu.ui", NULL, NULL);
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp9_, _tmp11_, &_inner_error_);
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp11_);
#line 127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 1250 "gnome-chess.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = e->message;
#line 131 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_error ("gnome-chess.vala:131: Error loading menu UI: %s", _tmp12_);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 1269 "gnome-chess.c"
	}
	__finally0:
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 125 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 1282 "gnome-chess.c"
	}
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->builder;
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = gtk_builder_get_object (_tmp13_, "appmenu");
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp14_) : NULL);
#line 134 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	menu = _tmp15_;
#line 135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_application_set_app_menu ((GtkApplication*) self, menu);
#line 1294 "gnome-chess.c"
	{
		GtkBuilder* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->builder;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = g_build_filename (PKGDATADIR, "gnome-chess.ui", NULL, NULL);
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp16_, _tmp18_, &_inner_error_);
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp18_);
#line 139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 1311 "gnome-chess.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = e;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_->message;
#line 143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:143: Could not load UI: %s", _tmp20_);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 1333 "gnome-chess.c"
	}
	__finally1:
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (menu);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (data_dir);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 137 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 1348 "gnome-chess.c"
	}
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->builder;
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_builder_get_object (_tmp21_, "gnome_chess_app");
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GTK_TYPE_WINDOW, GtkWindow));
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->window = _tmp23_;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->builder;
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = gtk_builder_get_object (_tmp24_, "save_game_button");
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GTK_TYPE_WIDGET, GtkWidget));
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_button);
#line 146 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_button = _tmp26_;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->builder;
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_builder_get_object (_tmp27_, "undo_move_button");
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GTK_TYPE_WIDGET, GtkWidget));
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 147 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->undo_button = _tmp29_;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->builder;
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "pause_game_button");
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GTK_TYPE_WIDGET, GtkWidget));
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->pause_button = _tmp32_;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->builder;
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "claim_draw_button");
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_WIDGET, GtkWidget));
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->claim_draw_button);
#line 149 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->claim_draw_button = _tmp35_;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->builder;
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = gtk_builder_get_object (_tmp36_, "resign_button");
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GTK_TYPE_WIDGET, GtkWidget));
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->resign_button);
#line 150 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->resign_button = _tmp38_;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = self->priv->builder;
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = gtk_builder_get_object (_tmp39_, "fullscreen_button");
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GTK_TYPE_WIDGET, GtkWidget));
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->fullscreen_button);
#line 151 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->fullscreen_button = _tmp41_;
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->builder;
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = gtk_builder_get_object (_tmp42_, "first_move_button");
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GTK_TYPE_WIDGET, GtkWidget));
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->first_move_button = _tmp44_;
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = self->priv->builder;
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = gtk_builder_get_object (_tmp45_, "prev_move_button");
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GTK_TYPE_WIDGET, GtkWidget));
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 153 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->prev_move_button = _tmp47_;
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = self->priv->builder;
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = gtk_builder_get_object (_tmp48_, "next_move_button");
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GTK_TYPE_WIDGET, GtkWidget));
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->next_move_button = _tmp50_;
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = self->priv->builder;
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = gtk_builder_get_object (_tmp51_, "last_move_button");
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GTK_TYPE_WIDGET, GtkWidget));
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 155 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->last_move_button = _tmp53_;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = self->priv->builder;
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = gtk_builder_get_object (_tmp54_, "history_combo");
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->history_combo = _tmp56_;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = self->priv->builder;
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = gtk_builder_get_object (_tmp57_, "white_time_label");
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, GTK_TYPE_WIDGET, GtkWidget));
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->white_time_label = _tmp59_;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->builder;
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = gtk_builder_get_object (_tmp60_, "black_time_label");
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GTK_TYPE_WIDGET, GtkWidget));
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 158 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->black_time_label = _tmp62_;
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp63_ = self->priv->builder;
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp64_ = gtk_builder_get_object (_tmp63_, "view_box");
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, GTK_TYPE_VBOX, GtkVBox));
#line 159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	view_box = _tmp65_;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp66_ = self->priv->builder;
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp67_ = gtk_builder_get_object (_tmp66_, "view_container");
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, GTK_TYPE_CONTAINER, GtkContainer));
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 160 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->view_container = _tmp68_;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = self->priv->builder;
#line 161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp69_, self);
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = self->priv->window;
#line 163 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_application_add_window ((GtkApplication*) self, _tmp70_);
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp71_ = self->priv->window;
#line 164 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp71_, "focus-out-event", (GCallback) _application_on_window_focus_out_gtk_widget_focus_out_event, self, 0);
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp72_ = self->priv->window;
#line 165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkWidget*) _tmp72_, "focus-in-event", (GCallback) _application_on_window_focus_in_gtk_widget_focus_in_event, self, 0);
#line 167 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 167 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp73_);
#line 167 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 167 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->info_bar = _tmp73_;
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = self->priv->info_bar;
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = gtk_info_bar_get_content_area (_tmp74_);
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, GTK_TYPE_CONTAINER, GtkContainer));
#line 168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	content_area = _tmp76_;
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = view_box;
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = self->priv->info_bar;
#line 169 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start ((GtkBox*) _tmp77_, (GtkWidget*) _tmp78_, FALSE, TRUE, (guint) 0);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp79_);
#line 170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	vbox = _tmp79_;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = vbox;
#line 171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp80_);
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = content_area;
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = vbox;
#line 172 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (_tmp81_, (GtkWidget*) _tmp82_);
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = (GtkLabel*) gtk_label_new ("");
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp83_);
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_title_label);
#line 173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->info_title_label = _tmp83_;
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = self->priv->info_title_label;
#line 174 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp84_);
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = vbox;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->info_title_label;
#line 175 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (_tmp85_, (GtkWidget*) _tmp86_, FALSE, TRUE, (guint) 0);
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = vbox;
#line 176 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp87_, TRUE);
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = vbox;
#line 177 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_vexpand ((GtkWidget*) _tmp88_, FALSE);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = (GtkLabel*) gtk_label_new ("");
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp89_);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_label);
#line 178 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->info_label = _tmp89_;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = self->priv->info_label;
#line 179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp90_);
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = vbox;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = self->priv->info_label;
#line 180 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (_tmp91_, (GtkWidget*) _tmp92_, TRUE, TRUE, (guint) 0);
#line 182 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = chess_scene_new ();
#line 182 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 182 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->scene = _tmp93_;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->scene;
#line 183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp94_, "is-human", (GCallback) ___lambda2__chess_scene_is_human, self, 0);
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = self->priv->scene;
#line 184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp95_, "changed", (GCallback) _application_scene_changed_cb_chess_scene_changed, self, 0);
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = self->priv->scene;
#line 185 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp96_, "choose-promotion-type", (GCallback) _application_show_promotion_type_selector_chess_scene_choose_promotion_type, self, 0);
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = self->priv->settings;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = self->priv->scene;
#line 186 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp97_, "show-move-hints", (GObject*) _tmp98_, "show-move-hints", G_SETTINGS_BIND_GET);
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->settings;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = self->priv->scene;
#line 187 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp99_, "show-numbering", (GObject*) _tmp100_, "show-numbering", G_SETTINGS_BIND_GET);
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = self->priv->settings;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = self->priv->scene;
#line 188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp101_, "piece-theme", (GObject*) _tmp102_, "theme-name", G_SETTINGS_BIND_GET);
#line 189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = self->priv->settings;
#line 189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = self->priv->scene;
#line 189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp103_, "show-3d-smooth", (GObject*) _tmp104_, "show-3d-smooth", G_SETTINGS_BIND_GET);
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->settings;
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = self->priv->scene;
#line 190 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp105_, "move-format", (GObject*) _tmp106_, "move-format", G_SETTINGS_BIND_GET);
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = self->priv->settings;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = self->priv->scene;
#line 191 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp107_, "board-side", (GObject*) _tmp108_, "board-side", G_SETTINGS_BIND_GET);
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = self->priv->settings;
#line 193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp109_, "changed", (GCallback) _application_settings_changed_cb_g_settings_changed, self, 0);
#line 194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = self->priv->settings;
#line 194 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_settings_changed_cb (self, _tmp110_, "show-3d");
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp111_ = g_build_filename (SYSCONFDIR, "chess-engines.conf", NULL, NULL);
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = _tmp111_;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = ai_profile_load_ai_profiles (_tmp112_);
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->ai_profiles = _tmp113_;
#line 196 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp112_);
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = self->priv->ai_profiles;
#line 1682 "gnome-chess.c"
	{
		GList* profile_collection = NULL;
		GList* profile_it = NULL;
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		profile_collection = _tmp114_;
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		for (profile_it = profile_collection; profile_it != NULL; profile_it = profile_it->next) {
#line 1690 "gnome-chess.c"
			AIProfile* _tmp115_ = NULL;
			AIProfile* profile = NULL;
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp115_ = _ai_profile_ref0 ((AIProfile*) profile_it->data);
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			profile = _tmp115_;
#line 1697 "gnome-chess.c"
			{
				AIProfile* _tmp116_ = NULL;
				const gchar* _tmp117_ = NULL;
				const gchar* _tmp118_ = NULL;
				AIProfile* _tmp119_ = NULL;
				const gchar* _tmp120_ = NULL;
				const gchar* _tmp121_ = NULL;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp116_ = profile;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp117_ = ai_profile_get_name (_tmp116_);
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp118_ = _tmp117_;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp119_ = profile;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp120_ = ai_profile_get_path (_tmp119_);
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp121_ = _tmp120_;
#line 198 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				g_message ("gnome-chess.vala:198: Detected AI profile %s in %s", _tmp118_, _tmp121_);
#line 197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_ai_profile_unref0 (profile);
#line 1721 "gnome-chess.c"
			}
		}
	}
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp122_ = g_file_get_path (data_dir);
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp123_ = _tmp122_;
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp124_ = g_strconcat (_tmp123_, "/autosave.pgn", NULL);
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->autosave_filename = _tmp124_;
#line 200 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp123_);
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp125_ = self->priv->game_file;
#line 203 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp125_ == NULL) {
#line 1741 "gnome-chess.c"
		const gchar* _tmp126_ = NULL;
		gboolean _tmp127_ = FALSE;
		GFile* _tmp130_ = NULL;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp126_ = self->priv->autosave_filename;
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp127_ = g_file_test (_tmp126_, G_FILE_TEST_EXISTS);
#line 205 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp127_) {
#line 1751 "gnome-chess.c"
			const gchar* _tmp128_ = NULL;
			GFile* _tmp129_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp128_ = self->priv->autosave_filename;
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp129_ = g_file_new_for_path (_tmp128_);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp129_;
#line 1762 "gnome-chess.c"
		}
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp130_ = self->priv->game_file;
#line 208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp130_ != NULL) {
#line 209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->in_history = TRUE;
#line 1770 "gnome-chess.c"
		} else {
#line 211 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_start_new_game (self);
#line 1774 "gnome-chess.c"
		}
	} else {
#line 214 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->in_history = FALSE;
#line 1779 "gnome-chess.c"
	}
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp131_ = self->priv->game_file;
#line 216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp131_ != NULL) {
#line 1785 "gnome-chess.c"
		{
			GFile* _tmp132_ = NULL;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp132_ = self->priv->game_file;
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_load_game (self, _tmp132_, &_inner_error_);
#line 220 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_inner_error_ != NULL) {
#line 1794 "gnome-chess.c"
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp133_ = NULL;
			GFile* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_ = NULL;
			GError* _tmp137_ = NULL;
			const gchar* _tmp138_ = NULL;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp133_ = stderr;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp134_ = self->priv->game_file;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp135_ = g_file_get_path (_tmp134_);
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp136_ = _tmp135_;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp137_ = e;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp138_ = _tmp137_->message;
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			fprintf (_tmp133_, "Failed to load %s: %s\n", _tmp136_, _tmp138_);
#line 224 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp136_);
#line 225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_application_quit ((GApplication*) self);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 1832 "gnome-chess.c"
		}
		__finally2:
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (vbox);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (content_area);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (view_box);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (menu);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (data_dir);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return;
#line 1853 "gnome-chess.c"
		}
	}
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp139_ = self->priv->window;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp140_ = self->priv->settings;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp141_ = g_settings_get_int (_tmp140_, "width");
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp142_ = self->priv->settings;
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp143_ = g_settings_get_int (_tmp142_, "height");
#line 229 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_default_size (_tmp139_, _tmp141_, _tmp143_);
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp144_ = self->priv->settings;
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp145_ = g_settings_get_boolean (_tmp144_, "fullscreen");
#line 231 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp145_) {
#line 1874 "gnome-chess.c"
		GtkWindow* _tmp146_ = NULL;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp146_ = self->priv->window;
#line 233 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_fullscreen (_tmp146_);
#line 234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->is_fullscreen = TRUE;
#line 1882 "gnome-chess.c"
	} else {
		GSettings* _tmp147_ = NULL;
		gboolean _tmp148_ = FALSE;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp147_ = self->priv->settings;
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp148_ = g_settings_get_boolean (_tmp147_, "maximized");
#line 236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp148_) {
#line 1892 "gnome-chess.c"
			GtkWindow* _tmp149_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp149_ = self->priv->window;
#line 238 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_window_maximize (_tmp149_);
#line 1898 "gnome-chess.c"
		}
	}
#line 241 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_show (self);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (vbox);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (content_area);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (view_box);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (menu);
#line 112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (data_dir);
#line 1913 "gnome-chess.c"
}


static void application_real_shutdown (GApplication* base) {
	Application * self;
	ChessEngine* _tmp0_ = NULL;
#line 244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = (Application*) base;
#line 246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (application_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
#line 247 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 247 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 1928 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 248 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp1_);
#line 1934 "gnome-chess.c"
	}
}


PieceType application_show_promotion_type_selector (Application* self) {
	PieceType result = 0;
	GtkBuilder* promotion_type_selector_builder = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GtkDialog* promotion_type_selector_dialog = NULL;
	GtkBuilder* _tmp6_ = NULL;
	GObject* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	gchar* color = NULL;
	ChessGame* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessPlayer* _tmp11_ = NULL;
	Color _tmp12_ = 0;
	gchar* filename = NULL;
	ChessScene* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	ChessScene* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	const gchar* _tmp35_ = NULL;
	ChessScene* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	GtkBuilder* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	const gchar* _tmp45_ = NULL;
	ChessScene* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	const gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_ = NULL;
	GtkBuilder* _tmp53_ = NULL;
	GObject* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GtkBuilder* _tmp56_ = NULL;
	PieceType selection = 0;
	gint choice = 0;
	GtkDialog* _tmp57_ = NULL;
	gint _tmp58_ = 0;
	gint _tmp59_ = 0;
	GtkDialog* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
#line 251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = gtk_builder_new ();
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 255 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_builder = _tmp0_;
#line 2010 "gnome-chess.c"
	{
		GtkBuilder* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = promotion_type_selector_builder;
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = g_build_filename (PKGDATADIR, "promotion-type-selector.ui", NULL, NULL);
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_;
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp1_, _tmp3_, &_inner_error_);
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp3_);
#line 258 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 2027 "gnome-chess.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 262 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = e;
#line 262 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_->message;
#line 262 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:262: Could not load promotion type selector UI: %s", _tmp5_);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2049 "gnome-chess.c"
	}
	__finally3:
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (promotion_type_selector_builder);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 256 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return 0;
#line 2062 "gnome-chess.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = promotion_type_selector_builder;
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_builder_get_object (_tmp6_, "dialog_promotion_type_selector");
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp7_) : NULL);
#line 265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	promotion_type_selector_dialog = _tmp8_;
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->game;
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = chess_game_get_current_player (_tmp9_);
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = _tmp10_;
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _tmp11_->color;
#line 268 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == COLOR_WHITE) {
#line 2082 "gnome-chess.c"
		gchar* _tmp13_ = NULL;
#line 269 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = g_strdup ("white");
#line 269 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 269 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		color = _tmp13_;
#line 2090 "gnome-chess.c"
	} else {
		gchar* _tmp14_ = NULL;
#line 271 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = g_strdup ("black");
#line 271 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (color);
#line 271 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		color = _tmp14_;
#line 2099 "gnome-chess.c"
	}
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->scene;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = chess_scene_get_theme_name (_tmp15_);
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = color;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = g_strdup_printf ("%sQueen.svg", _tmp18_);
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _tmp19_;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = g_build_filename (PKGDATADIR, "pieces", _tmp17_, _tmp20_, NULL);
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _tmp21_;
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp20_);
#line 273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	filename = _tmp22_;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = promotion_type_selector_builder;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_builder_get_object (_tmp23_, "image_queen");
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = filename;
#line 274 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp24_) : NULL, _tmp25_);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = self->priv->scene;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = chess_scene_get_theme_name (_tmp26_);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp27_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = color;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = g_strdup_printf ("%sKnight.svg", _tmp29_);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _tmp30_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = g_build_filename (PKGDATADIR, "pieces", _tmp28_, _tmp31_, NULL);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	filename = _tmp32_;
#line 276 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp31_);
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = promotion_type_selector_builder;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "image_knight");
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = filename;
#line 277 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp34_) : NULL, _tmp35_);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = self->priv->scene;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = chess_scene_get_theme_name (_tmp36_);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = color;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = g_strdup_printf ("%sRook.svg", _tmp39_);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = _tmp40_;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = g_build_filename (PKGDATADIR, "pieces", _tmp38_, _tmp41_, NULL);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	filename = _tmp42_;
#line 279 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp41_);
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = promotion_type_selector_builder;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = gtk_builder_get_object (_tmp43_, "image_rook");
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = filename;
#line 280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp44_) : NULL, _tmp45_);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp46_ = self->priv->scene;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp47_ = chess_scene_get_theme_name (_tmp46_);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp48_ = _tmp47_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp49_ = color;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = g_strdup_printf ("%sBishop.svg", _tmp49_);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = _tmp50_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = g_build_filename (PKGDATADIR, "pieces", _tmp48_, _tmp51_, NULL);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	filename = _tmp52_;
#line 282 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp51_);
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp53_ = promotion_type_selector_builder;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = gtk_builder_get_object (_tmp53_, "image_bishop");
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = filename;
#line 283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_piece_image (self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, GTK_TYPE_IMAGE) ? ((GtkImage*) _tmp54_) : NULL, _tmp55_);
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = promotion_type_selector_builder;
#line 285 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp56_, self);
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = promotion_type_selector_dialog;
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = gtk_dialog_run (_tmp57_);
#line 288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	choice = _tmp58_;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = choice;
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	switch (_tmp59_) {
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case APPLICATION_PROMOTION_TYPE_SELECTED_QUEEN:
#line 2229 "gnome-chess.c"
		{
#line 292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_QUEEN;
#line 293 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 2235 "gnome-chess.c"
		}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case APPLICATION_PROMOTION_TYPE_SELECTED_KNIGHT:
#line 2239 "gnome-chess.c"
		{
#line 295 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_KNIGHT;
#line 296 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 2245 "gnome-chess.c"
		}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case APPLICATION_PROMOTION_TYPE_SELECTED_ROOK:
#line 2249 "gnome-chess.c"
		{
#line 298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_ROOK;
#line 299 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 2255 "gnome-chess.c"
		}
#line 289 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case APPLICATION_PROMOTION_TYPE_SELECTED_BISHOP:
#line 2259 "gnome-chess.c"
		{
#line 301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_BISHOP;
#line 302 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 2265 "gnome-chess.c"
		}
		default:
		{
#line 304 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			selection = PIECE_TYPE_QUEEN;
#line 305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 2273 "gnome-chess.c"
		}
	}
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = promotion_type_selector_dialog;
#line 307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp60_);
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = selection;
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (filename);
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (color);
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_dialog);
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (promotion_type_selector_builder);
#line 309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 2292 "gnome-chess.c"
}


static void application_set_piece_image (Application* self, GtkImage* image, const gchar* filename) {
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* pixbuf = NULL;
	GtkImage* _tmp11_ = NULL;
	GdkPixbuf* _tmp12_ = NULL;
	GError * _inner_error_ = NULL;
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (image != NULL);
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (filename != NULL);
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp0_, &_tmp1_);
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	width = _tmp0_;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	height = _tmp1_;
#line 315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2322 "gnome-chess.c"
	}
	{
		GdkPixbuf* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		GdkPixbuf* _tmp7_ = NULL;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = filename;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = width;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = height;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = rsvg_pixbuf_from_file_at_size (_tmp4_, _tmp5_, _tmp6_, &_inner_error_);
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp7_;
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 2342 "gnome-chess.c"
			goto __catch4_g_error;
		}
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (pixbuf);
#line 321 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pixbuf = _tmp3_;
#line 2349 "gnome-chess.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = filename;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = e;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_->message;
#line 325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:325: Failed to load image %s: %s", _tmp8_, _tmp10_);
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (pixbuf);
#line 326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2376 "gnome-chess.c"
	}
	__finally4:
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (pixbuf);
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 319 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2389 "gnome-chess.c"
	}
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = image;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = pixbuf;
#line 328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_image_set_from_pixbuf (_tmp11_, _tmp12_);
#line 312 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pixbuf);
#line 2399 "gnome-chess.c"
}


void application_quit_game (Application* self) {
	guint _tmp0_ = 0U;
	GtkWindow* _tmp1_ = NULL;
#line 339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 341 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 342 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_save_duration_cb (self);
#line 2414 "gnome-chess.c"
	}
#line 344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_autosave (self);
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->window;
#line 345 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
#line 2422 "gnome-chess.c"
}


static void application_autosave (Application* self) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game_needs_saving;
#line 351 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp0_) {
#line 2435 "gnome-chess.c"
		const gchar* _tmp1_ = NULL;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->autosave_filename;
#line 353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_remove (_tmp1_);
#line 354 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2443 "gnome-chess.c"
	}
	{
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp5_ = FALSE;
		GFile* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		PGNGame* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->in_history;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (!_tmp3_) {
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = TRUE;
#line 2460 "gnome-chess.c"
		} else {
			GFile* _tmp4_ = NULL;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->game_file;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = _tmp4_ == NULL;
#line 2467 "gnome-chess.c"
		}
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp2_;
#line 359 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp5_) {
#line 2473 "gnome-chess.c"
			const gchar* _tmp6_ = NULL;
			GFile* _tmp7_ = NULL;
#line 360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->autosave_filename;
#line 360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = g_file_new_for_path (_tmp6_);
#line 360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->game_file);
#line 360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->game_file = _tmp7_;
#line 2484 "gnome-chess.c"
		}
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game_file;
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = g_file_get_path (_tmp8_);
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_debug ("gnome-chess.vala:362: Writing current game to %s", _tmp10_);
#line 362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp10_);
#line 363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_update_pgn_time_remaining (self);
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->pgn_game;
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game_file;
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_write (_tmp11_, _tmp12_, &_inner_error_);
#line 364 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 2506 "gnome-chess.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = e;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_->message;
#line 368 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:368: Failed to autosave: %s", _tmp14_);
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2528 "gnome-chess.c"
	}
	__finally5:
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 357 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2539 "gnome-chess.c"
	}
}


static void application_settings_changed_cb (Application* self, GSettings* settings, const gchar* key) {
	const gchar* _tmp0_ = NULL;
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (settings != NULL);
#line 372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (key != NULL);
#line 374 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = key;
#line 374 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp0_, "show-3d") == 0) {
#line 2556 "gnome-chess.c"
		ChessView* _tmp1_ = NULL;
		GSettings* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		ChessView* _tmp9_ = NULL;
		ChessView* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		GtkContainer* _tmp12_ = NULL;
		ChessView* _tmp13_ = NULL;
		ChessView* _tmp14_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->view;
#line 376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp1_ != NULL) {
#line 2570 "gnome-chess.c"
			GtkContainer* _tmp2_ = NULL;
			ChessView* _tmp3_ = NULL;
			ChessView* _tmp4_ = NULL;
#line 378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = self->priv->view_container;
#line 378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->view;
#line 378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_container_remove (_tmp2_, (GtkWidget*) _tmp3_);
#line 379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->view;
#line 379 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 2584 "gnome-chess.c"
		}
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = settings;
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = g_settings_get_boolean (_tmp5_, "show-3d");
#line 381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp6_) {
#line 2592 "gnome-chess.c"
			ChessView3D* _tmp7_ = NULL;
#line 382 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = chess_view3_d_new ();
#line 382 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_object_ref_sink (_tmp7_);
#line 382 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->view);
#line 382 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->view = (ChessView*) _tmp7_;
#line 2602 "gnome-chess.c"
		} else {
			ChessView2D* _tmp8_ = NULL;
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = chess_view2_d_new ();
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_object_ref_sink (_tmp8_);
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->view);
#line 384 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->view = (ChessView*) _tmp8_;
#line 2613 "gnome-chess.c"
		}
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->view;
#line 385 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 300, 300);
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->view;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_view_set_scene (_tmp10_, _tmp11_);
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->view_container;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->view;
#line 387 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_container_add (_tmp12_, (GtkWidget*) _tmp13_);
#line 388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->view;
#line 388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_show ((GtkWidget*) _tmp14_);
#line 2635 "gnome-chess.c"
	}
}


static gpointer _chess_state_ref0 (gpointer self) {
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self ? chess_state_ref (self) : NULL;
#line 2643 "gnome-chess.c"
}


static void application_update_history_panel (Application* self) {
	ChessGame* _tmp0_ = NULL;
	gint move_number = 0;
	ChessScene* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint n_moves = 0;
	ChessGame* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
	GtkWidget* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GtkWidget* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	GtkWidget* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean _tmp20_ = FALSE;
	gint _tmp21_ = 0;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gint i = 0;
	gint _tmp26_ = 0;
	ChessGame* _tmp27_ = NULL;
	GList* _tmp28_ = NULL;
	GtkComboBox* _tmp42_ = NULL;
	gint _tmp43_ = 0;
#line 392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 394 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 2685 "gnome-chess.c"
	}
#line 397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_number (_tmp1_);
#line 397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp3_;
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_n_moves (_tmp4_);
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 398 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	n_moves = (gint) _tmp6_;
#line 399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = move_number;
#line 399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_ < 0) {
#line 2707 "gnome-chess.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = move_number;
#line 400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = n_moves;
#line 400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		move_number = _tmp8_ + (1 + _tmp9_);
#line 2716 "gnome-chess.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = n_moves;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp11_ > 0) {
#line 2722 "gnome-chess.c"
		gint _tmp12_ = 0;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = move_number;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp12_ != 0;
#line 2728 "gnome-chess.c"
	} else {
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = FALSE;
#line 2732 "gnome-chess.c"
	}
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->first_move_button;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp10_;
#line 402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp13_, _tmp14_);
#line 403 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->prev_move_button;
#line 403 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = move_number;
#line 403 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp15_, _tmp16_ > 0);
#line 404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->next_move_button;
#line 404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = move_number;
#line 404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = n_moves;
#line 404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp17_, _tmp18_ < _tmp19_);
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = n_moves;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ > 0) {
#line 2758 "gnome-chess.c"
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = move_number;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = n_moves;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp22_ != _tmp23_;
#line 2767 "gnome-chess.c"
	} else {
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = FALSE;
#line 2771 "gnome-chess.c"
	}
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->last_move_button;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp20_;
#line 405 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp24_, _tmp25_);
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = n_moves;
#line 408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	i = _tmp26_;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->game;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp27_->move_stack;
#line 2787 "gnome-chess.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		state_collection = _tmp28_;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 2795 "gnome-chess.c"
			ChessState* _tmp29_ = NULL;
			ChessState* state = NULL;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = _chess_state_ref0 ((ChessState*) state_it->data);
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			state = _tmp29_;
#line 2802 "gnome-chess.c"
			{
				ChessState* _tmp30_ = NULL;
				ChessMove* _tmp31_ = NULL;
				gint _tmp41_ = 0;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = state;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = _tmp30_->last_move;
#line 411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp31_ != NULL) {
#line 2813 "gnome-chess.c"
					GtkTreeIter iter = {0};
					GtkComboBox* _tmp32_ = NULL;
					GtkTreeModel* _tmp33_ = NULL;
					GtkTreeModel* _tmp34_ = NULL;
					gint _tmp35_ = 0;
					GtkTreeIter _tmp36_ = {0};
					gboolean _tmp37_ = FALSE;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = self->priv->history_combo;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp33_ = gtk_combo_box_get_model (_tmp32_);
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp34_ = _tmp33_;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp35_ = i;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp37_ = gtk_tree_model_iter_nth_child (_tmp34_, &_tmp36_, NULL, _tmp35_);
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					iter = _tmp36_;
#line 414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (_tmp37_) {
#line 2835 "gnome-chess.c"
						GtkTreeIter _tmp38_ = {0};
						ChessState* _tmp39_ = NULL;
						ChessMove* _tmp40_ = NULL;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp38_ = iter;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = state;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp40_ = _tmp39_->last_move;
#line 415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						application_set_move_text (self, &_tmp38_, _tmp40_);
#line 2847 "gnome-chess.c"
					}
				}
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = i;
#line 417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				i = _tmp41_ - 1;
#line 409 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_chess_state_unref0 (state);
#line 2856 "gnome-chess.c"
			}
		}
	}
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->history_combo;
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = move_number;
#line 420 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp42_, _tmp43_);
#line 2866 "gnome-chess.c"
}


static void application_scene_changed_cb (Application* self, ChessScene* scene) {
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (scene != NULL);
#line 425 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_history_panel (self);
#line 2877 "gnome-chess.c"
}


static void _application_game_start_cb_chess_game_started (ChessGame* _sender, gpointer self) {
#line 483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_start_cb (self, _sender);
#line 2884 "gnome-chess.c"
}


static void _application_game_turn_cb_chess_game_turn_started (ChessGame* _sender, ChessPlayer* player, gpointer self) {
#line 484 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_turn_cb (self, _sender, player);
#line 2891 "gnome-chess.c"
}


static void _application_game_move_cb_chess_game_moved (ChessGame* _sender, ChessMove* move, gpointer self) {
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_move_cb (self, _sender, move);
#line 2898 "gnome-chess.c"
}


static void _application_game_undo_cb_chess_game_undo (ChessGame* _sender, gpointer self) {
#line 486 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_undo_cb (self, _sender);
#line 2905 "gnome-chess.c"
}


static void _application_game_end_cb_chess_game_ended (ChessGame* _sender, gpointer self) {
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_end_cb (self, _sender);
#line 2912 "gnome-chess.c"
}


static void _application_game_clock_tick_cb_chess_clock_tick (ChessClock* _sender, gpointer self) {
#line 489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_game_clock_tick_cb (self, _sender);
#line 2919 "gnome-chess.c"
}


static void _application_engine_ready_cb_chess_engine_ready_changed (ChessEngine* _sender, gpointer self) {
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_ready_cb (self, _sender);
#line 2926 "gnome-chess.c"
}


static void _application_engine_move_cb_chess_engine_moved (ChessEngine* _sender, const gchar* move, gpointer self) {
#line 514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_move_cb (self, _sender, move);
#line 2933 "gnome-chess.c"
}


static void _application_engine_resigned_cb_chess_engine_resigned (ChessEngine* _sender, gpointer self) {
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_resigned_cb (self, _sender);
#line 2940 "gnome-chess.c"
}


static void _application_engine_stopped_cb_chess_engine_stopped (ChessEngine* _sender, gpointer self) {
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_stopped_cb (self, _sender);
#line 2947 "gnome-chess.c"
}


static void _application_engine_error_cb_chess_engine_error (ChessEngine* _sender, gpointer self) {
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_error_cb (self, _sender);
#line 2954 "gnome-chess.c"
}


static void _application_engine_claim_draw_cb_chess_engine_claim_draw (ChessEngine* _sender, gpointer self) {
#line 518 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_claim_draw_cb (self, _sender);
#line 2961 "gnome-chess.c"
}


static void _application_engine_offer_draw_cb_chess_engine_offer_draw (ChessEngine* _sender, gpointer self) {
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_engine_offer_draw_cb (self, _sender);
#line 2968 "gnome-chess.c"
}


static void application_start_game (Application* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp15_ = NULL;
	GtkTreeModel* _tmp16_ = NULL;
	GtkTreeModel* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	GtkListStore* _tmp19_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter _tmp21_ = {0};
	GtkListStore* _tmp22_ = NULL;
	GtkTreeIter _tmp23_ = {0};
	const gchar* _tmp24_ = NULL;
	GtkComboBox* _tmp25_ = NULL;
	GtkTreeIter _tmp26_ = {0};
	gchar* fen = NULL;
	gchar* _tmp27_ = NULL;
	gchar** moves = NULL;
	PGNGame* _tmp28_ = NULL;
	GList* _tmp29_ = NULL;
	guint _tmp30_ = 0U;
	gchar** _tmp31_ = NULL;
	gint moves_length1 = 0;
	gint _moves_size_ = 0;
	gint i = 0;
	PGNGame* _tmp32_ = NULL;
	GList* _tmp33_ = NULL;
	PGNGame* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	const gchar* _tmp50_ = NULL;
	gchar** _tmp51_ = NULL;
	gint _tmp51__length1 = 0;
	ChessGame* _tmp52_ = NULL;
	gboolean _tmp53_ = FALSE;
	PGNGame* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	const gchar* _tmp56_ = NULL;
	gboolean _tmp61_ = FALSE;
	ChessGame* _tmp87_ = NULL;
	ChessGame* _tmp88_ = NULL;
	ChessGame* _tmp89_ = NULL;
	ChessGame* _tmp90_ = NULL;
	ChessGame* _tmp91_ = NULL;
	ChessGame* _tmp92_ = NULL;
	ChessClock* _tmp93_ = NULL;
	ChessClock* _tmp94_ = NULL;
	ChessScene* _tmp98_ = NULL;
	ChessGame* _tmp99_ = NULL;
	GtkInfoBar* _tmp100_ = NULL;
	GtkWidget* _tmp101_ = NULL;
	gchar* white_engine = NULL;
	PGNGame* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	const gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gchar* white_level = NULL;
	PGNGame* _tmp106_ = NULL;
	const gchar* _tmp107_ = NULL;
	const gchar* _tmp108_ = NULL;
	gchar* _tmp109_ = NULL;
	const gchar* _tmp110_ = NULL;
	gchar* black_engine = NULL;
	PGNGame* _tmp112_ = NULL;
	const gchar* _tmp113_ = NULL;
	const gchar* _tmp114_ = NULL;
	gchar* _tmp115_ = NULL;
	gchar* black_level = NULL;
	PGNGame* _tmp116_ = NULL;
	const gchar* _tmp117_ = NULL;
	const gchar* _tmp118_ = NULL;
	gchar* _tmp119_ = NULL;
	const gchar* _tmp120_ = NULL;
	ChessEngine* _tmp122_ = NULL;
	const gchar* _tmp138_ = NULL;
	ChessEngine* _tmp166_ = NULL;
	gboolean _tmp196_ = FALSE;
	GtkWidget* _tmp197_ = NULL;
	gboolean _tmp198_ = FALSE;
	ChessGame* _tmp199_ = NULL;
	gboolean _tmp200_ = FALSE;
	gchar** _tmp201_ = NULL;
	gint _tmp201__length1 = 0;
	gboolean _tmp205_ = FALSE;
	ChessGame* _tmp211_ = NULL;
	ChessResult _tmp212_ = 0;
	GtkWidget* _tmp214_ = NULL;
	GtkWidget* _tmp215_ = NULL;
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->in_history;
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = TRUE;
#line 3071 "gnome-chess.c"
	} else {
		GFile* _tmp2_ = NULL;
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game_file;
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp2_ == NULL;
#line 3078 "gnome-chess.c"
	}
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp0_;
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_) {
#line 3084 "gnome-chess.c"
		GtkWindow* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->window;
#line 432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _ ("Chess");
#line 432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_set_title (_tmp4_, _tmp5_);
#line 3093 "gnome-chess.c"
	} else {
		gchar* path = NULL;
		GFile* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		GtkWindow* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->game_file;
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = g_file_get_path (_tmp6_);
#line 437 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		path = _tmp7_;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->window;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _ ("Chess - %1$s");
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = path;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = g_path_get_basename (_tmp10_);
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = g_strdup_printf (_tmp9_, _tmp12_);
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_set_title (_tmp8_, _tmp14_);
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp14_);
#line 438 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp12_);
#line 430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (path);
#line 3133 "gnome-chess.c"
	}
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->history_combo;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = gtk_combo_box_get_model (_tmp15_);
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_;
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp18_;
#line 444 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = model;
#line 444 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_clear (_tmp19_);
#line 446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = model;
#line 446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp20_, &_tmp21_);
#line 446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp21_;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = model;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = iter;
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = _ ("Game Start");
#line 447 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp22_, &_tmp23_, 0, _tmp24_, 1, 0, -1, -1);
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->history_combo;
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = iter;
#line 450 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp25_, &_tmp26_);
#line 452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = g_strdup (CHESS_GAME_STANDARD_SETUP);
#line 452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	fen = _tmp27_;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->pgn_game;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = _tmp28_->moves;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = g_list_length (_tmp29_);
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = g_new0 (gchar*, _tmp30_ + 1);
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	moves = _tmp31_;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	moves_length1 = _tmp30_;
#line 453 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_moves_size_ = moves_length1;
#line 454 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	i = 0;
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = self->priv->pgn_game;
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = _tmp32_->moves;
#line 3193 "gnome-chess.c"
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		move_collection = _tmp33_;
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
#line 3201 "gnome-chess.c"
			gchar* _tmp34_ = NULL;
			gchar* move = NULL;
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup ((const gchar*) move_it->data);
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			move = _tmp34_;
#line 3208 "gnome-chess.c"
			{
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gint _tmp36_ = 0;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				gchar* _tmp39_ = NULL;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = moves;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp35__length1 = moves_length1;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = i;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				i = _tmp36_ + 1;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = move;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = g_strdup (_tmp37_);
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (_tmp35_[_tmp36_]);
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp35_[_tmp36_] = _tmp38_;
#line 456 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = _tmp35_[_tmp36_];
#line 455 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move);
#line 3236 "gnome-chess.c"
			}
		}
	}
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = self->priv->pgn_game;
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = pgn_game_get_set_up (_tmp40_);
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = _tmp41_;
#line 458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp42_) {
#line 3248 "gnome-chess.c"
		PGNGame* _tmp43_ = NULL;
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = self->priv->pgn_game;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = pgn_game_get_fen (_tmp43_);
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _tmp44_;
#line 460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp45_ != NULL) {
#line 3260 "gnome-chess.c"
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->pgn_game;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = pgn_game_get_fen (_tmp46_);
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp48_ = _tmp47_;
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = g_strdup (_tmp48_);
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (fen);
#line 461 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			fen = _tmp49_;
#line 3277 "gnome-chess.c"
		} else {
#line 463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:463: Chess game has SetUp tag but no FEN tag");
#line 3281 "gnome-chess.c"
		}
	}
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp50_ = fen;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp51_ = moves;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp51__length1 = moves_length1;
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp52_ = chess_game_new (_tmp50_, _tmp51_, _tmp51__length1);
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_chess_game_unref0 (self->priv->game);
#line 465 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game = _tmp52_;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = self->priv->pgn_game;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = pgn_game_get_time_control (_tmp54_);
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = _tmp55_;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp56_ != NULL) {
#line 3304 "gnome-chess.c"
		PGNGame* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		gint _tmp60_ = 0;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = self->priv->pgn_game;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = pgn_game_get_time_control (_tmp57_);
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = _tmp58_;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = atoi (_tmp59_);
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = _tmp60_ != 0;
#line 3319 "gnome-chess.c"
	} else {
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = FALSE;
#line 3323 "gnome-chess.c"
	}
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = _tmp53_;
#line 471 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp61_) {
#line 3329 "gnome-chess.c"
		gboolean _tmp62_ = FALSE;
		PGNGame* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		const gchar* _tmp65_ = NULL;
		gboolean _tmp69_ = FALSE;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = self->priv->pgn_game;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = pgn_game_get_white_time_left (_tmp63_);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = _tmp64_;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp65_ != NULL) {
#line 3343 "gnome-chess.c"
			PGNGame* _tmp66_ = NULL;
			const gchar* _tmp67_ = NULL;
			const gchar* _tmp68_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp66_ = self->priv->pgn_game;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp67_ = pgn_game_get_black_time_left (_tmp66_);
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp68_ = _tmp67_;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = _tmp68_ != NULL;
#line 3355 "gnome-chess.c"
		} else {
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp62_ = FALSE;
#line 3359 "gnome-chess.c"
		}
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = _tmp62_;
#line 473 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp69_) {
#line 3365 "gnome-chess.c"
			gint white_seconds = 0;
			PGNGame* _tmp70_ = NULL;
			const gchar* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			gint _tmp73_ = 0;
			gint black_seconds = 0;
			PGNGame* _tmp74_ = NULL;
			const gchar* _tmp75_ = NULL;
			const gchar* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gboolean _tmp78_ = FALSE;
			gint _tmp79_ = 0;
			gboolean _tmp81_ = FALSE;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp70_ = self->priv->pgn_game;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp71_ = pgn_game_get_white_time_left (_tmp70_);
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp72_ = _tmp71_;
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp73_ = atoi (_tmp72_);
#line 475 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			white_seconds = _tmp73_;
#line 476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = self->priv->pgn_game;
#line 476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = pgn_game_get_black_time_left (_tmp74_);
#line 476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = _tmp75_;
#line 476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = atoi (_tmp76_);
#line 476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			black_seconds = _tmp77_;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp79_ = white_seconds;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_tmp79_ > 0) {
#line 3403 "gnome-chess.c"
				gint _tmp80_ = 0;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = black_seconds;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = _tmp80_ > 0;
#line 3409 "gnome-chess.c"
			} else {
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp78_ = FALSE;
#line 3413 "gnome-chess.c"
			}
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp81_ = _tmp78_;
#line 478 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_tmp81_) {
#line 3419 "gnome-chess.c"
				ChessGame* _tmp82_ = NULL;
				gint _tmp83_ = 0;
				gint _tmp84_ = 0;
				ChessClock* _tmp85_ = NULL;
				ChessClock* _tmp86_ = NULL;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp82_ = self->priv->game;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp83_ = white_seconds;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp84_ = black_seconds;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp85_ = chess_clock_new ((guint) _tmp83_, (guint) _tmp84_);
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp86_ = _tmp85_;
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				chess_game_set_clock (_tmp82_, _tmp86_);
#line 479 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (_tmp86_);
#line 3439 "gnome-chess.c"
			}
		}
	}
#line 483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = self->priv->game;
#line 483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp87_, "started", (GCallback) _application_game_start_cb_chess_game_started, self, 0);
#line 484 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = self->priv->game;
#line 484 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp88_, "turn-started", (GCallback) _application_game_turn_cb_chess_game_turn_started, self, 0);
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = self->priv->game;
#line 485 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp89_, "moved", (GCallback) _application_game_move_cb_chess_game_moved, self, 0);
#line 486 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = self->priv->game;
#line 486 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp90_, "undo", (GCallback) _application_game_undo_cb_chess_game_undo, self, 0);
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = self->priv->game;
#line 487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object (_tmp91_, "ended", (GCallback) _application_game_end_cb_chess_game_ended, self, 0);
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = self->priv->game;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = chess_game_get_clock (_tmp92_);
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = _tmp93_;
#line 488 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp94_ != NULL) {
#line 3471 "gnome-chess.c"
		ChessGame* _tmp95_ = NULL;
		ChessClock* _tmp96_ = NULL;
		ChessClock* _tmp97_ = NULL;
#line 489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp95_ = self->priv->game;
#line 489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp96_ = chess_game_get_clock (_tmp95_);
#line 489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp97_ = _tmp96_;
#line 489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp97_, "tick", (GCallback) _application_game_clock_tick_cb_chess_clock_tick, self, 0);
#line 3483 "gnome-chess.c"
	}
#line 491 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = self->priv->scene;
#line 491 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = self->priv->game;
#line 491 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_game (_tmp98_, _tmp99_);
#line 492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = self->priv->info_bar;
#line 492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp100_);
#line 493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = self->priv->save_button;
#line 493 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp101_, FALSE);
#line 494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_history_panel (self);
#line 495 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_control_buttons (self);
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = self->priv->pgn_game;
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = pgn_game_get_white_ai (_tmp102_);
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = _tmp103_;
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = g_strdup (_tmp104_);
#line 498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	white_engine = _tmp105_;
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = self->priv->pgn_game;
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = pgn_game_get_white_level (_tmp106_);
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = _tmp107_;
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = g_strdup (_tmp108_);
#line 499 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	white_level = _tmp109_;
#line 500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = white_level;
#line 500 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp110_ == NULL) {
#line 3527 "gnome-chess.c"
		gchar* _tmp111_ = NULL;
#line 501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp111_ = g_strdup ("normal");
#line 501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (white_level);
#line 501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		white_level = _tmp111_;
#line 3535 "gnome-chess.c"
	}
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = self->priv->pgn_game;
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = pgn_game_get_black_ai (_tmp112_);
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = _tmp113_;
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = g_strdup (_tmp114_);
#line 503 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	black_engine = _tmp115_;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = self->priv->pgn_game;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp117_ = pgn_game_get_black_level (_tmp116_);
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp118_ = _tmp117_;
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp119_ = g_strdup (_tmp118_);
#line 504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	black_level = _tmp119_;
#line 505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp120_ = black_level;
#line 505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp120_ == NULL) {
#line 3561 "gnome-chess.c"
		gchar* _tmp121_ = NULL;
#line 506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp121_ = g_strdup ("normal");
#line 506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (black_level);
#line 506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		black_level = _tmp121_;
#line 3569 "gnome-chess.c"
	}
#line 508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 510 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp122_ = self->priv->opponent_engine;
#line 510 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp122_ != NULL) {
#line 3583 "gnome-chess.c"
		ChessEngine* _tmp123_ = NULL;
		ChessEngine* _tmp124_ = NULL;
		guint _tmp125_ = 0U;
		ChessEngine* _tmp126_ = NULL;
		guint _tmp127_ = 0U;
		ChessEngine* _tmp128_ = NULL;
		guint _tmp129_ = 0U;
		ChessEngine* _tmp130_ = NULL;
		guint _tmp131_ = 0U;
		ChessEngine* _tmp132_ = NULL;
		guint _tmp133_ = 0U;
		ChessEngine* _tmp134_ = NULL;
		guint _tmp135_ = 0U;
		ChessEngine* _tmp136_ = NULL;
		guint _tmp137_ = 0U;
#line 512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp123_ = self->priv->opponent_engine;
#line 512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp123_);
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp124_ = self->priv->opponent_engine;
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("ready-changed", TYPE_CHESS_ENGINE, &_tmp125_, NULL, FALSE);
#line 513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp124_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp125_, 0, NULL, (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self);
#line 514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp126_ = self->priv->opponent_engine;
#line 514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("moved", TYPE_CHESS_ENGINE, &_tmp127_, NULL, FALSE);
#line 514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp126_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp127_, 0, NULL, (GCallback) _application_engine_move_cb_chess_engine_moved, self);
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp128_ = self->priv->opponent_engine;
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("resigned", TYPE_CHESS_ENGINE, &_tmp129_, NULL, FALSE);
#line 515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp128_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp129_, 0, NULL, (GCallback) _application_engine_resigned_cb_chess_engine_resigned, self);
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp130_ = self->priv->opponent_engine;
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("stopped", TYPE_CHESS_ENGINE, &_tmp131_, NULL, FALSE);
#line 516 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp130_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp131_, 0, NULL, (GCallback) _application_engine_stopped_cb_chess_engine_stopped, self);
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp132_ = self->priv->opponent_engine;
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("error", TYPE_CHESS_ENGINE, &_tmp133_, NULL, FALSE);
#line 517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp132_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp133_, 0, NULL, (GCallback) _application_engine_error_cb_chess_engine_error, self);
#line 518 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp134_ = self->priv->opponent_engine;
#line 518 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("claim-draw", TYPE_CHESS_ENGINE, &_tmp135_, NULL, FALSE);
#line 518 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp134_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp135_, 0, NULL, (GCallback) _application_engine_claim_draw_cb_chess_engine_claim_draw, self);
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp136_ = self->priv->opponent_engine;
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_parse_name ("offer-draw", TYPE_CHESS_ENGINE, &_tmp137_, NULL, FALSE);
#line 519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_handlers_disconnect_matched (_tmp136_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp137_, 0, NULL, (GCallback) _application_engine_offer_draw_cb_chess_engine_offer_draw, self);
#line 520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = NULL;
#line 3649 "gnome-chess.c"
	}
#line 523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp138_ = white_engine;
#line 523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp138_ != NULL) {
#line 3655 "gnome-chess.c"
		ChessGame* _tmp139_ = NULL;
		ChessPlayer* _tmp140_ = NULL;
		ChessPlayer* _tmp141_ = NULL;
		ChessPlayer* _tmp142_ = NULL;
		ChessGame* _tmp143_ = NULL;
		ChessPlayer* _tmp144_ = NULL;
		ChessPlayer* _tmp145_ = NULL;
		ChessPlayer* _tmp146_ = NULL;
		const gchar* _tmp147_ = NULL;
		const gchar* _tmp148_ = NULL;
		ChessEngine* _tmp149_ = NULL;
		ChessPlayer* _tmp150_ = NULL;
		ChessPlayer* _tmp151_ = NULL;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp139_ = self->priv->game;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp140_ = chess_game_get_white (_tmp139_);
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp141_ = _tmp140_;
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp142_ = _g_object_ref0 (_tmp141_);
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent);
#line 525 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent = _tmp142_;
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp143_ = self->priv->game;
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp144_ = chess_game_get_black (_tmp143_);
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp145_ = _tmp144_;
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp146_ = _g_object_ref0 (_tmp145_);
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->human_player);
#line 526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->human_player = _tmp146_;
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp147_ = white_engine;
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp148_ = white_level;
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp149_ = application_get_engine (self, _tmp147_, _tmp148_);
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (self->priv->opponent_engine);
#line 527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->opponent_engine = _tmp149_;
#line 528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp150_ = self->priv->opponent;
#line 528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp150_, FALSE);
#line 529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp151_ = self->priv->human_player;
#line 529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp151_, TRUE);
#line 3711 "gnome-chess.c"
	} else {
		const gchar* _tmp152_ = NULL;
#line 531 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp152_ = black_engine;
#line 531 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp152_ != NULL) {
#line 3718 "gnome-chess.c"
			ChessGame* _tmp153_ = NULL;
			ChessPlayer* _tmp154_ = NULL;
			ChessPlayer* _tmp155_ = NULL;
			ChessPlayer* _tmp156_ = NULL;
			ChessGame* _tmp157_ = NULL;
			ChessPlayer* _tmp158_ = NULL;
			ChessPlayer* _tmp159_ = NULL;
			ChessPlayer* _tmp160_ = NULL;
			const gchar* _tmp161_ = NULL;
			const gchar* _tmp162_ = NULL;
			ChessEngine* _tmp163_ = NULL;
			ChessPlayer* _tmp164_ = NULL;
			ChessPlayer* _tmp165_ = NULL;
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp153_ = self->priv->game;
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp154_ = chess_game_get_black (_tmp153_);
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp155_ = _tmp154_;
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp156_ = _g_object_ref0 (_tmp155_);
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent);
#line 533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent = _tmp156_;
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp157_ = self->priv->game;
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp158_ = chess_game_get_white (_tmp157_);
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp159_ = _tmp158_;
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp160_ = _g_object_ref0 (_tmp159_);
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->human_player);
#line 534 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->human_player = _tmp160_;
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp161_ = black_engine;
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp162_ = black_level;
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp163_ = application_get_engine (self, _tmp161_, _tmp162_);
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (self->priv->opponent_engine);
#line 535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->opponent_engine = _tmp163_;
#line 536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp164_ = self->priv->opponent;
#line 536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp164_, FALSE);
#line 537 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp165_ = self->priv->human_player;
#line 537 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			chess_player_set_local_human (_tmp165_, TRUE);
#line 3774 "gnome-chess.c"
		}
	}
#line 541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp166_ = self->priv->opponent_engine;
#line 541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp166_ == NULL) {
#line 3781 "gnome-chess.c"
		ChessGame* _tmp167_ = NULL;
		ChessPlayer* _tmp168_ = NULL;
		ChessPlayer* _tmp169_ = NULL;
		ChessGame* _tmp170_ = NULL;
		ChessPlayer* _tmp171_ = NULL;
		ChessPlayer* _tmp172_ = NULL;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp167_ = self->priv->game;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp168_ = chess_game_get_black (_tmp167_);
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp169_ = _tmp168_;
#line 543 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp169_, TRUE);
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp170_ = self->priv->game;
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp171_ = chess_game_get_white (_tmp170_);
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp172_ = _tmp171_;
#line 544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_set_local_human (_tmp172_, TRUE);
#line 3804 "gnome-chess.c"
	} else {
		ChessEngine* _tmp173_ = NULL;
		ChessEngine* _tmp174_ = NULL;
		ChessEngine* _tmp175_ = NULL;
		ChessEngine* _tmp176_ = NULL;
		ChessEngine* _tmp177_ = NULL;
		ChessEngine* _tmp178_ = NULL;
		ChessEngine* _tmp179_ = NULL;
		ChessEngine* _tmp180_ = NULL;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp173_ = self->priv->opponent_engine;
#line 548 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp173_, "ready-changed", (GCallback) _application_engine_ready_cb_chess_engine_ready_changed, self, 0);
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp174_ = self->priv->opponent_engine;
#line 549 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp174_, "moved", (GCallback) _application_engine_move_cb_chess_engine_moved, self, 0);
#line 550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp175_ = self->priv->opponent_engine;
#line 550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp175_, "resigned", (GCallback) _application_engine_resigned_cb_chess_engine_resigned, self, 0);
#line 551 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp176_ = self->priv->opponent_engine;
#line 551 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp176_, "stopped", (GCallback) _application_engine_stopped_cb_chess_engine_stopped, self, 0);
#line 552 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp177_ = self->priv->opponent_engine;
#line 552 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp177_, "error", (GCallback) _application_engine_error_cb_chess_engine_error, self, 0);
#line 553 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp178_ = self->priv->opponent_engine;
#line 553 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp178_, "claim-draw", (GCallback) _application_engine_claim_draw_cb_chess_engine_claim_draw, self, 0);
#line 554 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp179_ = self->priv->opponent_engine;
#line 554 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_signal_connect_object (_tmp179_, "offer-draw", (GCallback) _application_engine_offer_draw_cb_chess_engine_offer_draw, self, 0);
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp180_ = self->priv->opponent_engine;
#line 555 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_start (_tmp180_);
#line 3846 "gnome-chess.c"
	}
	{
		gint j = 0;
		ChessGame* _tmp181_ = NULL;
		GList* _tmp182_ = NULL;
		guint _tmp183_ = 0U;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp181_ = self->priv->game;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp182_ = _tmp181_->move_stack;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp183_ = g_list_length (_tmp182_);
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		j = ((gint) _tmp183_) - 2;
#line 3861 "gnome-chess.c"
		{
			gboolean _tmp184_ = FALSE;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp184_ = TRUE;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 3868 "gnome-chess.c"
				gboolean _tmp185_ = FALSE;
				gint _tmp187_ = 0;
				ChessState* state = NULL;
				ChessGame* _tmp188_ = NULL;
				GList* _tmp189_ = NULL;
				gint _tmp190_ = 0;
				gconstpointer _tmp191_ = NULL;
				ChessState* _tmp192_ = NULL;
				ChessGame* _tmp193_ = NULL;
				ChessState* _tmp194_ = NULL;
				ChessMove* _tmp195_ = NULL;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp185_ = _tmp184_;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!_tmp185_) {
#line 3884 "gnome-chess.c"
					gint _tmp186_ = 0;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp186_ = j;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					j = _tmp186_ - 1;
#line 3890 "gnome-chess.c"
				}
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp184_ = FALSE;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp187_ = j;
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!(_tmp187_ >= 0)) {
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					break;
#line 3900 "gnome-chess.c"
				}
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp188_ = self->priv->game;
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp189_ = _tmp188_->move_stack;
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp190_ = j;
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp191_ = g_list_nth_data (_tmp189_, (guint) _tmp190_);
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp192_ = _chess_state_ref0 ((ChessState*) _tmp191_);
#line 561 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				state = _tmp192_;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp193_ = self->priv->game;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp194_ = state;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp195_ = _tmp194_->last_move;
#line 562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				application_game_move_cb (self, _tmp193_, _tmp195_);
#line 559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_chess_state_unref0 (state);
#line 3924 "gnome-chess.c"
			}
		}
	}
#line 565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp196_ = self->priv->in_history;
#line 565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = _tmp196_;
#line 566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp197_ = self->priv->save_button;
#line 566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp198_ = self->priv->in_history;
#line 566 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp197_, _tmp198_);
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp199_ = self->priv->game;
#line 567 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_game_start (_tmp199_);
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp201_ = moves;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp201__length1 = moves_length1;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp201__length1 > 0) {
#line 3948 "gnome-chess.c"
		ChessGame* _tmp202_ = NULL;
		ChessClock* _tmp203_ = NULL;
		ChessClock* _tmp204_ = NULL;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp202_ = self->priv->game;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp203_ = chess_game_get_clock (_tmp202_);
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp204_ = _tmp203_;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp200_ = _tmp204_ != NULL;
#line 3960 "gnome-chess.c"
	} else {
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp200_ = FALSE;
#line 3964 "gnome-chess.c"
	}
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp205_ = _tmp200_;
#line 569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp205_) {
#line 3970 "gnome-chess.c"
		ChessGame* _tmp206_ = NULL;
		ChessClock* _tmp207_ = NULL;
		ChessClock* _tmp208_ = NULL;
		GtkWidget* _tmp209_ = NULL;
#line 571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp206_ = self->priv->game;
#line 571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp207_ = chess_game_get_clock (_tmp206_);
#line 571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp208_ = _tmp207_;
#line 571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_clock_start (_tmp208_);
#line 572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp209_ = self->priv->pause_button;
#line 572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp209_, TRUE);
#line 3987 "gnome-chess.c"
	} else {
		GtkWidget* _tmp210_ = NULL;
#line 576 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp210_ = self->priv->pause_button;
#line 576 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp210_, FALSE);
#line 3994 "gnome-chess.c"
	}
#line 579 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp211_ = self->priv->game;
#line 579 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp212_ = _tmp211_->result;
#line 579 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp212_ != CHESS_RESULT_IN_PROGRESS) {
#line 4002 "gnome-chess.c"
		ChessGame* _tmp213_ = NULL;
#line 580 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp213_ = self->priv->game;
#line 580 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_game_end_cb (self, _tmp213_);
#line 4008 "gnome-chess.c"
	}
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp214_ = self->priv->white_time_label;
#line 582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp214_);
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp215_ = self->priv->black_time_label;
#line 583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp215_);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_level);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (black_engine);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_level);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (white_engine);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	moves = (_vala_array_free (moves, moves_length1, (GDestroyNotify) g_free), NULL);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (fen);
#line 428 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 4032 "gnome-chess.c"
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4043 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4049 "gnome-chess.c"
	}
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4053 "gnome-chess.c"
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4064 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4070 "gnome-chess.c"
	}
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4074 "gnome-chess.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4085 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4091 "gnome-chess.c"
	}
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4095 "gnome-chess.c"
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4106 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4112 "gnome-chess.c"
	}
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4116 "gnome-chess.c"
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4127 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4133 "gnome-chess.c"
	}
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4137 "gnome-chess.c"
}


static gchar** _vala_array_dup7 (gchar** self, int length) {
	gchar** result;
	int i;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4148 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4154 "gnome-chess.c"
	}
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4158 "gnome-chess.c"
}


static gchar** _vala_array_dup8 (gchar** self, int length) {
	gchar** result;
	int i;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4169 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4175 "gnome-chess.c"
	}
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4179 "gnome-chess.c"
}


static gchar** _vala_array_dup9 (gchar** self, int length) {
	gchar** result;
	int i;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4190 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4196 "gnome-chess.c"
	}
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4200 "gnome-chess.c"
}


static gchar** _vala_array_dup10 (gchar** self, int length) {
	gchar** result;
	int i;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = g_new0 (gchar*, length + 1);
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	for (i = 0; i < length; i++) {
#line 4211 "gnome-chess.c"
		gchar* _tmp0_ = NULL;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = g_strdup (self[i]);
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result[i] = _tmp0_;
#line 4217 "gnome-chess.c"
	}
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4221 "gnome-chess.c"
}


static ChessEngine* application_get_engine (Application* self, const gchar* name, const gchar* difficulty) {
	ChessEngine* result = NULL;
	ChessEngine* engine = NULL;
	AIProfile* profile = NULL;
	const gchar* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	AIProfile* _tmp12_ = NULL;
	gchar** options = NULL;
	gint options_length1 = 0;
	gint _options_size_ = 0;
	gchar** uci_go_options = NULL;
	gint uci_go_options_length1 = 0;
	gint _uci_go_options_size_ = 0;
	gchar** args = NULL;
	gint args_length1 = 0;
	gint _args_size_ = 0;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GQuark _tmp21_ = 0U;
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label0 = 0;
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp20_label1 = 0;
#line 4248 "gnome-chess.c"
	AIProfile* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	const gchar* _tmp60_ = NULL;
#line 586 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 586 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 586 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (difficulty != NULL, NULL);
#line 589 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	profile = NULL;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = name;
#line 591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp0_, "human") == 0) {
#line 592 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 592 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_ai_profile_unref0 (profile);
#line 592 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 592 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 4272 "gnome-chess.c"
	}
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->ai_profiles;
#line 4276 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp1_;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 4284 "gnome-chess.c"
			AIProfile* _tmp2_ = NULL;
			AIProfile* p = NULL;
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			p = _tmp2_;
#line 4291 "gnome-chess.c"
			{
				gboolean _tmp3_ = FALSE;
				const gchar* _tmp4_ = NULL;
				gboolean _tmp9_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp4_ = name;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp4_, "") == 0) {
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp3_ = TRUE;
#line 4302 "gnome-chess.c"
				} else {
					AIProfile* _tmp5_ = NULL;
					const gchar* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp5_ = p;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp6_ = ai_profile_get_name (_tmp5_);
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp7_ = _tmp6_;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp8_ = name;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp3_ = g_strcmp0 (_tmp7_, _tmp8_) == 0;
#line 4318 "gnome-chess.c"
				}
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = _tmp3_;
#line 596 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp9_) {
#line 4324 "gnome-chess.c"
					AIProfile* _tmp10_ = NULL;
					AIProfile* _tmp11_ = NULL;
#line 598 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = p;
#line 598 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp11_ = _ai_profile_ref0 (_tmp10_);
#line 598 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_ai_profile_unref0 (profile);
#line 598 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					profile = _tmp11_;
#line 599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_ai_profile_unref0 (p);
#line 599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					break;
#line 4339 "gnome-chess.c"
				}
#line 594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_ai_profile_unref0 (p);
#line 4343 "gnome-chess.c"
			}
		}
	}
#line 602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = profile;
#line 602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ == NULL) {
#line 4351 "gnome-chess.c"
		const gchar* _tmp13_ = NULL;
		GList* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		gconstpointer _tmp16_ = NULL;
		AIProfile* _tmp17_ = NULL;
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = name;
#line 604 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:604: Unknown AI profile %s", _tmp13_);
#line 605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->ai_profiles;
#line 605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp14_ == NULL) {
#line 606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_ai_profile_unref0 (profile);
#line 606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4373 "gnome-chess.c"
		}
#line 607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->ai_profiles;
#line 607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_->data;
#line 607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _ai_profile_ref0 ((AIProfile*) _tmp16_);
#line 607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_ai_profile_unref0 (profile);
#line 607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		profile = _tmp17_;
#line 4385 "gnome-chess.c"
	}
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = difficulty;
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = (NULL == _tmp19_) ? 0 : g_quark_from_string (_tmp19_);
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp21_ == ((0 != _tmp20_label0) ? _tmp20_label0 : (_tmp20_label0 = g_quark_from_static_string ("easy")))) {
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4397 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gchar** _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				AIProfile* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gchar** _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gchar** _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				AIProfile* _tmp30_ = NULL;
				gchar** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gchar** _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gchar** _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp22_ = profile;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp23_ = ai_profile_get_easy_options (_tmp22_, &_tmp23__length1);
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp24_ = _tmp23_;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp24__length1 = _tmp23__length1;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp25_ = (_tmp24_ != NULL) ? _vala_array_dup2 (_tmp24_, _tmp24__length1) : ((gpointer) _tmp24_);
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp25__length1 = _tmp24__length1;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = _tmp25_;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp25__length1;
#line 614 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp26_ = profile;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp27_ = ai_profile_get_easy_uci_go_options (_tmp26_, &_tmp27__length1);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp28_ = _tmp27_;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp28__length1 = _tmp27__length1;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp29_ = (_tmp28_ != NULL) ? _vala_array_dup3 (_tmp28_, _tmp28__length1) : ((gpointer) _tmp28_);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp29__length1 = _tmp28__length1;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp29_;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp29__length1;
#line 615 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp30_ = profile;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp31_ = ai_profile_get_easy_args (_tmp30_, &_tmp31__length1);
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp32_ = _tmp31_;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp32__length1 = _tmp31__length1;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp33_ = (_tmp32_ != NULL) ? _vala_array_dup4 (_tmp32_, _tmp32__length1) : ((gpointer) _tmp32_);
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp33__length1 = _tmp32__length1;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = _tmp33_;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp33__length1;
#line 616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 617 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 4483 "gnome-chess.c"
			}
		}
	} else if (_tmp21_ == ((0 != _tmp20_label1) ? _tmp20_label1 : (_tmp20_label1 = g_quark_from_static_string ("hard")))) {
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4489 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp34_ = NULL;
				gchar** _tmp35_ = NULL;
				gint _tmp35__length1 = 0;
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gchar** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				AIProfile* _tmp38_ = NULL;
				gchar** _tmp39_ = NULL;
				gint _tmp39__length1 = 0;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gchar** _tmp41_ = NULL;
				gint _tmp41__length1 = 0;
				AIProfile* _tmp42_ = NULL;
				gchar** _tmp43_ = NULL;
				gint _tmp43__length1 = 0;
				gchar** _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gchar** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp34_ = profile;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp35_ = ai_profile_get_hard_options (_tmp34_, &_tmp35__length1);
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp36_ = _tmp35_;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp36__length1 = _tmp35__length1;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp37_ = (_tmp36_ != NULL) ? _vala_array_dup5 (_tmp36_, _tmp36__length1) : ((gpointer) _tmp36_);
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp37__length1 = _tmp36__length1;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = _tmp37_;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp37__length1;
#line 625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp38_ = profile;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = ai_profile_get_hard_uci_go_options (_tmp38_, &_tmp39__length1);
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _tmp39_;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp40__length1 = _tmp39__length1;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = (_tmp40_ != NULL) ? _vala_array_dup6 (_tmp40_, _tmp40__length1) : ((gpointer) _tmp40_);
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp41__length1 = _tmp40__length1;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp41_;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp41__length1;
#line 626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = profile;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = ai_profile_get_hard_args (_tmp42_, &_tmp43__length1);
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp44_ = _tmp43_;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp44__length1 = _tmp43__length1;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp45_ = (_tmp44_ != NULL) ? _vala_array_dup7 (_tmp44_, _tmp44__length1) : ((gpointer) _tmp44_);
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp45__length1 = _tmp44__length1;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = _tmp45_;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp45__length1;
#line 627 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 628 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 4575 "gnome-chess.c"
			}
		}
	} else {
#line 611 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 4581 "gnome-chess.c"
			default:
			{
				AIProfile* _tmp46_ = NULL;
				gchar** _tmp47_ = NULL;
				gint _tmp47__length1 = 0;
				gchar** _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				AIProfile* _tmp50_ = NULL;
				gchar** _tmp51_ = NULL;
				gint _tmp51__length1 = 0;
				gchar** _tmp52_ = NULL;
				gint _tmp52__length1 = 0;
				gchar** _tmp53_ = NULL;
				gint _tmp53__length1 = 0;
				AIProfile* _tmp54_ = NULL;
				gchar** _tmp55_ = NULL;
				gint _tmp55__length1 = 0;
				gchar** _tmp56_ = NULL;
				gint _tmp56__length1 = 0;
				gchar** _tmp57_ = NULL;
				gint _tmp57__length1 = 0;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = profile;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp47_ = ai_profile_get_normal_options (_tmp46_, &_tmp47__length1);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = _tmp47_;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp48__length1 = _tmp47__length1;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = (_tmp48_ != NULL) ? _vala_array_dup8 (_tmp48_, _tmp48__length1) : ((gpointer) _tmp48_);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp49__length1 = _tmp48__length1;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options = _tmp49_;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				options_length1 = _tmp49__length1;
#line 620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_options_size_ = options_length1;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = profile;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_normal_uci_go_options (_tmp50_, &_tmp51__length1);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp52__length1 = _tmp51__length1;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = (_tmp52_ != NULL) ? _vala_array_dup9 (_tmp52_, _tmp52__length1) : ((gpointer) _tmp52_);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp53__length1 = _tmp52__length1;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options = _tmp53_;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				uci_go_options_length1 = _tmp53__length1;
#line 621 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_uci_go_options_size_ = uci_go_options_length1;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = profile;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = ai_profile_get_normal_args (_tmp54_, &_tmp55__length1);
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp56_ = _tmp55_;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp56__length1 = _tmp55__length1;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = (_tmp56_ != NULL) ? _vala_array_dup10 (_tmp56_, _tmp56__length1) : ((gpointer) _tmp56_);
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp57__length1 = _tmp56__length1;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args = _tmp57_;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				args_length1 = _tmp57__length1;
#line 622 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_args_size_ = args_length1;
#line 623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 4667 "gnome-chess.c"
			}
		}
	}
#line 631 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = profile;
#line 631 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = ai_profile_get_protocol (_tmp58_);
#line 631 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = _tmp59_;
#line 631 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp60_, "cecp") == 0) {
#line 4679 "gnome-chess.c"
		gchar** _tmp61_ = NULL;
		gint _tmp61__length1 = 0;
		AIProfile* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gchar** _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		gchar** _tmp66_ = NULL;
		gint _tmp66__length1 = 0;
		ChessEngineCECP* _tmp67_ = NULL;
#line 633 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = uci_go_options;
#line 633 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp61__length1 = uci_go_options_length1;
#line 633 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warn_if_fail (_tmp61__length1 == 0);
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = profile;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = ai_profile_get_binary (_tmp62_);
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = args;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp65__length1 = args_length1;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp66_ = options;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp66__length1 = options_length1;
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp67_ = chess_engine_cecp_new (_tmp64_, _tmp65_, _tmp65__length1, _tmp66_, _tmp66__length1);
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (engine);
#line 634 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		engine = (ChessEngine*) _tmp67_;
#line 4716 "gnome-chess.c"
	} else {
		AIProfile* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		const gchar* _tmp70_ = NULL;
#line 636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp68_ = profile;
#line 636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = ai_profile_get_protocol (_tmp68_);
#line 636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = _tmp69_;
#line 636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (g_strcmp0 (_tmp70_, "uci") == 0) {
#line 4729 "gnome-chess.c"
			AIProfile* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			const gchar* _tmp73_ = NULL;
			gchar** _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gchar** _tmp75_ = NULL;
			gint _tmp75__length1 = 0;
			gchar** _tmp76_ = NULL;
			gint _tmp76__length1 = 0;
			ChessEngineUCI* _tmp77_ = NULL;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp71_ = profile;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp72_ = ai_profile_get_binary (_tmp71_);
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp73_ = _tmp72_;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp74_ = args;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp74__length1 = args_length1;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp75_ = options;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp75__length1 = options_length1;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp76_ = uci_go_options;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp76__length1 = uci_go_options_length1;
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp77_ = chess_engine_uci_new (_tmp73_, _tmp74_, _tmp74__length1, _tmp75_, _tmp75__length1, _tmp76_, _tmp76__length1);
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			engine = (ChessEngine*) _tmp77_;
#line 4764 "gnome-chess.c"
		} else {
			AIProfile* _tmp78_ = NULL;
			const gchar* _tmp79_ = NULL;
			const gchar* _tmp80_ = NULL;
#line 642 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp78_ = profile;
#line 642 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp79_ = ai_profile_get_protocol (_tmp78_);
#line 642 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp80_ = _tmp79_;
#line 642 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_warning ("gnome-chess.vala:642: Unknown AI protocol %s", _tmp80_);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			result = NULL;
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_ai_profile_unref0 (profile);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_object_unref0 (engine);
#line 643 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return result;
#line 4791 "gnome-chess.c"
		}
	}
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = engine;
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	uci_go_options = (_vala_array_free (uci_go_options, uci_go_options_length1, (GDestroyNotify) g_free), NULL);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	options = (_vala_array_free (options, options_length1, (GDestroyNotify) g_free), NULL);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_ai_profile_unref0 (profile);
#line 646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4806 "gnome-chess.c"
}


static void application_real_activate (GApplication* base) {
	Application * self;
	GtkWindow* _tmp0_ = NULL;
#line 649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = (Application*) base;
#line 651 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 651 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 4819 "gnome-chess.c"
}


static void application_engine_ready_cb (Application* self, ChessEngine* engine) {
	ChessEngine* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 654 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 654 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_engine_get_ready (_tmp0_);
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 4839 "gnome-chess.c"
		ChessView* _tmp3_ = NULL;
#line 658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->view;
#line 658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
#line 4845 "gnome-chess.c"
	}
}


static void application_engine_move_cb (Application* self, ChessEngine* engine, const gchar* move) {
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = move;
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_player_move (_tmp0_, _tmp1_, TRUE);
#line 664 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 4868 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp3_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4874 "gnome-chess.c"
	}
}


static void application_engine_resigned_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 668 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 670 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_player_resign (_tmp0_);
#line 4889 "gnome-chess.c"
}


static gboolean __lambda3_ (Application* self) {
	gboolean result = FALSE;
	ChessGame* _tmp0_ = NULL;
#line 683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4904 "gnome-chess.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 4913 "gnome-chess.c"
}


static void application_engine_stopped_cb (Application* self, ChessEngine* engine) {
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 673 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 682 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ___lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 4924 "gnome-chess.c"
}


static void application_engine_error_cb (Application* self, ChessEngine* engine) {
	ChessGame* _tmp0_ = NULL;
#line 689 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 689 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 691 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 691 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_game_stop (_tmp0_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4938 "gnome-chess.c"
}


static void application_engine_claim_draw_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 694 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 694 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_player_claim_draw (_tmp0_);
#line 696 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 4955 "gnome-chess.c"
		ChessGame* _tmp2_ = NULL;
#line 697 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 697 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_stop (_tmp2_, CHESS_RESULT_BUG, CHESS_RULE_BUG);
#line 4961 "gnome-chess.c"
	}
}


static void application_engine_offer_draw_cb (Application* self, ChessEngine* engine) {
	ChessPlayer* _tmp0_ = NULL;
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 700 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (engine != NULL);
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 702 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_player_claim_draw (_tmp0_);
#line 4976 "gnome-chess.c"
}


static void application_game_start_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 4990 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 716 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 716 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_start_game (_tmp1_);
#line 4996 "gnome-chess.c"
	}
}


static void application_game_clock_tick_cb (Application* self, ChessClock* clock) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (clock != NULL);
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->white_time_label;
#line 721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp0_);
#line 722 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->black_time_label;
#line 722 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp1_);
#line 5016 "gnome-chess.c"
}


static void application_game_turn_cb (Application* self, ChessGame* game, ChessPlayer* player) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ChessGame* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp12_ = FALSE;
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (player != NULL);
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = game;
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_clock (_tmp0_);
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 727 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 5044 "gnome-chess.c"
		GtkWidget* _tmp3_ = NULL;
#line 728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->pause_button;
#line 728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp3_, TRUE);
#line 5050 "gnome-chess.c"
	}
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = game;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_->is_started;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 5058 "gnome-chess.c"
		ChessEngine* _tmp8_ = NULL;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->opponent_engine;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp8_ != NULL;
#line 5064 "gnome-chess.c"
	} else {
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = FALSE;
#line 5068 "gnome-chess.c"
	}
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp5_;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_) {
#line 5074 "gnome-chess.c"
		ChessPlayer* _tmp10_ = NULL;
		ChessPlayer* _tmp11_ = NULL;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = player;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->opponent;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp10_ == _tmp11_;
#line 5083 "gnome-chess.c"
	} else {
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = FALSE;
#line 5087 "gnome-chess.c"
	}
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _tmp4_;
#line 730 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_) {
#line 5093 "gnome-chess.c"
		ChessEngine* _tmp13_ = NULL;
#line 731 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->opponent_engine;
#line 731 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_request_move (_tmp13_);
#line 5099 "gnome-chess.c"
	}
}


static void application_set_move_text (Application* self, GtkTreeIter* iter, ChessMove* move) {
#line 737 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static const gchar* human_descriptions[] = {"White pawn moves from %1$s to %2$s", "White pawn at %1$s takes the black pawn at %2$s", "White pawn at %1$s takes the black rook at %2$s", "White pawn at %1$s takes the black knight at %2$s", "White pawn at %1$s takes the black bishop at %2$s", "White pawn at %1$s takes the black queen at %2$s", "White rook moves from %1$s to %2$s", "White rook at %1$s takes the black pawn at %2$s", "White rook at %1$s takes the black rook at %2$s", "White rook at %1$s takes the black knight at %2$s", "White rook at %1$s takes the black bishop at %2$s", "White rook at %1$s takes the black queen at %2$s", "White knight moves from %1$s to %2$s", "White knight at %1$s takes the black pawn at %2$s", "White knight at %1$s takes the black rook at %2$s", "White knight at %1$s takes the black knight at %2$s", "White knight at %1$s takes the black bishop at %2$s", "White knight at %1$s takes the black queen at %2$s", "White bishop moves from %1$s to %2$s", "White bishop at %1$s takes the black pawn at %2$s", "White bishop at %1$s takes the black rook at %2$s", "White bishop at %1$s takes the black knight at %2$s", "White bishop at %1$s takes the black bishop at %2$s", "White bishop at %1$s takes the black queen at %2$s", "White queen moves from %1$s to %2$s", "White queen at %1$s takes the black pawn at %2$s", "White queen at %1$s takes the black rook at %2$s", "White queen at %1$s takes the black knight at %2$s", "White queen at %1$s takes the black bishop at %2$s", "White queen at %1$s takes the black queen at %2$s", "White king moves from %1$s to %2$s", "White king at %1$s takes the black pawn at %2$s", "White king at %1$s takes the black rook at %2$s", "White king at %1$s takes the black knight at %2$s", "White king at %1$s takes the black bishop at %2$s", "White king at %1$s takes the black queen at %2$s", "Black pawn moves from %1$s to %2$s", "Black pawn at %1$s takes the white pawn at %2$s", "Black pawn at %1$s takes the white rook at %2$s", "Black pawn at %1$s takes the white knight at %2$s", "Black pawn at %1$s takes the white bishop at %2$s", "Black pawn at %1$s takes the white queen at %2$s", "Black rook moves from %1$s to %2$s", "Black rook at %1$s takes the white pawn at %2$s", "Black rook at %1$s takes the white rook at %2$s", "Black rook at %1$s takes the white knight at %2$s", "Black rook at %1$s takes the white bishop at %2$s", "Black rook at %1$s takes the white queen at %2$s", "Black knight moves from %1$s to %2$s", "Black knight at %1$s takes the white pawn at %2$s", "Black knight at %1$s takes the white rook at %2$s", "Black knight at %1$s takes the white knight at %2$s", "Black knight at %1$s takes the white bishop at %2$s", "Black knight at %1$s takes the white queen at %2$s", "Black bishop moves from %1$s to %2$s", "Black bishop at %1$s takes the white pawn at %2$s", "Black bishop at %1$s takes the white rook at %2$s", "Black bishop at %1$s takes the white knight at %2$s", "Black bishop at %1$s takes the white bishop at %2$s", "Black bishop at %1$s takes the white queen at %2$s", "Black queen moves from %1$s to %2$s", "Black queen at %1$s takes the white pawn at %2$s", "Black queen at %1$s takes the white rook at %2$s", "Black queen at %1$s takes the white knight at %2$s", "Black queen at %1$s takes the white bishop at %2$s", "Black queen at %1$s takes the white queen at %2$s", "Black king moves from %1$s to %2$s", "Black king at %1$s takes the white pawn at %2$s", "Black king at %1$s takes the white rook at %2$s", "Black king at %1$s takes the white knight at %2$s", "Black king at %1$s takes the white bishop at %2$s", "Black king at %1$s takes the white queen at %2$s"};
#line 5107 "gnome-chess.c"
	gchar* move_text = NULL;
	gchar* _tmp0_ = NULL;
	ChessScene* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GQuark _tmp6_ = 0U;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label0 = 0;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label1 = 0;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	static GQuark _tmp5_label2 = 0;
#line 5121 "gnome-chess.c"
	GtkListStore* model = NULL;
	GtkComboBox* _tmp85_ = NULL;
	GtkTreeModel* _tmp86_ = NULL;
	GtkTreeModel* _tmp87_ = NULL;
	GtkListStore* _tmp88_ = NULL;
	gchar _tmp89_ = '\0';
	ChessMove* _tmp90_ = NULL;
	gint _tmp91_ = 0;
	gchar* label = NULL;
	ChessMove* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	gchar _tmp94_ = '\0';
	const gchar* _tmp95_ = NULL;
	gchar* _tmp96_ = NULL;
	GtkListStore* _tmp97_ = NULL;
	GtkTreeIter _tmp98_ = {0};
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (iter != NULL);
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 882 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = g_strdup ("");
#line 882 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	move_text = _tmp0_;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->scene;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = chess_scene_get_move_format (_tmp1_);
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_;
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("human")))) {
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5162 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp7_ = NULL;
				ChessPiece* _tmp8_ = NULL;
#line 886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = move;
#line 886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = _tmp7_->moved_rook;
#line 886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp8_ == NULL) {
#line 5173 "gnome-chess.c"
					gint index = 0;
					ChessMove* _tmp9_ = NULL;
					ChessPiece* _tmp10_ = NULL;
					gint _tmp14_ = 0;
					ChessMove* _tmp15_ = NULL;
					ChessPiece* _tmp16_ = NULL;
					PieceType _tmp17_ = 0;
					ChessMove* _tmp18_ = NULL;
					ChessPiece* _tmp19_ = NULL;
					ChessPlayer* _tmp20_ = NULL;
					Color _tmp21_ = 0;
					gchar* start = NULL;
					ChessMove* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					ChessMove* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					gchar* _tmp27_ = NULL;
					gchar* end = NULL;
					ChessMove* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					ChessMove* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gchar* _tmp32_ = NULL;
					gint _tmp33_ = 0;
					const gchar* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
#line 889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = move;
#line 889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = _tmp9_->victim;
#line 889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (_tmp10_ == NULL) {
#line 890 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						index = 0;
#line 5211 "gnome-chess.c"
					} else {
						ChessMove* _tmp11_ = NULL;
						ChessPiece* _tmp12_ = NULL;
						PieceType _tmp13_ = 0;
#line 892 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp11_ = move;
#line 892 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp12_ = _tmp11_->victim;
#line 892 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp13_ = _tmp12_->type;
#line 892 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						index = (gint) (_tmp13_ + 1);
#line 5224 "gnome-chess.c"
					}
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = index;
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp15_ = move;
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp16_ = _tmp15_->piece;
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = _tmp16_->type;
#line 893 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					index = _tmp14_ + (_tmp17_ * 6);
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = move;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp19_ = _tmp18_->piece;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = _tmp19_->player;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp21_ = _tmp20_->color;
#line 894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (_tmp21_ == COLOR_BLACK) {
#line 5246 "gnome-chess.c"
						gint _tmp22_ = 0;
#line 895 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = index;
#line 895 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						index = _tmp22_ + 36;
#line 5252 "gnome-chess.c"
					}
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp23_ = move;
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp24_ = _tmp23_->f0;
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp25_ = move;
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp26_ = _tmp25_->r0;
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp27_ = g_strdup_printf ("%c%d", 'a' + _tmp24_, _tmp26_ + 1);
#line 897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					start = _tmp27_;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp28_ = move;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp29_ = _tmp28_->f1;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp30_ = move;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp31_ = _tmp30_->r1;
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp32_ = g_strdup_printf ("%c%d", 'a' + _tmp29_, _tmp31_ + 1);
#line 898 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					end = _tmp32_;
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp33_ = index;
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp34_ = human_descriptions[_tmp33_];
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp35_ = _ (_tmp34_);
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp36_ = start;
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp37_ = end;
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp38_ = g_strdup_printf (_tmp35_, _tmp36_, _tmp37_);
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_g_free0 (move_text);
#line 899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					move_text = _tmp38_;
#line 886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_g_free0 (end);
#line 886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_g_free0 (start);
#line 5298 "gnome-chess.c"
				} else {
					gboolean _tmp39_ = FALSE;
					ChessMove* _tmp40_ = NULL;
					gint _tmp41_ = 0;
					ChessMove* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gboolean _tmp46_ = FALSE;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp40_ = move;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp41_ = _tmp40_->f0;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp42_ = move;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp43_ = _tmp42_->f1;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (_tmp41_ < _tmp43_) {
#line 5316 "gnome-chess.c"
						ChessMove* _tmp44_ = NULL;
						gint _tmp45_ = 0;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp44_ = move;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp45_ = _tmp44_->r0;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = _tmp45_ == 0;
#line 5325 "gnome-chess.c"
					} else {
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp39_ = FALSE;
#line 5329 "gnome-chess.c"
					}
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp46_ = _tmp39_;
#line 901 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (_tmp46_) {
#line 5335 "gnome-chess.c"
						const gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
#line 903 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp47_ = _ ("White castles kingside");
#line 903 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp48_ = g_strdup (_tmp47_);
#line 903 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_g_free0 (move_text);
#line 903 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						move_text = _tmp48_;
#line 5346 "gnome-chess.c"
					} else {
						gboolean _tmp49_ = FALSE;
						ChessMove* _tmp50_ = NULL;
						gint _tmp51_ = 0;
						ChessMove* _tmp52_ = NULL;
						gint _tmp53_ = 0;
						gboolean _tmp56_ = FALSE;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp50_ = move;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp51_ = _tmp50_->f1;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp52_ = move;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp53_ = _tmp52_->f0;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						if (_tmp51_ < _tmp53_) {
#line 5364 "gnome-chess.c"
							ChessMove* _tmp54_ = NULL;
							gint _tmp55_ = 0;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp54_ = move;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp55_ = _tmp54_->r0;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp49_ = _tmp55_ == 0;
#line 5373 "gnome-chess.c"
						} else {
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp49_ = FALSE;
#line 5377 "gnome-chess.c"
						}
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp56_ = _tmp49_;
#line 905 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						if (_tmp56_) {
#line 5383 "gnome-chess.c"
							const gchar* _tmp57_ = NULL;
							gchar* _tmp58_ = NULL;
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp57_ = _ ("White castles queenside");
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp58_ = g_strdup (_tmp57_);
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_g_free0 (move_text);
#line 907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							move_text = _tmp58_;
#line 5394 "gnome-chess.c"
						} else {
							gboolean _tmp59_ = FALSE;
							ChessMove* _tmp60_ = NULL;
							gint _tmp61_ = 0;
							ChessMove* _tmp62_ = NULL;
							gint _tmp63_ = 0;
							gboolean _tmp66_ = FALSE;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp60_ = move;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp61_ = _tmp60_->f0;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp62_ = move;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp63_ = _tmp62_->f1;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							if (_tmp61_ < _tmp63_) {
#line 5412 "gnome-chess.c"
								ChessMove* _tmp64_ = NULL;
								gint _tmp65_ = 0;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp64_ = move;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp65_ = _tmp64_->r0;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp59_ = _tmp65_ == 7;
#line 5421 "gnome-chess.c"
							} else {
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp59_ = FALSE;
#line 5425 "gnome-chess.c"
							}
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							_tmp66_ = _tmp59_;
#line 909 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
							if (_tmp66_) {
#line 5431 "gnome-chess.c"
								const gchar* _tmp67_ = NULL;
								gchar* _tmp68_ = NULL;
#line 911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp67_ = _ ("Black castles kingside");
#line 911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp68_ = g_strdup (_tmp67_);
#line 911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_g_free0 (move_text);
#line 911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								move_text = _tmp68_;
#line 5442 "gnome-chess.c"
							} else {
								gboolean _tmp69_ = FALSE;
								ChessMove* _tmp70_ = NULL;
								gint _tmp71_ = 0;
								ChessMove* _tmp72_ = NULL;
								gint _tmp73_ = 0;
								gboolean _tmp76_ = FALSE;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp70_ = move;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp71_ = _tmp70_->f1;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp72_ = move;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp73_ = _tmp72_->f0;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								if (_tmp71_ < _tmp73_) {
#line 5460 "gnome-chess.c"
									ChessMove* _tmp74_ = NULL;
									gint _tmp75_ = 0;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp74_ = move;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp75_ = _tmp74_->r0;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp69_ = _tmp75_ == 7;
#line 5469 "gnome-chess.c"
								} else {
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp69_ = FALSE;
#line 5473 "gnome-chess.c"
								}
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								_tmp76_ = _tmp69_;
#line 913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
								if (_tmp76_) {
#line 5479 "gnome-chess.c"
									const gchar* _tmp77_ = NULL;
									gchar* _tmp78_ = NULL;
#line 915 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp77_ = _ ("Black castles queenside");
#line 915 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_tmp78_ = g_strdup (_tmp77_);
#line 915 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									_g_free0 (move_text);
#line 915 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									move_text = _tmp78_;
#line 5490 "gnome-chess.c"
								} else {
#line 917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
									g_assert_not_reached ();
#line 5494 "gnome-chess.c"
								}
							}
						}
					}
				}
#line 918 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 5502 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("san")))) {
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5508 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp79_ = NULL;
				gchar* _tmp80_ = NULL;
#line 921 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp79_ = move;
#line 921 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp80_ = chess_move_get_san (_tmp79_);
#line 921 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 921 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp80_;
#line 922 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 5523 "gnome-chess.c"
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("fan")))) {
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5529 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
#line 925 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp81_ = move;
#line 925 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp82_ = chess_move_get_fan (_tmp81_);
#line 925 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 925 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp82_;
#line 926 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 5544 "gnome-chess.c"
			}
		}
	} else {
#line 883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		switch (0) {
#line 5550 "gnome-chess.c"
			default:
			{
				ChessMove* _tmp83_ = NULL;
				gchar* _tmp84_ = NULL;
#line 930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp83_ = move;
#line 930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp84_ = chess_move_get_lan (_tmp83_);
#line 930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (move_text);
#line 930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				move_text = _tmp84_;
#line 931 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				break;
#line 5565 "gnome-chess.c"
			}
		}
	}
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = self->priv->history_combo;
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = gtk_combo_box_get_model (_tmp85_);
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = _tmp86_;
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp88_;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = move;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = _tmp90_->number;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if ((_tmp91_ % 2) == 0) {
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = 'b';
#line 5587 "gnome-chess.c"
	} else {
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp89_ = 'a';
#line 5591 "gnome-chess.c"
	}
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = move;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = _tmp92_->number;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = _tmp89_;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = move_text;
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = g_strdup_printf ("%u%c. %s", (guint) ((_tmp93_ + 1) / 2), (gint) _tmp94_, _tmp95_);
#line 935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	label = _tmp96_;
#line 936 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = model;
#line 936 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = *iter;
#line 936 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp97_, &_tmp98_, 0, label, -1, -1);
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (label);
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (move_text);
#line 5617 "gnome-chess.c"
}


static void application_game_move_cb (Application* self, ChessGame* game, ChessMove* move) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp8_ = FALSE;
	ChessMove* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	PGNGame* _tmp11_ = NULL;
	GList* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp17_ = NULL;
	GtkTreeModel* _tmp18_ = NULL;
	GtkTreeModel* _tmp19_ = NULL;
	GtkListStore* _tmp20_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	GtkListStore* _tmp23_ = NULL;
	GtkTreeIter _tmp24_ = {0};
	ChessMove* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	GtkTreeIter _tmp27_ = {0};
	ChessMove* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	ChessMove* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	ChessGame* _tmp32_ = NULL;
	guint _tmp33_ = 0U;
	guint _tmp34_ = 0U;
	gboolean _tmp38_ = FALSE;
	GtkWidget* _tmp41_ = NULL;
	ChessEngine* _tmp42_ = NULL;
	ChessView* _tmp45_ = NULL;
#line 939 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 939 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 939 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (move != NULL);
#line 942 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = TRUE;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = move;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_->number;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp3_ == 1) {
#line 5671 "gnome-chess.c"
		ChessPlayer* _tmp4_ = NULL;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->opponent;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = _tmp4_ != NULL;
#line 5677 "gnome-chess.c"
	} else {
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = FALSE;
#line 5681 "gnome-chess.c"
	}
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp1_;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_) {
#line 5687 "gnome-chess.c"
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->opponent;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->color;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp7_ == COLOR_WHITE;
#line 5696 "gnome-chess.c"
	} else {
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 5700 "gnome-chess.c"
	}
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp0_;
#line 945 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_) {
#line 946 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 5708 "gnome-chess.c"
	}
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = move;
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_->number;
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->pgn_game;
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _tmp11_->moves;
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = g_list_length (_tmp12_);
#line 948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp10_) > _tmp13_) {
#line 5722 "gnome-chess.c"
		PGNGame* _tmp14_ = NULL;
		ChessMove* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
#line 949 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->pgn_game;
#line 949 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = move;
#line 949 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = chess_move_get_san (_tmp15_);
#line 949 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_->moves = g_list_append (_tmp14_->moves, _tmp16_);
#line 5734 "gnome-chess.c"
	}
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->history_combo;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = gtk_combo_box_get_model (_tmp17_);
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _tmp18_;
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp20_;
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = model;
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_append (_tmp21_, &_tmp22_);
#line 953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp22_;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = model;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = iter;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = move;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _tmp25_->number;
#line 954 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_set (_tmp23_, &_tmp24_, 1, _tmp26_, -1, -1);
#line 955 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = iter;
#line 955 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = move;
#line 955 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_move_text (self, &_tmp27_, _tmp28_);
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = move;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = _tmp30_->number;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = game;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = chess_game_get_n_moves (_tmp32_);
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = _tmp33_;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp31_) == _tmp34_) {
#line 5780 "gnome-chess.c"
		ChessScene* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = self->priv->scene;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = chess_scene_get_move_number (_tmp35_);
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = _tmp36_;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp37_ == (-1);
#line 5792 "gnome-chess.c"
	} else {
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = FALSE;
#line 5796 "gnome-chess.c"
	}
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp29_;
#line 958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_) {
#line 5802 "gnome-chess.c"
		GtkComboBox* _tmp39_ = NULL;
		GtkTreeIter _tmp40_ = {0};
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = self->priv->history_combo;
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = iter;
#line 959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp39_, &_tmp40_);
#line 5811 "gnome-chess.c"
	}
#line 961 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = self->priv->save_button;
#line 961 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp41_, TRUE);
#line 962 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_history_panel (self);
#line 963 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_control_buttons (self);
#line 965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = self->priv->opponent_engine;
#line 965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp42_ != NULL) {
#line 5825 "gnome-chess.c"
		ChessEngine* _tmp43_ = NULL;
		ChessMove* _tmp44_ = NULL;
#line 966 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = self->priv->opponent_engine;
#line 966 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = move;
#line 966 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_report_move (_tmp43_, _tmp44_);
#line 5834 "gnome-chess.c"
	}
#line 967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp45_ = self->priv->view;
#line 967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp45_);
#line 939 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 5842 "gnome-chess.c"
}


static void application_game_undo_cb (Application* self, ChessGame* game) {
	ChessEngine* _tmp0_ = NULL;
	PGNGame* _tmp2_ = NULL;
	PGNGame* _tmp3_ = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkListStore* model = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkListStore* _tmp9_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp10_ = NULL;
	GtkListStore* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkTreeIter _tmp13_ = {0};
	GtkListStore* _tmp14_ = NULL;
	GtkTreeIter _tmp15_ = {0};
	ChessScene* _tmp16_ = NULL;
	GtkListStore* _tmp17_ = NULL;
	GtkListStore* _tmp18_ = NULL;
	gint _tmp19_ = 0;
	GtkTreeIter _tmp20_ = {0};
	GtkComboBox* _tmp21_ = NULL;
	GtkTreeIter _tmp22_ = {0};
	ChessView* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent_engine;
#line 973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 5883 "gnome-chess.c"
		ChessEngine* _tmp1_ = NULL;
#line 974 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->opponent_engine;
#line 974 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_undo (_tmp1_);
#line 5889 "gnome-chess.c"
	}
#line 977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->pgn_game;
#line 977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_->moves;
#line 977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = g_list_last (_tmp4_);
#line 977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_->moves = g_list_remove_link (_tmp2_->moves, _tmp5_);
#line 980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->history_combo;
#line 980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
#line 980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp9_;
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = model;
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = model;
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp11_, NULL);
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp10_, &_tmp13_, NULL, _tmp12_ - 1);
#line 982 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp13_;
#line 983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = model;
#line 983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = iter;
#line 983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_list_store_remove (_tmp14_, &_tmp15_);
#line 986 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->scene;
#line 986 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp16_, -1);
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = model;
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = model;
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp18_, NULL);
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp17_, &_tmp20_, NULL, _tmp19_ - 1);
#line 989 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp20_;
#line 990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->history_combo;
#line 990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = iter;
#line 990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active_iter (_tmp21_, &_tmp22_);
#line 991 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->view;
#line 991 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp23_);
#line 993 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = game;
#line 993 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = chess_game_get_n_moves (_tmp24_);
#line 993 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _tmp25_;
#line 993 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_ > ((guint) 0)) {
#line 5959 "gnome-chess.c"
		GtkWidget* _tmp27_ = NULL;
#line 995 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = TRUE;
#line 996 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->save_button;
#line 996 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp27_, TRUE);
#line 5967 "gnome-chess.c"
	} else {
		GtkWidget* _tmp28_ = NULL;
#line 1000 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->game_needs_saving = FALSE;
#line 1001 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->save_button;
#line 1001 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp28_, FALSE);
#line 5976 "gnome-chess.c"
	}
#line 1004 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_history_panel (self);
#line 1005 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_update_control_buttons (self);
#line 970 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 5984 "gnome-chess.c"
}


static void application_update_control_buttons (Application* self) {
	gboolean can_resign = FALSE;
	ChessGame* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	GtkWidget* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkWidget* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean can_undo = FALSE;
	ChessGame* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	gboolean _tmp16_ = FALSE;
	ChessPlayer* _tmp17_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
#line 1008 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1010 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1010 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_n_moves (_tmp0_);
#line 1010 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1010 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	can_resign = _tmp2_ > ((guint) 0);
#line 1011 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->resign_button;
#line 1011 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = can_resign;
#line 1011 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp3_, _tmp4_);
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = can_resign;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 6028 "gnome-chess.c"
		ChessGame* _tmp7_ = NULL;
		ChessPlayer* _tmp8_ = NULL;
		ChessPlayer* _tmp9_ = NULL;
		ChessPlayer* _tmp10_ = NULL;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_current_player (_tmp7_);
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->opponent;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp9_ != _tmp10_;
#line 6043 "gnome-chess.c"
	} else {
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = FALSE;
#line 6047 "gnome-chess.c"
	}
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->claim_draw_button;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _tmp5_;
#line 1014 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp11_, _tmp12_);
#line 1017 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->game;
#line 1017 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = chess_game_get_n_moves (_tmp13_);
#line 1017 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _tmp14_;
#line 1017 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	can_undo = _tmp15_ > ((guint) 0);
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->opponent;
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp17_ != NULL) {
#line 6067 "gnome-chess.c"
		ChessPlayer* _tmp18_ = NULL;
		Color _tmp19_ = 0;
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->opponent;
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp18_->color;
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp19_ == COLOR_WHITE;
#line 6076 "gnome-chess.c"
	} else {
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = FALSE;
#line 6080 "gnome-chess.c"
	}
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _tmp16_;
#line 1018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp20_) {
#line 6086 "gnome-chess.c"
		ChessGame* _tmp21_ = NULL;
		guint _tmp22_ = 0U;
		guint _tmp23_ = 0U;
#line 1019 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->game;
#line 1019 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = chess_game_get_n_moves (_tmp21_);
#line 1019 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = _tmp22_;
#line 1019 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		can_undo = _tmp23_ > ((guint) 1);
#line 6098 "gnome-chess.c"
	}
#line 1021 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->undo_button;
#line 1021 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = can_undo;
#line 1021 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp24_, _tmp25_);
#line 6106 "gnome-chess.c"
}


static void application_game_end_cb (Application* self, ChessGame* game) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	ChessEngine* _tmp4_ = NULL;
	gchar* title = NULL;
	gchar* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
	ChessResult _tmp8_ = 0;
	gchar* reason = NULL;
	gchar* _tmp23_ = NULL;
	ChessGame* _tmp24_ = NULL;
	ChessRule _tmp25_ = 0;
	GtkLabel* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	gchar* _tmp56_ = NULL;
	gchar* _tmp57_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	const gchar* _tmp59_ = NULL;
	GtkInfoBar* _tmp60_ = NULL;
	GtkWidget* _tmp61_ = NULL;
	GtkWidget* _tmp62_ = NULL;
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (game != NULL);
#line 1026 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->resign_button;
#line 1026 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp0_, FALSE);
#line 1027 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->undo_button;
#line 1027 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp1_, FALSE);
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->claim_draw_button;
#line 1028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp2_, FALSE);
#line 1029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->pause_button;
#line 1029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp3_, FALSE);
#line 1031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_needs_saving = FALSE;
#line 1033 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->opponent_engine;
#line 1033 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp4_ != NULL) {
#line 6159 "gnome-chess.c"
		ChessEngine* _tmp5_ = NULL;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = self->priv->opponent_engine;
#line 1034 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_engine_stop (_tmp5_);
#line 6165 "gnome-chess.c"
	}
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = g_strdup ("");
#line 1036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	title = _tmp6_;
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = game;
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_->result;
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	switch (_tmp8_) {
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_WHITE_WON:
#line 6179 "gnome-chess.c"
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			PGNGame* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = _ ("White wins");
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = g_strdup (_tmp9_);
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			title = _tmp10_;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->pgn_game;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = pgn_game_RESULT_WHITE;
#line 1042 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp11_, _tmp12_);
#line 1043 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6201 "gnome-chess.c"
		}
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BLACK_WON:
#line 6205 "gnome-chess.c"
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			PGNGame* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = _ ("Black wins");
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			title = _tmp14_;
#line 1047 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = self->priv->pgn_game;
#line 1047 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = pgn_game_RESULT_BLACK;
#line 1047 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp15_, _tmp16_);
#line 1048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6227 "gnome-chess.c"
		}
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_DRAW:
#line 6231 "gnome-chess.c"
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			PGNGame* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp17_ = _ ("Game is drawn");
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			title = _tmp18_;
#line 1052 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp19_ = self->priv->pgn_game;
#line 1052 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = pgn_game_RESULT_DRAW;
#line 1052 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_result (_tmp19_, _tmp20_);
#line 1053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6253 "gnome-chess.c"
		}
#line 1037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RESULT_BUG:
#line 6257 "gnome-chess.c"
		{
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
#line 1056 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp21_ = _ ("Oops! Something has gone wrong.");
#line 1056 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = g_strdup (_tmp21_);
#line 1056 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (title);
#line 1056 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			title = _tmp22_;
#line 1058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6271 "gnome-chess.c"
		}
		default:
		{
#line 1060 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6277 "gnome-chess.c"
		}
	}
#line 1063 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = g_strdup ("");
#line 1063 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	reason = _tmp23_;
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = game;
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _tmp24_->rule;
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	switch (_tmp25_) {
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_CHECKMATE:
#line 6292 "gnome-chess.c"
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp26_ = _ ("Opponent is in check and cannot move (checkmate)");
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp27_ = g_strdup (_tmp26_);
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp27_;
#line 1069 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6306 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_STALEMATE:
#line 6310 "gnome-chess.c"
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
#line 1072 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp28_ = _ ("Opponent cannot move (stalemate)");
#line 1072 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = g_strdup (_tmp28_);
#line 1072 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1072 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp29_;
#line 1073 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6324 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_FIFTY_MOVES:
#line 6328 "gnome-chess.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 1076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _ ("No piece has been taken or pawn moved in the last fifty moves");
#line 1076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = g_strdup (_tmp30_);
#line 1076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp31_;
#line 1077 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6342 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_TIMEOUT:
#line 6346 "gnome-chess.c"
		{
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _ ("Opponent has run out of time");
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp33_;
#line 1081 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6360 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_THREE_FOLD_REPETITION:
#line 6364 "gnome-chess.c"
		{
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
#line 1084 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = _ ("The same board state has occurred three times (threefold repetition)");
#line 1084 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp35_ = g_strdup (_tmp34_);
#line 1084 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1084 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp35_;
#line 1085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6378 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_INSUFFICIENT_MATERIAL:
#line 6382 "gnome-chess.c"
		{
			const gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 1088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp36_ = _ ("Neither player can checkmate (insufficient material)");
#line 1088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = g_strdup (_tmp36_);
#line 1088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp37_;
#line 1089 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6396 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_RESIGN:
#line 6400 "gnome-chess.c"
		{
			ChessGame* _tmp38_ = NULL;
			ChessResult _tmp39_ = 0;
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = game;
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp39_ = _tmp38_->result;
#line 1091 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_tmp39_ == CHESS_RESULT_WHITE_WON) {
#line 6410 "gnome-chess.c"
				const gchar* _tmp40_ = NULL;
				gchar* _tmp41_ = NULL;
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = _ ("The black player has resigned");
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp41_ = g_strdup (_tmp40_);
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1094 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				reason = _tmp41_;
#line 6421 "gnome-chess.c"
			} else {
				const gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp42_ = _ ("The white player has resigned");
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = g_strdup (_tmp42_);
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (reason);
#line 1099 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				reason = _tmp43_;
#line 6433 "gnome-chess.c"
			}
#line 1101 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6437 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_ABANDONMENT:
#line 6441 "gnome-chess.c"
		{
			const gchar* _tmp44_ = NULL;
			gchar* _tmp45_ = NULL;
			PGNGame* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = _ ("The game has been abandoned");
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = g_strdup (_tmp44_);
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp45_;
#line 1105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = self->priv->pgn_game;
#line 1105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = pgn_game_TERMINATE_ABANDONED;
#line 1105 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp46_, _tmp47_);
#line 1106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6463 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_DEATH:
#line 6467 "gnome-chess.c"
		{
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			PGNGame* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp48_ = _ ("One of the players has died");
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = g_strdup (_tmp48_);
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp49_;
#line 1110 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp50_ = self->priv->pgn_game;
#line 1110 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp51_ = pgn_game_TERMINATE_DEATH;
#line 1110 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_termination (_tmp50_, _tmp51_);
#line 1111 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6489 "gnome-chess.c"
		}
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		case CHESS_RULE_BUG:
#line 6493 "gnome-chess.c"
		{
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp52_ = _ ("The game cannot continue.");
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp53_ = g_strdup (_tmp52_);
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (reason);
#line 1114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			reason = _tmp53_;
#line 1116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			break;
#line 6507 "gnome-chess.c"
		}
		default:
#line 1064 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		break;
#line 6512 "gnome-chess.c"
	}
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp54_ = self->priv->info_title_label;
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp55_ = title;
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp56_ = g_strdup_printf ("<big><b>%s</b></big>", _tmp55_);
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp57_ = _tmp56_;
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_label_set_markup (_tmp54_, _tmp57_);
#line 1119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp57_);
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp58_ = self->priv->info_label;
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp59_ = reason;
#line 1120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_label_set_text (_tmp58_, _tmp59_);
#line 1121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp60_ = self->priv->info_bar;
#line 1121 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp60_);
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp61_ = self->priv->white_time_label;
#line 1123 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp61_);
#line 1124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp62_ = self->priv->black_time_label;
#line 1124 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_queue_draw (_tmp62_);
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (reason);
#line 1024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (title);
#line 6548 "gnome-chess.c"
}


void application_show (Application* self) {
	GtkWindow* _tmp0_ = NULL;
#line 1127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->window;
#line 1129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 6560 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1133 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_quit_game (self);
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6578 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_configure_event_cb (GtkWidget* widget, GdkEventConfigure* event, Application* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 1140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->settings;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_settings_get_boolean (_tmp1_, "maximized");
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 6600 "gnome-chess.c"
		GSettings* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->settings;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = g_settings_get_boolean (_tmp3_, "fullscreen");
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = !_tmp4_;
#line 6609 "gnome-chess.c"
	} else {
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6613 "gnome-chess.c"
	}
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp0_;
#line 1142 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_) {
#line 6619 "gnome-chess.c"
		GSettings* _tmp6_ = NULL;
		GdkEventConfigure _tmp7_ = {0};
		gint _tmp8_ = 0;
		GSettings* _tmp9_ = NULL;
		GdkEventConfigure _tmp10_ = {0};
		gint _tmp11_ = 0;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->settings;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = *event;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_.width;
#line 1144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_settings_set_int (_tmp6_, "width", _tmp8_);
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = self->priv->settings;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = *event;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_.height;
#line 1145 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_settings_set_int (_tmp9_, "height", _tmp11_);
#line 6642 "gnome-chess.c"
	}
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1148 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6648 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT gnome_chess_app_window_state_event_cb (GtkWidget* widget, GdkEventWindowState* event, Application* self) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp6_ = {0};
	GdkWindowState _tmp7_ = 0;
#line 1152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1152 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = *event;
#line 1154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = _tmp0_.changed_mask;
#line 1154 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 6670 "gnome-chess.c"
		gboolean is_maximized = FALSE;
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 1156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = *event;
#line 1156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = _tmp2_.new_window_state;
#line 1156 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->settings;
#line 1157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = is_maximized;
#line 1157 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_settings_set_boolean (_tmp4_, "maximized", _tmp5_);
#line 6688 "gnome-chess.c"
	}
#line 1159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = *event;
#line 1159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _tmp6_.changed_mask;
#line 1159 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if ((_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
#line 6696 "gnome-chess.c"
		GdkEventWindowState _tmp8_ = {0};
		GdkWindowState _tmp9_ = 0;
		GSettings* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
#line 1161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = *event;
#line 1161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_.new_window_state;
#line 1161 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		self->priv->is_fullscreen = (_tmp9_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
#line 1162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->settings;
#line 1162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->is_fullscreen;
#line 1162 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_settings_set_boolean (_tmp10_, "fullscreen", _tmp11_);
#line 6713 "gnome-chess.c"
	}
#line 1165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1165 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6719 "gnome-chess.c"
}


static gboolean application_prompt_save_game (Application* self, const gchar* prompt_text) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkMessageDialog* dialog = NULL;
	GtkWindow* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkMessageDialog* _tmp9_ = NULL;
	GtkMessageDialog* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	ChessGame* _tmp12_ = NULL;
	ChessResult _tmp13_ = 0;
	gint _result_ = 0;
	GtkMessageDialog* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GtkMessageDialog* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean _tmp28_ = FALSE;
#line 1168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1168 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (prompt_text != NULL, FALSE);
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->game_needs_saving;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 6751 "gnome-chess.c"
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->in_history;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (!_tmp3_) {
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = TRUE;
#line 6761 "gnome-chess.c"
		} else {
			GFile* _tmp4_ = NULL;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->game_file;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = _tmp4_ == NULL;
#line 6768 "gnome-chess.c"
		}
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp2_;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = _tmp5_;
#line 6774 "gnome-chess.c"
	} else {
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = FALSE;
#line 6778 "gnome-chess.c"
	}
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp0_;
#line 1170 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 1171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = TRUE;
#line 1171 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 6788 "gnome-chess.c"
	}
#line 1173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->window;
#line 1173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = prompt_text;
#line 1173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp7_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp8_);
#line 1173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp9_);
#line 1173 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	dialog = _tmp9_;
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = dialog;
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = _ ("_Cancel");
#line 1179 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_add_button ((GtkDialog*) _tmp10_, _tmp11_, (gint) GTK_RESPONSE_CANCEL);
#line 1181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->game;
#line 1181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_->result;
#line 1181 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_ == CHESS_RESULT_IN_PROGRESS) {
#line 6812 "gnome-chess.c"
		GtkMessageDialog* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		GtkMessageDialog* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = dialog;
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _ ("_Abandon game");
#line 1183 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp14_, _tmp15_, (gint) GTK_RESPONSE_NO);
#line 1184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = dialog;
#line 1184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _ ("_Save game for later");
#line 1184 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp16_, _tmp17_, (gint) GTK_RESPONSE_YES);
#line 6829 "gnome-chess.c"
	} else {
		GtkMessageDialog* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GtkMessageDialog* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
#line 1188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = dialog;
#line 1188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _ ("_Discard game");
#line 1188 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp18_, _tmp19_, (gint) GTK_RESPONSE_NO);
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = dialog;
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _ ("_Save game log");
#line 1189 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_add_button ((GtkDialog*) _tmp20_, _tmp21_, (gint) GTK_RESPONSE_YES);
#line 6847 "gnome-chess.c"
	}
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = dialog;
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = gtk_dialog_run ((GtkDialog*) _tmp22_);
#line 1192 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_result_ = _tmp23_;
#line 1193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = dialog;
#line 1193 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp24_);
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _result_;
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp26_ == ((gint) GTK_RESPONSE_CANCEL)) {
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = TRUE;
#line 6865 "gnome-chess.c"
	} else {
		gint _tmp27_ = 0;
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _result_;
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp27_ == ((gint) GTK_RESPONSE_DELETE_EVENT);
#line 6872 "gnome-chess.c"
	}
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _tmp25_;
#line 1195 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp28_) {
#line 1197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = FALSE;
#line 1197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (dialog);
#line 1197 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 6884 "gnome-chess.c"
	} else {
		gint _tmp29_ = 0;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _result_;
#line 1199 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp29_ == ((gint) GTK_RESPONSE_YES)) {
#line 6891 "gnome-chess.c"
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
#line 1202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _ ("_Discard");
#line 1202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = _ ("_Save");
#line 1202 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_save_game (self, _tmp30_, _tmp31_);
#line 6900 "gnome-chess.c"
		} else {
			gint _tmp32_ = 0;
#line 1206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _result_;
#line 1206 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_warn_if_fail (_tmp32_ == ((gint) GTK_RESPONSE_NO));
#line 1208 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 1209 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_autosave (self);
#line 6911 "gnome-chess.c"
		}
	}
#line 1212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (dialog);
#line 1212 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 6920 "gnome-chess.c"
}


void G_MODULE_EXPORT new_game_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 1216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1216 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before starting a new one?");
#line 1218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = application_prompt_save_game (self, _tmp0_);
#line 1218 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_) {
#line 1219 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_start_new_game (self);
#line 6939 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT resign_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
#line 1223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1223 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->human_player;
#line 1225 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 6954 "gnome-chess.c"
		ChessPlayer* _tmp1_ = NULL;
#line 1226 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->human_player;
#line 1226 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_resign (_tmp1_);
#line 6960 "gnome-chess.c"
	} else {
		ChessGame* _tmp2_ = NULL;
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
#line 1228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_current_player (_tmp2_);
#line 1228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1228 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_resign (_tmp4_);
#line 6973 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT claim_draw_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1232 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_current_player (_tmp0_);
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = chess_player_claim_draw (_tmp2_);
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp3_) {
#line 6997 "gnome-chess.c"
		GtkMessageDialog* dialog = NULL;
		GtkWindow* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		GtkMessageDialog* _tmp6_ = NULL;
		gint repetitions = 0;
		ChessGame* _tmp7_ = NULL;
		ChessGame* _tmp8_ = NULL;
		ChessState* _tmp9_ = NULL;
		ChessState* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint moves = 0;
		ChessGame* _tmp12_ = NULL;
		ChessState* _tmp13_ = NULL;
		ChessState* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gboolean _tmp16_ = FALSE;
		gint _tmp17_ = 0;
		gboolean _tmp19_ = FALSE;
		const gchar* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		GtkMessageDialog* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		const gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		gchar* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_ = NULL;
		const gchar* _tmp69_ = NULL;
		gchar* _tmp70_ = NULL;
		gchar* _tmp71_ = NULL;
		gchar* _tmp72_ = NULL;
		gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		const gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		gchar* _tmp78_ = NULL;
		gint _tmp79_ = 0;
		GtkMessageDialog* _tmp80_ = NULL;
		GtkMessageDialog* _tmp81_ = NULL;
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->window;
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _ ("You cannot currently claim a draw.");
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new_with_markup (_tmp4_, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "<span weight=\"bold\" size=\"larger\">%s</span>", _tmp5_);
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_object_ref_sink (_tmp6_);
#line 1236 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		dialog = _tmp6_;
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_current_state (_tmp8_);
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_state_repeated_times (_tmp7_, _tmp10_);
#line 1243 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		repetitions = _tmp11_;
#line 1244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_current_state (_tmp12_);
#line 1244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_->halfmove_clock;
#line 1244 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		moves = _tmp15_ / 2;
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = repetitions;
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp17_ == 1) {
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = TRUE;
#line 7114 "gnome-chess.c"
		} else {
			gint _tmp18_ = 0;
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp18_ = repetitions;
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp16_ = _tmp18_ == 2;
#line 7121 "gnome-chess.c"
		}
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = _tmp16_;
#line 1246 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warn_if_fail (_tmp19_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = repetitions;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp21_ == 1) {
#line 7131 "gnome-chess.c"
			const gchar* _tmp22_ = NULL;
#line 1250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp22_ = _ ("It is the first time this board position has occurred");
#line 1250 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = _tmp22_;
#line 7137 "gnome-chess.c"
		} else {
			const gchar* _tmp23_ = NULL;
#line 1251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp23_ = _ ("It is the second time this board position has occurred");
#line 1251 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp20_ = _tmp23_;
#line 7144 "gnome-chess.c"
		}
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = dialog;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = _tmp20_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = g_strconcat ("• ", _tmp25_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = _tmp26_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp29_ = _tmp28_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp30_ = g_strconcat (_tmp29_, "• ", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp31_ = _tmp30_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp32_ = moves;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp33_ = ngettext ("%d move has passed without a capture or pawn advancement", "%d moves have passed without a capture or pawn advancement", (gulong) _tmp32_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp35_ = _tmp34_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp36_ = g_strconcat (_tmp35_, "\n\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = _tmp36_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp38_ = _ ("You can claim a draw when either:");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = g_strconcat (_tmp37_, _tmp38_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp40_ = _tmp39_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = g_strconcat (_tmp40_, "\n\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = _tmp41_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = g_strconcat (_tmp42_, "• ", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp44_ = _tmp43_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp45_ = _ ("Any board position has occurred three times");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp46_ = g_strconcat (_tmp44_, _tmp45_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp47_ = _tmp46_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp48_ = g_strconcat (_tmp47_, "\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp49_ = _tmp48_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp50_ = g_strconcat (_tmp49_, "• ", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp51_ = _tmp50_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp52_ = _ ("50 moves have passed without a capture or pawn advancement");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp53_ = g_strconcat (_tmp51_, _tmp52_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp54_ = _tmp53_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp55_ = g_strconcat (_tmp54_, "\n\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp56_ = _tmp55_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp57_ = _ ("(Board position is affected by the ability to castle or capture en pas" \
"sant.)");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp58_ = g_strconcat (_tmp56_, _tmp57_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp59_ = _tmp58_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp60_ = g_strconcat (_tmp59_, "\n\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp61_ = _tmp60_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp62_ = _ ("The game is automatically a draw if:");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp63_ = g_strconcat (_tmp61_, _tmp62_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp64_ = _tmp63_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp65_ = g_strconcat (_tmp64_, "\n\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp66_ = _tmp65_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp67_ = g_strconcat (_tmp66_, "• ", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp68_ = _tmp67_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp69_ = _ ("The current player cannot move (stalemate)");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp70_ = g_strconcat (_tmp68_, _tmp69_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = _tmp70_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp72_ = g_strconcat (_tmp71_, "\n", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp73_ = _tmp72_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp74_ = g_strconcat (_tmp73_, "• ", NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp75_ = _tmp74_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp76_ = _ ("Neither player can checkmate (insufficient material)");
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp77_ = g_strconcat (_tmp75_, _tmp76_, NULL);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp78_ = _tmp77_;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp79_ = moves;
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_message_dialog_format_secondary_text (_tmp24_, _tmp78_, _tmp79_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp78_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp75_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp73_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp71_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp68_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp66_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp64_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp61_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp59_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp56_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp54_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp51_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp49_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp47_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp44_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp42_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp40_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp37_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp35_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp31_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp29_);
#line 1249 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp27_);
#line 1264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp80_ = dialog;
#line 1264 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run ((GtkDialog*) _tmp80_);
#line 1265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp81_ = dialog;
#line 1265 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp81_);
#line 1234 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (dialog);
#line 7314 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT undo_move_cb (GtkWidget* widget, Application* self) {
	ChessPlayer* _tmp0_ = NULL;
#line 1270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1270 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->opponent;
#line 1272 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 7329 "gnome-chess.c"
		ChessPlayer* _tmp1_ = NULL;
#line 1273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->human_player;
#line 1273 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp1_);
#line 7335 "gnome-chess.c"
	} else {
		ChessGame* _tmp2_ = NULL;
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
#line 1275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->game;
#line 1275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = chess_game_get_opponent (_tmp2_);
#line 1275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_;
#line 1275 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_player_undo (_tmp4_);
#line 7348 "gnome-chess.c"
	}
}


static void application_stash_button_sensitivity (Application* self) {
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	GtkWidget* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GtkWidget* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkWidget* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	GtkWidget* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkComboBox* _tmp28_ = NULL;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_ = FALSE;
	gboolean _tmp31_ = FALSE;
#line 1278 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->undo_button;
#line 1280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_sensitive (_tmp0_);
#line 1280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO] = _tmp2_;
#line 1280 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO];
#line 1281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->claim_draw_button;
#line 1281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = gtk_widget_get_sensitive (_tmp4_);
#line 1281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW] = _tmp6_;
#line 1281 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW];
#line 1283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->resign_button;
#line 1283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_widget_get_sensitive (_tmp8_);
#line 1283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN] = _tmp10_;
#line 1283 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN];
#line 1284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->first_move_button;
#line 1284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_widget_get_sensitive (_tmp12_);
#line 1284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = _tmp13_;
#line 1284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE] = _tmp14_;
#line 1284 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE];
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->prev_move_button;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = gtk_widget_get_sensitive (_tmp16_);
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = _tmp17_;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE] = _tmp18_;
#line 1286 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE];
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->next_move_button;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_widget_get_sensitive (_tmp20_);
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = _tmp21_;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE] = _tmp22_;
#line 1288 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE];
#line 1290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = self->priv->last_move_button;
#line 1290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = gtk_widget_get_sensitive (_tmp24_);
#line 1290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = _tmp25_;
#line 1290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE] = _tmp26_;
#line 1290 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE];
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->history_combo;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp28_);
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY] = _tmp30_;
#line 1292 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY];
#line 7468 "gnome-chess.c"
}


static void application_revert_button_sensitivity (Application* self) {
	GtkWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkWidget* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkWidget* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkWidget* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	GtkWidget* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GtkWidget* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	GtkComboBox* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
#line 1295 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->undo_button;
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_UNDO];
#line 1297 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp0_, _tmp1_);
#line 1298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->claim_draw_button;
#line 1298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_CLAIM_DRAW];
#line 1298 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp2_, _tmp3_);
#line 1300 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->resign_button;
#line 1300 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_RESIGN];
#line 1300 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp4_, _tmp5_);
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->first_move_button;
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_FIRST_MOVE];
#line 1301 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp6_, _tmp7_);
#line 1303 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->prev_move_button;
#line 1303 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_PREV_MOVE];
#line 1303 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp8_, _tmp9_);
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->next_move_button;
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_NEXT_MOVE];
#line 1305 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp10_, _tmp11_);
#line 1307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->last_move_button;
#line 1307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_LAST_MOVE];
#line 1307 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp12_, _tmp13_);
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->history_combo;
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->widget_sensitivity[APPLICATION_SENSITIVITY_INDEX_HISTORY];
#line 1309 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, _tmp15_);
#line 7539 "gnome-chess.c"
}


void G_MODULE_EXPORT pause_game_button_pressed_cb (GtkWidget* widget, Application* self) {
	ChessGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkToolButton* tool_button = NULL;
	GtkWidget* _tmp5_ = NULL;
	GtkToolButton* _tmp6_ = NULL;
	ChessGame* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
#line 1313 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1313 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_is_paused (_tmp0_);
#line 1315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1315 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 7565 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
#line 1316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1316 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_unpause (_tmp3_);
#line 7571 "gnome-chess.c"
	} else {
		ChessGame* _tmp4_ = NULL;
#line 1318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->game;
#line 1318 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_game_superpause (_tmp4_);
#line 7578 "gnome-chess.c"
	}
#line 1320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->pause_button;
#line 1320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_TOOL_BUTTON, GtkToolButton));
#line 1320 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	tool_button = _tmp6_;
#line 1322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->game;
#line 1322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = chess_game_get_is_paused (_tmp7_);
#line 1322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 1322 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_) {
#line 7594 "gnome-chess.c"
		GtkToolButton* _tmp10_ = NULL;
		GtkToolButton* _tmp11_ = NULL;
		GtkWidget* _tmp12_ = NULL;
		GtkWidget* _tmp13_ = NULL;
		GtkWidget* _tmp14_ = NULL;
		GtkWidget* _tmp15_ = NULL;
		GtkWidget* _tmp16_ = NULL;
		GtkWidget* _tmp17_ = NULL;
		GtkWidget* _tmp18_ = NULL;
		GtkComboBox* _tmp19_ = NULL;
#line 1324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = tool_button;
#line 1324 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_stock_id (_tmp10_, "gtk-media-play");
#line 1325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = tool_button;
#line 1325 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_label (_tmp11_, "Start");
#line 1326 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_stash_button_sensitivity (self);
#line 1327 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->undo_button;
#line 1327 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp12_, FALSE);
#line 1328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->claim_draw_button;
#line 1328 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp13_, FALSE);
#line 1329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->resign_button;
#line 1329 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp14_, FALSE);
#line 1330 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->first_move_button;
#line 1330 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp15_, FALSE);
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = self->priv->prev_move_button;
#line 1331 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp16_, FALSE);
#line 1332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->next_move_button;
#line 1332 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp17_, FALSE);
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->last_move_button;
#line 1333 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive (_tmp18_, FALSE);
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = self->priv->history_combo;
#line 1334 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp19_, FALSE);
#line 7647 "gnome-chess.c"
	} else {
		GtkToolButton* _tmp20_ = NULL;
		GtkToolButton* _tmp21_ = NULL;
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = tool_button;
#line 1338 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_stock_id (_tmp20_, "gtk-media-pause");
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = tool_button;
#line 1339 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_label (_tmp21_, "Pause");
#line 1340 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_revert_button_sensitivity (self);
#line 7661 "gnome-chess.c"
	}
#line 1313 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (tool_button);
#line 7665 "gnome-chess.c"
}


void application_quit_cb (Application* self) {
#line 1344 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1346 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_quit_game (self);
#line 7674 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT white_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1350 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 0.0;
#line 1352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 0.0;
#line 1352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 0.0;
#line 1352 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 1.0;
#line 1353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 1.0;
#line 1353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 1.0;
#line 1353 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_WHITE);
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1355 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1356 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7735 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT black_time_draw_cb (GtkWidget* widget, cairo_t* c, Application* self) {
	gboolean result = FALSE;
	gdouble fg[3] = {0};
	gdouble _tmp0_[3] = {0};
	gdouble bg[3] = {0};
	gdouble _tmp1_[3] = {0};
	GtkWidget* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	ChessGame* _tmp4_ = NULL;
	ChessClock* _tmp5_ = NULL;
	ChessClock* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
#line 1360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1360 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[0] = 1.0;
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[1] = 1.0;
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_[2] = 1.0;
#line 1362 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	memcpy (fg, _tmp0_, 3 * sizeof (gdouble));
#line 1363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[0] = 0.0;
#line 1363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[1] = 0.0;
#line 1363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_[2] = 0.0;
#line 1363 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	memcpy (bg, _tmp1_, 3 * sizeof (gdouble));
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = widget;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->game;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = chess_game_get_clock (_tmp4_);
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = application_make_clock_text (self, _tmp6_, COLOR_BLACK);
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_;
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_draw_time (self, _tmp2_, _tmp3_, _tmp8_, fg, 3, bg, 3);
#line 1365 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp8_);
#line 1366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1366 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 7796 "gnome-chess.c"
}


static gchar* application_make_clock_text (Application* self, ChessClock* clock, Color color) {
	gchar* result = NULL;
	ChessClock* _tmp0_ = NULL;
	gint used = 0;
	Color _tmp2_ = 0;
	gint _tmp23_ = 0;
#line 1369 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1371 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = clock;
#line 1371 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == NULL) {
#line 7812 "gnome-chess.c"
		gchar* _tmp1_ = NULL;
#line 1372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = g_strdup ("∞");
#line 1372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = _tmp1_;
#line 1372 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7820 "gnome-chess.c"
	}
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = color;
#line 1375 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 7826 "gnome-chess.c"
		ChessGame* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessClock* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		guint _tmp7_ = 0U;
		ChessGame* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		ChessClock* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->game;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = chess_game_get_clock (_tmp3_);
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = chess_clock_get_white_initial_seconds (_tmp5_);
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = self->priv->game;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = chess_game_get_clock (_tmp8_);
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _tmp9_;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_clock_get_white_seconds_used (_tmp10_);
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1376 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		used = (gint) (_tmp7_ - _tmp12_);
#line 7859 "gnome-chess.c"
	} else {
		ChessGame* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		ChessClock* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		guint _tmp17_ = 0U;
		ChessGame* _tmp18_ = NULL;
		ChessClock* _tmp19_ = NULL;
		ChessClock* _tmp20_ = NULL;
		guint _tmp21_ = 0U;
		guint _tmp22_ = 0U;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->game;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = chess_game_get_clock (_tmp13_);
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = _tmp14_;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = chess_clock_get_black_initial_seconds (_tmp15_);
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = _tmp16_;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = self->priv->game;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = chess_game_get_clock (_tmp18_);
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = chess_clock_get_black_seconds_used (_tmp20_);
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = _tmp21_;
#line 1378 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		used = (gint) (_tmp17_ - _tmp22_);
#line 7893 "gnome-chess.c"
	}
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = used;
#line 1380 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp23_ >= 60) {
#line 7899 "gnome-chess.c"
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gchar* _tmp26_ = NULL;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = used;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = used;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = g_strdup_printf ("%d:%02d", _tmp24_ / 60, _tmp25_ % 60);
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = _tmp26_;
#line 1381 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7913 "gnome-chess.c"
	} else {
		gint _tmp27_ = 0;
		gchar* _tmp28_ = NULL;
#line 1383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = used;
#line 1383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = g_strdup_printf (":%02d", _tmp27_);
#line 1383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = _tmp28_;
#line 1383 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 7925 "gnome-chess.c"
	}
}


static void application_draw_time (Application* self, GtkWidget* widget, cairo_t* c, const gchar* text, gdouble* fg, int fg_length1, gdouble* bg, int bg_length1) {
	gdouble alpha = 0.0;
	GtkWidget* _tmp0_ = NULL;
	GtkStateType _tmp1_ = 0;
	cairo_t* _tmp2_ = NULL;
	gdouble* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gdouble _tmp4_ = 0.0;
	gdouble* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gdouble _tmp6_ = 0.0;
	gdouble* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gdouble* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gdouble _tmp13_ = 0.0;
	gdouble* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	GtkWidget* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	cairo_text_extents_t extents = {0};
	cairo_t* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	cairo_text_extents_t _tmp25_ = {0};
	cairo_t* _tmp26_ = NULL;
	GtkWidget* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	cairo_text_extents_t _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	cairo_text_extents_t _tmp31_ = {0};
	gdouble _tmp32_ = 0.0;
	GtkWidget* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	cairo_text_extents_t _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	cairo_text_extents_t _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	cairo_t* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	GtkWidget* _tmp41_ = NULL;
	cairo_text_extents_t _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
#line 1386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (c != NULL);
#line 1386 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (text != NULL);
#line 1388 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	alpha = 1.0;
#line 1390 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1390 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_widget_get_state (_tmp0_);
#line 1390 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp1_ == GTK_STATE_INSENSITIVE) {
#line 1391 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		alpha = 0.5;
#line 8001 "gnome-chess.c"
	}
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = c;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = bg;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3__length1 = bg_length1;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _tmp3_[0];
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = bg;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5__length1 = bg_length1;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_[1];
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = bg;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7__length1 = bg_length1;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = _tmp7_[2];
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = alpha;
#line 1392 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp2_, _tmp4_, _tmp6_, _tmp8_, _tmp9_);
#line 1393 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = c;
#line 1393 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_paint (_tmp10_);
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = c;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = fg;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12__length1 = fg_length1;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_[0];
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = fg;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14__length1 = fg_length1;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = _tmp14_[1];
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = fg;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16__length1 = fg_length1;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = _tmp16_[2];
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = alpha;
#line 1395 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_set_source_rgba (_tmp11_, _tmp13_, _tmp15_, _tmp17_, _tmp18_);
#line 1396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = c;
#line 1396 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_select_font_face (_tmp19_, "fixed", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = c;
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = widget;
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = gtk_widget_get_allocated_height (_tmp21_);
#line 1397 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_set_font_size (_tmp20_, 0.6 * _tmp22_);
#line 1399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = c;
#line 1399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = text;
#line 1399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_text_extents (_tmp23_, _tmp24_, &_tmp25_);
#line 1399 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	extents = _tmp25_;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = c;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = widget;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = gtk_widget_get_allocated_width (_tmp27_);
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = extents;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = _tmp29_.width;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = extents;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_.x_bearing;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = widget;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_widget_get_allocated_height (_tmp33_);
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = extents;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = _tmp35_.height;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = extents;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_.y_bearing;
#line 1400 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_move_to (_tmp26_, ((_tmp28_ - _tmp30_) / 2) - _tmp32_, ((_tmp34_ - _tmp36_) / 2) - _tmp38_);
#line 1402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = c;
#line 1402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = text;
#line 1402 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	cairo_show_text (_tmp39_, _tmp40_);
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = widget;
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = extents;
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp43_ = _tmp42_.width;
#line 1404 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_size_request (_tmp41_, ((gint) _tmp43_) + 6, -1);
#line 8117 "gnome-chess.c"
}


void G_MODULE_EXPORT history_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint move_number = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	ChessGame* _tmp8_ = NULL;
	gboolean _tmp13_ = FALSE;
	ChessScene* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1408 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1411 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1412 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 8150 "gnome-chess.c"
	}
#line 1414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1414 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &move_number, -1, -1);
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->game;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp8_ == NULL) {
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 8168 "gnome-chess.c"
	} else {
		gint _tmp9_ = 0;
		ChessGame* _tmp10_ = NULL;
		guint _tmp11_ = 0U;
		guint _tmp12_ = 0U;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = move_number;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->game;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = chess_game_get_n_moves (_tmp10_);
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = ((guint) _tmp9_) == _tmp12_;
#line 8184 "gnome-chess.c"
	}
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp7_;
#line 1415 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_) {
#line 1416 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		move_number = -1;
#line 8192 "gnome-chess.c"
	}
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->scene;
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = move_number;
#line 1417 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp14_, _tmp15_);
#line 8200 "gnome-chess.c"
}


void G_MODULE_EXPORT history_latest_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
#line 1421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1421 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1423 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, -1);
#line 8214 "gnome-chess.c"
}


void G_MODULE_EXPORT history_next_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint move_number = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	ChessGame* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
#line 1427 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1427 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1429 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == (-1)) {
#line 1430 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 8244 "gnome-chess.c"
	}
#line 1432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1432 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	move_number = _tmp5_ + 1;
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = move_number;
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->game;
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 1433 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (((guint) _tmp6_) >= _tmp9_) {
#line 8264 "gnome-chess.c"
		ChessScene* _tmp10_ = NULL;
#line 1434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1434 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, -1);
#line 8270 "gnome-chess.c"
	} else {
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
#line 1436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = move_number;
#line 1436 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp11_, _tmp12_);
#line 8280 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_previous_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ChessScene* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 1440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1440 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_scene_get_move_number (_tmp0_);
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1442 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ == 0) {
#line 1443 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 8306 "gnome-chess.c"
	}
#line 1445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->scene;
#line 1445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = chess_scene_get_move_number (_tmp3_);
#line 1445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1445 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp5_ == (-1)) {
#line 8316 "gnome-chess.c"
		ChessScene* _tmp6_ = NULL;
		ChessGame* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
#line 1446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = self->priv->scene;
#line 1446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_n_moves (_tmp7_);
#line 1446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1446 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp6_, ((gint) _tmp9_) - 1);
#line 8331 "gnome-chess.c"
	} else {
		ChessScene* _tmp10_ = NULL;
		ChessScene* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 1448 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = self->priv->scene;
#line 1448 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = self->priv->scene;
#line 1448 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = chess_scene_get_move_number (_tmp11_);
#line 1448 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = _tmp12_;
#line 1448 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		chess_scene_set_move_number (_tmp10_, _tmp13_ - 1);
#line 8347 "gnome-chess.c"
	}
}


void G_MODULE_EXPORT history_start_clicked_cb (GtkWidget* widget, Application* self) {
	ChessScene* _tmp0_ = NULL;
#line 1452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1452 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1454 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->scene;
#line 1454 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	chess_scene_set_move_number (_tmp0_, 0);
#line 8362 "gnome-chess.c"
}


void G_MODULE_EXPORT toggle_fullscreen_cb (GtkWidget* widget, Application* self) {
	gboolean _tmp0_ = FALSE;
#line 1458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1458 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->is_fullscreen;
#line 1460 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_) {
#line 8376 "gnome-chess.c"
		GtkWidget* _tmp1_ = NULL;
		GtkWindow* _tmp2_ = NULL;
#line 1462 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->fullscreen_button;
#line 1462 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_TOOL_BUTTON, GtkToolButton), "gtk-fullscreen");
#line 1463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = self->priv->window;
#line 1463 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_unfullscreen (_tmp2_);
#line 8387 "gnome-chess.c"
	} else {
		GtkWidget* _tmp3_ = NULL;
		GtkWindow* _tmp4_ = NULL;
#line 1467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->fullscreen_button;
#line 1467 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tool_button_set_stock_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GTK_TYPE_TOOL_BUTTON, GtkToolButton), "gtk-leave-fullscreen");
#line 1468 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = self->priv->window;
#line 1468 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_fullscreen (_tmp4_);
#line 8399 "gnome-chess.c"
	}
}


void application_preferences_cb (Application* self) {
	GtkDialog* _tmp0_ = NULL;
	GtkBuilder* _tmp2_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkDialog* _tmp11_ = NULL;
	GtkWindow* _tmp12_ = NULL;
	GSettings* _tmp13_ = NULL;
	GtkBuilder* _tmp14_ = NULL;
	GObject* _tmp15_ = NULL;
	GSettings* _tmp16_ = NULL;
	GtkBuilder* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GSettings* _tmp19_ = NULL;
	GtkBuilder* _tmp20_ = NULL;
	GObject* _tmp21_ = NULL;
	GSettings* _tmp22_ = NULL;
	GtkBuilder* _tmp23_ = NULL;
	GObject* _tmp24_ = NULL;
	GtkBuilder* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkComboBox* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	GSettings* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	GtkComboBox* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	GtkComboBox* ai_combo = NULL;
	GtkBuilder* _tmp33_ = NULL;
	GObject* _tmp34_ = NULL;
	GtkComboBox* _tmp35_ = NULL;
	GtkListStore* ai_model = NULL;
	GtkComboBox* _tmp36_ = NULL;
	GtkTreeModel* _tmp37_ = NULL;
	GtkTreeModel* _tmp38_ = NULL;
	GtkListStore* _tmp39_ = NULL;
	gchar* opponent_name = NULL;
	GSettings* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	GList* _tmp44_ = NULL;
	GtkComboBox* _tmp69_ = NULL;
	gint _tmp70_ = 0;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkComboBox* _tmp75_ = NULL;
	GtkComboBox* _tmp76_ = NULL;
	GSettings* _tmp77_ = NULL;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	GtkBuilder* _tmp80_ = NULL;
	GObject* _tmp81_ = NULL;
	GtkComboBox* _tmp82_ = NULL;
	GtkBuilder* _tmp83_ = NULL;
	GObject* _tmp84_ = NULL;
	GtkAdjustment* _tmp85_ = NULL;
	GtkBuilder* _tmp86_ = NULL;
	GObject* _tmp87_ = NULL;
	GtkContainer* _tmp88_ = NULL;
	GtkBuilder* _tmp89_ = NULL;
	GObject* _tmp90_ = NULL;
	GtkComboBox* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkComboBox* orientation_combo = NULL;
	GtkBuilder* _tmp94_ = NULL;
	GObject* _tmp95_ = NULL;
	GtkComboBox* _tmp96_ = NULL;
	GtkComboBox* _tmp97_ = NULL;
	GSettings* _tmp98_ = NULL;
	gchar* _tmp99_ = NULL;
	gchar* _tmp100_ = NULL;
	GtkComboBox* move_combo = NULL;
	GtkBuilder* _tmp101_ = NULL;
	GObject* _tmp102_ = NULL;
	GtkComboBox* _tmp103_ = NULL;
	GtkComboBox* _tmp104_ = NULL;
	GSettings* _tmp105_ = NULL;
	gchar* _tmp106_ = NULL;
	gchar* _tmp107_ = NULL;
	GtkCheckButton* show_3d_check = NULL;
	GtkBuilder* _tmp108_ = NULL;
	GObject* _tmp109_ = NULL;
	GtkCheckButton* _tmp110_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkBuilder* _tmp111_ = NULL;
	GObject* _tmp112_ = NULL;
	GtkComboBox* _tmp113_ = NULL;
	GtkComboBox* _tmp114_ = NULL;
	GSettings* _tmp115_ = NULL;
	gchar* _tmp116_ = NULL;
	gchar* _tmp117_ = NULL;
	GtkComboBox* _tmp118_ = NULL;
	GtkCheckButton* _tmp119_ = NULL;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	GtkCheckButton* show_3d_smooth_check = NULL;
	GtkBuilder* _tmp122_ = NULL;
	GObject* _tmp123_ = NULL;
	GtkCheckButton* _tmp124_ = NULL;
	GtkCheckButton* _tmp125_ = NULL;
	GtkCheckButton* _tmp126_ = NULL;
	gboolean _tmp127_ = FALSE;
	gboolean _tmp128_ = FALSE;
	GtkBuilder* _tmp129_ = NULL;
	GtkComboBox* _tmp130_ = NULL;
	gint _tmp131_ = 0;
	GtkDialog* _tmp134_ = NULL;
	GError * _inner_error_ = NULL;
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1474 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1474 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 8520 "gnome-chess.c"
		GtkDialog* _tmp1_ = NULL;
#line 1476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->preferences_dialog;
#line 1476 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 1477 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 8528 "gnome-chess.c"
	}
#line 1480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_builder_new ();
#line 1480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_builder);
#line 1480 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_builder = _tmp2_;
#line 8536 "gnome-chess.c"
	{
		GtkBuilder* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->preferences_builder;
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = g_build_filename (PKGDATADIR, "preferences.ui", NULL, NULL);
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_builder_add_from_file (_tmp3_, _tmp5_, &_inner_error_);
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp5_);
#line 1483 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 8553 "gnome-chess.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = e;
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = _tmp6_->message;
#line 1487 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:1487: Could not load preferences UI: %s", _tmp7_);
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 8575 "gnome-chess.c"
	}
	__finally6:
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 1481 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 8586 "gnome-chess.c"
	}
#line 1489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->preferences_builder;
#line 1489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_builder_get_object (_tmp8_, "preferences");
#line 1489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GTK_TYPE_DIALOG, GtkDialog));
#line 1489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 1489 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = _tmp10_;
#line 1490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->preferences_dialog;
#line 1490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->window;
#line 1490 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp11_, _tmp12_);
#line 1492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->settings;
#line 1492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->preferences_builder;
#line 1492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = gtk_builder_get_object (_tmp14_, "show_numbering_check");
#line 1492 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp13_, "show-numbering", _tmp15_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = self->priv->settings;
#line 1494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->preferences_builder;
#line 1494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = gtk_builder_get_object (_tmp17_, "show_move_hints_check");
#line 1494 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp16_, "show-move-hints", _tmp18_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = self->priv->settings;
#line 1496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->preferences_builder;
#line 1496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_builder_get_object (_tmp20_, "show_3d_check");
#line 1496 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp19_, "show-3d", _tmp21_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = self->priv->settings;
#line 1498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->preferences_builder;
#line 1498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = gtk_builder_get_object (_tmp23_, "show_3d_smooth_check");
#line 1498 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_bind (_tmp22_, "show-3d-smooth", _tmp24_, "active", G_SETTINGS_BIND_DEFAULT);
#line 1501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->preferences_builder;
#line 1501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = gtk_builder_get_object (_tmp25_, "side_combo");
#line 1501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 1501 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->side_combo = _tmp27_;
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = self->priv->settings;
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = g_settings_get_boolean (_tmp29_, "play-as-white");
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp30_) {
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = 0;
#line 8654 "gnome-chess.c"
	} else {
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = 1;
#line 8658 "gnome-chess.c"
	}
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = self->priv->side_combo;
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp28_;
#line 1502 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_combo_box_set_active (_tmp31_, _tmp32_);
#line 1504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->preferences_builder;
#line 1504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = gtk_builder_get_object (_tmp33_, "opponent_combo");
#line 1504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1504 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	ai_combo = _tmp35_;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = ai_combo;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp37_ = gtk_combo_box_get_model (_tmp36_);
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = _tmp37_;
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp39_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1505 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	ai_model = _tmp39_;
#line 1506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = self->priv->settings;
#line 1506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp41_ = g_settings_get_string (_tmp40_, "opponent");
#line 1506 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	opponent_name = _tmp41_;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp42_ = opponent_name;
#line 1507 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp42_, "human") == 0) {
#line 8694 "gnome-chess.c"
		GtkComboBox* _tmp43_ = NULL;
#line 1508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp43_ = ai_combo;
#line 1508 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp43_, 0);
#line 8700 "gnome-chess.c"
	}
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp44_ = self->priv->ai_profiles;
#line 8704 "gnome-chess.c"
	{
		GList* p_collection = NULL;
		GList* p_it = NULL;
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		p_collection = _tmp44_;
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
#line 8712 "gnome-chess.c"
			AIProfile* _tmp45_ = NULL;
			AIProfile* p = NULL;
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = _ai_profile_ref0 ((AIProfile*) p_it->data);
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			p = _tmp45_;
#line 8719 "gnome-chess.c"
			{
				GtkTreeIter iter = {0};
				GtkListStore* _tmp46_ = NULL;
				GtkTreeIter _tmp47_ = {0};
				GtkListStore* _tmp48_ = NULL;
				GtkTreeIter _tmp49_ = {0};
				AIProfile* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				const gchar* _tmp52_ = NULL;
				AIProfile* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				gboolean _tmp56_ = FALSE;
				AIProfile* _tmp57_ = NULL;
				const gchar* _tmp58_ = NULL;
				const gchar* _tmp59_ = NULL;
				const gchar* _tmp60_ = NULL;
				gboolean _tmp66_ = FALSE;
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = ai_model;
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_append (_tmp46_, &_tmp47_);
#line 1512 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				iter = _tmp47_;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = ai_model;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = iter;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = p;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = ai_profile_get_name (_tmp50_);
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp52_ = _tmp51_;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp53_ = p;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp54_ = ai_profile_get_name (_tmp53_);
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp55_ = _tmp54_;
#line 1513 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_list_store_set (_tmp48_, &_tmp49_, 0, _tmp52_, 1, _tmp55_, -1, -1);
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp57_ = p;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp58_ = ai_profile_get_name (_tmp57_);
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp59_ = _tmp58_;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp60_ = opponent_name;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (g_strcmp0 (_tmp59_, _tmp60_) == 0) {
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp56_ = TRUE;
#line 8774 "gnome-chess.c"
				} else {
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_ = NULL;
					gboolean _tmp65_ = FALSE;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp62_ = opponent_name;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (g_strcmp0 (_tmp62_, "") == 0) {
#line 8783 "gnome-chess.c"
						GtkComboBox* _tmp63_ = NULL;
						gint _tmp64_ = 0;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp63_ = ai_combo;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp64_ = gtk_combo_box_get_active (_tmp63_);
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp61_ = _tmp64_ == (-1);
#line 8792 "gnome-chess.c"
					} else {
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp61_ = FALSE;
#line 8796 "gnome-chess.c"
					}
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp65_ = _tmp61_;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp56_ = _tmp65_;
#line 8802 "gnome-chess.c"
				}
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp66_ = _tmp56_;
#line 1514 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp66_) {
#line 8808 "gnome-chess.c"
					GtkComboBox* _tmp67_ = NULL;
					GtkTreeIter _tmp68_ = {0};
#line 1515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp67_ = ai_combo;
#line 1515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp68_ = iter;
#line 1515 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					gtk_combo_box_set_active_iter (_tmp67_, &_tmp68_);
#line 8817 "gnome-chess.c"
				}
#line 1509 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_ai_profile_unref0 (p);
#line 8821 "gnome-chess.c"
			}
		}
	}
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp69_ = ai_combo;
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp70_ = gtk_combo_box_get_active (_tmp69_);
#line 1517 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp70_ == (-1)) {
#line 8831 "gnome-chess.c"
		GtkComboBox* _tmp71_ = NULL;
		GSettings* _tmp72_ = NULL;
#line 1519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp71_ = ai_combo;
#line 1519 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active (_tmp71_, 0);
#line 1520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp72_ = self->priv->settings;
#line 1520 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_settings_set_string (_tmp72_, "opponent", "human");
#line 8842 "gnome-chess.c"
	}
#line 1523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp73_ = self->priv->preferences_builder;
#line 1523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "difficulty_combo");
#line 1523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 1523 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->difficulty_combo = _tmp75_;
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp76_ = self->priv->difficulty_combo;
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp77_ = self->priv->settings;
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp78_ = g_settings_get_string (_tmp77_, "difficulty");
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp79_ = _tmp78_;
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_combo (self, _tmp76_, 1, _tmp79_);
#line 1524 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp79_);
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp80_ = self->priv->preferences_builder;
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp81_ = gtk_builder_get_object (_tmp80_, "duration_combo");
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 1526 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_combo = _tmp82_;
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp83_ = self->priv->preferences_builder;
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp84_ = gtk_builder_get_object (_tmp83_, "duration_adjustment");
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp85_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GTK_TYPE_ADJUSTMENT, GtkAdjustment));
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 1527 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->duration_adjustment = _tmp85_;
#line 1528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp86_ = self->priv->preferences_builder;
#line 1528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp87_ = gtk_builder_get_object (_tmp86_, "custom_duration_box");
#line 1528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 1528 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_box = _tmp88_;
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp89_ = self->priv->preferences_builder;
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp90_ = gtk_builder_get_object (_tmp89_, "custom_duration_units_combo");
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp91_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 1529 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->custom_duration_units_combo = _tmp91_;
#line 1530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp92_ = self->priv->settings;
#line 1530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp93_ = g_settings_get_int (_tmp92_, "duration");
#line 1530 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_duration (self, _tmp93_, TRUE);
#line 1532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp94_ = self->priv->preferences_builder;
#line 1532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp95_ = gtk_builder_get_object (_tmp94_, "orientation_combo");
#line 1532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp96_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1532 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	orientation_combo = _tmp96_;
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp97_ = orientation_combo;
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp98_ = self->priv->settings;
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp99_ = g_settings_get_string (_tmp98_, "board-side");
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp100_ = _tmp99_;
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_combo (self, _tmp97_, 1, _tmp100_);
#line 1533 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp100_);
#line 1535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp101_ = self->priv->preferences_builder;
#line 1535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp102_ = gtk_builder_get_object (_tmp101_, "move_format_combo");
#line 1535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp103_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1535 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	move_combo = _tmp103_;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp104_ = move_combo;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp105_ = self->priv->settings;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp106_ = g_settings_get_string (_tmp105_, "move-format");
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp107_ = _tmp106_;
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_combo (self, _tmp104_, 1, _tmp107_);
#line 1536 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp107_);
#line 1538 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp108_ = self->priv->preferences_builder;
#line 1538 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp109_ = gtk_builder_get_object (_tmp108_, "show_3d_check");
#line 1538 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp110_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, GTK_TYPE_CHECK_BUTTON, GtkCheckButton));
#line 1538 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	show_3d_check = _tmp110_;
#line 1540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp111_ = self->priv->preferences_builder;
#line 1540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp112_ = gtk_builder_get_object (_tmp111_, "piece_style_combo");
#line 1540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp113_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, GTK_TYPE_COMBO_BOX, GtkComboBox));
#line 1540 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	theme_combo = _tmp113_;
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp114_ = theme_combo;
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp115_ = self->priv->settings;
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp116_ = g_settings_get_string (_tmp115_, "piece-theme");
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp117_ = _tmp116_;
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_set_combo (self, _tmp114_, 1, _tmp117_);
#line 1541 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp117_);
#line 1542 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp118_ = theme_combo;
#line 1542 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp119_ = show_3d_check;
#line 1542 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp120_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp119_);
#line 1542 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp121_ = _tmp120_;
#line 1542 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp118_, !_tmp121_);
#line 1544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp122_ = self->priv->preferences_builder;
#line 1544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp123_ = gtk_builder_get_object (_tmp122_, "show_3d_smooth_check");
#line 1544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp124_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, GTK_TYPE_CHECK_BUTTON, GtkCheckButton));
#line 1544 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	show_3d_smooth_check = _tmp124_;
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp125_ = show_3d_smooth_check;
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp126_ = show_3d_check;
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp127_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp126_);
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp128_ = _tmp127_;
#line 1545 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp125_, _tmp128_);
#line 1547 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp129_ = self->priv->preferences_builder;
#line 1547 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_builder_connect_signals (_tmp129_, self);
#line 1550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp130_ = ai_combo;
#line 1550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp131_ = gtk_combo_box_get_active (_tmp130_);
#line 1550 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp131_ == 0) {
#line 9018 "gnome-chess.c"
		GtkComboBox* _tmp132_ = NULL;
		GtkComboBox* _tmp133_ = NULL;
#line 1552 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp132_ = self->priv->side_combo;
#line 1552 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp132_, FALSE);
#line 1553 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp133_ = self->priv->difficulty_combo;
#line 1553 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp133_, FALSE);
#line 9029 "gnome-chess.c"
	}
#line 1556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp134_ = self->priv->preferences_dialog;
#line 1556 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp134_);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (show_3d_smooth_check);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (theme_combo);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (show_3d_check);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (move_combo);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (orientation_combo);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent_name);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_model);
#line 1472 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (ai_combo);
#line 9051 "gnome-chess.c"
}


static void application_set_combo (Application* self, GtkComboBox* combo, gint value_index, const gchar* value) {
	GtkTreeIter iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (value != NULL);
#line 1562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1562 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first (_tmp4_, &_tmp5_);
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1563 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp6_) {
#line 1564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1564 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9093 "gnome-chess.c"
	}
	{
		gboolean _tmp7_ = FALSE;
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = TRUE;
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9101 "gnome-chess.c"
			gboolean _tmp8_ = FALSE;
			gchar* v = NULL;
			GtkTreeModel* _tmp11_ = NULL;
			GtkTreeIter _tmp12_ = {0};
			gint _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _tmp7_;
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (!_tmp8_) {
#line 9113 "gnome-chess.c"
				GtkTreeModel* _tmp9_ = NULL;
				gboolean _tmp10_ = FALSE;
#line 1574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = model;
#line 1574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp10_ = gtk_tree_model_iter_next (_tmp9_, &iter);
#line 1574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!_tmp10_) {
#line 1574 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					break;
#line 9124 "gnome-chess.c"
				}
			}
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = FALSE;
#line 1568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = model;
#line 1568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = iter;
#line 1568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = value_index;
#line 1568 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp11_, &_tmp12_, _tmp13_, &v, -1, -1);
#line 1569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = v;
#line 1569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp15_ = value;
#line 1569 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (g_strcmp0 (_tmp14_, _tmp15_) == 0) {
#line 9143 "gnome-chess.c"
				GtkComboBox* _tmp16_ = NULL;
				GtkTreeIter _tmp17_ = {0};
#line 1571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = combo;
#line 1571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp17_ = iter;
#line 1571 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp16_, &_tmp17_);
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_free0 (v);
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1572 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				return;
#line 9158 "gnome-chess.c"
			}
#line 1565 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (v);
#line 9162 "gnome-chess.c"
		}
	}
#line 1559 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9167 "gnome-chess.c"
}


static gchar* application_get_combo (Application* self, GtkComboBox* combo, gint value_index) {
	gchar* result = NULL;
	gchar* value = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gint _tmp7_ = 0;
#line 1577 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1577 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (combo != NULL, NULL);
#line 1581 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1581 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1581 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1581 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = NULL;
#line 1582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (value);
#line 1582 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 9201 "gnome-chess.c"
	}
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = value_index;
#line 1583 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, _tmp7_, &value, -1, -1);
#line 1584 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = value;
#line 1584 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9219 "gnome-chess.c"
}


void G_MODULE_EXPORT side_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean play_as_white = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 1588 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1588 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1591 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1592 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9249 "gnome-chess.c"
	}
#line 1594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1594 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &play_as_white, -1, -1);
#line 1595 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1595 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = play_as_white;
#line 1595 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_boolean (_tmp7_, "play-as-white", _tmp8_);
#line 9267 "gnome-chess.c"
}


void G_MODULE_EXPORT opponent_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* opponent = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean vs_human = FALSE;
	GtkComboBox* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GtkComboBox* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	GtkComboBox* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 1599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1602 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1603 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9304 "gnome-chess.c"
	}
#line 1605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1605 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &opponent, -1, -1);
#line 1606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = opponent;
#line 1606 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "opponent", _tmp8_);
#line 1607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = combo;
#line 1607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = gtk_combo_box_get_active (_tmp9_);
#line 1607 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	vs_human = _tmp10_ == 0;
#line 1608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->side_combo;
#line 1608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = vs_human;
#line 1608 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, !_tmp12_);
#line 1609 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->difficulty_combo;
#line 1609 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = vs_human;
#line 1609 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, !_tmp14_);
#line 1599 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (opponent);
#line 9342 "gnome-chess.c"
}


void G_MODULE_EXPORT difficulty_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* difficulty = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GSettings* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
#line 1613 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1613 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1616 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1617 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9372 "gnome-chess.c"
	}
#line 1619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1619 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &difficulty, -1, -1);
#line 1620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->settings;
#line 1620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = difficulty;
#line 1620 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp7_, "difficulty", _tmp8_);
#line 1613 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (difficulty);
#line 9392 "gnome-chess.c"
}


static void application_set_duration (Application* self, gint duration, gboolean simplify) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter max_iter = {0};
	GtkTreeIter _tmp4_ = {0};
	gint max_multiplier = 0;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	gint value = 0;
	gint _tmp22_ = 0;
	gboolean _tmp29_ = FALSE;
	GtkComboBox* _tmp30_ = NULL;
	GtkTreeModel* _tmp31_ = NULL;
	GtkTreeModel* _tmp32_ = NULL;
	GtkTreeModel* _tmp33_ = NULL;
	GtkTreeModel* _tmp34_ = NULL;
	GtkTreeIter _tmp35_ = {0};
	gboolean _tmp36_ = FALSE;
#line 1623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1625 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1626 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	max_iter = _tmp4_;
#line 1629 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	max_multiplier = 0;
#line 1630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = model;
#line 1630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = gtk_tree_model_get_iter_first (_tmp5_, &_tmp6_);
#line 1630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp6_;
#line 1630 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp7_) {
#line 9443 "gnome-chess.c"
		{
			gboolean _tmp8_ = FALSE;
#line 1632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = TRUE;
#line 1632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 9450 "gnome-chess.c"
				gboolean _tmp9_ = FALSE;
				gint multiplier = 0;
				GtkTreeModel* _tmp12_ = NULL;
				GtkTreeIter _tmp13_ = {0};
				gboolean _tmp14_ = FALSE;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gboolean _tmp19_ = FALSE;
#line 1632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp9_ = _tmp8_;
#line 1632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!_tmp9_) {
#line 9463 "gnome-chess.c"
					GtkTreeModel* _tmp10_ = NULL;
					gboolean _tmp11_ = FALSE;
#line 1641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = model;
#line 1641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp11_ = gtk_tree_model_iter_next (_tmp10_, &iter);
#line 1641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (!_tmp11_) {
#line 1641 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						break;
#line 9474 "gnome-chess.c"
					}
				}
#line 1632 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = FALSE;
#line 1635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = model;
#line 1635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = iter;
#line 1635 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get (_tmp12_, &_tmp13_, 1, &multiplier, -1, -1);
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp15_ = multiplier;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp16_ = max_multiplier;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp15_ > _tmp16_) {
#line 9491 "gnome-chess.c"
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp17_ = duration;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp18_ = multiplier;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = (_tmp17_ % _tmp18_) == 0;
#line 9500 "gnome-chess.c"
				} else {
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp14_ = FALSE;
#line 9504 "gnome-chess.c"
				}
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp19_ = _tmp14_;
#line 1636 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (_tmp19_) {
#line 9510 "gnome-chess.c"
					gint _tmp20_ = 0;
					GtkTreeIter _tmp21_ = {0};
#line 1638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp20_ = multiplier;
#line 1638 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					max_multiplier = _tmp20_;
#line 1639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp21_ = iter;
#line 1639 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					max_iter = _tmp21_;
#line 9521 "gnome-chess.c"
				}
			}
		}
	}
#line 1645 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	value = 0;
#line 1646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = max_multiplier;
#line 1646 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp22_ > 0) {
#line 9532 "gnome-chess.c"
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		GtkAdjustment* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GtkComboBox* _tmp27_ = NULL;
		GtkTreeIter _tmp28_ = {0};
#line 1648 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = duration;
#line 1648 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = max_multiplier;
#line 1648 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value = _tmp23_ / _tmp24_;
#line 1649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = self->priv->duration_adjustment;
#line 1649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = value;
#line 1649 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_adjustment_set_value (_tmp25_, (gdouble) _tmp26_);
#line 1650 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp27_ = self->priv->custom_duration_units_combo;
#line 1650 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = max_iter;
#line 1650 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_combo_box_set_active_iter (_tmp27_, &_tmp28_);
#line 9557 "gnome-chess.c"
	}
#line 1653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = simplify;
#line 1653 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp29_) {
#line 1654 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1654 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9567 "gnome-chess.c"
	}
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->duration_combo;
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = gtk_combo_box_get_model (_tmp30_);
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _tmp31_;
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = _g_object_ref0 (_tmp32_);
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 1656 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp33_;
#line 1657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp34_ = model;
#line 1657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = gtk_tree_model_get_iter_first (_tmp34_, &_tmp35_);
#line 1657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp35_;
#line 1657 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp36_) {
#line 1658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (model);
#line 1658 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 9593 "gnome-chess.c"
	}
	{
		gboolean _tmp37_ = FALSE;
#line 1659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = TRUE;
#line 1659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		while (TRUE) {
#line 9601 "gnome-chess.c"
			gboolean _tmp38_ = FALSE;
			gint v = 0;
			GtkTreeModel* _tmp41_ = NULL;
			GtkTreeIter _tmp42_ = {0};
			gboolean _tmp43_ = FALSE;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
			gboolean _tmp47_ = FALSE;
#line 1659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp38_ = _tmp37_;
#line 1659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (!_tmp38_) {
#line 9614 "gnome-chess.c"
				GtkTreeModel* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
#line 1669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp39_ = model;
#line 1669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp40_ = gtk_tree_model_iter_next (_tmp39_, &iter);
#line 1669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!_tmp40_) {
#line 1669 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					break;
#line 9625 "gnome-chess.c"
				}
			}
#line 1659 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp37_ = FALSE;
#line 1662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp41_ = model;
#line 1662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp42_ = iter;
#line 1662 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_tree_model_get (_tmp41_, &_tmp42_, 1, &v, -1, -1);
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = v;
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = duration;
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_tmp44_ == _tmp45_) {
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = TRUE;
#line 9644 "gnome-chess.c"
			} else {
				gint _tmp46_ = 0;
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp46_ = v;
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp43_ = _tmp46_ == (-1);
#line 9651 "gnome-chess.c"
			}
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = _tmp43_;
#line 1663 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_tmp47_) {
#line 9657 "gnome-chess.c"
				GtkComboBox* _tmp48_ = NULL;
				GtkTreeIter _tmp49_ = {0};
				GtkContainer* _tmp50_ = NULL;
				gint _tmp51_ = 0;
#line 1665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp48_ = self->priv->duration_combo;
#line 1665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp49_ = iter;
#line 1665 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_combo_box_set_active_iter (_tmp48_, &_tmp49_);
#line 1666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp50_ = self->priv->custom_duration_box;
#line 1666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp51_ = v;
#line 1666 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_widget_set_visible ((GtkWidget*) _tmp50_, _tmp51_ == (-1));
#line 1667 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_g_object_unref0 (model);
#line 1667 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				return;
#line 9678 "gnome-chess.c"
			}
		}
	}
#line 1623 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9684 "gnome-chess.c"
}


static gint application_get_duration (Application* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint magnitude = 0;
	GtkAdjustment* _tmp8_ = NULL;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gint multiplier = 0;
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
#line 1672 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->duration_combo;
#line 1675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1675 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_) {
#line 9714 "gnome-chess.c"
		gint duration = 0;
		GtkComboBox* _tmp3_ = NULL;
		GtkTreeModel* _tmp4_ = NULL;
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter _tmp6_ = {0};
		gint _tmp7_ = 0;
#line 1678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->duration_combo;
#line 1678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = iter;
#line 1678 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = duration;
#line 1679 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp7_ >= 0) {
#line 1680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			result = duration;
#line 1680 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return result;
#line 9739 "gnome-chess.c"
		}
	}
#line 1683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->duration_adjustment;
#line 1683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_adjustment_get_value (_tmp8_);
#line 1683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1683 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	magnitude = (gint) _tmp10_;
#line 1684 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	multiplier = 1;
#line 1685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->custom_duration_units_combo;
#line 1685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
#line 1685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp12_;
#line 1685 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp13_) {
#line 9760 "gnome-chess.c"
		GtkComboBox* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
#line 1686 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->custom_duration_units_combo;
#line 1686 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = gtk_combo_box_get_model (_tmp14_);
#line 1686 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 1686 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = iter;
#line 1686 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_tree_model_get (_tmp16_, &_tmp17_, 1, &multiplier, -1, -1);
#line 9775 "gnome-chess.c"
	}
#line 1687 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = magnitude;
#line 1687 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = multiplier;
#line 1687 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = _tmp18_ * _tmp19_;
#line 1687 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9785 "gnome-chess.c"
}


static gboolean application_save_duration_cb (Application* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint _tmp2_ = 0U;
#line 1690 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1692 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1692 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = application_get_duration (self);
#line 1692 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_int (_tmp0_, "duration", _tmp1_);
#line 1693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->save_duration_timeout;
#line 1693 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_source_remove (_tmp2_);
#line 1694 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 1695 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = FALSE;
#line 1695 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 9812 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_changed_cb (GtkAdjustment* adjustment, Application* self) {
	GtkListStore* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
#line 1699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (adjustment != NULL);
#line 1701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->custom_duration_units_combo;
#line 1701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
#line 1701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_LIST_STORE, GtkListStore));
#line 1701 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	model = _tmp3_;
#line 1704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = model;
#line 1704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp4_, &_tmp5_);
#line 1704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp5_;
#line 1704 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp6_) {
#line 9848 "gnome-chess.c"
		{
			gboolean _tmp7_ = FALSE;
#line 1706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = TRUE;
#line 1706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			while (TRUE) {
#line 9855 "gnome-chess.c"
				gboolean _tmp8_ = FALSE;
				gint multiplier = 0;
				GtkListStore* _tmp11_ = NULL;
				GtkTreeIter _tmp12_ = {0};
				gint _tmp13_ = 0;
#line 1706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp8_ = _tmp7_;
#line 1706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				if (!_tmp8_) {
#line 9865 "gnome-chess.c"
					GtkListStore* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
#line 1725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp9_ = model;
#line 1725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					_tmp10_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp9_, &iter);
#line 1725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					if (!_tmp10_) {
#line 1725 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						break;
#line 9876 "gnome-chess.c"
					}
				}
#line 1706 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp7_ = FALSE;
#line 1709 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp11_ = model;
#line 1709 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp12_ = iter;
#line 1709 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				gtk_tree_model_get ((GtkTreeModel*) _tmp11_, &_tmp12_, 1, &multiplier, -1, -1);
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				_tmp13_ = multiplier;
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
				switch (_tmp13_) {
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					case 1:
#line 9893 "gnome-chess.c"
					{
						GtkListStore* _tmp14_ = NULL;
						GtkTreeIter _tmp15_ = {0};
						GtkAdjustment* _tmp16_ = NULL;
						gdouble _tmp17_ = 0.0;
						gdouble _tmp18_ = 0.0;
						const gchar* _tmp19_ = NULL;
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp14_ = model;
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp15_ = iter;
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp16_ = adjustment;
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp17_ = gtk_adjustment_get_value (_tmp16_);
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp18_ = _tmp17_;
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp19_ = ngettext ("second", "seconds", (gulong) _tmp18_);
#line 1713 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp14_, &_tmp15_, 0, _tmp19_, -1, -1);
#line 1715 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						break;
#line 9917 "gnome-chess.c"
					}
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					case 60:
#line 9921 "gnome-chess.c"
					{
						GtkListStore* _tmp20_ = NULL;
						GtkTreeIter _tmp21_ = {0};
						GtkAdjustment* _tmp22_ = NULL;
						gdouble _tmp23_ = 0.0;
						gdouble _tmp24_ = 0.0;
						const gchar* _tmp25_ = NULL;
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp20_ = model;
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp21_ = iter;
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp22_ = adjustment;
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp23_ = gtk_adjustment_get_value (_tmp22_);
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp24_ = _tmp23_;
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp25_ = ngettext ("minute", "minutes", (gulong) _tmp24_);
#line 1717 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp25_, -1, -1);
#line 1719 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						break;
#line 9945 "gnome-chess.c"
					}
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					case 3600:
#line 9949 "gnome-chess.c"
					{
						GtkListStore* _tmp26_ = NULL;
						GtkTreeIter _tmp27_ = {0};
						GtkAdjustment* _tmp28_ = NULL;
						gdouble _tmp29_ = 0.0;
						gdouble _tmp30_ = 0.0;
						const gchar* _tmp31_ = NULL;
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp26_ = model;
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp27_ = iter;
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp28_ = adjustment;
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp29_ = gtk_adjustment_get_value (_tmp28_);
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp30_ = _tmp29_;
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						_tmp31_ = ngettext ("hour", "hours", (gulong) _tmp30_);
#line 1721 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						gtk_list_store_set (_tmp26_, &_tmp27_, 0, _tmp31_, -1, -1);
#line 1723 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
						break;
#line 9973 "gnome-chess.c"
					}
					default:
#line 1710 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
					break;
#line 9978 "gnome-chess.c"
				}
			}
		}
	}
#line 1728 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_duration (self);
#line 1699 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (model);
#line 9987 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_units_changed_cb (GtkWidget* widget, Application* self) {
#line 1732 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1732 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1734 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_duration (self);
#line 9998 "gnome-chess.c"
}


static gboolean _application_save_duration_cb_gsource_func (gpointer self) {
	gboolean result;
	result = application_save_duration_cb (self);
#line 1742 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10007 "gnome-chess.c"
}


static void application_save_duration (Application* self) {
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
#line 1737 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1740 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_duration_timeout;
#line 1740 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != ((guint) 0)) {
#line 10020 "gnome-chess.c"
		guint _tmp1_ = 0U;
#line 1741 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_duration_timeout;
#line 1741 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_source_remove (_tmp1_);
#line 10026 "gnome-chess.c"
	}
#line 1742 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _application_save_duration_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 1742 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = _tmp2_;
#line 10032 "gnome-chess.c"
}


void G_MODULE_EXPORT duration_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gint duration = 0;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkContainer* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
#line 1746 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1746 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = combo;
#line 1749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 1749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	iter = _tmp1_;
#line 1749 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp2_) {
#line 1750 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 10063 "gnome-chess.c"
	}
#line 1752 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = combo;
#line 1752 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 1752 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 1752 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = iter;
#line 1752 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, 1, &duration, -1, -1);
#line 1753 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->custom_duration_box;
#line 1753 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = duration;
#line 1753 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, _tmp8_ < 0);
#line 1755 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = duration;
#line 1755 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp9_ >= 0) {
#line 10085 "gnome-chess.c"
		gint _tmp10_ = 0;
#line 1756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = duration;
#line 1756 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_set_duration (self, _tmp10_, FALSE);
#line 10091 "gnome-chess.c"
	} else {
		gint _tmp11_ = 0;
#line 1758 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = application_get_duration (self);
#line 1758 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp11_ <= 0) {
#line 1759 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_set_duration (self, 60 * 60, FALSE);
#line 10100 "gnome-chess.c"
		}
	}
#line 1761 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_duration (self);
#line 10105 "gnome-chess.c"
}


void G_MODULE_EXPORT preferences_response_cb (GtkWidget* widget, gint response_id, Application* self) {
	GtkDialog* _tmp0_ = NULL;
#line 1765 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1765 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1767 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_dialog;
#line 1767 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 10119 "gnome-chess.c"
}


gboolean G_MODULE_EXPORT preferences_delete_event_cb (GtkWidget* widget, GdkEvent* event, Application* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
#line 1771 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1771 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 1771 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 1773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = widget;
#line 1773 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_MODULE_EXPORT preferences_response_cb (_tmp0_, (gint) GTK_RESPONSE_CANCEL, self);
#line 1774 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = TRUE;
#line 1774 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 10140 "gnome-chess.c"
}


void G_MODULE_EXPORT piece_style_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1778 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "piece-theme", _tmp3_);
#line 1780 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10165 "gnome-chess.c"
}


void G_MODULE_EXPORT show_3d_toggle_cb (GtkToggleButton* widget, Application* self) {
	GtkWidget* w = NULL;
	GtkBuilder* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	GtkBuilder* _tmp7_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkWidget* _tmp9_ = NULL;
	GtkWidget* _tmp10_ = NULL;
	GtkToggleButton* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
#line 1784 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1784 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->preferences_builder;
#line 1786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = gtk_builder_get_object (_tmp0_, "show_3d_smooth_check");
#line 1786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GTK_TYPE_WIDGET, GtkWidget));
#line 1786 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	w = _tmp2_;
#line 1787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = w;
#line 1787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = widget;
#line 1787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
#line 1787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _tmp5_;
#line 1787 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp3_, _tmp6_);
#line 1789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->preferences_builder;
#line 1789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = gtk_builder_get_object (_tmp7_, "piece_style_combo");
#line 1789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GTK_TYPE_WIDGET, GtkWidget));
#line 1789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (w);
#line 1789 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	w = _tmp9_;
#line 1790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = w;
#line 1790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = widget;
#line 1790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = gtk_toggle_button_get_active (_tmp11_);
#line 1790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = _tmp12_;
#line 1790 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_set_sensitive (_tmp10_, !_tmp13_);
#line 1784 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (w);
#line 10229 "gnome-chess.c"
}


void G_MODULE_EXPORT move_format_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1794 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "move-format", _tmp3_);
#line 1796 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10254 "gnome-chess.c"
}


void G_MODULE_EXPORT orientation_combo_changed_cb (GtkComboBox* combo, Application* self) {
	GSettings* _tmp0_ = NULL;
	GtkComboBox* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1800 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1800 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (combo != NULL);
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->settings;
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = combo;
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = application_get_combo (self, _tmp1_, 1);
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _tmp2_;
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_settings_set_string (_tmp0_, "board-side", _tmp3_);
#line 1802 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp3_);
#line 10279 "gnome-chess.c"
}


void application_help_cb (Application* self) {
	GError * _inner_error_ = NULL;
#line 1805 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 10287 "gnome-chess.c"
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 1809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp0_ = self->priv->window;
#line 1809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = gtk_window_get_screen (_tmp0_);
#line 1809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 1809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_show_uri (_tmp1_, "help:gnome-chess", _tmp2_, &_inner_error_);
#line 1809 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 10302 "gnome-chess.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 1813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = e;
#line 1813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = _tmp3_->message;
#line 1813 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_warning ("gnome-chess.vala:1813: Unable to open help: %s", _tmp4_);
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 10324 "gnome-chess.c"
	}
	__finally7:
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 1807 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 10335 "gnome-chess.c"
	}
}


static void _application_about_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 1842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_about_response_cb (self, response_id);
#line 10343 "gnome-chess.c"
}


void application_about_cb (Application* self) {
	GtkAboutDialog* _tmp0_ = NULL;
	GtkAboutDialog* _tmp2_ = NULL;
	GtkAboutDialog* _tmp3_ = NULL;
	GtkWindow* _tmp4_ = NULL;
	GtkAboutDialog* _tmp5_ = NULL;
	GtkAboutDialog* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkAboutDialog* _tmp8_ = NULL;
	GtkAboutDialog* _tmp9_ = NULL;
	GtkAboutDialog* _tmp10_ = NULL;
	GtkAboutDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkAboutDialog* _tmp13_ = NULL;
	GtkAboutDialog* _tmp14_ = NULL;
	GtkAboutDialog* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkAboutDialog* _tmp17_ = NULL;
	GtkAboutDialog* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	GtkAboutDialog* _tmp20_ = NULL;
	GtkAboutDialog* _tmp21_ = NULL;
	GtkAboutDialog* _tmp22_ = NULL;
#line 1820 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1822 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 1822 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 10376 "gnome-chess.c"
		GtkAboutDialog* _tmp1_ = NULL;
#line 1824 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->about_dialog;
#line 1824 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp1_);
#line 1825 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 10384 "gnome-chess.c"
	}
#line 1828 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = (GtkAboutDialog*) gtk_about_dialog_new ();
#line 1828 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp2_);
#line 1828 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 1828 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = _tmp2_;
#line 1829 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->about_dialog;
#line 1829 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = self->priv->window;
#line 1829 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp4_);
#line 1830 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->about_dialog;
#line 1830 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
#line 1831 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->about_dialog;
#line 1831 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("Chess");
#line 1831 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_program_name (_tmp6_, _tmp7_);
#line 1832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = self->priv->about_dialog;
#line 1832 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_version (_tmp8_, VERSION);
#line 1833 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->about_dialog;
#line 1833 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_copyright (_tmp9_, "Copyright © 2010–2013 Robert Ancell\n" \
"Copyright © 2013 Michael Catanzaro");
#line 1834 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->about_dialog;
#line 1834 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_license_type (_tmp10_, GTK_LICENSE_GPL_2_0);
#line 1835 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->about_dialog;
#line 1835 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = _ ("The 2D/3D chess game for GNOME. \n" \
"\n" \
"GNOME Chess is a part of GNOME Games.");
#line 1835 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_comments (_tmp11_, _tmp12_);
#line 1836 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->about_dialog;
#line 1836 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_authors (_tmp13_, APPLICATION_authors);
#line 1837 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = self->priv->about_dialog;
#line 1837 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_artists (_tmp14_, APPLICATION_artists);
#line 1838 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->about_dialog;
#line 1838 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("translator-credits");
#line 1838 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_translator_credits (_tmp15_, _tmp16_);
#line 1839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = self->priv->about_dialog;
#line 1839 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_website (_tmp17_, "http://www.gnome.org/projects/gnome-games/");
#line 1840 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->about_dialog;
#line 1840 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = _ ("GNOME Games web site");
#line 1840 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_website_label (_tmp18_, _tmp19_);
#line 1841 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = self->priv->about_dialog;
#line 1841 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_about_dialog_set_logo_icon_name (_tmp20_, "gnome-chess");
#line 1842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = self->priv->about_dialog;
#line 1842 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp21_, "response", (GCallback) _application_about_response_cb_gtk_dialog_response, self, 0);
#line 1843 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = self->priv->about_dialog;
#line 1843 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _tmp22_);
#line 10464 "gnome-chess.c"
}


static void application_about_response_cb (Application* self, gint response_id) {
	GtkAboutDialog* _tmp0_ = NULL;
#line 1846 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->about_dialog;
#line 1848 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1849 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 1849 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 10480 "gnome-chess.c"
}


void G_MODULE_EXPORT save_game_cb (GtkWidget* widget, Application* self) {
#line 1853 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1853 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1855 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_game (self, "_Cancel", "_Save");
#line 10491 "gnome-chess.c"
}


static void application_add_info_bar_to_dialog (Application* self, GtkDialog* dialog, GtkInfoBar** info_bar, GtkLabel** label) {
	GtkInfoBar* _vala_info_bar = NULL;
	GtkLabel* _vala_label = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkInfoBar* _tmp1_ = NULL;
	GtkContainer* content_area = NULL;
	GtkContainer* _tmp2_ = NULL;
	GtkContainer* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkContainer* child = NULL;
	GtkDialog* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GtkContainer* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	GtkDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (dialog != NULL);
#line 1860 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 1860 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp0_);
#line 1860 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	vbox = _tmp0_;
#line 1861 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) vbox);
#line 1863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 1863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp1_);
#line 1863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_info_bar);
#line 1863 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_vala_info_bar = _tmp1_;
#line 1864 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = gtk_info_bar_get_content_area (_vala_info_bar);
#line 1864 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1864 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	content_area = _tmp3_;
#line 1865 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_box_pack_start (vbox, (GtkWidget*) _vala_info_bar, FALSE, TRUE, (guint) 0);
#line 1867 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
#line 1867 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp4_);
#line 1867 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (_vala_label);
#line 1867 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_vala_label = _tmp4_;
#line 1868 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_container_add (content_area, (GtkWidget*) _vala_label);
#line 1869 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_show ((GtkWidget*) _vala_label);
#line 1871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = dialog;
#line 1871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = gtk_bin_get_child ((GtkBin*) _tmp5_);
#line 1871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GTK_TYPE_CONTAINER, GtkContainer));
#line 1871 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	child = _tmp7_;
#line 1872 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_reparent ((GtkWidget*) child, (GtkWidget*) vbox);
#line 1873 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = dialog;
#line 1873 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = gtk_container_get_border_width ((GtkContainer*) _tmp8_);
#line 1873 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = _tmp9_;
#line 1873 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width (child, _tmp10_);
#line 1874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = dialog;
#line 1874 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp11_, (guint) 0);
#line 1876 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_box_set_child_packing (vbox, (GtkWidget*) child, TRUE, TRUE, (guint) 0, GTK_PACK_START);
#line 1877 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = dialog;
#line 1877 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) vbox);
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (child);
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (content_area);
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (vbox);
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (info_bar) {
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		*info_bar = _vala_info_bar;
#line 10592 "gnome-chess.c"
	} else {
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_info_bar);
#line 10596 "gnome-chess.c"
	}
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (label) {
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		*label = _vala_label;
#line 10602 "gnome-chess.c"
	} else {
#line 1858 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (_vala_label);
#line 10606 "gnome-chess.c"
	}
}


static void _application_save_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 1896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_file_cb (self);
#line 10614 "gnome-chess.c"
}


static void _application_save_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 1897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_cb (self, response_id);
#line 10621 "gnome-chess.c"
}


static void application_save_game (Application* self, const gchar* cancel_button_label, const gchar* save_button_label) {
	GtkFileChooserDialog* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GtkFileChooserDialog* _tmp6_ = NULL;
	GtkFileChooserDialog* _tmp7_ = NULL;
	GtkInfoBar* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkFileChooserDialog* _tmp10_ = NULL;
	GtkFileChooserDialog* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	GtkFileChooserDialog* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileFilter* _tmp25_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	GtkFileFilter* _tmp29_ = NULL;
	GtkFileChooserDialog* _tmp30_ = NULL;
	GtkFileFilter* _tmp31_ = NULL;
	GtkFileFilter* _tmp32_ = NULL;
	GtkFileChooserDialog* _tmp33_ = NULL;
#line 1880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (cancel_button_label != NULL);
#line 1880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (save_button_label != NULL);
#line 1883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->save_dialog;
#line 1883 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ != NULL) {
#line 10665 "gnome-chess.c"
		GtkFileChooserDialog* _tmp1_ = NULL;
#line 1885 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp1_ = self->priv->save_dialog;
#line 1885 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_dialog_run ((GtkDialog*) _tmp1_);
#line 1886 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 10673 "gnome-chess.c"
	}
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _ ("Save Chess Game");
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = self->priv->window;
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = cancel_button_label;
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = save_button_label;
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp2_, _tmp3_, GTK_FILE_CHOOSER_ACTION_SAVE, _tmp4_, GTK_RESPONSE_CANCEL, _tmp5_, GTK_RESPONSE_OK, NULL, NULL);
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp6_);
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 1889 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = _tmp6_;
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = self->priv->save_dialog;
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp7_, &_tmp8_, &_tmp9_);
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = _tmp8_;
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 1894 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = _tmp9_;
#line 1896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->save_dialog;
#line 1896 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp10_, "file-activated", (GCallback) _application_save_file_cb_gtk_file_chooser_file_activated, self, 0);
#line 1897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = self->priv->save_dialog;
#line 1897 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp11_, "response", (GCallback) _application_save_cb_gtk_dialog_response, self, 0);
#line 1899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->saved_filename;
#line 1899 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ != NULL) {
#line 10715 "gnome-chess.c"
		GtkFileChooserDialog* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 1900 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->save_dialog;
#line 1900 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = self->priv->saved_filename;
#line 1900 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_filename ((GtkFileChooser*) _tmp13_, _tmp14_);
#line 10724 "gnome-chess.c"
	} else {
		GtkFileChooserDialog* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = self->priv->save_dialog;
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _ ("Untitled Chess Game");
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = g_strconcat (_tmp16_, ".pgn", NULL);
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_;
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp15_, _tmp18_);
#line 1902 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp18_);
#line 10742 "gnome-chess.c"
	}
#line 1906 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = gtk_file_filter_new ();
#line 1906 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp19_);
#line 1906 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp19_;
#line 1907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = pgn_filter;
#line 1907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = _ ("PGN files");
#line 1907 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp20_, _tmp21_);
#line 1910 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = pgn_filter;
#line 1910 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp22_, "*.pgn");
#line 1911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = self->priv->save_dialog;
#line 1911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = pgn_filter;
#line 1911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 1911 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp23_, _tmp25_);
#line 1913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = gtk_file_filter_new ();
#line 1913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp26_);
#line 1913 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp26_;
#line 1914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = all_filter;
#line 1914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = _ ("All files");
#line 1914 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp27_, _tmp28_);
#line 1917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp29_ = all_filter;
#line 1917 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp29_, "*");
#line 1918 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp30_ = self->priv->save_dialog;
#line 1918 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp31_ = all_filter;
#line 1918 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 1918 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp30_, _tmp32_);
#line 1920 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp33_ = self->priv->save_dialog;
#line 1920 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_dialog_run ((GtkDialog*) _tmp33_);
#line 1880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 1880 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 10800 "gnome-chess.c"
}


static void application_save_file_cb (Application* self) {
#line 1923 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1925 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_save_cb (self, (gint) GTK_RESPONSE_OK);
#line 10809 "gnome-chess.c"
}


static void application_update_pgn_time_remaining (Application* self) {
	ChessGame* _tmp0_ = NULL;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
#line 1928 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = self->priv->game;
#line 1930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = chess_game_get_clock (_tmp0_);
#line 1930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = _tmp1_;
#line 1930 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 10827 "gnome-chess.c"
		guint initial_time = 0U;
		PGNGame* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		guint white_used = 0U;
		ChessGame* _tmp7_ = NULL;
		ChessClock* _tmp8_ = NULL;
		ChessClock* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		guint _tmp11_ = 0U;
		guint black_used = 0U;
		ChessGame* _tmp12_ = NULL;
		ChessClock* _tmp13_ = NULL;
		ChessClock* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		PGNGame* _tmp17_ = NULL;
		guint _tmp18_ = 0U;
		guint _tmp19_ = 0U;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		PGNGame* _tmp22_ = NULL;
		guint _tmp23_ = 0U;
		guint _tmp24_ = 0U;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
#line 1933 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->pgn_game;
#line 1933 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp4_ = pgn_game_get_time_control (_tmp3_);
#line 1933 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = _tmp4_;
#line 1933 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = atoi (_tmp5_);
#line 1933 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		initial_time = (guint) _tmp6_;
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = self->priv->game;
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = chess_game_get_clock (_tmp7_);
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = _tmp8_;
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = chess_clock_get_white_seconds_used (_tmp9_);
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = _tmp10_;
#line 1934 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		white_used = _tmp11_;
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = self->priv->game;
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = chess_game_get_clock (_tmp12_);
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = _tmp13_;
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = chess_clock_get_black_seconds_used (_tmp14_);
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 1935 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		black_used = _tmp16_;
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = initial_time;
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = white_used;
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = g_strdup_printf ("%u", _tmp18_ - _tmp19_);
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = _tmp20_;
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp21_);
#line 1937 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp21_);
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = self->priv->pgn_game;
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = initial_time;
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = black_used;
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp25_ = g_strdup_printf ("%u", _tmp23_ - _tmp24_);
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp26_ = _tmp25_;
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp22_, _tmp26_);
#line 1938 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp26_);
#line 10917 "gnome-chess.c"
	}
}


static void application_save_cb (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
#line 1942 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1944 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 1944 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 1946 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		application_update_pgn_time_remaining (self);
#line 10934 "gnome-chess.c"
		{
			PGNGame* _tmp1_ = NULL;
			GtkFileChooserDialog* _tmp2_ = NULL;
			GFile* _tmp3_ = NULL;
			GtkFileChooserDialog* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			GtkWidget* _tmp6_ = NULL;
#line 1950 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->pgn_game;
#line 1950 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = self->priv->save_dialog;
#line 1950 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp2_);
#line 1950 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_write (_tmp1_, _tmp3_, &_inner_error_);
#line 1950 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_inner_error_ != NULL) {
#line 10952 "gnome-chess.c"
				goto __catch8_g_error;
			}
#line 1951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = self->priv->save_dialog;
#line 1951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp4_);
#line 1951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (self->priv->saved_filename);
#line 1951 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->saved_filename = _tmp5_;
#line 1952 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = self->priv->save_button;
#line 1952 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_widget_set_sensitive (_tmp6_, FALSE);
#line 1953 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->game_needs_saving = FALSE;
#line 10969 "gnome-chess.c"
		}
		goto __finally8;
		__catch8_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			GtkInfoBar* _tmp13_ = NULL;
			GtkInfoBar* _tmp14_ = NULL;
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = self->priv->save_dialog_error_label;
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _ ("Failed to save game: %s");
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = e;
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = _tmp9_->message;
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = g_strdup_printf (_tmp8_, _tmp10_);
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = _tmp11_;
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp7_, _tmp12_);
#line 1957 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp12_);
#line 1958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp13_ = self->priv->save_dialog_info_bar;
#line 1958 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp13_, GTK_MESSAGE_ERROR);
#line 1959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp14_ = self->priv->save_dialog_info_bar;
#line 1959 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp14_);
#line 1960 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 1960 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return;
#line 11015 "gnome-chess.c"
		}
		__finally8:
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 1948 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return;
#line 11026 "gnome-chess.c"
		}
	}
#line 1964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = self->priv->save_dialog;
#line 1964 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
#line 1965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 1965 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 1966 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 1966 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 1967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 1967 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 11045 "gnome-chess.c"
}


static void _application_open_file_cb_gtk_file_chooser_file_activated (GtkFileChooser* _sender, gpointer self) {
#line 1990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_open_file_cb (self);
#line 11052 "gnome-chess.c"
}


static void _application_open_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 1991 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_open_cb (self, response_id);
#line 11059 "gnome-chess.c"
}


void G_MODULE_EXPORT open_game_cb (GtkWidget* widget, Application* self) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GtkFileChooserDialog* _tmp2_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkFileChooserDialog* _tmp8_ = NULL;
	GtkFileChooserDialog* _tmp9_ = NULL;
	GtkInfoBar* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkFileChooserDialog* _tmp12_ = NULL;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GtkFileFilter* pgn_filter = NULL;
	GtkFileFilter* _tmp14_ = NULL;
	GtkFileFilter* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkFileFilter* _tmp17_ = NULL;
	GtkFileChooserDialog* _tmp18_ = NULL;
	GtkFileFilter* _tmp19_ = NULL;
	GtkFileFilter* _tmp20_ = NULL;
	GtkFileFilter* all_filter = NULL;
	GtkFileFilter* _tmp21_ = NULL;
	GtkFileFilter* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GtkFileFilter* _tmp24_ = NULL;
	GtkFileChooserDialog* _tmp25_ = NULL;
	GtkFileFilter* _tmp26_ = NULL;
	GtkFileFilter* _tmp27_ = NULL;
	GtkFileChooserDialog* _tmp28_ = NULL;
#line 1971 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 1971 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (widget != NULL);
#line 1973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("Save this game before loading another one?");
#line 1973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = application_prompt_save_game (self, _tmp0_);
#line 1973 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!_tmp1_) {
#line 1974 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 11106 "gnome-chess.c"
	}
#line 1977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->open_dialog;
#line 1977 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp2_ != NULL) {
#line 11112 "gnome-chess.c"
		GtkFileChooserDialog* _tmp3_ = NULL;
#line 1979 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp3_ = self->priv->open_dialog;
#line 1979 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gtk_window_present ((GtkWindow*) _tmp3_);
#line 1980 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 11120 "gnome-chess.c"
	}
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _ ("Load Chess Game");
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = self->priv->window;
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _ ("_Cancel");
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = _ ("_Open");
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp4_, _tmp5_, GTK_FILE_CHOOSER_ACTION_OPEN, _tmp6_, GTK_RESPONSE_CANCEL, _tmp7_, GTK_RESPONSE_OK, NULL, NULL);
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp8_);
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 1983 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = _tmp8_;
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = self->priv->open_dialog;
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_add_info_bar_to_dialog (self, (GtkDialog*) _tmp9_, &_tmp10_, &_tmp11_);
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = _tmp10_;
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 1988 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = _tmp11_;
#line 1990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = self->priv->open_dialog;
#line 1990 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkFileChooser*) _tmp12_, "file-activated", (GCallback) _application_open_file_cb_gtk_file_chooser_file_activated, self, 0);
#line 1991 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->open_dialog;
#line 1991 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_signal_connect_object ((GtkDialog*) _tmp13_, "response", (GCallback) _application_open_cb_gtk_dialog_response, self, 0);
#line 1994 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = gtk_file_filter_new ();
#line 1994 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp14_);
#line 1994 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	pgn_filter = _tmp14_;
#line 1995 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp15_ = pgn_filter;
#line 1995 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = _ ("PGN files");
#line 1995 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp15_, _tmp16_);
#line 1998 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp17_ = pgn_filter;
#line 1998 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp17_, "*.pgn");
#line 1999 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp18_ = self->priv->open_dialog;
#line 1999 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp19_ = pgn_filter;
#line 1999 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 1999 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp18_, _tmp20_);
#line 2001 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = gtk_file_filter_new ();
#line 2001 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_object_ref_sink (_tmp21_);
#line 2001 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	all_filter = _tmp21_;
#line 2002 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = all_filter;
#line 2002 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = _ ("All files");
#line 2002 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_set_name (_tmp22_, _tmp23_);
#line 2005 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp24_ = all_filter;
#line 2005 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_filter_add_pattern (_tmp24_, "*");
#line 2006 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->open_dialog;
#line 2006 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = all_filter;
#line 2006 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = _g_object_ref0 (_tmp26_);
#line 2006 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_file_chooser_add_filter ((GtkFileChooser*) _tmp25_, _tmp27_);
#line 2008 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp28_ = self->priv->open_dialog;
#line 2008 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_window_present ((GtkWindow*) _tmp28_);
#line 1971 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (all_filter);
#line 1971 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (pgn_filter);
#line 11214 "gnome-chess.c"
}


static void application_open_file_cb (Application* self) {
#line 2011 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2013 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_open_cb (self, (gint) GTK_RESPONSE_OK);
#line 11223 "gnome-chess.c"
}


static void application_open_cb (Application* self, gint response_id) {
	gint _tmp0_ = 0;
	GtkFileChooserDialog* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
#line 2016 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = response_id;
#line 2018 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 11237 "gnome-chess.c"
		{
			GtkFileChooserDialog* _tmp1_ = NULL;
			GFile* _tmp2_ = NULL;
			GtkFileChooserDialog* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
#line 2022 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->in_history = FALSE;
#line 2023 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp1_ = self->priv->open_dialog;
#line 2023 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp2_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp1_);
#line 2023 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			application_load_game (self, _tmp2_, &_inner_error_);
#line 2023 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			if (_inner_error_ != NULL) {
#line 11253 "gnome-chess.c"
				goto __catch9_g_error;
			}
#line 2024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp3_ = self->priv->open_dialog;
#line 2024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp4_ = gtk_file_chooser_get_filename ((GtkFileChooser*) _tmp3_);
#line 2024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (self->priv->saved_filename);
#line 2024 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			self->priv->saved_filename = _tmp4_;
#line 11264 "gnome-chess.c"
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* e = NULL;
			GtkLabel* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GError* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			GtkInfoBar* _tmp11_ = NULL;
			GtkInfoBar* _tmp12_ = NULL;
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			e = _inner_error_;
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_inner_error_ = NULL;
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp5_ = self->priv->open_dialog_error_label;
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp6_ = _ ("Failed to open game: %s");
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp7_ = e;
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp8_ = _tmp7_->message;
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp9_ = g_strdup_printf (_tmp6_, _tmp8_);
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp10_ = _tmp9_;
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_label_set_text (_tmp5_, _tmp10_);
#line 2028 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (_tmp10_);
#line 2029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp11_ = self->priv->open_dialog_info_bar;
#line 2029 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_info_bar_set_message_type (_tmp11_, GTK_MESSAGE_ERROR);
#line 2030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp12_ = self->priv->open_dialog_info_bar;
#line 2030 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			gtk_widget_show ((GtkWidget*) _tmp12_);
#line 2031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_error_free0 (e);
#line 2031 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return;
#line 11310 "gnome-chess.c"
		}
		__finally9:
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			g_clear_error (&_inner_error_);
#line 2020 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return;
#line 11321 "gnome-chess.c"
		}
	}
#line 2035 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp13_ = self->priv->open_dialog;
#line 2035 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 2036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 2036 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 2037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 2037 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 2038 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 2038 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 11340 "gnome-chess.c"
}


static void application_start_new_game (Application* self) {
	PGNGame* _tmp0_ = NULL;
	GDateTime* now = NULL;
	GDateTime* _tmp1_ = NULL;
	PGNGame* _tmp2_ = NULL;
	GDateTime* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	PGNGame* _tmp6_ = NULL;
	GDateTime* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gint duration = 0;
	GSettings* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gchar* engine_name = NULL;
	GSettings* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	gchar* engine_level = NULL;
	GSettings* _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_ = NULL;
	gboolean _tmp40_ = FALSE;
#line 2041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2043 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->in_history = FALSE;
#line 2044 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2044 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = NULL;
#line 2046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = pgn_game_new ();
#line 2046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_pgn_game_unref0 (self->priv->pgn_game);
#line 2046 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp0_;
#line 2047 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_date_time_new_now_local ();
#line 2047 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	now = _tmp1_;
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = self->priv->pgn_game;
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = now;
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = g_date_time_format (_tmp3_, "%Y.%m.%d");
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = _tmp4_;
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_date (_tmp2_, _tmp5_);
#line 2048 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp5_);
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = self->priv->pgn_game;
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp7_ = now;
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp8_ = g_date_time_format (_tmp7_, "%H:%M:%S");
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp9_ = _tmp8_;
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	pgn_game_set_time (_tmp6_, _tmp9_);
#line 2049 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (_tmp9_);
#line 2050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp10_ = self->priv->settings;
#line 2050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp11_ = g_settings_get_int (_tmp10_, "duration");
#line 2050 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	duration = _tmp11_;
#line 2051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp12_ = duration;
#line 2051 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp12_ > 0) {
#line 11422 "gnome-chess.c"
		PGNGame* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		PGNGame* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		PGNGame* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = self->priv->pgn_game;
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp14_ = duration;
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = g_strdup_printf ("%i", _tmp14_ / 2);
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp16_ = _tmp15_;
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_time_control (_tmp13_, _tmp16_);
#line 2053 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp16_);
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = self->priv->pgn_game;
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = duration;
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_strdup_printf ("%i", _tmp18_ / 2);
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp20_ = _tmp19_;
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_white_time_left (_tmp17_, _tmp20_);
#line 2054 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp20_);
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp21_ = self->priv->pgn_game;
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp22_ = duration;
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp23_ = g_strdup_printf ("%i", _tmp22_ / 2);
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp24_ = _tmp23_;
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		pgn_game_set_black_time_left (_tmp21_, _tmp24_);
#line 2055 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_free0 (_tmp24_);
#line 11471 "gnome-chess.c"
	}
#line 2057 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp25_ = self->priv->settings;
#line 2057 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp26_ = g_settings_get_string (_tmp25_, "opponent");
#line 2057 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	engine_name = _tmp26_;
#line 2058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp27_ = engine_name;
#line 2058 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_strcmp0 (_tmp27_, "") == 0) {
#line 11483 "gnome-chess.c"
		GList* _tmp28_ = NULL;
#line 2060 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp28_ = self->priv->ai_profiles;
#line 2060 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp28_ != NULL) {
#line 11489 "gnome-chess.c"
			GList* _tmp29_ = NULL;
			gconstpointer _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp29_ = self->priv->ai_profiles;
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp30_ = _tmp29_->data;
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp31_ = ai_profile_get_name ((AIProfile*) _tmp30_);
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp32_ = _tmp31_;
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp33_ = g_strdup (_tmp32_);
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2061 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp33_;
#line 11509 "gnome-chess.c"
		} else {
			gchar* _tmp34_ = NULL;
#line 2063 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp34_ = g_strdup ("human");
#line 2063 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_g_free0 (engine_name);
#line 2063 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			engine_name = _tmp34_;
#line 11518 "gnome-chess.c"
		}
	}
#line 2065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp35_ = self->priv->settings;
#line 2065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp36_ = g_settings_get_string (_tmp35_, "difficulty");
#line 2065 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	engine_level = _tmp36_;
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp38_ = engine_name;
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp38_ != NULL) {
#line 11531 "gnome-chess.c"
		const gchar* _tmp39_ = NULL;
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp39_ = engine_name;
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = g_strcmp0 (_tmp39_, "human") != 0;
#line 11537 "gnome-chess.c"
	} else {
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp37_ = FALSE;
#line 11541 "gnome-chess.c"
	}
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp40_ = _tmp37_;
#line 2066 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp40_) {
#line 11547 "gnome-chess.c"
		GSettings* _tmp41_ = NULL;
		gboolean _tmp42_ = FALSE;
#line 2068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp41_ = self->priv->settings;
#line 2068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp42_ = g_settings_get_boolean (_tmp41_, "play-as-white");
#line 2068 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_tmp42_) {
#line 11556 "gnome-chess.c"
			PGNGame* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			PGNGame* _tmp45_ = NULL;
			const gchar* _tmp46_ = NULL;
#line 2070 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp43_ = self->priv->pgn_game;
#line 2070 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp44_ = engine_name;
#line 2070 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_ai (_tmp43_, _tmp44_);
#line 2071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp45_ = self->priv->pgn_game;
#line 2071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp46_ = engine_level;
#line 2071 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_black_level (_tmp45_, _tmp46_);
#line 11573 "gnome-chess.c"
		} else {
			PGNGame* _tmp47_ = NULL;
			const gchar* _tmp48_ = NULL;
			PGNGame* _tmp49_ = NULL;
			const gchar* _tmp50_ = NULL;
#line 2075 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp47_ = self->priv->pgn_game;
#line 2075 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp48_ = engine_name;
#line 2075 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_white_ai (_tmp47_, _tmp48_);
#line 2076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp49_ = self->priv->pgn_game;
#line 2076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			_tmp50_ = engine_level;
#line 2076 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			pgn_game_set_white_level (_tmp49_, _tmp50_);
#line 11591 "gnome-chess.c"
		}
	}
#line 2080 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_start_game (self);
#line 2041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_level);
#line 2041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (engine_name);
#line 2041 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_date_time_unref0 (now);
#line 11602 "gnome-chess.c"
}


static gpointer _pgn_game_ref0 (gpointer self) {
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self ? pgn_game_ref (self) : NULL;
#line 11609 "gnome-chess.c"
}


static void application_load_game (Application* self, GFile* file, GError** error) {
	PGN* pgn = NULL;
	GFile* _tmp0_ = NULL;
	PGN* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	PGNGame* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GFile* _tmp6_ = NULL;
	GError * _inner_error_ = NULL;
#line 2083 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (self != NULL);
#line 2083 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (file != NULL);
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = file;
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = pgn_new_from_file (_tmp0_, &_inner_error_);
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	pgn = _tmp1_;
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_propagate_error (error, _inner_error_);
#line 2085 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return;
#line 11639 "gnome-chess.c"
	}
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = pgn->games;
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = _pgn_game_ref0 ((PGNGame*) _tmp3_);
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_pgn_game_unref0 (self->priv->pgn_game);
#line 2086 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->pgn_game = _tmp4_;
#line 2088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp5_ = file;
#line 2088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 2088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 2088 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->game_file = _tmp6_;
#line 2089 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_start_game (self);
#line 2083 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_pgn_unref0 (pgn);
#line 11663 "gnome-chess.c"
}


static void application_class_init (ApplicationClass * klass) {
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	application_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_type_class_add_private (klass, sizeof (ApplicationPrivate));
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (klass)->startup = application_real_startup;
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (klass)->shutdown = application_real_shutdown;
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_APPLICATION_CLASS (klass)->activate = application_real_activate;
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (klass)->finalize = application_finalize;
#line 11680 "gnome-chess.c"
}


static void application_instance_init (Application * self) {
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv = APPLICATION_GET_PRIVATE (self);
#line 40 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->preferences_dialog = NULL;
#line 47 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_duration_timeout = (guint) 0;
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog = NULL;
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_info_bar = NULL;
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->open_dialog_error_label = NULL;
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog = NULL;
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_info_bar = NULL;
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->save_dialog_error_label = NULL;
#line 54 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->about_dialog = NULL;
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->saved_filename = NULL;
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent = NULL;
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->human_player = NULL;
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->opponent_engine = NULL;
#line 67 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->priv->is_fullscreen = FALSE;
#line 11715 "gnome-chess.c"
}


static void application_finalize (GObject* obj) {
	Application * self;
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_APPLICATION, Application);
#line 16 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->settings);
#line 17 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->builder);
#line 18 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_builder);
#line 19 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->window);
#line 20 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_bar);
#line 21 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_title_label);
#line 22 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->info_label);
#line 23 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view_container);
#line 24 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->scene);
#line 25 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->view);
#line 26 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_button);
#line 27 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->undo_button);
#line 28 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->pause_button);
#line 29 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->claim_draw_button);
#line 30 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->resign_button);
#line 31 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->fullscreen_button);
#line 32 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->first_move_button);
#line 33 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->prev_move_button);
#line 34 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->next_move_button);
#line 35 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->last_move_button);
#line 36 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->history_combo);
#line 37 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->white_time_label);
#line 38 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->black_time_label);
#line 40 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->preferences_dialog);
#line 41 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->side_combo);
#line 42 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->difficulty_combo);
#line 43 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_combo);
#line 44 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->duration_adjustment);
#line 45 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_box);
#line 46 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->custom_duration_units_combo);
#line 48 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog);
#line 49 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_info_bar);
#line 50 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->open_dialog_error_label);
#line 51 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog);
#line 52 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_info_bar);
#line 53 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->save_dialog_error_label);
#line 54 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->about_dialog);
#line 56 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_pgn_game_unref0 (self->priv->pgn_game);
#line 57 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_chess_game_unref0 (self->priv->game);
#line 59 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->autosave_filename);
#line 60 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->game_file);
#line 62 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_free0 (self->priv->saved_filename);
#line 63 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	__g_list_free__ai_profile_unref0_0 (self->priv->ai_profiles);
#line 64 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent);
#line 65 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->human_player);
#line 66 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (self->priv->opponent_engine);
#line 14 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_OBJECT_CLASS (application_parent_class)->finalize (obj);
#line 11817 "gnome-chess.c"
}


GType application_get_type (void) {
	static volatile gsize application_type_id__volatile = 0;
	if (g_once_init_enter (&application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Application), 0, (GInstanceInitFunc) application_instance_init, NULL };
		GType application_type_id;
		application_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Application", &g_define_type_info, 0);
		g_once_init_leave (&application_type_id__volatile, application_type_id);
	}
	return application_type_id__volatile;
}


gint gnome_chess_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	GFile* game_file = NULL;
	gchar** _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	Application* app = NULL;
	GFile* _tmp20_ = NULL;
	Application* _tmp21_ = NULL;
	Application* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GError * _inner_error_ = NULL;
#line 2106 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	setlocale (LC_ALL, "");
#line 2107 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 2108 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 2109 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	textdomain (GETTEXT_PACKAGE);
#line 2112 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_set_prgname ("glchess");
#line 2114 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gtk_init (&args_length1, &args);
#line 2116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp0_ = _ ("[FILE] - Play Chess");
#line 2116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 2116 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	c = _tmp1_;
#line 2118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp2_ = c;
#line 2118 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_option_context_add_main_entries (_tmp2_, GNOME_CHESS_options, GETTEXT_PACKAGE);
#line 2119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp3_ = c;
#line 2119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 2119 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 11879 "gnome-chess.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 2122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp5_ = c;
#line 2122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 2122 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (_inner_error_ != NULL) {
#line 11888 "gnome-chess.c"
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		e = _inner_error_;
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_inner_error_ = NULL;
#line 2126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp6_ = stderr;
#line 2126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp7_ = e;
#line 2126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp8_ = _tmp7_->message;
#line 2126 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp9_ = stderr;
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11_ = args;
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp11__length1 = args_length1;
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp12_ = _tmp11_[0];
#line 2127 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp9_, _tmp10_, _tmp12_);
#line 2129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp13_ = stderr;
#line 2129 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp13_, "\n");
#line 2130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = EXIT_FAILURE;
#line 2130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_error_free0 (e);
#line 2130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_option_context_free0 (c);
#line 2130 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 11941 "gnome-chess.c"
	}
	__finally10:
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_inner_error_ != NULL) {
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_option_context_free0 (c);
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_clear_error (&_inner_error_);
#line 2120 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return 0;
#line 11954 "gnome-chess.c"
	}
#line 2132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp14_ = gnome_chess_show_version;
#line 2132 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp14_) {
#line 11960 "gnome-chess.c"
		FILE* _tmp15_ = NULL;
#line 2135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp15_ = stderr;
#line 2135 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		fprintf (_tmp15_, "gnome-chess %s\n", VERSION);
#line 2136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		result = EXIT_SUCCESS;
#line 2136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_option_context_free0 (c);
#line 2136 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return result;
#line 11972 "gnome-chess.c"
	}
#line 2139 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	game_file = NULL;
#line 2140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16_ = args;
#line 2140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp16__length1 = args_length1;
#line 2140 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (_tmp16__length1 > 1) {
#line 11982 "gnome-chess.c"
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		GFile* _tmp19_ = NULL;
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17_ = args;
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp17__length1 = args_length1;
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp18_ = _tmp17_[1];
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_tmp19_ = g_file_new_for_path (_tmp18_);
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		_g_object_unref0 (game_file);
#line 2141 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		game_file = _tmp19_;
#line 11999 "gnome-chess.c"
	}
#line 2143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp20_ = game_file;
#line 2143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp21_ = application_new (_tmp20_);
#line 2143 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	app = _tmp21_;
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp22_ = app;
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_tmp23_ = g_application_run ((GApplication*) _tmp22_, 0, NULL);
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	result = _tmp23_;
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (app);
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_object_unref0 (game_file);
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	_g_option_context_free0 (c);
#line 2144 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return result;
#line 12021 "gnome-chess.c"
}


int main (int argc, char ** argv) {
#line 2104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_type_init ();
#line 2104 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return gnome_chess_main (argv, argc);
#line 12030 "gnome-chess.c"
}


GnomeChess* gnome_chess_construct (GType object_type) {
	GnomeChess* self = NULL;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = (GnomeChess*) g_type_create_instance (object_type);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return self;
#line 12040 "gnome-chess.c"
}


GnomeChess* gnome_chess_new (void) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return gnome_chess_construct (TYPE_GNOME_CHESS);
#line 12047 "gnome-chess.c"
}


static void value_gnome_chess_init (GValue* value) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	value->data[0].v_pointer = NULL;
#line 12054 "gnome-chess.c"
}


static void value_gnome_chess_free_value (GValue* value) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (value->data[0].v_pointer) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gnome_chess_unref (value->data[0].v_pointer);
#line 12063 "gnome-chess.c"
	}
}


static void value_gnome_chess_copy_value (const GValue* src_value, GValue* dest_value) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (src_value->data[0].v_pointer) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		dest_value->data[0].v_pointer = gnome_chess_ref (src_value->data[0].v_pointer);
#line 12073 "gnome-chess.c"
	} else {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		dest_value->data[0].v_pointer = NULL;
#line 12077 "gnome-chess.c"
	}
}


static gpointer value_gnome_chess_peek_pointer (const GValue* value) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return value->data[0].v_pointer;
#line 12085 "gnome-chess.c"
}


static gchar* value_gnome_chess_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (collect_values[0].v_pointer) {
#line 12092 "gnome-chess.c"
		GnomeChess* object;
		object = collect_values[0].v_pointer;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		if (object->parent_instance.g_class == NULL) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12099 "gnome-chess.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 12103 "gnome-chess.c"
		}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = gnome_chess_ref (object);
#line 12107 "gnome-chess.c"
	} else {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = NULL;
#line 12111 "gnome-chess.c"
	}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return NULL;
#line 12115 "gnome-chess.c"
}


static gchar* value_gnome_chess_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GnomeChess** object_p;
	object_p = collect_values[0].v_pointer;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!object_p) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 12126 "gnome-chess.c"
	}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (!value->data[0].v_pointer) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		*object_p = NULL;
#line 12132 "gnome-chess.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		*object_p = value->data[0].v_pointer;
#line 12136 "gnome-chess.c"
	} else {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		*object_p = gnome_chess_ref (value->data[0].v_pointer);
#line 12140 "gnome-chess.c"
	}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return NULL;
#line 12144 "gnome-chess.c"
}


GParamSpec* param_spec_gnome_chess (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecGnomeChess* spec;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_GNOME_CHESS), NULL);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return G_PARAM_SPEC (spec);
#line 12158 "gnome-chess.c"
}


gpointer value_get_gnome_chess (const GValue* value) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS), NULL);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return value->data[0].v_pointer;
#line 12167 "gnome-chess.c"
}


void value_set_gnome_chess (GValue* value, gpointer v_object) {
	GnomeChess* old;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	old = value->data[0].v_pointer;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (v_object) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = v_object;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gnome_chess_ref (value->data[0].v_pointer);
#line 12187 "gnome-chess.c"
	} else {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = NULL;
#line 12191 "gnome-chess.c"
	}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (old) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gnome_chess_unref (old);
#line 12197 "gnome-chess.c"
	}
}


void value_take_gnome_chess (GValue* value, gpointer v_object) {
	GnomeChess* old;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_GNOME_CHESS));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	old = value->data[0].v_pointer;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (v_object) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_GNOME_CHESS));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = v_object;
#line 12216 "gnome-chess.c"
	} else {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		value->data[0].v_pointer = NULL;
#line 12220 "gnome-chess.c"
	}
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (old) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		gnome_chess_unref (old);
#line 12226 "gnome-chess.c"
	}
}


static void gnome_chess_class_init (GnomeChessClass * klass) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	gnome_chess_parent_class = g_type_class_peek_parent (klass);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	GNOME_CHESS_CLASS (klass)->finalize = gnome_chess_finalize;
#line 12236 "gnome-chess.c"
}


static void gnome_chess_instance_init (GnomeChess * self) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self->ref_count = 1;
#line 12243 "gnome-chess.c"
}


static void gnome_chess_finalize (GnomeChess* obj) {
	GnomeChess * self;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GNOME_CHESS, GnomeChess);
#line 12251 "gnome-chess.c"
}


GType gnome_chess_get_type (void) {
	static volatile gsize gnome_chess_type_id__volatile = 0;
	if (g_once_init_enter (&gnome_chess_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_gnome_chess_init, value_gnome_chess_free_value, value_gnome_chess_copy_value, value_gnome_chess_peek_pointer, "p", value_gnome_chess_collect_value, "p", value_gnome_chess_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GnomeChessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_chess_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeChess), 0, (GInstanceInitFunc) gnome_chess_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gnome_chess_type_id;
		gnome_chess_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GnomeChess", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gnome_chess_type_id__volatile, gnome_chess_type_id);
	}
	return gnome_chess_type_id__volatile;
}


gpointer gnome_chess_ref (gpointer instance) {
	GnomeChess* self;
	self = instance;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	g_atomic_int_inc (&self->ref_count);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	return instance;
#line 12276 "gnome-chess.c"
}


void gnome_chess_unref (gpointer instance) {
	GnomeChess* self;
	self = instance;
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		GNOME_CHESS_GET_CLASS (self)->finalize (self);
#line 2093 "/home/mcatanzaro/jhbuild/src/gnome-chess/src/gnome-chess.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 12289 "gnome-chess.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



