/* generic-destination.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include "generic-destination.h"

#define CLASS(gd) (GENERIC_DESTINATION_CLASS (G_OBJECT_GET_CLASS (gd)))

static void gd_class_init (GenericDestinationClass *klass);
static void gd_init (GenericDestination *gd, GenericDestinationClass *klass);
static void gd_finalize (GObject *object);

static GObjectClass *parent_class = NULL;

static void
gd_class_init (GenericDestinationClass *klass)
{
	GObjectClass *object_class;

	parent_class = g_type_class_peek_parent (klass);

	object_class = G_OBJECT_CLASS (klass);
	object_class->finalize = gd_finalize;
	klass->get_parameters = NULL;
}

static void
gd_init (GenericDestination *gd, GenericDestinationClass *klass)
{
}

static void
gd_finalize (GObject *object)
{
	parent_class->finalize;
}

GType
generic_destination_get_type (void)
{
	static GType type = 0;
                                                                                                  
        if (type == 0) {
                static GTypeInfo info = {
                        sizeof (GenericDestinationClass),
                        (GBaseInitFunc) NULL,
                        (GBaseFinalizeFunc) NULL,
                        (GClassInitFunc) gd_class_init,
                        NULL, NULL,
                        sizeof (GenericDestination),
                        0,
                        (GInstanceInitFunc) gd_init
                };
		type = g_type_register_static (G_TYPE_OBJECT, "GenericDestination", &info, 0);
        }

        return type;
}

const GParamSpecPool *
generic_destination_get_parameters (GenericDestination *gd)
{
	g_return_val_if_fail (IS_GENERIC_DESTINATION (gd), NULL);
	g_return_val_if_fail (CLASS (gd)->get_parameters != NULL, NULL);

	return CLASS (gd)->get_parameters (gd);
}
