/* gnome-netinfo - A GUI Interface for network utilities
 * Copyright (C) 2002 by German Poo-Caaman~o
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <gnome.h>
#include "netstat.h"

#ifdef NETSTAT_PROGRAM

gchar *
netstat_get_active_option (Netinfo * netinfo)
{
	gchar *option = NULL;
	
	g_return_val_if_fail (netinfo != NULL, NULL);
	
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (netinfo->routing))) {
		option = g_strdup ("-r");
	}
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (netinfo->protocol))) {
		option = g_strdup ("-A inet -l");
	}
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (netinfo->multicast))) {
		option = g_strdup ("-g");
	}
	return option;
}
void
netstat_stop (Netinfo * netinfo) {
	g_return_if_fail (netinfo != NULL);
	
	netinfo_stop_process_command (netinfo);
}

void
netstat_do (Netinfo * netinfo)
{
	GtkTextBuffer *buffer = NULL;
	GtkTextIter start, end;
	gchar *command = NULL;
	gchar *option = NULL;

	g_return_if_fail (netinfo != NULL);

	option = netstat_get_active_option (netinfo);
	
	buffer =
	    gtk_text_view_get_buffer (GTK_TEXT_VIEW (netinfo->output));

	gtk_text_buffer_get_start_iter (buffer, &start);
	gtk_text_buffer_get_end_iter (buffer, &end);

	gtk_text_buffer_delete (buffer, &start, &end);

	command =
	    g_strdup_printf ("%s netstat %s", NETSTAT_PROGRAM, option);

	netinfo->command_line = g_strsplit (command, " ", -1);

	netinfo_process_command (netinfo);

	g_strfreev (netinfo->command_line);
	g_free (command);
	g_free (option);
}

/* Process each line from ping command */
void 
netstat_foreach (Netinfo * netinfo, gchar * line, gint len, gpointer user_data)
{
	gchar *text_utf8;
	gssize bytes_written;
	GtkWidget *entry = NULL;
	GtkTextBuffer *buffer = NULL;
	GtkTextIter iter;
	
	g_return_if_fail (netinfo != NULL);
	/*g_return_if_fail (line != NULL);*/
	
	buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (netinfo->output));
	gtk_text_buffer_get_end_iter (buffer, &iter);

	if (len > 0) {
		text_utf8 = g_locale_to_utf8 (line, len,
						  NULL, &bytes_written,
						  NULL);

		gtk_text_buffer_insert
			(GTK_TEXT_BUFFER (buffer), &iter, text_utf8,
			 bytes_written);
		g_free (text_utf8);
	}
}

#endif
