/* main-window.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include <glib/gfileutils.h>
#include <libgnome/gnome-i18n.h>
#include "configuration.h"

static GConfClient *conf_client = NULL;
static GList *fileset_list = NULL;

void
config_init (void)
{
	if (conf_client)
		return;

	conf_client = gconf_client_get_default ();
}

static GList *
add_fileset (GList *list, const gchar *name, const gchar *path, gboolean backup, time_t last_backup)
{
	FileSetInfo *fsi;

	fsi = g_new0 (FileSetInfo, 1);
	fsi->name = g_strdup (name);
	fsi->path = g_strdup (path);
	fsi->backup = backup;
	fsi->last_backup = last_backup;

	list = g_list_append (list, fsi);

	return list;
}

static GList *
add_fileset_if_exists (GList *list, const gchar *name, const gchar *path, gboolean backup, time_t last_backup)
{
	if (g_file_test (path, G_FILE_TEST_EXISTS))
		return add_fileset (list, name, path, backup, last_backup);

	return list;
}

const FileSetInfo *
config_get_fileset_by_name (const gchar *name)
{
	GList *list;

	g_return_val_if_fail (name != NULL, NULL);

	list = config_get_fileset_list ();
	for (; list != NULL; list = list->next) {
		FileSetInfo *fsi = list->data;

		if (!strcmp (fsi->name, name))
			return fsi;
	}

	return NULL;
}

const GList *
config_get_fileset_list (void)
{
	GSList *sl;
	gchar *str;

	if (fileset_list)
		return fileset_list;

	if (!gconf_client_dir_exists (conf_client, "/apps/gnome-backup/filesets", NULL)) {
		str = g_build_filename (g_get_home_dir (), ".gconf", NULL);
		fileset_list = add_fileset (fileset_list, _("User configuration"), str, TRUE, -1);
		g_free (str);

		str = g_build_filename (g_get_home_dir (), "evolution", NULL);
		fileset_list = add_fileset_if_exists (fileset_list, _("Evolution data"), str, TRUE, -1);
		g_free (str);
	} else {
	}

	return (const GList *) fileset_list;
}
