/* main-window.c - GNOME backup tool
                                                                                                  
   Copyright (C) 2003 Rodrigo Moya
                                                                                                  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
                                                                                                  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
                                                                                                  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  */

#include "gnome-backup.h"
#include <gtk/gtkaccelgroup.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkitemfactory.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkmenubar.h>
#include <gtk/gtknotebook.h>
#include <gtk/gtkstock.h>
#include <gtk/gtktable.h>
#include <gtk/gtktoolbar.h>
#include <libgnome/gnome-i18n.h>
#include <libgnomeui/gnome-about.h>
#include <libgnomeui/gnome-stock-icons.h>
#include <libgnomeui/gnome-uidefs.h>

static struct {
	GtkWidget *window;
	GtkWidget *toolbar;
	GtkWidget *statusbar;
	GtkWidget *notebook;
	GtkWidget *destination;
	GtkWidget *file_list;
} main_window;

static void
menu_about_cb (gpointer callback_data, guint callback_action, GtkWidget *widget)
{
	GtkWidget *dialog;
	const gchar *authors[] = {
		"Rodrigo Moya <rodrigo@gnome-db.org>",
		NULL
	};

	dialog = gnome_about_new ("GNOME Backup", VERSION,
				  _("Copyright (C) 2003 Rodrigo Moya"),
				  _("Backup client tool for GNOME"),
				  authors,
				  NULL, NULL, NULL);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (main_window.window));
	gtk_widget_show (dialog);
}

static void
menu_new_cb (gpointer callback_data, guint callback_action, GtkWidget *widget)
{
}

static void
menu_quit_cb (gpointer callback_data, guint callback_action, GtkWidget *widget)
{
	gtk_widget_destroy (main_window.window);
}

static void
toolbar_destination_options_cb (GtkWidget *button, gpointer user_data)
{
}

static void
toolbar_new_cb (GtkWidget *button, gpointer user_data)
{
}

static void
toolbar_preferences_cb (GtkWidget *button, gpointer user_data)
{
}

static void
window_destroyed_cb (GtkObject *object, gpointer user_data)
{
	gtk_main_quit ();
}

static GtkItemFactoryEntry menubar_items[] = {
	{ N_("/_File"), NULL, 0, 0, "<Branch>" },
	{ N_("/File/_New"), N_("<control>N"), menu_new_cb, 0, "<StockItem>", GTK_STOCK_NEW },
	{ N_("/File/sep1"), NULL, NULL, 0, "<Separator>" },
	{ N_("/File/_Quit"), N_("<control>Q"), menu_quit_cb, 0, "<StockItem>", GTK_STOCK_QUIT },
	{ N_("/_Edit"), NULL, 0, 0, "<Branch>" },
	{ N_("/Edit/_Properties"), NULL, NULL, 0, "<StockItem>", GTK_STOCK_PROPERTIES },
	{ N_("/_Help"), NULL, 0, 0, "<Branch>" },
	{ N_("/Help/_About"), NULL, menu_about_cb, 0, "<StockItem>", GNOME_STOCK_ABOUT }
};

void
main_window_init (void)
{
	GtkWidget *table, *button;
	GtkAccelGroup *accel_group;
	GtkItemFactory *item_factory;
	static gboolean initialized = FALSE;

	if (initialized)
		return;

	/* create the main window */
	main_window.window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title (GTK_WINDOW (main_window.window), "GNOME Backup Tool");
	g_signal_connect (main_window.window, "destroy", G_CALLBACK (window_destroyed_cb), NULL);

	table = gtk_table_new (2, 5, FALSE);
	gtk_container_add (GTK_CONTAINER (main_window.window), table);

	/* create the menubar */
	accel_group = gtk_accel_group_new ();
	gtk_window_add_accel_group (GTK_WINDOW (main_window.window), accel_group);

	item_factory = gtk_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);

	/* set up the item factory to go away with the window */
	g_object_ref (item_factory);
	gtk_object_sink (GTK_OBJECT (item_factory));
	g_object_set_data_full (G_OBJECT (main_window.window),
				"<main>",
				item_factory,
				(GDestroyNotify) g_object_unref);

	/* create the menu items */
	gtk_item_factory_create_items (item_factory, G_N_ELEMENTS (menubar_items), menubar_items, NULL);
	gtk_table_attach (GTK_TABLE (table),
			  gtk_item_factory_get_widget (item_factory, "<main>"),
			  0, 2, 0, 1, GTK_EXPAND | GTK_FILL, 0, 0, 0);

	/* create the toolbar */
	main_window.toolbar = gtk_toolbar_new ();
	gtk_container_set_border_width (GTK_CONTAINER (main_window.toolbar), GNOME_PAD_SMALL);

	main_window.destination = destination_selector_new ();
	gtk_widget_show (main_window.destination);
	gtk_toolbar_append_widget (GTK_TOOLBAR (main_window.toolbar),
				   main_window.destination,
				   _("Select backup destination"),
				   NULL);

	gtk_toolbar_insert_stock (GTK_TOOLBAR (main_window.toolbar),
				  GTK_STOCK_ADD,
				  _("Set options for selected backup destination"),
				  NULL,
				  G_CALLBACK (toolbar_destination_options_cb),
				  NULL, -1);

	gtk_toolbar_append_space (GTK_TOOLBAR (main_window.toolbar));
	gtk_toolbar_insert_stock (GTK_TOOLBAR (main_window.toolbar),
				  GTK_STOCK_NEW,
				  _("Create a new set of files to be backed up"),
				  NULL,
				  G_CALLBACK (toolbar_new_cb),
				  NULL, -1);
	gtk_toolbar_insert_stock (GTK_TOOLBAR (main_window.toolbar),
				  GTK_STOCK_PROPERTIES,
				  _("Edit properties for selection"),
				  NULL,
				  G_CALLBACK (toolbar_preferences_cb),
				  NULL, -1);
	gtk_table_attach (GTK_TABLE (table), main_window.toolbar, 0, 2, 1, 2,
			  GTK_EXPAND | GTK_FILL, 0, 0, 0);

	/* create status bar */
	main_window.statusbar = gtk_statusbar_new ();
	gtk_table_attach (GTK_TABLE (table), main_window.statusbar, 0, 1, 4, 5,
			  GTK_EXPAND | GTK_FILL, 0, 0, 0);

	/* finalize */
	g_object_unref (accel_group);
	initialized = TRUE;

	gtk_widget_show_all (main_window.window);

	/* add the workspace */
	main_window.notebook = gtk_notebook_new ();

	main_window.file_list = file_list_new ();
	gtk_widget_show (main_window.file_list);
	gtk_notebook_append_page (GTK_NOTEBOOK (main_window.notebook),
				  main_window.file_list,
				  gtk_label_new (_("Files")));

	gtk_widget_show (main_window.notebook);
	gtk_table_attach (GTK_TABLE (table), main_window.notebook, 0, 2, 3, 4,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK,
			  GTK_FILL | GTK_EXPAND | GTK_SHRINK, GNOME_PAD_SMALL, GNOME_PAD_SMALL);
}
