/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <gconf/gconf-client.h>

#include "interface.h"
#include "support.h"
#include "helpers.h"

static void
gconf_notify_func (GConfClient *client,
		   guint        cnxn_id,
		   GConfEntry  *entry,
		   gpointer     user_data)
{
	GtkWidget   *check_button = GTK_WIDGET (user_data);
	GConfValue  *value;
	gboolean     checked;
	
	value = gconf_entry_get_value (entry);

	checked = gconf_value_get_bool (value);

	/* Update the check button accordingly. */
	gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check_button),
				      checked);
}

int
main (int argc, char *argv[])
{
  GtkWidget *window1;
  GConfClient *client;
  gboolean     value;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE,
                      argc, argv,
                      GNOME_PARAM_APP_DATADIR, PACKAGE_DATA_DIR,
                      NULL);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */

  window1 = create_window1 ();
  client = gconf_client_get_default ();
	
  value = gconf_client_get_bool (client, GCONFKEY, NULL);
	
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (lookup_widget(GTK_WINDOW(window1), "checkbutton1")),
				      value);
  gconf_client_add_dir (client,
	  	      GCONFPATH,
		      GCONF_CLIENT_PRELOAD_NONE,
		      NULL);

  gconf_client_notify_add (client,
			 GCONFKEY,
			 gconf_notify_func,
			 lookup_widget(GTK_WINDOW(window1), "checkbutton1"),
			 NULL,
			 NULL);
  gtk_widget_show (window1);

  gtk_main ();
  return 0;
}

