/* $Id: backup_conduit.c,v 1.17 1999/12/03 02:16:44 eskil Exp $ */

#include <glib.h>
#include <gnome.h>

#include <pi-source.h>
#include <pi-socket.h>
#include <pi-file.h>
#include <pi-dlp.h>
#include <pi-version.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <utime.h>
#include <unistd.h>
#include <pwd.h>
#include <signal.h>
#include <errno.h>

#include <gpilotd/gnome-pilot-conduit-backup.h>
#include "backup_conduit.h"

/* Helper functions */
static void
protect_name(char *d, char *s) {
	while(*s) {
		switch(*s) {
		case '/': *(d++) = '='; *(d++) = '2'; *(d++) = 'F'; break;
		case '=': *(d++) = '='; *(d++) = '3'; *(d++) = 'D'; break;
		case '\x0A': *(d++) = '='; *(d++) = '0'; *(d++) = 'A'; break;
		case '\x0D': *(d++) = '='; *(d++) = '0'; *(d++) = 'D'; break;
#if 0
		case ' ': *(d++) = '='; *(d++) = '2'; *(d++) = '0'; break;
#endif
		default: *(d++) = *s;
		}
		++s;
	}
	*d = '\0';
}
static void
prepare_backup_conduit (GnomePilotConduitBackup *pilot_conduit_backup,
			guint32 pilotId)
{
	gchar prefix[45];
	gchar *backup_dir;
	gboolean updated_only;
	gboolean remove_deleted;

	g_snprintf(prefix,44,"/gnome-pilot.d/backup-conduit/Pilot_%u/",pilotId);

	gnome_config_push_prefix(prefix);
	backup_dir = gnome_config_get_string("backup_dir");
	updated_only = gnome_config_get_bool("updated_only=TRUE");
	remove_deleted = gnome_config_get_bool("remove_deleted=FALSE");
	gnome_config_pop_prefix();


	if (backup_dir==NULL) {
		char file_name[80];
		g_snprintf (file_name, 79, "%s/pilot/", g_get_home_dir());
		backup_dir = g_strdup(file_name);
	}
	/* let's make sure that this directory exists */
	if (mkdir (backup_dir, (mode_t)0755 ) < 0) { /* Wow, I never though I would use octal in C :)*/
		if(errno != EEXIST) {
			g_warning ("Unable to create directory:\n\t%s\n", backup_dir);
		}
	}
}

/* Signals */
static gint
gnome_real_pilot_conduit_backup_backup_prc (GnomePilotConduitBackup *pilot_conduit_backup,
					    GnomePilotDBInfo *dbinfo)
{
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);
	return 0;
}
static gint
gnome_real_pilot_conduit_backup_backup_db (GnomePilotConduitBackup *pilot_conduit_backup,
					   GnomePilotDBInfo *dbinfo)
{
	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);
	return 0;
}

static gint
gnome_real_pilot_conduit_backup_backup (GnomePilotConduitBackup *pilot_conduit_backup,
					GnomePilotDBInfo *dbinfo, gpointer data)
{
	char name[256];      /* FIXME: potentiel overun  -  (UGH, this sux -jrb) */
	struct pi_file *f;
	struct stat statb;
	struct utimbuf times;

	g_return_val_if_fail (pilot_conduit_backup != NULL, -1);
	g_return_val_if_fail (dbinfo != NULL, -1);
	g_return_val_if_fail (GNOME_IS_PILOT_CONDUIT_BACKUP (pilot_conduit_backup), -1);

	strcpy (name, GET_CFG(pilot_conduit_backup)->backup_dir);
	strcat (name,"/");
	protect_name (name + strlen (name), PI_DBINFO (dbinfo)->name);

	if (PI_DBINFO (dbinfo)->flags & dlpDBFlagResource)
		strcat (name,".prc");
	else
		strcat (name,".pdb");

	if (GET_CFG(pilot_conduit_backup)->remove_deleted) {
		GList *link;

		link = g_list_find_custom (GET_CFG(pilot_conduit_backup)->files_in_backup,
					   name,
					   (GCompareFunc) g_strcasecmp);
		GET_CFG(pilot_conduit_backup)->files_in_backup =
			g_list_remove_link (GET_CFG(pilot_conduit_backup)->files_in_backup,
					    link);
	}
	if (GET_CFG(pilot_conduit_backup)->updated_only) {
		if (stat (name, &statb) == 0) {
			if (PI_DBINFO (dbinfo)->modifyDate == statb.st_mtime) {
				return 0;
			}
		}
	}

	PI_DBINFO (dbinfo)->flags &= 0xff;

	f = pi_file_create (name, PI_DBINFO (dbinfo));
	if(f==0) {
		return -1;
	}

	g_message(_("Making backup of %s..."),PI_DBINFO (dbinfo)->name);
	if(pi_file_retrieve (f, dbinfo->pilot_socket, 0) < 0) {
		/* failed!? */
		pi_file_close (f);
		g_warning(_("Backup of %s failed!"),PI_DBINFO (dbinfo)->name);
		return -1;
	} else {
		/* ok */
		pi_file_close (f);
		times.actime = PI_DBINFO (dbinfo)->createDate;
		times.modtime = PI_DBINFO (dbinfo)->modifyDate;
		utime (name, &times);
		return 0;
	}
}
GnomePilotConduit *
conduit_get_gpilot_conduit (guint32 pilotId)
{
	ConduitCfg *cfg;
	GtkObject *retval;

	retval = gnome_pilot_conduit_backup_new ();
	g_assert (retval != NULL);
	load_configuration(&cfg,pilotId);

	gtk_object_set_data(retval,"configuration",cfg);

	gtk_signal_connect (retval, "backup", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup, NULL);
	gtk_signal_connect (retval, "backup_prc", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup_prc, NULL);
	gtk_signal_connect (retval, "backup_db", (GtkSignalFunc) gnome_real_pilot_conduit_backup_backup_db, NULL);

	return GNOME_PILOT_CONDUIT (retval);
}
void
conduit_destroy_gpilot_conduit (GnomePilotConduit *conduit)
{
	ConduitCfg *cfg;
	cfg = GET_CFG(conduit);
	destroy_configuration(&cfg);
	gtk_object_destroy (GTK_OBJECT (conduit));
}

