/* gnome-pilot-conduit.h
 * Copyright (C) 1999  Red Hat Inc.,
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_PILOT_CONDUIT_STANDARD_H__
#define __GNOME_PILOT_CONDUIT_STANDARD_H__

#include <gnome.h>
#include "gnome-pilot-dbinfo.h"
#include "gnome-pilot-conduit.h"
#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PILOT_CONDUIT_STANDARD			(gnome_pilot_conduit_standard_get_type ())
#define GNOME_PILOT_CONDUIT_STANDARD(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD, GnomePilotConduitStandard))
#define GNOME_PILOT_CONDUIT_STANDARD_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PILOT_CONDUIT_STANDARD, GnomePilotConduitStandardClass))
#define GNOME_IS_PILOT_CONDUIT_STANDARD(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD))
#define GNOME_IS_PILOT_CONDUIT_STANDARD_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_STANDARD))


typedef struct _GnomePilotConduitStandard         GnomePilotConduitStandard;
typedef struct _GnomePilotConduitStandardClass    GnomePilotConduitStandardClass;

struct _GnomePilotConduitStandard
{
	GnomePilotConduit parent;
	gchar *db_name;
	gboolean slow;
	guint32 creator_id;
};

struct _GnomePilotConduitStandardClass
{
	GnomePilotConduitClass parent_class;

	gint (*copy_to_pilot)		  (GnomePilotConduitStandard *conduit,
					   GnomePilotDBInfo  *dbinfo);
	gint (*copy_from_pilot)		  (GnomePilotConduitStandard *conduit,
					   GnomePilotDBInfo  *dbinfo);
	gint (*merge_to_pilot)		  (GnomePilotConduitStandard *conduit,
					   GnomePilotDBInfo  *dbinfo);
	gint (*merge_from_pilot)	  (GnomePilotConduitStandard *conduit,
					   GnomePilotDBInfo  *dbinfo);
	gint (*synchronize)		  (GnomePilotConduitStandard *conduit,
					   GnomePilotDBInfo  *dbinfo);
};


GtkType      gnome_pilot_conduit_standard_get_type (void);
GtkObject   *gnome_pilot_conduit_standard_new              (const char *db_name,
							    guint32 creator_id);
void         gnome_pilot_conduit_standard_construct        (GnomePilotConduitStandard *conduit,
							    const char *db_name,
							    guint32 creator_id);
const gchar *gnome_pilot_conduit_standard_get_db_name      (GnomePilotConduitStandard *conduit);
guint32      gnome_pilot_conduit_standard_get_creator_id   (GnomePilotConduitStandard *conduit);
void         gnome_pilot_conduit_standard_set_slow         (GnomePilotConduitStandard *conduit);
gint         gnome_pilot_conduit_standard_copy_to_pilot    (GnomePilotConduitStandard *conduit,
							    GnomePilotDBInfo  *dbinfo);
gint         gnome_pilot_conduit_standard_copy_from_pilot  (GnomePilotConduitStandard *conduit,
							    GnomePilotDBInfo  *dbinfo);
gint         gnome_pilot_conduit_standard_merge_to_pilot   (GnomePilotConduitStandard *conduit,
							    GnomePilotDBInfo  *dbinfo);
gint         gnome_pilot_conduit_standard_merge_from_pilot (GnomePilotConduitStandard *conduit,
							    GnomePilotDBInfo  *dbinfo);
gint         gnome_pilot_conduit_standard_synchronize      (GnomePilotConduitStandard *conduit,
							    GnomePilotDBInfo  *dbinfo);
#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PILOT_CONDUIT_STANDARD_H__ */
