/* gnome-pilot-conduit.h
 * Copyright (C) 1999  Red Hat Inc.,
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_PILOT_CONDUIT_H__
#define __GNOME_PILOT_CONDUIT_H__

#include <gnome.h>
#include "gnome-pilot-dbinfo.h"

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PILOT_CONDUIT			(gnome_pilot_conduit_get_type ())
#define GNOME_PILOT_CONDUIT(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_PILOT_CONDUIT, GnomePilotConduit))
#define GNOME_PILOT_CONDUIT_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PILOT_CONDUIT, GnomePilotConduitClass))
#define GNOME_IS_PILOT_CONDUIT(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT))
#define GNOME_IS_PILOT_CONDUIT_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT))


typedef struct _GnomePilotConduit         GnomePilotConduit;
typedef struct _GnomePilotConduitClass    GnomePilotConduitClass;

struct _GnomePilotConduit
{
	GtkObject parent;
	gchar *name;
};
struct _GnomePilotConduitClass
{
	GtkObjectClass parent_class;
};


GtkType      gnome_pilot_conduit_get_type 	(void);
void         gnome_pilot_conduit_construct      (GnomePilotConduit *pilot_conduit,
						 const gchar *name);
const gchar* gnome_pilot_conduit_get_name       (GnomePilotConduit *pilot_conduit); 

void         gnome_pilot_conduit_progress       (GnomePilotConduit *pilot_conduit, 
						 gint current, 
						 gint total);
void         gnome_pilot_conduit_message                (GnomePilotConduit *pilot_conduit,
						 gchar *message);
void         gnome_pilot_conduit_error                  (GnomePilotConduit *pilot_conduit,
						 gchar *message);

typedef enum {
	GnomePilotConduitSyncTypeCustom,
	GnomePilotConduitSyncTypeSynchronize,
	GnomePilotConduitSyncTypeCopyFromPilot,
	GnomePilotConduitSyncTypeCopyToPilot,
	GnomePilotConduitSyncTypeMergeFromPilot,
	GnomePilotConduitSyncTypeMergeToPilot,
	GnomePilotConduitSyncTypeNotSet
} GnomePilotConduitSyncType;

gint         gnome_pilot_conduit_sync_type_str_to_int(const gchar *s);
const gchar* gnome_pilot_conduit_sync_type_int_to_str(GnomePilotConduitSyncType e);



#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PILOT_CONDUIT_H__ */
