/* gnome-pilot-conduit-backup.h
 * Copyright (C) 1999  J. Arthur Random
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
#ifndef __GNOME_PILOT_CONDUIT_BACKUP_H__
#define __GNOME_PILOT_CONDUIT_BACKUP_H__

#include <gnome.h>
#include "gnome-pilot-conduit.h"
#include "gnome-pilot-dbinfo.h"
#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PILOT_CONDUIT_BACKUP			(gnome_pilot_conduit_backup_get_type ())
#define GNOME_PILOT_CONDUIT_BACKUP(obj)			(GTK_CHECK_CAST ((obj), GNOME_TYPE_PILOT_CONDUIT_BACKUP, GnomePilotConduitBackup))
#define GNOME_PILOT_CONDUIT_BACKUP_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PILOT_CONDUIT_BACKUP, GnomePilotConduitBackupClass))
#define GNOME_IS_PILOT_CONDUIT_BACKUP(obj)			(GTK_CHECK_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_BACKUP))
#define GNOME_IS_PILOT_CONDUIT_BACKUP_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), GNOME_TYPE_PILOT_CONDUIT_BACKUP))


typedef struct _GnomePilotConduitBackup       GnomePilotConduitBackup;
typedef struct _GnomePilotConduitBackupClass  GnomePilotConduitBackupClass;

struct _GnomePilotConduitBackup
{
	GnomePilotConduit parent;
};
struct _GnomePilotConduitBackupClass
{
	GnomePilotConduitClass parent_class;

	/* Signals go here */
	gint (*backup_db)	(GnomePilotConduitBackup *pilot_conduit_backup,
				 GnomePilotDBInfo *dbinfo);
	gint (*backup_prc)	(GnomePilotConduitBackup *pilot_conduit_backup,
				 GnomePilotDBInfo *dbinfo);
	gint (*backup)		(GnomePilotConduitBackup *pilot_conduit_backup,
				 GnomePilotDBInfo *dbinfo);
};


GtkType    gnome_pilot_conduit_backup_get_type   (void);
GtkObject *gnome_pilot_conduit_backup_new        (void);
void       gnome_pilot_conduit_backup_construct  (GnomePilotConduitBackup *pilot_conduit_backup,
						  gchar *backup_dir,
						  gboolean remove_deleted,
						  gboolean updated_only,
						  guint32 pilotId);
gint       gnome_pilot_conduit_backup_backup_db  (GnomePilotConduitBackup *pilot_conduit_backup,
						  GnomePilotDBInfo *dbinfo);
gint       gnome_pilot_conduit_backup_backup_prc (GnomePilotConduitBackup *pilot_conduit_backup,
						  GnomePilotDBInfo *dbinfo);
gint       gnome_pilot_conduit_backup_backup     (GnomePilotConduitBackup *pilot_conduit_backup,
						  GnomePilotDBInfo *dbinfo);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PILOT_CONDUIT_BACKUP_H__ */
