/*

  BEWARE!! This is not a useful tool, it is a playgroundfor eskil to test gpilotd!

 */
#include <config.h>
#include <libgnorba/gnorba.h>
#include <gpilotd/gnome-pilot-client.h>

GnomePilotClient *gpc;
CORBA_Environment ev;

int     arg_pause=0,
	arg_unpause=0,
	arg_id = 0,
	arg_restart=0,
	arg_setuser = 0,
	arg_listbases = 0,
	arg_monitorall=0,
	arg_monitor;
char
	*arg_install = NULL,
	*arg_username = NULL,
	*arg_restore = NULL,
	*arg_conduit = NULL,
	*arg_cradle = NULL,
	*arg_list_by_login = NULL,
	*arg_pilot = NULL;

gint outstanding_request=0;

gboolean stay_alive = TRUE;

static const struct poptOption options[] = {
	{"pause", 'p', POPT_ARG_NONE, &arg_pause, 0, N_("Pause daemon"), NULL},
	{"unpause", 'u', POPT_ARG_NONE, &arg_unpause, 0, N_("Unpause daemon"), NULL},
	{"restart", 'r', POPT_ARG_NONE, &arg_restart, 0, N_("Restart daemon"), NULL},
	{"setuser", 'S', POPT_ARG_NONE, &arg_setuser, 0, N_("Set user id and name"), NULL},
	{"pilotid" , '\0', POPT_ARG_INT, &arg_id, 0, N_("ID for the pilot"), N_("ID")},
	{"install",'\0', POPT_ARG_STRING, &arg_install, 0 , N_("Install file"), N_("FILE")},
	{"restore", '\0', POPT_ARG_STRING, &arg_restore, 0, N_("Restore directory"), N_("DIRECTORY")},
	{"conduit", '\0', POPT_ARG_STRING, &arg_conduit, 0, N_("Run conduit"), N_("CONDUIT")},
	{"userid", '\0', POPT_ARG_STRING, &arg_username, 0, N_("Username to set"), N_("USERNAME")},
	{"monitor", 'm', POPT_ARG_NONE, &arg_monitor, 0, N_("Monitor the specified pilots actions"), NULL},
	{"monitorall", 'A', POPT_ARG_NONE, &arg_monitorall, 0, N_("Monitor all pilots"), NULL},
	{"listpilots", '\0', POPT_ARG_STRING, &arg_list_by_login, 0, N_("list pilots by login"), N_("LOGIN")},
	{"pilot", '\0', POPT_ARG_STRING, &arg_pilot, 0, N_("Specify pilot to operate on (defaults to MyPilot)"), N_("PILOTNAME")},
	{"cradle", '\0', POPT_ARG_STRING, &arg_cradle, 0, N_("Specify a cradle to operate on (defaults to Cradle0)"), N_("CRADLENAME")},
	{"listbases", 'l', POPT_ARG_NONE, &arg_listbases, 0, N_("List the specifed pilot's bases"), NULL},
	{NULL, '\0', 0, NULL, 0} /* end the list */
};

static void
pilot_connect(GnomePilotClient *gpc, gchar *pilot_id, GNOME_Pilot_PilotUser *userinfo, gpointer data) {
	g_message("connect:   pilot_id  %s",pilot_id);
};

static void
pilot_disconnect(GnomePilotClient *gpc, gchar *pilot_id, gboolean *b) {
	g_message("disconnect: pilot_id  %s",pilot_id);
	(*b) = FALSE;
};

static void
pilot_request_completed(GnomePilotClient *gpc, gchar *pilot_id, gint handle, gpointer data) {
	if (handle == outstanding_request) {
		if (pilot_id && strlen(pilot_id))
			g_message("%s completed request %d",pilot_id,handle);
		else 
			g_message("Completed request %d",handle);
		outstanding_request = 0;
		stay_alive = FALSE;
		return;
	} else {
		g_message("unknown request completed");
	}
}

static void 
the_loop() {
	while (stay_alive) {
		g_message("*cough*");
		g_main_iteration(TRUE);
	}
}

static void list_bases() {
	GList *list = NULL,*ptr;

	gnome_pilot_client_get_databases_from_cache (gpc,arg_pilot,&list);
	if (list)
		for (ptr = list; ptr; ptr = ptr->next) {
			g_message ("database %s", (char*)ptr->data);
		}
	else 
		g_message ("No databases");
}

static void list_by_login() {
	GList *list = NULL,*ptr;

	gnome_pilot_client_get_pilots_by_user_login (gpc,arg_list_by_login,&list);
	if (list)
		for (ptr = list; ptr; ptr = ptr->next ) {
			g_message ("Pilot : %s", (char*)ptr->data);
		}
	else 
		g_message ("No pilots");
}

static void
print_err(gint err) {
	stay_alive = FALSE;
	switch(err) {
	case GPILOTD_OK:
		g_message("request sent");


		stay_alive = TRUE;
		if (outstanding_request!=0) {
			g_message("request handle is %d",outstanding_request);
		}
		break;
	case GPILOTD_ERR_INVAL:
		g_message("** Invalid arguments");
		break;
	case GPILOTD_ERR_FAILED:
		g_message("** Request failed");
		break;
	case GPILOTD_ERR_INTERNAL:
		g_message("** Internal libgpilotd error");
		break;
	case GPILOTD_ERR_NOT_CONNECTED:
		g_message("** Not connected to the daemon, try restart");
		break;
	}
}

static void 
restore(char *rest) 
{
	gint err;
	g_message("Restoring %s",arg_install);
	err = gnome_pilot_client_restore(gpc,arg_pilot,arg_restore,GNOME_Pilot_PERSISTENT,0,&outstanding_request);
	print_err(err);
	if (err==GPILOTD_OK)
		the_loop();
};

static void 
revive(char *rest) 
{
	GNOME_Pilot_PilotUser user;
	gint err;

	g_message("Reviving %d to %s from %s",arg_id,arg_cradle,arg_restore);
	user.userID = arg_id;
	user.username = CORBA_string_dup(arg_username);
	err = gnome_pilot_client_set_user_info(gpc,
					       arg_cradle,
					       user,
					       FALSE,
					       GNOME_Pilot_PERSISTENT,
					       0,
					       &outstanding_request);
	err = gnome_pilot_client_restore(gpc,
					 arg_pilot,
					 arg_restore,
					 GNOME_Pilot_PERSISTENT,
					 0,
					 &outstanding_request);
	print_err(err);
	if (err==GPILOTD_OK)
		the_loop();
};

static void 
install(char *rest) 
{
	gint err;
	g_message("Installing %s",arg_install);
	err = gnome_pilot_client_install_file(gpc,arg_pilot,arg_install,GNOME_Pilot_PERSISTENT,0,&outstanding_request);	
	print_err(err);
	if (err==GPILOTD_OK)
		the_loop();
};

static void 
conduit(char *rest) {

	gint err;
	g_message("Restoring %s",arg_install);
	err = gnome_pilot_client_restore(gpc,arg_pilot,arg_conduit,GNOME_Pilot_PERSISTENT,0,&outstanding_request);	
	print_err(err);
	if (err==GPILOTD_OK)
		the_loop();
};

static void 
set_user() 
{
	GNOME_Pilot_PilotUser user;
	gint err;
	gboolean abort = FALSE;

	if (arg_id==0) {
		g_warning("Please set a pilotid using --pilotid");
		abort = TRUE;
	}
	if (arg_username==NULL) {
		g_warning("Please set a username using --username");
		abort = TRUE;
	}
	if (arg_cradle==NULL) {
		g_warning("Please set a cradle using --cradle");
		abort = TRUE;
	}

	if (!abort) {
		g_message("Setting userid/name %d/%s on %s",arg_id,arg_username,arg_cradle);
		user.userID = arg_id;
		user.username = CORBA_string_dup(arg_username);
		err = gnome_pilot_client_set_user_info(gpc,
						       arg_cradle,
						       user,
						       FALSE,
						       GNOME_Pilot_PERSISTENT,
						       0,
						       &outstanding_request);
		print_err(err);
		if (err==GPILOTD_OK)
			the_loop();
	}
};

int
main(int argc, char *argv[]) {
	CORBA_Environment ev;
        poptContext pctx;
	
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);

	if(argc<2) {
		g_message("type `%s --help` for usage",argv[0]);
		exit(1);
	}

	gnome_CORBA_init_with_popt_table("gpilotd-client","1.0",
					 &argc,argv,
					 options,0,&pctx,
					 0,&ev);

	if (arg_pilot==NULL) arg_pilot = g_strdup("MyPilot");

	gpc = GNOME_PILOT_CLIENT(gnome_pilot_client_new());

	gnome_pilot_client_connect_to_daemon(gpc);

	gtk_signal_connect(GTK_OBJECT(gpc),"completed_request", (GtkSignalFunc)pilot_request_completed, NULL);

	if (arg_pause!=0) {
		g_message("Pausing daemon");
		gnome_pilot_client_pause_daemon(gpc);
	} else if (arg_unpause!=0) {
		g_message("Unpausing daemon");
		gnome_pilot_client_unpause_daemon(gpc);	
	} else if (arg_restart!=0) {
		g_message("Restarting daemon");
		gnome_pilot_client_restart_daemon(gpc);
	} else if (arg_install!=NULL) {
		install(arg_install);
	} else if (arg_cradle!=NULL && arg_restore!=NULL && arg_setuser) {
		revive(NULL);
	} else if (arg_restore!=NULL) {
		restore(arg_restore);
	} else if (arg_conduit!=NULL) {
		conduit(arg_conduit);
	} else if (arg_setuser) {
		set_user();
	} else if (arg_listbases) {
		list_bases();
	} else if (arg_list_by_login) {
		list_by_login();
	} else if (arg_monitor) {
		g_message("Monitor on %s",arg_pilot);
		gnome_pilot_client_monitor_on(gpc,arg_pilot);
		gnome_pilot_client_notify_on(gpc,GNOME_Pilot_NOTIFY_CONNECT);
		gnome_pilot_client_notify_on(gpc,GNOME_Pilot_NOTIFY_DISCONNECT);
		
		gtk_signal_connect(GTK_OBJECT(gpc),"pilot_connect", (GtkSignalFunc)pilot_connect,NULL);
		gtk_signal_connect(GTK_OBJECT(gpc),"pilot_disconnect", (GtkSignalFunc)pilot_disconnect,&stay_alive);

		the_loop();

		gnome_pilot_client_notify_off(gpc,GNOME_Pilot_NOTIFY_CONNECT);
		gnome_pilot_client_notify_off(gpc,GNOME_Pilot_NOTIFY_DISCONNECT);
		gnome_pilot_client_monitor_off(gpc,arg_pilot);
	} else if (arg_monitorall) {
		g_message("Monitor on all");
		gnome_pilot_client_monitor_on_all_pilots(gpc);
		gtk_signal_connect(GTK_OBJECT(gpc),"pilot_connect", (GtkSignalFunc)pilot_connect,NULL);
		gtk_signal_connect(GTK_OBJECT(gpc),"pilot_disconnect", (GtkSignalFunc)pilot_disconnect,&stay_alive);
		the_loop();
		gnome_pilot_client_monitor_off_all_pilots(gpc);		
	}

	return 0;
}

