/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* gpilotd-control-applet.c
 *
 * Copyright (C) 1998 Red Hat Software       
 * Copyright (C) 1999-2000 Free Software Foundation
 * Copyright (C) 2001  Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authors: Eskil Heyn Olsen
 *          Vadim Strizhevsky
 *          Michael Fulbright <msf@redhat.com>
 *          JP Rosevear <jpr@ximian.com>
 *
 */

#include <config.h>
#include <ctype.h>
#include <gnome.h>
#include <glade/glade.h>

#include <capplet-widget.h>
#include <libgnomeui/gnome-window-icon.h>
#include <gpilotd/gnome-pilot-client.h>

#include "gnome-pilot-druid.h"
#include "gnome-pilot-capplet.h"

#ifdef USING_OAF
#include <liboaf/liboaf.h>
#else
#include <libgnorba/gnorba.h>
#endif

#include "pilot.h"
#include "util.h"

static void
monitor_pilots (GnomePilotClient *gpc, PilotState * state)
{
	GList *tmp = state->pilots;
	if (tmp!= NULL){
		while (tmp!= NULL){
			GPilotPilot *pilot =(GPilotPilot*)tmp->data;
			g_message ("pilot = %s",pilot->name);
			gnome_pilot_client_monitor_on (gpc,pilot->name);
			tmp = tmp->next;
		}
		gnome_pilot_client_notify_on (gpc, GNOME_Pilot_NOTIFY_CONNECT);
		gnome_pilot_client_notify_on (gpc, GNOME_Pilot_NOTIFY_DISCONNECT);
	}
}

int
main (int argc, char *argv[])
{
	GnomePilotClient *gpc = NULL;
	PilotState *state = NULL;

	GtkWidget *gpcap = NULL, *gpcc = NULL;
	GtkWidget *capplet = NULL;
	gboolean druid_on = FALSE, druid_prog = FALSE;

	struct poptOption options[] = {
		{"druid", '\0', POPT_ARG_NONE, &druid_on, 0, N_("Start druid only"), NULL},
		
		{NULL, '\0', 0, NULL, 0, NULL, NULL}
	};

	
	bindtextdomain (PACKAGE, GNOMELOCALEDIR);
	textdomain (PACKAGE);
	
	if (argc > 1 && strcmp (argv[1], "--druid") == 0) {
		/* we are a regular gnome app with CORBA support */
#if USING_OAF
		gnome_init_with_popt_table ("gpilot control applet",
					    VERSION, argc, argv,
					    options,0,NULL);
#else /* USING_OAF */
		CORBA_Environment ev;
		gnome_CORBA_init_with_popt_table ("gpilot control applet",
						 VERSION, &argc, argv,
						 options,0,NULL,0,&ev);
#endif /* USING_OAF */

		druid_on = TRUE;
		druid_prog = TRUE;
	} else {
		/* we're a capplet (we get CORBA for free from capplet_init) */
		switch (gnome_capplet_init ("gpilot control applet", VERSION, argc, argv, 
					   options,0,NULL)) {
		case 1: return 0; break;
		case -1: g_error (_("Error initializing gpilotd capplet")); break;
		default: break;
		}
	}
	gnome_window_icon_set_default_from_file (GNOME_ICONDIR"/gnome-palm.png");
	
	/* we using glade */
	glade_gnome_init ();
	
	/* put all code to set things up in here */
	if (loadPilotState (&state) < 0) {
		error_dialog (_("Error loading pilot state, aborting"));
		g_error (_("Error loading pilot state, aborting"));
		return -1;
	}

	gpc = GNOME_PILOT_CLIENT (gnome_pilot_client_new ());

	if (gnome_pilot_client_connect_to_daemon (gpc) != GPILOTD_OK) {
		error_dialog (_("Cannot connect to the GnomePilot Daemon"));
		g_error (_("Cannot connect to the GnomePilot Daemon"));
		return -1;
	}

	monitor_pilots (gpc, state);
	if (druid_on) {
		GtkObject *druid;
		
		if (state->pilots!= NULL || state->devices!= NULL) {
			error_dialog (_("Cannot run druid if pilots or cradles already configured"));
			return -1;
		}

		druid = gnome_pilot_druid_new (gpc);
		gnome_pilot_druid_run_and_close (GNOME_PILOT_DRUID (druid));
	} else {
		
		capplet = capplet_widget_new ();

		gpcap = gnome_pilot_capplet_new (gpc);
		gtk_container_add (GTK_CONTAINER (capplet), gpcap);
		gnome_pilot_capplet_set_parent (GNOME_PILOT_CAPPLET (gpcap), CAPPLET_WIDGET (capplet));

		gtk_widget_show_all (capplet);
	
		/* popup the druid if nothing is configured - assume this is the first time */
		if (state->pilots == NULL && state->devices == NULL) {
			GtkObject *druid;
			
			druid = gnome_pilot_druid_new (gpc);
			gnome_pilot_druid_run_and_close (GNOME_PILOT_DRUID (druid));

			if (gpcap != NULL)
				gnome_pilot_capplet_update (GNOME_PILOT_CAPPLET (gpcap));
		}

		/* done setting up, now run main loop */
		capplet_gtk_main ();
	}
	freePilotState (state);

	return 0;
}    

