/* A first cut at an interface for text handling */

/* A font family code is a handle gotten from gnome-font. gnome-font
   will also have an interface for querying a font family given the
   handle. */

typedef guint32 G_Ucs4;

typedef struct _GnomeTextLayout GnomeTextLayout;
typedef struct _GnomeTextBreak GnomeTextBreak;
typedef struct _GnomeTextAttrEl GnomeTextAttrEl;
typedef struct _GnomeTextGlyph GnomeTextGlyph;

typedef int GnomeTextFontListHandle;
typedef int GnomeTextFontHandle;
typedef int GnomeTextFont;

typedef enum {
  GNOME_TEXT_END,

  GNOME_TEXT_FONT_LIST, /* A GnomeTextFontList handle */
  GNOME_TEXT_SIZE, /* point size * 1000 */
  GNOME_TEXT_XSCALE, /* 800 = condensed, 1000 = normal, 1300 = extended */
  GNOME_TEXT_OBLIQUING_UGH, /* tangent of angle * 1000 */
  GNOME_TEXT_WEIGHT, /* GNOME_TEXT_BOOK and GNOME_TEXT_BOLD are values */
  GNOME_TEXT_ITALICS, /* boolean */
  GNOME_TEXT_KERNING, /* boolean, inverted */
  GNOME_TEXT_LIGATURES, /* GNOME_TEXT_LIG_NONE, _NORMAL, _MAX */
  GNOME_TEXT_TRACKING, /* extra letterspace in .001 em units */
  GNOME_TEXT_SMALL_CAPS, /* boolean */
  GNOME_TEXT_GLYPH_ALTERNATE, /* integer, font specific */
  GNOME_TEXT_UNDERLINE_UGH, /* boolean, or maybe 2 for double underline */
  GNOME_TEXT_STRIKETHROUGH, /* boolean */
  GNOME_TEXT_RISE, /* extra height from baseline in .001 em units */
  GNOME_TEXT_COLOR, /* rgba */
  /* language code */
  /* random multiple master attributes, etc., here */
  /* probably hyphenation preferences need to get added too */
  GNOME_TEXT_LAST
} GnomeTextAttr;

typedef enum {
  GNOME_TEXT_GLYPH_END,

  GNOME_TEXT_GLYPH_FONT, /* A GnomeTextFont handle */
  GNOME_TEXT_GLYPH_SIZE, /* point size * 1000 */
  GNOME_TEXT_GLYPH_XSCALE, /* 800 = condensed, 1000 = normal, 1300 = extended */
  GNOME_TEXT_GLYPH_OBLIQUING, /* tangent of angle * 1000 */
  GNOME_TEXT_GLYPH_UNDERLINE, /* boolean, or maybe 2 for double underline */
  GNOME_TEXT_GLYPH_STRIKETHROUGH, /* boolean */
  GNOME_TEXT_GLYPH_RISE, /* extra height from baseline in .001 em units */
  GNOME_TEXT_GLYPH_COLOR /* rgba */
  /* random multiple master attributes, etc., here */
} GnomeTextGlyphAttr;

struct _GnomeTextAttrEl {
  int char_pos; /* offset in (possibly wide) characters from start of string */
  GnomeTextAttr attr;
  int attr_val;
};

/* so the standard interface of attributed text into gnome_text is:

func (G_Ucs4 *chars, GnomeTextAttrEl *attrs);

maybe n_chars too, maybe null terminated.

The chars are UCS4 encoded. Thus, ISO-8859-1 characters can just get
zero-extended. This may seem wasteful to you now, but it will make
full Unicode a lot easier later down the road. Trust me.

Note added 4 Jan 1999: on the advice of Chris Lahey, I'm going with
UTF-8 instead of UCS4 as the standard encoding.

*/

/* Next up is an interface that returns a list of breaks given an
   attributed text stream. These are in essentially the same format
   as libhnj. */

struct _GnomeTextBreak {
  int x0;
  int x1;
  int penalty;
  int flags;
};

/* The x values are in 0.001 of a user space coordinate units.

It will probably store an x value for each character - but rough.
In particular, they will change with line breaks, and also positioning
with ligatures is approximate at best. And this is for English-like
languages!

Finally, there must be a data structure somewhere that maps breaks
back to character positions. Searching in the x value for
each character works, but may (or may not be) extra computation.

Anyway, the GnomeTextBreak values are run through the justification
engine, and a series of line breaks are returned (see libhnj for
more discussion).

The line breaks, x value list, and original attributed text are then
run through a second pass of the high level gnome_text interface,
resulting in an attributed glyph list.

Attributed glyph lists are very much like attributed text, except:
1. a font handle is used instead of a font family handle
2. instead of UCS4 character numbers, glyph numbers are given,
   the encoding of which are specific to the font.
3. an x value is given for each glyph, and all x spacing attributes
   are gone
4. ligature codes are gone because this step takes care of ligation

Thus, the following attributes remain:

_FONT, // not present in attributed text
_SIZE,
_XSCALE,
_OBLIQUING_UGH,
_UNDERLINE_UGH,
_STRIKETHROUGH,
_RISE,
_COLOR

*/

struct _GnomeTextGlyph {
  int glyph_num;
  int x;
};

/* The GnomeTextLayout data structure is an "object" that stays with
   the text as it goes through the different phases.

   Should this structure be renamed simple GnomeText?
*/
struct _GnomeTextLayout {
  /* This is going to go, to be replaced by a GnomeTextGlyphAttr list */
  GnomeTextAttrEl *attrs;

  GnomeTextBreak *breaks;
  int n_breaks;

  GnomeTextGlyph *glyphs;
  int n_glyphs;
};

