#ifndef __GNOME_PRINT_PS_H__
#define __GNOME_PRINT_PS_H__

#include <libgnomeprint/gnome-print.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define GNOME_TYPE_PRINT_PS		 (gnome_print_ps_get_type ())
#define GNOME_PRINT_PS(obj)		 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_PS, GnomePrintPs))
#define GNOME_PRINT_PS_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_PS, GnomePrintPsClass))
#define GNOME_IS_PRINT_PS(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_PS))
#define GNOME_IS_PRINT_PS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_PS))

typedef struct _GnomePrintPs       GnomePrintPs;
typedef struct _GnomePrintPsClass  GnomePrintPsClass;

typedef enum {
  GNOME_PRINT_PS_TYPE_GENERIC_PS
} GnomePrintPsType;

struct _GnomePrintPs
{
  GnomePrintContext pc;


  /* the list of fonts that have already been downloaded */
  int n_fonts, n_fonts_max;
  char **fonts;

  /* the list of fonts assumed to already exist in the printer */
  int n_builtins, n_builtins_max;
  char **builtins;

  /* list of fonts that have been reencoded, and exist int printer */
  int  n_fonts_reencoded, n_fonts_reencoded_max;
  char **fonts_reencoded;

  /* current color */
  double r;
  double g;
  double b;

  /* current font */
  const char *current_font;
  double current_font_size;
  const GnomeFont *current_gnome_font;

  /* here follows stuff for printing gnome-text lines */
  GnomeTextFontHandle cur_font;
  int cur_size;
};

struct _GnomePrintPsClass
{
  GnomePrintContextClass parent_class;
};


GtkType gnome_print_ps_get_type (void);

GnomePrintPs *gnome_print_ps_new (GnomePrinter *printer);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __GNOME_PRINT_PS_H__ */
