#ifndef __GNOME_PRINT_META_H__
#define __GNOME_PRINT_META_H__

#include <libgnomeprint/gnome-print.h>

#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */

#define GNOME_TYPE_PRINT_META		 (gnome_print_meta_get_type ())
#define GNOME_PRINT_META(obj)		 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_META, GnomePrintMeta))
#define GNOME_PRINT_META_CLASS(klass)	 (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_META, GnomePrintMetaClass))
#define GNOME_IS_PRINT_META(obj)	 (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_META))
#define GNOME_IS_PRINT_META_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_META))

typedef struct {
	GnomePrintContext pc;

	char *buffer;
	int   buffer_size;
	int   current;
} GnomePrintMeta;

typedef struct {
	GnomePrintContextClass parent_class;
} GnomePrintMetaClass;

GtkType         gnome_print_meta_get_type (void);
GnomePrintMeta *gnome_print_meta_new      (void);
GnomePrintMeta *gnome_print_meta_new_from (void *data);

/* Returns the value in GnomePrinterMeta structure, shared with the object */
int             gnome_print_meta_access_buffer (GnomePrintMeta *meta,
						void **buffer, int *buflen);
/* Duplicates the metadata buffer and returns a copy of it */
int             gnome_print_meta_get_copy      (GnomePrintMeta *meta,
						void **bufer, int *buflen);

/*
 * Rendering a metafile into a GnomePrintContext
 */

gboolean        gnome_print_meta_render_from_object (GnomePrintContext *destination,
						     GnomePrintMeta *source);
gboolean        gnome_print_meta_render             (GnomePrintContext *destination,
						     void *meta_stream);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GNOME_PRINT_META_H__ */
