#ifndef __GNOME_PRINT_PREVIEW_H__
#define __GNOME_PRINT_PREVIEW_H__

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-paper.h>
#include <libgnomeui/gnome-canvas.h>
#include <libgnomeprint/gnome-print.h>

BEGIN_GNOME_DECLS

/*
 * GnomePrintPreview printer context.
 */
#define GNOME_TYPE_PRINT_PREVIEW	 (gnome_print_preview_get_type ())
#define GNOME_PRINT_PREVIEW(obj)	 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_PREVIEW, GnomePrintPreview))
#define GNOME_PRINT_PREVIEW_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_PREVIEW, GnomePrintPreviewClass))
#define GNOME_IS_PRINT_PREVIEW(obj)	    (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_PREVIEW))
#define GNOME_IS_PRINT_PREVIEW_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_PREVIEW))

typedef struct _GnomePrintPreview        GnomePrintPreview;
typedef struct _GnomePrintPreviewPrivate GnomePrintPreviewPrivate;
typedef struct _GnomePrintPreviewClass   GnomePrintPreviewClass;

struct _GnomePrintPreview {
	GnomePrintContext pc;

	GnomePrintPreviewPrivate *priv;

	GnomeCanvas *canvas;
};

struct _GnomePrintPreviewClass {
	GnomePrintContextClass parent_class;
};

GtkType            gnome_print_preview_get_type  (void);
GnomePrintContext *gnome_print_preview_new       (GnomeCanvas *canvas,
						  const char *paper_size);
void               gnome_print_preview_construct (GnomePrintPreview *preview,
						  GnomeCanvas *canvas,
						  const GnomePaper *paper_info);

/*
 * GnomePrintPreviewJob object: used to control the page display on the Canvas
 * preview item
 *
 */
#define GNOME_TYPE_PRINT_PREVIEW_JOB	 (gnome_print_preview_job_get_type ())
#define GNOME_PRINT_PREVIEW_JOB(obj)	 (GTK_CHECK_CAST ((obj), GNOME_TYPE_PRINT_PREVIEW_JOB, GnomePrintPreviewJob))
#define GNOME_PRINT_PREVIEW_JOB_CLASS(klass) (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_PRINT_PREVIEW_JOB, GnomePrintPreviewJobClass))
#define GNOME_IS_PRINT_PREVIEW_JOB(obj)	    (GTK_CHECK_TYPE ((obj), GNOME_TYPE_PRINT_PREVIEW_JOB))
#define GNOME_IS_PRINT_PREVIEW_JOB_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_PRINT_PREVIEW_JOB))

typedef struct _GnomePrintPreviewJob	    GnomePrintPreviewJob;
typedef struct _GnomePrintPreviewJobPrivate GnomePrintPreviewJobPrivate;
typedef struct _GnomePrintPreviewJobClass   GnomePrintPreviewJobClass;

struct _GnomePrintPreviewJob {
	GtkObject parent;

	GnomeCanvas                 *canvas;
	GnomePrintPreviewJobPrivate *priv;
};

struct _GnomePrintPreviewJobClass {
	GtkObjectClass parent_class;
};

GtkType               gnome_print_preview_job_get_type (void);
GnomePrintPreviewJob *gnome_print_preview_get_job      (GnomePrintPreview *p);
int                   gnome_print_preview_job_pages    (GnomePrintPreviewJob *pjob);
void                  gnome_print_preview_show_page    (GnomePrintPreviewJob *pjob,
							int page);
void                  gnome_print_preview_job_page_visible (GnomePrintPreviewJob *pjob,
							    int page,
							    gboolean visible);
END_GNOME_DECLS

#endif /* __GNOME_PRINT_PREVIEW_H__ */

