# Note that this is NOT a relocatable package
%define ver      1.0.13
%define  RELEASE 1
%define  rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix   /usr

Summary: GNOME utility programs
Name: gnome-utils
Version: %ver
Release: %rel
Copyright: LGPL
Group: Appilcations/System
Source: ftp://ftp.gnome.org/pub/GNOME/sources/gnome-utils-%{ver}.tar.gz
BuildRoot: /var/tmp/gnome-utils-%{PACKAGE_VERSION}-root
Obsoletes: gnome
URL: http://www.gnome.org
Requires: gnome-libs >= 1.0.13
Docdir: %{prefix}/doc

%description
GNOME is the GNU Network Object Model Environment. This powerful
environment is both easy to use and easy to configure.

This package will install some GNOME utilities, such as the
calculator, search tool, and system information overview tool.

%changelog
* Wed Sep 08 1999 Elliot Lee <sopwith@redhat.com>
- Updates from RHL package...

* Wed Sep 23 1998 Michael Fulbright <msf@redhat.com>

- Upgraded to 0.30

* Mon Apr  6 1998 Marc Ewing <marc@redhat.com>

- Integrate into gnome-utils CVS source tree

%prep
%setup

%build
%ifarch alpha
MYARCH_FLAGS=--host=alpha-redhat-linux
%endif
# Needed for snapshot releases.
if [ ! -f configure ]; then
  CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix $MYARCH_FLAGS
else
  CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix $MYARCH_FLAGS
fi

if [ "$SMP" != "" ]; then
  make MAKE="make -j$SMP"
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

# New users will never get rid of this :)
rm -f $RPM_BUILD_ROOT%{prefix}/share/gnome/apps/Utilities/gpenguin.desktop

# gshutdown isn't what we want at this time
rm -f $RPM_BUILD_ROOT%{prefix}/bin/gshutdown
rm -f $RPM_BUILD_ROOT%{prefix}/share/gnome/apps/*/gshutdown.desktop
rm -rf $RPM_BUILD_ROOT%{prefix}/share/gnome/help/gshutdown

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README
%{prefix}/bin/*
%{prefix}/man/*/*

%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/gnome/apps/*
%{prefix}/share/gnome/help/*
%{prefix}/share/gstripchart/*
