/* $Id: gdict-applet.c,v 1.19 2001/12/06 23:49:53 kevinv Exp $ */

/*
 *  Papadimitriou Spiros <spapadim+@cs.cmu.edu>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 *
 *  GDict panel applet
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include <gnome.h>
#ifdef GDICT_APPLET_WORKS
  #include <applet-widget.h>
#endif

#include <libbonoboui.h>
#include <panel-applet.h>

#include "gdict-app.h"
#include "gdict-about.h"
#include "gdict-pref.h"
#include "gdict-applet.h"
#include "gdict-pref-dialog.h"



#define DOCKED_APPLET_WIDTH 74
#define FLOATING_APPLET_WIDTH 14
#define SHORT_APPLET_HEIGHT 22
#define TALL_APPLET_HEIGHT 44

#ifdef GDICT_APPLET_WORKS
/* Returns the ideal vertical applet size based on panel width and
 * orientation. */
static gint 
gdict_applet_determine_height(GDictApplet *applet)
{

	int ideal_panel_size = 0;
	PanelOrientType orientation = ORIENT_UP;

	ideal_panel_size = applet_widget_get_panel_pixel_size(
		APPLET_WIDGET(applet->applet_widget));
	orientation = applet_widget_get_panel_orient(
		APPLET_WIDGET(applet->applet_widget));

	if ((orientation == ORIENT_UP || orientation == ORIENT_DOWN) && 
	    ideal_panel_size < PIXEL_SIZE_STANDARD)

		return SHORT_APPLET_HEIGHT;
	else
		return TALL_APPLET_HEIGHT;

	return 0;
}

/* Returns the ideal horizontal applet size based on panel width and
 * orientation. */
static gint
gdict_applet_determine_width(GDictApplet *applet)
{

	if (applet->handlebox_widget != NULL && 
		GTK_HANDLE_BOX(applet->handlebox_widget)->child_detached)

		return FLOATING_APPLET_WIDTH;
	else
		return DOCKED_APPLET_WIDTH;

	return 0;
}

/* Configures and displays the applet as appropriate for the panel
 * width, orientation, and handlebox state. */
static void
gdict_applet_render (GDictApplet * applet)
{

	gint applet_height = 0;
	gint applet_width = 0;

	applet_height = gdict_applet_determine_height(applet);
	applet_width = gdict_applet_determine_width(applet);

	if (applet_height == TALL_APPLET_HEIGHT) {
		gtk_widget_show(applet->button_widget);
	}
	else {
		gtk_widget_hide(applet->button_widget);
	}

	gtk_container_set_border_width (GTK_CONTAINER(applet->vbox_widget), 2);
	gtk_widget_show(applet->vbox_widget);
	gtk_widget_show(applet->entry_widget);
	if (applet->handle) {
		g_return_if_fail(applet->handlebox_widget);
		gtk_handle_box_set_shadow_type(
			GTK_HANDLE_BOX(applet->handlebox_widget), GTK_SHADOW_IN);
		gtk_widget_set_usize(applet->handlebox_widget, applet_width, 
							 applet_height);
		gtk_widget_show(applet->handlebox_widget);
	}
	else {
		gtk_widget_set_usize(applet->vbox_widget, applet_width, applet_height);
	}
	gtk_widget_show (applet->applet_widget);

}

/* Signal handler that gets called when the user re-attaches the
 * handlebox's float window to its ghost. */
static gint
applet_attach_cb (GtkHandleBox * handlebox, AppletWidget *widget, 
				  gpointer data)
{
	gdict_applet_render((GDictApplet *) data);
	return FALSE;
}

/* Signal handler that gets called when the user detaches the
 * handlebox's float window. */
static gint
applet_detach_cb (GtkHandleBox * handlebox, AppletWidget *widget, 
				  gpointer data)
{
	gdict_applet_render((GDictApplet *) data);
	return FALSE;
}

/* Signal handler that gets called when the user changes the
 * orientation of his panel. */
static gint
applet_change_orient_cb (AppletWidget *widget, PanelOrientType orientation, 
						 gpointer data)
{
	GDictApplet * applet = (GDictApplet *) data;

	/* Note: Technically we could use the orientation parameter to
	 * resize the applet in a slightly more efficient fashion, but for
	 * now I decided to reuse gdict_applet_render for the sake of
	 * simplicity. */ 
	gdict_applet_render((GDictApplet *) applet);
	return FALSE;
}

/* Signal handler that gets called when the user changes the pixel
 * width of his panel. */
static gint
applet_change_pixel_size_cb (AppletWidget *widget, int size, gpointer data)
{
	GDictApplet * applet = (GDictApplet *) data;

	/* Note: Technically we could use the size parameter to
	 * resize the applet in a slightly more efficient fashion, but for
	 * now I decided to reuse this gdict_applet_render for the sake of
	 * simplicity. */ 
	gdict_applet_render((GDictApplet *) applet);
	return FALSE;
}

/* Signal handler for the "Help" menu item */
static void
cb_help (GtkWidget *w, gpointer data)
{
	GnomeHelpMenuEntry help_entry = { "gdict", "index.html" };
	gnome_help_display(NULL, &help_entry);
}



/* Signal handler for "Spell Check" menu item */
static void
applet_spell_cb (AppletWidget *widget, gpointer data) 
{
    gchar *text;
	GDictApplet * applet = (GDictApplet *) data;

    text = gtk_entry_get_text (GTK_ENTRY (applet->entry_widget));
    gdict_spell (text, FALSE);
    gtk_entry_set_text (GTK_ENTRY (applet->entry_widget), "");
}


/* Signal handler for any event that should trigger a lookup */
static void
applet_lookup_cb (GtkWidget *widget, gpointer data)
{
	GDictApplet * applet = (GDictApplet *) data;

    gchar *text = gtk_entry_get_text(GTK_ENTRY(applet->entry_widget));
    if (*text == 0)
        return;
    g_strdown (text);
    if (!GTK_WIDGET_VISIBLE (gdict_app))
        gtk_widget_show (gdict_app);
    gtk_entry_set_text (GTK_ENTRY (applet->entry_widget), "");
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    gtk_editable_select_region (GTK_EDITABLE (word_entry), 0, strlen (text));
    gdict_app_do_lookup (text);
}


/* Connects any signal handlers needed for the applet to function. */
static void
gdict_applet_connect_signals (GDictApplet * applet)
{
    gtk_signal_connect (GTK_OBJECT(applet->applet_widget), 
						"button_press_event",
                        GTK_SIGNAL_FUNC(applet_clicked_cb), 
						(gpointer) applet);
    gtk_signal_connect (GTK_OBJECT(applet->applet_widget), "destroy",
                        GTK_SIGNAL_FUNC(gtk_main_quit), 
						(gpointer) applet);
    gtk_signal_connect (GTK_OBJECT(applet->button_widget), "clicked",
						GTK_SIGNAL_FUNC(applet_lookup_cb), 
						(gpointer) applet);
    gtk_signal_connect (GTK_OBJECT(applet->entry_widget), "activate",
                        GTK_SIGNAL_FUNC(applet_lookup_cb), 
						(gpointer) applet);
	gtk_signal_connect (GTK_OBJECT(applet->applet_widget), "change_orient",
						GTK_SIGNAL_FUNC(applet_change_orient_cb),
						(gpointer) applet);
	gtk_signal_connect (GTK_OBJECT(applet->applet_widget), "change_pixel_size",
						GTK_SIGNAL_FUNC(applet_change_pixel_size_cb),
						(gpointer) applet);
	if (applet->handle) {
        gtk_signal_connect (GTK_OBJECT(applet->handlebox_widget), 
							"child_detached",
                            GTK_SIGNAL_FUNC(applet_detach_cb), 
							(gpointer) applet);
        gtk_signal_connect (GTK_OBJECT(applet->handlebox_widget), 
							"child_attached",
                            GTK_SIGNAL_FUNC(applet_attach_cb), 
							(gpointer) applet);
	}
}

/* Sets up the applet's context menu */
static void
gdict_applet_populate_menu (GDictApplet * applet)
{
    applet_widget_register_stock_callback 
		(APPLET_WIDGET (applet->applet_widget), "about",
		 GNOME_STOCK_MENU_ABOUT, _("About..."),
		 applet_about_cb, NULL);
    applet_widget_register_stock_callback
        (APPLET_WIDGET (applet->applet_widget), "help",
		 GNOME_STOCK_PIXMAP_HELP, _("Help"),
		 (AppletCallbackFunc) cb_help,
		 NULL);
    applet_widget_register_stock_callback 
		(APPLET_WIDGET (applet->applet_widget), "preferences",
		 GNOME_STOCK_MENU_PREF, _("Preferences..."),
		 applet_pref_cb, NULL);
    applet_widget_register_callback
		(APPLET_WIDGET (applet->applet_widget), "show_hide_window", 
		 _("Show/Hide Definition Window..."), applet_show_hide_defbox_cb,
		 NULL);
    applet_widget_register_callback
		(APPLET_WIDGET (applet->applet_widget), "spell_check", 
		 _("Spell Check..."), applet_spell_cb, (gpointer) applet);
}


/* Constructs an applet object, containing all its necessary widgets */
static GDictApplet * 
gdict_applet_new ()
{
	GDictApplet *applet = NULL;

	applet = g_malloc (sizeof(GDictApplet));

    if ((applet->applet_widget = applet_widget_new("gdict")) == NULL)
        g_error(_("Cannot create applet!\n"));

    applet->vbox_widget = gtk_vbox_new(FALSE, 2);
    applet->entry_widget = gtk_entry_new();
    applet->button_widget = gtk_button_new_with_label(_("Lookup"));

    applet->handle = gdict_pref.applet_handle;

    if (gdict_applet_determine_height (applet) != TALL_APPLET_HEIGHT)
	    applet->handle = TRUE;

    if (applet->handle) {
        applet->handlebox_widget = gtk_handle_box_new();
    } else {
		applet->handlebox_widget = NULL;
    }

	return applet;
}



/* Packs and adds widgets inside container widgets, as needed for the
 * applet.  When this call is finished, the interface for the applet
 * should be all set up and ready to display using gdict_applet_render. */
static void
gdict_applet_pack_widgets (GDictApplet * applet)
{
    gtk_box_pack_end(GTK_BOX(applet->vbox_widget), applet->button_widget, 
					 TRUE, TRUE, 0);

    if (applet->handle) {
        gtk_container_add(GTK_CONTAINER(applet->handlebox_widget), 
						  applet->vbox_widget);
        applet_widget_add(APPLET_WIDGET(applet->applet_widget), 
						  applet->handlebox_widget);
	}
	else {
        applet_widget_add(APPLET_WIDGET(applet->applet_widget), 
						  applet->vbox_widget);
	}

    /* We want to allow pasting into the input box so we pack it after */
    /* applet_widdget_add has bound the middle button -- thanks to webcontrol applet! :-) */
    gtk_box_pack_end(GTK_BOX(applet->vbox_widget), applet->entry_widget, TRUE, 
					 TRUE, 0);
}



#endif

static void
entry_activate_cb (GtkEntry *entry, gpointer data)
{
    gchar *text = gtk_editable_get_chars (GTK_EDITABLE (entry), 0, -1);
    
    if (!context)
		gdict_init_context ();
    if (!GTK_WIDGET_VISIBLE (gdict_app))
        gtk_widget_show (gdict_app);
    
    if (*text == 0)
        return;
    g_strdown (text);
    gdict_app_do_lookup (text);
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    g_free (text);
 
#if 0   
    gtk_entry_set_text (GTK_ENTRY (applet->entry_widget), "");
    gtk_entry_set_text (GTK_ENTRY (word_entry), text);
    gtk_editable_select_region (GTK_EDITABLE (word_entry), 0, strlen (text));
    gdict_app_do_lookup (text);
#endif
}

static void
text_received (GtkClipboard *clipboard, const gchar *text, gpointer data)
{
	GtkEntry *entry = GTK_ENTRY (data);	
	
	if (!text)
		return;
		
	g_print ("text = %s \n", text);
			
	gtk_entry_set_text (entry, text);
	entry_activate_cb (entry, NULL);
	
}

static void
button_press_cb (GtkButton *button, gpointer data)
{
	GtkEntry *entry = GTK_ENTRY (data);
	GtkClipboard *clipboard;
	
	clipboard = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
 		
 	gtk_clipboard_request_text (clipboard, text_received, entry);
	
	/*entry_activate_cb (entry, NULL);*/
	
}

static void
about_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	gdict_about();
}

static void
help_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{

}

static void
prefs_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	gdict_app_show_preferences ();
}

static void
show_hide_defbox_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	if (!context)
		gdict_init_context ();
	if (!GTK_WIDGET_VISIBLE (gdict_app))
        	gtk_widget_show (gdict_app);
    	else
        	gtk_widget_hide (gdict_app);
}

static void
spell_cb (BonoboUIComponent *uic,
          gpointer           user_data,
          const gchar       *verbname)
{
	if (!context)
		gdict_init_context ();
#ifdef FIXME
	GtkWidget *entry = GTK_WIDGET (user_data);
	text = gtk_entry_get_text (GTK_ENTRY (applet->entry_widget));
    	gdict_spell (text, FALSE);
    gtk_entry_set_text (GTK_ENTRY (applet->entry_widget), "");
#endif
}

static const BonoboUIVerb gdict_applet_menu_verbs [] = {
        BONOBO_UI_VERB ("about", about_cb),
        BONOBO_UI_VERB ("help", help_cb),
        BONOBO_UI_VERB ("prefs", prefs_cb),
	BONOBO_UI_VERB ("def win", show_hide_defbox_cb),
        BONOBO_UI_VERB ("spell", spell_cb),

        BONOBO_UI_VERB_END
};

static const char gdict_applet_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Item 1\" verb=\"about\" _label=\"About...\"/>\n"
        "   <menuitem name=\"Item 2\" verb=\"help\" _label=\"Help\"/>\n"
        "   <menuitem name=\"Item 3\" verb=\"prefs\" _label=\"Preferences...\"/>\n"
        "   <menuitem name=\"Item 4\" verb=\"def win\" _label=\"Show/Hide Definition Window...\"/>\n"
        "   <menuitem name=\"Item 5\" verb=\"spell\" _label=\"Spell Check...\"/>\n"
        "</popup>\n";

static BonoboObject *
gdict_applet_new (void) {
 	GtkWidget *applet;
 	GtkWidget *hbox;
 	GtkWidget *button; 	 	
 	GtkWidget *entry;
 	
	hbox = gtk_hbox_new (FALSE, 0);
	
	button = gtk_button_new_with_label (_("Lookup"));
	gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 2);
	  	
 	entry = gtk_entry_new ();
 	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 0);
 	
 	applet = panel_applet_new (hbox);
 	
 	gdict_app_create (TRUE);
 	
 	panel_applet_setup_menu (PANEL_APPLET (applet),
                                 gdict_applet_menu_xml,
                                 gdict_applet_menu_verbs,
                                 NULL);                               
                                 
 	gtk_widget_show_all (applet);
 	gdict_pref_load ();
 	
 	/* server will be contacted when an action is performed */
 	context = NULL;
 	
 	g_signal_connect (G_OBJECT (entry), "activate",
 			  G_CALLBACK (entry_activate_cb), NULL);
 	g_signal_connect (G_OBJECT (button), "clicked",
 			  G_CALLBACK (button_press_cb), entry);
 	
 	
 	return BONOBO_OBJECT (panel_applet_get_control (PANEL_APPLET (applet)));
 	
}

static BonoboObject *
gdict_applet_factory (BonoboGenericFactory *this,
                     const gchar          *iid,
                     gpointer              data)
{
        BonoboObject *applet = NULL;

        if (!strcmp (iid, "OAFIID:GNOME_GDictApplet"))
                applet = gdict_applet_new ();

        return applet;
}

PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_GDictApplet_Factory",
                             "Dictionary",
                             "0",
                             gdict_applet_factory,
                             NULL)
 	
