#ifndef __GDICT_PREF_H_
#define __GDICT_PREF_H_

/* $Id: gdict-pref.h,v 1.6 2002/05/11 21:04:28 gman Exp $ */

/*
 *  Papadimitriou Spiros <spapadim@cs.cmu.edu>
 *  Mike Hughes <mfh@psilord.com>
 *
 *  This code released under the GNU GPL.
 *  Read the file COPYING for more information.
 * 
 *  GDict preferences
 *
 */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtk.h>
#include <gconf/gconf-client.h>
#include "dict.h"

enum {
    TYPEFACE_HEADWORD,              /* Headword */
    TYPEFACE_NUMBER,                /* Sub-definition number */
    TYPEFACE_PRONUNCIATION,         /* Pronunciation */
    TYPEFACE_ETYMOLOGY,             /* Etymology */
    TYPEFACE_PART,                  /* Part of speech */
    TYPEFACE_EXAMPLE,               /* Example phrase */
    TYPEFACE_BODY,                  /* Definition body */
    TYPEFACE_XREF,                  /* Cross-reference */
    NUM_TYPEFACES
};

typedef struct _GDictTypeface {
    GdkFont   *font;
    gchar     *font_name;
    GdkColor  *color;
} GDictTypeface;

typedef struct _GDictPref {
    /* Server preferences */
    gchar        *server;
    gint          port;
    gboolean      smart;        /* Auto-detect patterns */
    gchar        *database;     /* Database to search for words and defs */
    gchar        *dfl_strat;    /* Default match strategy */

    /* Applet preferences (read only during startup) */
    gboolean      applet_handle;

    /* Font preferences */
    GDictTypeface typefaces[NUM_TYPEFACES];
} GDictPref;

extern GDictPref gdict_pref;

void gdict_pref_load (void);
GConfClient* gdict_get_gconf_client (void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GDICT_PREF_H_ */
