/* brlinp.h
 *
 * Copyright 2001, 2002 Sun Microsystems, Inc.,
 * Copyright 2001, 2002 BAUM Retec, A.G.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _brlinp_h
#define _brlinp_h

/* Braille Input Parser States */
typedef enum
{
	BIPS_IDLE,
	BIPS_BRL_IN,
	BIPS_KEY,
	BIPS_SENSOR,
	BIPS_SWITCH,	
	BIPS_UNKNOWN
} BrlInParserStates;


/* Braille Input Event Type */
typedef enum
{
	
	BIET_UNKNOWN,
	BIET_KEY,
	BIET_SENSOR,
	BIET_SWITCH

} BrlInEventTypes;


/* Braille Input Event */
typedef struct
{
	
	BrlInEventTypes	event_type;
	union
	{
		char*					key_codes;	
		char*					switch_codes;
		char* 				sensor_codes;
	} event_data;
	
} BrlInEvent;


/* API */

typedef void (*BrlInCallback) (BrlInEvent* brl_in_event);

int brl_in_xml_init (BrlInCallback callback_proc);	
void brl_in_xml_terminate ();
void brl_in_xml_parse (char* buffer, int len);

#endif
