// -*- C++ -*-

/* 
 * guppidata.h
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include "guppidata.h"
#include "libguppi/scalardata.h"
#include "goose/RealSet.h"

static DataStore* ds = 0;

DataStore* 
guppi_datastore()
{
  if (ds == 0)
    {
      ds = new DataStore;

      double max = 15000000;
      int n = 0;
      while (n < 10)
        {
          // Put in some stupid ass fake data for debugging
          ScalarData* d = new ScalarData;
          
          bool ascend = (rand() < RAND_MAX/2);

          double add = ascend ? 10000 : 6000;
          double sub = ascend ? 6000 : 10000;

          double i = ascend ? (0.0 + rand()/(RAND_MAX/max)) : ((max-1.0) - rand()/(RAND_MAX/max));
          while ((ascend && i < max) || (!ascend && i > -1000.0))
            {
              d->add(i/1000);
              int r = rand();
              // on average, move in a single direction.
              i += (double)r/(RAND_MAX/add);
              i -= (double)r/(RAND_MAX/sub);
            }

          g_debug("Created random scalar data");

          if (rand() < RAND_MAX/2)
            {
              RealSet* rs = d->checkout_realset();

              g_debug("Scrambling this random data");

              rs->scramble();

              d->checkin_realset(rs, true, false);
            }

          // vary the number of elements
          max += rand()/(RAND_MAX/850000.0);
          max -= rand()/(RAND_MAX/300000.0);

          char buf[100];
          g_snprintf(buf, 99, "Test data %d", n);
          
          d->set_name(buf);
          
          ds->insert(d);

          ++n;
        }

      ScalarData* d = new ScalarData;
      d->set_name("Empty Data 0");
      ds->insert(d);

      d = new ScalarData;
      d->set_name("Empty Data 1");
      ds->insert(d);

      d = new ScalarData;
      d->set_name("One Point 0");
      d->add(1000.0);
      ds->insert(d);

      d = new ScalarData;
      d->set_name("One Point 1");
      d->add(2000.0);
      ds->insert(d);

      d = new ScalarData;
      d->set_name("Duplicate Points 0");
      int z = 0;
      while (z < 205)
        {
          d->add(2000.0);
          ++z;
        }
      ds->insert(d);

      d = new ScalarData;
      d->set_name("Duplicate Points 1");
      z = 0;
      while (z < 205)
        {
          d->add(1000.0);
          ++z;
        }
      ds->insert(d);


#define NPOINTS 250000
      {
        double* xv;
        double* yv;

        xv = new double[NPOINTS];
        yv = new double[NPOINTS];
        
        g_debug("Making %d-point data sets...", NPOINTS);
        guint i = 0;
        double v, v2;
        while (i < sizeof(xv)/sizeof(xv[0]))
          {
            int r = random();
            v = (double(r)/(((double)RAND_MAX)/2000.0));
            r = random();
            v2 = (double(r)/(((double)RAND_MAX)/2000.0));
            
            if (random() > (RAND_MAX/2)) v = -v;
            
            xv[i] = CLAMP(v, -v2, v2);
            
            r = random();
            v = (double(r)/(((double)RAND_MAX)/2000.0));
            r = random();
            v2 = (double(r)/(((double)RAND_MAX)/2000.0));
            
            if (random() > (RAND_MAX/2)) v = -v;
            
            yv[i] = CLAMP(v, -v2, v2);

            ++i;
          }
        
        d = new ScalarData;
        d->set_name("Huge data set 1");
        RealSet* rs = d->checkout_realset();
        rs->add(xv, NPOINTS);
        d->checkin_realset(rs, true, false);
        ds->insert(d);
        
        d = new ScalarData;
        d->set_name("Huge data set 2");
        rs = d->checkout_realset();
        rs->add(yv, NPOINTS);
        d->checkin_realset(rs, true, false);
        ds->insert(d);      
        
        delete [] xv;
        delete [] yv;

        g_debug("Done.");
      }
    }

  return ds;
}

void 
guppi_replace_datastore(DataStore* newds)
{
  if (ds != 0)
    {
      delete ds;
      ds = 0;
    }
  
  ds = newds;
}




