// -*- C++ -*-

/* 
 * util.cc
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "util.h"

#include "markerstyle.h"

static MarkerPalette* mp = 0;

MarkerPalette*
guppi_marker_palette()
{
  return mp;
}

bool
guppi_init_library()
{
  g_return_val_if_fail(mp == 0, false); // check for duplicate init

  mp = new MarkerPalette;
  mp->ref();

  return true;
}

void 
guppi_shutdown_library()
{
  if (mp != 0)
    {
      if (mp->unref() == 0)
        delete mp;

      mp = 0;
    }
}

static Frontend* fe = 0;

void 
guppi_register_frontend(Frontend* fe_)
{
  g_return_if_fail(fe == 0);

  fe = fe_;
}

Frontend* 
guppi_frontend()
{
  return fe;
}
