/* CharacterData.c generated by valac 0.12.0, the Vala compiler
 * generated from CharacterData.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>


#define GXML_DOM_TYPE_XNODE (gxml_dom_xnode_get_type ())
#define GXML_DOM_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNode))
#define GXML_DOM_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))
#define GXML_DOM_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))

typedef struct _GXmlDomXNode GXmlDomXNode;
typedef struct _GXmlDomXNodeClass GXmlDomXNodeClass;
typedef struct _GXmlDomXNodePrivate GXmlDomXNodePrivate;

#define GXML_DOM_TYPE_NODE_TYPE (gxml_dom_node_type_get_type ())

#define GXML_DOM_TYPE_NODE_LIST (gxml_dom_node_list_get_type ())
#define GXML_DOM_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeList))
#define GXML_DOM_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_NODE_LIST))
#define GXML_DOM_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeListIface))

typedef struct _GXmlDomNodeList GXmlDomNodeList;
typedef struct _GXmlDomNodeListIface GXmlDomNodeListIface;

#define GXML_DOM_TYPE_ATTR (gxml_dom_attr_get_type ())
#define GXML_DOM_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttr))
#define GXML_DOM_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))
#define GXML_DOM_IS_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_IS_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))

typedef struct _GXmlDomAttr GXmlDomAttr;
typedef struct _GXmlDomAttrClass GXmlDomAttrClass;

#define GXML_DOM_TYPE_BACKED_NODE (gxml_dom_backed_node_get_type ())
#define GXML_DOM_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNode))
#define GXML_DOM_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))
#define GXML_DOM_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))

typedef struct _GXmlDomBackedNode GXmlDomBackedNode;
typedef struct _GXmlDomBackedNodeClass GXmlDomBackedNodeClass;
typedef struct _GXmlDomBackedNodePrivate GXmlDomBackedNodePrivate;

#define GXML_DOM_TYPE_CHARACTER_DATA (gxml_dom_character_data_get_type ())
#define GXML_DOM_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterData))
#define GXML_DOM_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterDataClass))
#define GXML_DOM_IS_CHARACTER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_CHARACTER_DATA))
#define GXML_DOM_IS_CHARACTER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_CHARACTER_DATA))
#define GXML_DOM_CHARACTER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_CHARACTER_DATA, GXmlDomCharacterDataClass))

typedef struct _GXmlDomCharacterData GXmlDomCharacterData;
typedef struct _GXmlDomCharacterDataClass GXmlDomCharacterDataClass;
typedef struct _GXmlDomCharacterDataPrivate GXmlDomCharacterDataPrivate;

#define GXML_DOM_TYPE_DOCUMENT (gxml_dom_document_get_type ())
#define GXML_DOM_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocument))
#define GXML_DOM_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))
#define GXML_DOM_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))

typedef struct _GXmlDomDocument GXmlDomDocument;
typedef struct _GXmlDomDocumentClass GXmlDomDocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	GXML_DOM_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_DOM_ERROR_NOT_FOUND,
	GXML_DOM_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_DOM_ERROR_DOM,
	GXML_DOM_DOM_ERROR_INVALID_DOC,
	GXML_DOM_DOM_ERROR_INVALID_ROOT
} GXmlDomDomError;
#define GXML_DOM_DOM_ERROR gxml_dom_dom_error_quark ()
typedef enum  {
	GXML_DOM_NODE_TYPE_X_UNKNOWN = 0,
	GXML_DOM_NODE_TYPE_ELEMENT = 1,
	GXML_DOM_NODE_TYPE_ATTRIBUTE,
	GXML_DOM_NODE_TYPE_TEXT,
	GXML_DOM_NODE_TYPE_CDATA_SECTION,
	GXML_DOM_NODE_TYPE_ENTITY_REFERENCE,
	GXML_DOM_NODE_TYPE_ENTITY,
	GXML_DOM_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_DOM_NODE_TYPE_COMMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT_TYPE,
	GXML_DOM_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_DOM_NODE_TYPE_NOTATION
} GXmlDomNodeType;

struct _GXmlDomNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomXNode* (*item) (GXmlDomNodeList* self, gulong idx);
	void (*foreach) (GXmlDomNodeList* self, GFunc func, void* func_target);
	GXmlDomXNode* (*first) (GXmlDomNodeList* self);
	GXmlDomXNode* (*last) (GXmlDomNodeList* self);
	GXmlDomXNode* (*nth) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_data) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_prev) (GXmlDomNodeList* self, GXmlDomXNode* pivot, gulong n);
	gint (*find) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*find_custom) (GXmlDomNodeList* self, GXmlDomXNode* target, GCompareFunc cmp);
	gint (*position) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*index) (GXmlDomNodeList* self, GXmlDomXNode* target);
	GXmlDomXNode* (*insert_before) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomNodeList* self, GXmlDomXNode* old_child);
	GXmlDomXNode* (*append_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child);
	gchar* (*to_string) (GXmlDomNodeList* self);
	gulong (*get_length) (GXmlDomNodeList* self);
	void (*set_length) (GXmlDomNodeList* self, gulong value);
};

struct _GXmlDomXNode {
	GObject parent_instance;
	GXmlDomXNodePrivate * priv;
};

struct _GXmlDomXNodeClass {
	GObjectClass parent_class;
	GXmlDomXNode* (*insert_before) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomXNode* self, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*append_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GError** error);
	gboolean (*has_child_nodes) (GXmlDomXNode* self);
	GXmlDomXNode* (*clone_nodes) (GXmlDomXNode* self, gboolean deep);
	const gchar* (*get_node_value) (GXmlDomXNode* self);
	void (*set_node_value) (GXmlDomXNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlDomXNode* self);
	void (*set_node_name) (GXmlDomXNode* self, const gchar* value);
	GXmlDomNodeType (*get_node_type) (GXmlDomXNode* self);
	void (*set_node_type) (GXmlDomXNode* self, GXmlDomNodeType value);
	GXmlDomXNode* (*get_parent_node) (GXmlDomXNode* self);
	void (*set_parent_node) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomNodeList* (*get_child_nodes) (GXmlDomXNode* self);
	void (*set_child_nodes) (GXmlDomXNode* self, GXmlDomNodeList* value);
	GXmlDomXNode* (*get_first_child) (GXmlDomXNode* self);
	void (*set_first_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_last_child) (GXmlDomXNode* self);
	void (*set_last_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_previous_sibling) (GXmlDomXNode* self);
	void (*set_previous_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_next_sibling) (GXmlDomXNode* self);
	void (*set_next_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GHashTable* (*get_attributes) (GXmlDomXNode* self);
	void (*set_attributes) (GXmlDomXNode* self, GHashTable* value);
};

struct _GXmlDomBackedNode {
	GXmlDomXNode parent_instance;
	GXmlDomBackedNodePrivate * priv;
	xmlNode* node;
};

struct _GXmlDomBackedNodeClass {
	GXmlDomXNodeClass parent_class;
};

struct _GXmlDomCharacterData {
	GXmlDomBackedNode parent_instance;
	GXmlDomCharacterDataPrivate * priv;
};

struct _GXmlDomCharacterDataClass {
	GXmlDomBackedNodeClass parent_class;
};


static gpointer gxml_dom_character_data_parent_class = NULL;

GType gxml_dom_xnode_get_type (void) G_GNUC_CONST;
GQuark gxml_dom_dom_error_quark (void);
GType gxml_dom_node_type_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_attr_get_type (void) G_GNUC_CONST;
GType gxml_dom_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_character_data_get_type (void) G_GNUC_CONST;
enum  {
	GXML_DOM_CHARACTER_DATA_DUMMY_PROPERTY,
	GXML_DOM_CHARACTER_DATA_DATA,
	GXML_DOM_CHARACTER_DATA_LENGTH
};
GType gxml_dom_document_get_type (void) G_GNUC_CONST;
GXmlDomCharacterData* gxml_dom_character_data_new (xmlNode* char_node, GXmlDomDocument* doc);
GXmlDomCharacterData* gxml_dom_character_data_construct (GType object_type, xmlNode* char_node, GXmlDomDocument* doc);
GXmlDomBackedNode* gxml_dom_backed_node_new (xmlNode* node, GXmlDomDocument* owner);
GXmlDomBackedNode* gxml_dom_backed_node_construct (GType object_type, xmlNode* node, GXmlDomDocument* owner);
gchar* gxml_dom_character_data_substring_data (GXmlDomCharacterData* self, gulong offset, gulong count);
const gchar* gxml_dom_character_data_get_data (GXmlDomCharacterData* self);
void gxml_dom_character_data_append_data (GXmlDomCharacterData* self, const gchar* arg);
void gxml_dom_character_data_set_data (GXmlDomCharacterData* self, const gchar* value);
void gxml_dom_character_data_insert_data (GXmlDomCharacterData* self, gulong offset, const gchar* arg);
void gxml_dom_character_data_delete_data (GXmlDomCharacterData* self, gulong offset, gulong count);
void gxml_dom_character_data_replace_data (GXmlDomCharacterData* self, gulong offset, gulong count, const gchar* arg);
const gchar* gxml_dom_xnode_get_node_value (GXmlDomXNode* self);
void gxml_dom_xnode_set_node_value (GXmlDomXNode* self, const gchar* value);
gulong gxml_dom_character_data_get_length (GXmlDomCharacterData* self);
static void gxml_dom_character_data_set_length (GXmlDomCharacterData* self, gulong value);
static void _vala_gxml_dom_character_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gxml_dom_character_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GXmlDomCharacterData* gxml_dom_character_data_construct (GType object_type, xmlNode* char_node, GXmlDomDocument* doc) {
	GXmlDomCharacterData * self = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (GXmlDomCharacterData*) gxml_dom_backed_node_construct (object_type, char_node, doc);
	return self;
}


GXmlDomCharacterData* gxml_dom_character_data_new (xmlNode* char_node, GXmlDomDocument* doc) {
	return gxml_dom_character_data_construct (GXML_DOM_TYPE_CHARACTER_DATA, char_node, doc);
}


/**
 * Retrieves a substring of the character data
 * count-characters long, starting from the character
 * at offset.
 */
static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


gchar* gxml_dom_character_data_substring_data (GXmlDomCharacterData* self, gulong offset, gulong count) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = string_substring (_tmp0_, (glong) offset, (glong) count);
	result = _tmp1_;
	return result;
}


/**
 * Appends arg to the end of the character data.
 */
void gxml_dom_character_data_append_data (GXmlDomCharacterData* self, const gchar* arg) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = g_strconcat (_tmp0_, arg, NULL);
	_tmp2_ = _tmp1_;
	gxml_dom_character_data_set_data (self, _tmp2_);
	_g_free0 (_tmp2_);
}


/**
 * Inserts arg into the character data at offset.
 */
void gxml_dom_character_data_insert_data (GXmlDomCharacterData* self, gulong offset, const gchar* arg) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = string_substring (_tmp0_, (glong) 0, (glong) offset);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_dom_character_data_get_data (self);
	_tmp4_ = string_substring (_tmp3_, (glong) offset, (glong) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, arg, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	gxml_dom_character_data_set_data (self, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}


/**
 * Deletes a range of characters, count-characters long, starting from offset.
 */
void gxml_dom_character_data_delete_data (GXmlDomCharacterData* self, gulong offset, gulong count) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = string_substring (_tmp0_, (glong) 0, (glong) offset);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_dom_character_data_get_data (self);
	_tmp4_ = string_substring (_tmp3_, (glong) (offset + count), (glong) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	gxml_dom_character_data_set_data (self, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}


/**
 * Replaces a range of characters, count-characters
 * long, starting at offset, with arg.
 */
void gxml_dom_character_data_replace_data (GXmlDomCharacterData* self, gulong offset, gulong count, const gchar* arg) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = string_substring (_tmp0_, (glong) 0, (glong) offset);
	_tmp2_ = _tmp1_;
	_tmp3_ = gxml_dom_character_data_get_data (self);
	_tmp4_ = string_substring (_tmp3_, (glong) (offset + count), (glong) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, arg, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	gxml_dom_character_data_set_data (self, _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}


const gchar* gxml_dom_character_data_get_data (GXmlDomCharacterData* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gxml_dom_xnode_get_node_value ((GXmlDomXNode*) self);
	result = _tmp0_;
	return result;
}


void gxml_dom_character_data_set_data (GXmlDomCharacterData* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	gxml_dom_xnode_set_node_value ((GXmlDomXNode*) self, value);
	g_object_notify ((GObject *) self, "data");
}


gulong gxml_dom_character_data_get_length (GXmlDomCharacterData* self) {
	gulong result;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = gxml_dom_character_data_get_data (self);
	_tmp1_ = strlen (_tmp0_);
	result = (gulong) _tmp1_;
	return result;
}


static void gxml_dom_character_data_set_length (GXmlDomCharacterData* self, gulong value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "length");
}


static void gxml_dom_character_data_class_init (GXmlDomCharacterDataClass * klass) {
	gxml_dom_character_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_character_data_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_character_data_set_property;
	/**
	 * The character data in string form for the node.
	 * Generally equivalent to node_value.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_CHARACTER_DATA_DATA, g_param_spec_string ("data", "data", "data", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * The number of characters.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_CHARACTER_DATA_LENGTH, g_param_spec_ulong ("length", "length", "length", 0, G_MAXULONG, 0UL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gxml_dom_character_data_instance_init (GXmlDomCharacterData * self) {
}


/**
 * CharacterData defines an interface for manipulating XML character data. It is used by
 * the CDATASection, Text, and Comment node types. For more, see: [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-FF21A306]]
 */
GType gxml_dom_character_data_get_type (void) {
	static volatile gsize gxml_dom_character_data_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_character_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomCharacterDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_character_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomCharacterData), 0, (GInstanceInitFunc) gxml_dom_character_data_instance_init, NULL };
		GType gxml_dom_character_data_type_id;
		gxml_dom_character_data_type_id = g_type_register_static (GXML_DOM_TYPE_BACKED_NODE, "GXmlDomCharacterData", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_character_data_type_id__volatile, gxml_dom_character_data_type_id);
	}
	return gxml_dom_character_data_type_id__volatile;
}


static void _vala_gxml_dom_character_data_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomCharacterData * self;
	self = GXML_DOM_CHARACTER_DATA (object);
	switch (property_id) {
		case GXML_DOM_CHARACTER_DATA_DATA:
		g_value_set_string (value, gxml_dom_character_data_get_data (self));
		break;
		case GXML_DOM_CHARACTER_DATA_LENGTH:
		g_value_set_ulong (value, gxml_dom_character_data_get_length (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_character_data_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomCharacterData * self;
	self = GXML_DOM_CHARACTER_DATA (object);
	switch (property_id) {
		case GXML_DOM_CHARACTER_DATA_DATA:
		gxml_dom_character_data_set_data (self, g_value_get_string (value));
		break;
		case GXML_DOM_CHARACTER_DATA_LENGTH:
		gxml_dom_character_data_set_length (self, g_value_get_ulong (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



