/* Element.c generated by valac 0.12.0, the Vala compiler
 * generated from Element.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libxml/tree.h>


#define GXML_DOM_TYPE_XNODE (gxml_dom_xnode_get_type ())
#define GXML_DOM_XNODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNode))
#define GXML_DOM_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))
#define GXML_DOM_IS_XNODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_IS_XNODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_XNODE))
#define GXML_DOM_XNODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_XNODE, GXmlDomXNodeClass))

typedef struct _GXmlDomXNode GXmlDomXNode;
typedef struct _GXmlDomXNodeClass GXmlDomXNodeClass;
typedef struct _GXmlDomXNodePrivate GXmlDomXNodePrivate;

#define GXML_DOM_TYPE_NODE_TYPE (gxml_dom_node_type_get_type ())

#define GXML_DOM_TYPE_NODE_LIST (gxml_dom_node_list_get_type ())
#define GXML_DOM_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeList))
#define GXML_DOM_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_NODE_LIST))
#define GXML_DOM_NODE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_DOM_TYPE_NODE_LIST, GXmlDomNodeListIface))

typedef struct _GXmlDomNodeList GXmlDomNodeList;
typedef struct _GXmlDomNodeListIface GXmlDomNodeListIface;

#define GXML_DOM_TYPE_ATTR (gxml_dom_attr_get_type ())
#define GXML_DOM_ATTR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttr))
#define GXML_DOM_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))
#define GXML_DOM_IS_ATTR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_IS_ATTR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ATTR))
#define GXML_DOM_ATTR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ATTR, GXmlDomAttrClass))

typedef struct _GXmlDomAttr GXmlDomAttr;
typedef struct _GXmlDomAttrClass GXmlDomAttrClass;

#define GXML_DOM_TYPE_BACKED_NODE (gxml_dom_backed_node_get_type ())
#define GXML_DOM_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNode))
#define GXML_DOM_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))
#define GXML_DOM_IS_BACKED_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_IS_BACKED_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_BACKED_NODE))
#define GXML_DOM_BACKED_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_BACKED_NODE, GXmlDomBackedNodeClass))

typedef struct _GXmlDomBackedNode GXmlDomBackedNode;
typedef struct _GXmlDomBackedNodeClass GXmlDomBackedNodeClass;
typedef struct _GXmlDomBackedNodePrivate GXmlDomBackedNodePrivate;

#define GXML_DOM_TYPE_ELEMENT (gxml_dom_element_get_type ())
#define GXML_DOM_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_ELEMENT, GXmlDomElement))
#define GXML_DOM_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_ELEMENT, GXmlDomElementClass))
#define GXML_DOM_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_ELEMENT))
#define GXML_DOM_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_ELEMENT))
#define GXML_DOM_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_ELEMENT, GXmlDomElementClass))

typedef struct _GXmlDomElement GXmlDomElement;
typedef struct _GXmlDomElementClass GXmlDomElementClass;
typedef struct _GXmlDomElementPrivate GXmlDomElementPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GXML_DOM_TYPE_DOCUMENT (gxml_dom_document_get_type ())
#define GXML_DOM_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocument))
#define GXML_DOM_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))
#define GXML_DOM_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_DOM_TYPE_DOCUMENT))
#define GXML_DOM_DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_DOM_TYPE_DOCUMENT, GXmlDomDocumentClass))

typedef struct _GXmlDomDocument GXmlDomDocument;
typedef struct _GXmlDomDocumentClass GXmlDomDocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	GXML_DOM_DOM_ERROR_INDEX_SIZE,
	GXML_DOM_DOM_ERROR_DOMSTRING_SIZE,
	GXML_DOM_DOM_ERROR_HIERARCHY_REQUEST,
	GXML_DOM_DOM_ERROR_WRONG_DOCUMENT,
	GXML_DOM_DOM_ERROR_INVALID_CHARACTER,
	GXML_DOM_DOM_ERROR_NO_DATA_ALLOWED,
	GXML_DOM_DOM_ERROR_NO_MODIFICATION_ALLOWED,
	GXML_DOM_DOM_ERROR_NOT_FOUND,
	GXML_DOM_DOM_ERROR_NOT_SUPPORTED,
	GXML_DOM_DOM_ERROR_INUSE_ATTRIBUTE,
	GXML_DOM_DOM_ERROR_DOM,
	GXML_DOM_DOM_ERROR_INVALID_DOC,
	GXML_DOM_DOM_ERROR_INVALID_ROOT
} GXmlDomDomError;
#define GXML_DOM_DOM_ERROR gxml_dom_dom_error_quark ()
typedef enum  {
	GXML_DOM_NODE_TYPE_X_UNKNOWN = 0,
	GXML_DOM_NODE_TYPE_ELEMENT = 1,
	GXML_DOM_NODE_TYPE_ATTRIBUTE,
	GXML_DOM_NODE_TYPE_TEXT,
	GXML_DOM_NODE_TYPE_CDATA_SECTION,
	GXML_DOM_NODE_TYPE_ENTITY_REFERENCE,
	GXML_DOM_NODE_TYPE_ENTITY,
	GXML_DOM_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_DOM_NODE_TYPE_COMMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT,
	GXML_DOM_NODE_TYPE_DOCUMENT_TYPE,
	GXML_DOM_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_DOM_NODE_TYPE_NOTATION
} GXmlDomNodeType;

struct _GXmlDomNodeListIface {
	GTypeInterface parent_iface;
	GXmlDomXNode* (*item) (GXmlDomNodeList* self, gulong idx);
	void (*foreach) (GXmlDomNodeList* self, GFunc func, void* func_target);
	GXmlDomXNode* (*first) (GXmlDomNodeList* self);
	GXmlDomXNode* (*last) (GXmlDomNodeList* self);
	GXmlDomXNode* (*nth) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_data) (GXmlDomNodeList* self, gulong n);
	GXmlDomXNode* (*nth_prev) (GXmlDomNodeList* self, GXmlDomXNode* pivot, gulong n);
	gint (*find) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*find_custom) (GXmlDomNodeList* self, GXmlDomXNode* target, GCompareFunc cmp);
	gint (*position) (GXmlDomNodeList* self, GXmlDomXNode* target);
	gint (*index) (GXmlDomNodeList* self, GXmlDomXNode* target);
	GXmlDomXNode* (*insert_before) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomNodeList* self, GXmlDomXNode* old_child);
	GXmlDomXNode* (*append_child) (GXmlDomNodeList* self, GXmlDomXNode* new_child);
	gchar* (*to_string) (GXmlDomNodeList* self);
	gulong (*get_length) (GXmlDomNodeList* self);
	void (*set_length) (GXmlDomNodeList* self, gulong value);
};

struct _GXmlDomXNode {
	GObject parent_instance;
	GXmlDomXNodePrivate * priv;
};

struct _GXmlDomXNodeClass {
	GObjectClass parent_class;
	GXmlDomXNode* (*insert_before) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* ref_child, GError** error);
	GXmlDomXNode* (*replace_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*remove_child) (GXmlDomXNode* self, GXmlDomXNode* old_child, GError** error);
	GXmlDomXNode* (*append_child) (GXmlDomXNode* self, GXmlDomXNode* new_child, GError** error);
	gboolean (*has_child_nodes) (GXmlDomXNode* self);
	GXmlDomXNode* (*clone_nodes) (GXmlDomXNode* self, gboolean deep);
	const gchar* (*get_node_value) (GXmlDomXNode* self);
	void (*set_node_value) (GXmlDomXNode* self, const gchar* value);
	const gchar* (*get_node_name) (GXmlDomXNode* self);
	void (*set_node_name) (GXmlDomXNode* self, const gchar* value);
	GXmlDomNodeType (*get_node_type) (GXmlDomXNode* self);
	void (*set_node_type) (GXmlDomXNode* self, GXmlDomNodeType value);
	GXmlDomXNode* (*get_parent_node) (GXmlDomXNode* self);
	void (*set_parent_node) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomNodeList* (*get_child_nodes) (GXmlDomXNode* self);
	void (*set_child_nodes) (GXmlDomXNode* self, GXmlDomNodeList* value);
	GXmlDomXNode* (*get_first_child) (GXmlDomXNode* self);
	void (*set_first_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_last_child) (GXmlDomXNode* self);
	void (*set_last_child) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_previous_sibling) (GXmlDomXNode* self);
	void (*set_previous_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GXmlDomXNode* (*get_next_sibling) (GXmlDomXNode* self);
	void (*set_next_sibling) (GXmlDomXNode* self, GXmlDomXNode* value);
	GHashTable* (*get_attributes) (GXmlDomXNode* self);
	void (*set_attributes) (GXmlDomXNode* self, GHashTable* value);
};

struct _GXmlDomBackedNode {
	GXmlDomXNode parent_instance;
	GXmlDomBackedNodePrivate * priv;
	xmlNode* node;
};

struct _GXmlDomBackedNodeClass {
	GXmlDomXNodeClass parent_class;
};

struct _GXmlDomElement {
	GXmlDomBackedNode parent_instance;
	GXmlDomElementPrivate * priv;
};

struct _GXmlDomElementClass {
	GXmlDomBackedNodeClass parent_class;
};

struct _GXmlDomElementPrivate {
	GHashTable* _attributes;
};


static gpointer gxml_dom_element_parent_class = NULL;

GType gxml_dom_xnode_get_type (void) G_GNUC_CONST;
GQuark gxml_dom_dom_error_quark (void);
GType gxml_dom_node_type_get_type (void) G_GNUC_CONST;
GType gxml_dom_node_list_get_type (void) G_GNUC_CONST;
GType gxml_dom_attr_get_type (void) G_GNUC_CONST;
GType gxml_dom_backed_node_get_type (void) G_GNUC_CONST;
GType gxml_dom_element_get_type (void) G_GNUC_CONST;
#define GXML_DOM_ELEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GXML_DOM_TYPE_ELEMENT, GXmlDomElementPrivate))
enum  {
	GXML_DOM_ELEMENT_DUMMY_PROPERTY,
	GXML_DOM_ELEMENT_TAG_NAME,
	GXML_DOM_ELEMENT_NODE_VALUE,
	GXML_DOM_ELEMENT_ATTRIBUTES
};
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
GType gxml_dom_document_get_type (void) G_GNUC_CONST;
GXmlDomElement* gxml_dom_element_new (xmlNode* node, GXmlDomDocument* doc);
GXmlDomElement* gxml_dom_element_construct (GType object_type, xmlNode* node, GXmlDomDocument* doc);
GXmlDomBackedNode* gxml_dom_backed_node_new (xmlNode* node, GXmlDomDocument* owner);
GXmlDomBackedNode* gxml_dom_backed_node_construct (GType object_type, xmlNode* node, GXmlDomDocument* owner);
gchar* gxml_dom_element_get_attribute (GXmlDomElement* self, const gchar* name);
GHashTable* gxml_dom_xnode_get_attributes (GXmlDomXNode* self);
const gchar* gxml_dom_attr_get_value (GXmlDomAttr* self);
void gxml_dom_element_set_attribute (GXmlDomElement* self, const gchar* name, const gchar* value, GError** error);
GXmlDomDocument* gxml_dom_xnode_get_owner_document (GXmlDomXNode* self);
GXmlDomAttr* gxml_dom_document_create_attribute (GXmlDomDocument* self, const gchar* name, GError** error);
void gxml_dom_attr_set_value (GXmlDomAttr* self, const gchar* value);
void gxml_dom_element_remove_attribute (GXmlDomElement* self, const gchar* name, GError** error);
GXmlDomAttr* gxml_dom_element_get_attribute_node (GXmlDomElement* self, const gchar* name);
GXmlDomAttr* gxml_dom_element_set_attribute_node (GXmlDomElement* self, GXmlDomAttr* new_attr, GError** error);
const gchar* gxml_dom_attr_get_name (GXmlDomAttr* self);
GXmlDomAttr* gxml_dom_element_remove_attribute_node (GXmlDomElement* self, GXmlDomAttr* old_attr, GError** error);
GList* gxml_dom_element_get_elements_by_tag_name (GXmlDomElement* self, const gchar* tag_name);
GXmlDomXNode* gxml_dom_document_lookup_node (GXmlDomDocument* self, xmlNode* xmlnode);
static void _g_list_free__g_object_unref0_ (GList* self);
void gxml_dom_element_normalize (GXmlDomElement* self);
GXmlDomNodeList* gxml_dom_xnode_get_child_nodes (GXmlDomXNode* self);
GXmlDomNodeType gxml_dom_xnode_get_node_type (GXmlDomXNode* self);
const gchar* gxml_dom_element_get_tag_name (GXmlDomElement* self);
const gchar* gxml_dom_xnode_get_node_name (GXmlDomXNode* self);
static void gxml_dom_element_set_tag_name (GXmlDomElement* self, const gchar* value);
static void gxml_dom_element_finalize (GObject* obj);
const gchar* gxml_dom_xnode_get_node_value (GXmlDomXNode* self);
static void _vala_gxml_dom_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void gxml_dom_xnode_set_node_value (GXmlDomXNode* self, const gchar* value);
void gxml_dom_xnode_set_attributes (GXmlDomXNode* self, GHashTable* value);
static void _vala_gxml_dom_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


GXmlDomElement* gxml_dom_element_construct (GType object_type, xmlNode* node, GXmlDomDocument* doc) {
	GXmlDomElement * self = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (GXmlDomElement*) gxml_dom_backed_node_construct (object_type, node, doc);
	return self;
}


GXmlDomElement* gxml_dom_element_new (xmlNode* node, GXmlDomDocument* doc) {
	return gxml_dom_element_construct (GXML_DOM_TYPE_ELEMENT, node, doc);
}


/**
 * Retrieve the attribute value, as a string, for an
 * attribute associated with this element with the
 * name name.
 *
 * @param The name of the attribute whose value to retrieve.
 *
 * @return The value of the named attribute, or "" if
 * no such attribute is set.
 */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* gxml_dom_element_get_attribute (GXmlDomElement* self, const gchar* name) {
	gchar* result = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GXmlDomAttr* _tmp2_;
	GXmlDomAttr* attr;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((GXmlDomAttr*) _tmp1_);
	attr = _tmp2_;
	if (attr != NULL) {
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gxml_dom_attr_get_value (attr);
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		_g_object_unref0 (attr);
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_object_unref0 (attr);
		return result;
	}
	_g_object_unref0 (attr);
}


/**
 * Set the value of this element's attribute named
 * name to the string value.
 *
 * @param name Name of the attribute whose value to set.
 * @param value The value to set.
 */
void gxml_dom_element_set_attribute (GXmlDomElement* self, const gchar* name, const gchar* value, GError** error) {
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GXmlDomAttr* _tmp2_;
	GXmlDomAttr* attr;
	GHashTable* _tmp6_ = NULL;
	gchar* _tmp7_;
	GXmlDomAttr* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((GXmlDomAttr*) _tmp1_);
	attr = _tmp2_;
	if (attr == NULL) {
		GXmlDomDocument* _tmp3_ = NULL;
		GXmlDomAttr* _tmp4_ = NULL;
		GXmlDomAttr* _tmp5_;
		_tmp3_ = gxml_dom_xnode_get_owner_document ((GXmlDomXNode*) self);
		_tmp4_ = gxml_dom_document_create_attribute (_tmp3_, name, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == GXML_DOM_DOM_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (attr);
				return;
			} else {
				_g_object_unref0 (attr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (attr);
		attr = _tmp5_;
	}
	gxml_dom_attr_set_value (attr, value);
	_tmp6_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp7_ = g_strdup (name);
	_tmp8_ = _g_object_ref0 (attr);
	g_hash_table_replace (_tmp6_, _tmp7_, _tmp8_);
	_g_object_unref0 (attr);
}


/**
 * Remove the attribute named name from this element.
 *
 * @param name The name of the attribute to unset.
 */
void gxml_dom_element_remove_attribute (GXmlDomElement* self, const gchar* name, GError** error) {
	GHashTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	g_hash_table_remove (_tmp0_, name);
}


/**
 * Get the Attr node representing this element's attribute named name.
 *
 * @param name The name of the Attr node to retrieve.
 *
 * @return The Attr node named by name for this element.
 */
GXmlDomAttr* gxml_dom_element_get_attribute_node (GXmlDomElement* self, const gchar* name) {
	GXmlDomAttr* result = NULL;
	GHashTable* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GXmlDomAttr* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp1_ = g_hash_table_lookup (_tmp0_, name);
	_tmp2_ = _g_object_ref0 ((GXmlDomAttr*) _tmp1_);
	result = _tmp2_;
	return result;
}


/**
 * Set the attribute in Attr for this element.
 *
 * @param Attr The attribute to set.
 *
 * @return If an Attr with the same name exists, it
 * is replaced and the old Attr is returned.
 * Elsewise, null is returned.
 */
GXmlDomAttr* gxml_dom_element_set_attribute_node (GXmlDomElement* self, GXmlDomAttr* new_attr, GError** error) {
	GXmlDomAttr* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GXmlDomAttr* _tmp3_;
	GXmlDomAttr* old;
	GHashTable* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GXmlDomAttr* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (new_attr != NULL, NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp1_ = gxml_dom_attr_get_name (new_attr);
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
	_tmp3_ = _g_object_ref0 ((GXmlDomAttr*) _tmp2_);
	old = _tmp3_;
	_tmp4_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp5_ = gxml_dom_attr_get_name (new_attr);
	_tmp6_ = g_strdup (_tmp5_);
	_tmp7_ = _g_object_ref0 (new_attr);
	g_hash_table_replace (_tmp4_, _tmp6_, _tmp7_);
	result = old;
	return result;
}


/**
 * Remove Attr old_attr from this element, if it was
 * set.
 *
 * @param old_attr The Attr we are removing.
 *
 * @return The old_attr we wanted to remove, even if
 * it wasn't found.
 */
GXmlDomAttr* gxml_dom_element_remove_attribute_node (GXmlDomElement* self, GXmlDomAttr* old_attr, GError** error) {
	GXmlDomAttr* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GXmlDomAttr* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old_attr != NULL, NULL);
	_tmp0_ = gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self);
	_tmp1_ = gxml_dom_attr_get_name (old_attr);
	g_hash_table_remove (_tmp0_, _tmp1_);
	_tmp2_ = _g_object_ref0 (old_attr);
	result = _tmp2_;
	return result;
}


/**
 * Obtains a NodeList of Elements with the given
 * tag_name that are descendants of this Element.
 * This will include the current element if it
 * matches. The returned list is updated as necessary
 * as the tree changes.
 *
 * @param tag_name The tag name to match for.
 *
 * @return A NOdeList containing the matching descendants.
 */
static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


GList* gxml_dom_element_get_elements_by_tag_name (GXmlDomElement* self, const gchar* tag_name) {
	GList* result = NULL;
	GList* tagged;
	GQueue* _tmp0_ = NULL;
	GQueue* tocheck;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_name != NULL, NULL);
	tagged = NULL;
	_tmp0_ = g_queue_new ();
	tocheck = _tmp0_;
	g_queue_push_head (tocheck, GXML_DOM_BACKED_NODE (self)->node);
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		xmlNode* cur;
		_tmp1_ = g_queue_is_empty (tocheck);
		if (!(_tmp1_ == FALSE)) {
			break;
		}
		_tmp2_ = g_queue_pop_head (tocheck);
		cur = _tmp2_;
		if (g_strcmp0 (cur->name, tag_name) == 0) {
			GXmlDomDocument* _tmp3_ = NULL;
			GXmlDomXNode* _tmp4_ = NULL;
			GXmlDomXNode* _tmp5_;
			_tmp3_ = gxml_dom_xnode_get_owner_document ((GXmlDomXNode*) self);
			_tmp4_ = gxml_dom_document_lookup_node (_tmp3_, cur);
			_tmp5_ = _g_object_ref0 (_tmp4_);
			tagged = g_list_append (tagged, _tmp5_);
		}
		{
			xmlNode* child;
			child = cur->last;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					if (!_tmp6_) {
						child = child->prev;
					}
					_tmp6_ = FALSE;
					if (!(child != NULL)) {
						break;
					}
					g_queue_push_head (tocheck, child);
				}
			}
		}
	}
	result = tagged;
	_g_queue_free0 (tocheck);
	return result;
}


/**
 * This merges all adjacent Text nodes that are
 * descendants of this element. Sibling Text nodes
 * are not distinguishable in XML when stored outside
 * of the DOM.
 */
void gxml_dom_element_normalize (GXmlDomElement* self) {
	g_return_if_fail (self != NULL);
	{
		GXmlDomNodeList* _tmp0_ = NULL;
		GXmlDomNodeList* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _child_it;
		_tmp0_ = gxml_dom_xnode_get_child_nodes ((GXmlDomXNode*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_child_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			GXmlDomXNode* child;
			GXmlDomNodeType _tmp6_;
			_tmp4_ = gee_iterator_next (_child_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_child_it);
			child = (GXmlDomXNode*) _tmp5_;
			_tmp6_ = gxml_dom_xnode_get_node_type (child);
			switch (_tmp6_) {
				case GXML_DOM_NODE_TYPE_ELEMENT:
				{
					gxml_dom_element_normalize (GXML_DOM_ELEMENT (child));
					break;
				}
				case GXML_DOM_NODE_TYPE_TEXT:
				{
					break;
				}
				default:
				break;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_it);
	}
}


const gchar* gxml_dom_element_get_tag_name (GXmlDomElement* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = GXML_DOM_XNODE_CLASS (gxml_dom_element_parent_class)->get_node_name ((GXmlDomXNode*) GXML_DOM_BACKED_NODE (self));
	return result;
}


static void gxml_dom_element_set_tag_name (GXmlDomElement* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	g_object_notify ((GObject *) self, "tag-name");
}


static const gchar* gxml_dom_element_real_get_node_value (GXmlDomXNode* base) {
	const gchar* result;
	GXmlDomElement* self;
	self = (GXmlDomElement*) base;
	result = NULL;
	return result;
}


static void gxml_dom_element_real_set_node_value (GXmlDomXNode* base, const gchar* value) {
	GXmlDomElement* self;
	self = (GXmlDomElement*) base;
	g_object_notify ((GObject *) self, "node-value");
}


static GHashTable* gxml_dom_element_real_get_attributes (GXmlDomXNode* base) {
	GHashTable* result;
	GXmlDomElement* self;
	self = (GXmlDomElement*) base;
	result = self->priv->_attributes;
	return result;
}


static void gxml_dom_element_real_set_attributes (GXmlDomXNode* base, GHashTable* value) {
	GXmlDomElement* self;
	self = (GXmlDomElement*) base;
	g_object_notify ((GObject *) self, "attributes");
}


static void gxml_dom_element_class_init (GXmlDomElementClass * klass) {
	gxml_dom_element_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GXmlDomElementPrivate));
	GXML_DOM_XNODE_CLASS (klass)->get_node_value = gxml_dom_element_real_get_node_value;
	GXML_DOM_XNODE_CLASS (klass)->set_node_value = gxml_dom_element_real_set_node_value;
	GXML_DOM_XNODE_CLASS (klass)->get_attributes = gxml_dom_element_real_get_attributes;
	GXML_DOM_XNODE_CLASS (klass)->set_attributes = gxml_dom_element_real_set_attributes;
	G_OBJECT_CLASS (klass)->get_property = _vala_gxml_dom_element_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gxml_dom_element_set_property;
	G_OBJECT_CLASS (klass)->finalize = gxml_dom_element_finalize;
	/**
	 * The element's tag_name. Multiple elements can have
	 * the same tag name in a document. XML example:
	 * {{{<photos>
	 *   <img src="..." />
	 *   <img src="..." />
	 * </photos>}}}
	 * In this example, photos and img are tag names.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GXML_DOM_ELEMENT_TAG_NAME, g_param_spec_string ("tag-name", "tag-name", "tag-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	 * Elements do not have a node_value. Instead, their
	 * contents are stored in Attr attributes and in
	 * child_nodes.
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GXML_DOM_ELEMENT_NODE_VALUE, "node-value");
	/**
	 * Contains a HashTable of Attr attributes associated with this element.
	 *
	 * Attributes in the HashTable are updated live, so
	 * changes in the element's attributes through its
	 * other methods are reflected in the attributes
	 * HashTable.
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GXML_DOM_ELEMENT_ATTRIBUTES, "attributes");
}


static void gxml_dom_element_instance_init (GXmlDomElement * self) {
	GHashTable* _tmp0_ = NULL;
	self->priv = GXML_DOM_ELEMENT_GET_PRIVATE (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	self->priv->_attributes = _tmp0_;
}


static void gxml_dom_element_finalize (GObject* obj) {
	GXmlDomElement * self;
	self = GXML_DOM_ELEMENT (obj);
	_g_hash_table_unref0 (self->priv->_attributes);
	G_OBJECT_CLASS (gxml_dom_element_parent_class)->finalize (obj);
}


/**
 * Represent an XML Element node. These can have child nodes
 * of various types including other Elements. Elements can
 * have Attr attributes associated with them. Elements have
 * tag names. In addition to methods inherited from XNode,
 * Elements have additional methods for manipulating
 * attributes, as an alternative to manipulating the
 * attributes HashMap directly. For more, see:
 * [[http://www.w3.org/TR/DOM-Level-1/level-one-core.html#ID-745549614]]
 */
GType gxml_dom_element_get_type (void) {
	static volatile gsize gxml_dom_element_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_dom_element_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlDomElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_dom_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlDomElement), 0, (GInstanceInitFunc) gxml_dom_element_instance_init, NULL };
		GType gxml_dom_element_type_id;
		gxml_dom_element_type_id = g_type_register_static (GXML_DOM_TYPE_BACKED_NODE, "GXmlDomElement", &g_define_type_info, 0);
		g_once_init_leave (&gxml_dom_element_type_id__volatile, gxml_dom_element_type_id);
	}
	return gxml_dom_element_type_id__volatile;
}


static void _vala_gxml_dom_element_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GXmlDomElement * self;
	self = GXML_DOM_ELEMENT (object);
	switch (property_id) {
		case GXML_DOM_ELEMENT_TAG_NAME:
		g_value_set_string (value, gxml_dom_element_get_tag_name (self));
		break;
		case GXML_DOM_ELEMENT_NODE_VALUE:
		g_value_set_string (value, gxml_dom_xnode_get_node_value ((GXmlDomXNode*) self));
		break;
		case GXML_DOM_ELEMENT_ATTRIBUTES:
		g_value_set_boxed (value, gxml_dom_xnode_get_attributes ((GXmlDomXNode*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gxml_dom_element_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GXmlDomElement * self;
	self = GXML_DOM_ELEMENT (object);
	switch (property_id) {
		case GXML_DOM_ELEMENT_TAG_NAME:
		gxml_dom_element_set_tag_name (self, g_value_get_string (value));
		break;
		case GXML_DOM_ELEMENT_NODE_VALUE:
		gxml_dom_xnode_set_node_value ((GXmlDomXNode*) self, g_value_get_string (value));
		break;
		case GXML_DOM_ELEMENT_ATTRIBUTES:
		gxml_dom_xnode_set_attributes ((GXmlDomXNode*) self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



