/* SerializableEnum.c generated by valac 0.32.1, the Vala compiler
 * generated from SerializableEnum.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* SerializableValueList.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;

#define GXML_TYPE_SERIALIZABLE_ENUM (gxml_serializable_enum_get_type ())
#define GXML_SERIALIZABLE_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_ENUM, GXmlSerializableEnum))
#define GXML_SERIALIZABLE_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_SERIALIZABLE_ENUM, GXmlSerializableEnumClass))
#define GXML_IS_SERIALIZABLE_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_ENUM))
#define GXML_IS_SERIALIZABLE_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_SERIALIZABLE_ENUM))
#define GXML_SERIALIZABLE_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_SERIALIZABLE_ENUM, GXmlSerializableEnumClass))

typedef struct _GXmlSerializableEnum GXmlSerializableEnum;
typedef struct _GXmlSerializableEnumClass GXmlSerializableEnumClass;
typedef struct _GXmlSerializableEnumPrivate GXmlSerializableEnumPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

/**
 * Errors when de/serializing enumerations as a set of string when using {@link GXml.SerializableEnum}
 */
typedef enum  {
	GXML_SERIALIZABLE_ENUM_ERROR_INVALID_VALUE_ERROR,
	GXML_SERIALIZABLE_ENUM_ERROR_PARSE_ERROR
} GXmlSerializableEnumError;
#define GXML_SERIALIZABLE_ENUM_ERROR gxml_serializable_enum_error_quark ()
struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

typedef enum  {
	GXML_NODE_TYPE_X_UNKNOWN = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType G_GNUC_DEPRECATED;

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlSerializableEnum {
	GObject parent_instance;
	GXmlSerializableEnumPrivate * priv;
	gchar* _val;
	GType _enumtype;
};

struct _GXmlSerializableEnumClass {
	GObjectClass parent_class;
};


static gpointer gxml_serializable_enum_parent_class = NULL;
static GXmlSerializablePropertyIface* gxml_serializable_enum_gxml_serializable_property_parent_iface = NULL;

GQuark gxml_serializable_enum_error_quark (void);
GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
GType gxml_serializable_enum_get_type (void) G_GNUC_CONST;
enum  {
	GXML_SERIALIZABLE_ENUM_DUMMY_PROPERTY
};
GXmlSerializableEnum* gxml_serializable_enum_new_with_enum (GType type);
GXmlSerializableEnum* gxml_serializable_enum_construct_with_enum (GType object_type, GType type);
void gxml_serializable_enum_set_enum_type (GXmlSerializableEnum* self, GType type);
GType gxml_serializable_enum_get_enum_type (GXmlSerializableEnum* self);
void gxml_serializable_enum_parse (GXmlSerializableEnum* self, const gchar* str, GError** error);
GEnumValue* gxml_enumeration_parse (GType enumeration, const gchar* val, GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration, gint val, GError** error);
void gxml_serializable_enum_parse_integer (GXmlSerializableEnum* self, gint v, GError** error);
GEnumValue* gxml_enumeration_parse_integer (GType enumeration, gint val);
gint gxml_serializable_enum_to_integer (GXmlSerializableEnum* self, GError** error);
static gchar* gxml_serializable_enum_real_get_serializable_property_value (GXmlSerializableProperty* base);
static void gxml_serializable_enum_real_set_serializable_property_value (GXmlSerializableProperty* base, const gchar* val);
gchar* gxml_serializable_enum_to_string (GXmlSerializableEnum* self);
GXmlSerializableEnum* gxml_serializable_enum_new (void);
GXmlSerializableEnum* gxml_serializable_enum_construct (GType object_type);
static GObject * gxml_serializable_enum_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void gxml_init_init (void);
static void gxml_serializable_enum_finalize (GObject* obj);


GQuark gxml_serializable_enum_error_quark (void) {
	return g_quark_from_static_string ("gxml_serializable_enum_error-quark");
}


GXmlSerializableEnum* gxml_serializable_enum_construct_with_enum (GType object_type, GType type) {
	GXmlSerializableEnum * self = NULL;
	GType _tmp0_ = 0UL;
	self = (GXmlSerializableEnum*) g_object_new (object_type, NULL);
	_tmp0_ = type;
	self->_enumtype = _tmp0_;
	return self;
}


GXmlSerializableEnum* gxml_serializable_enum_new_with_enum (GType type) {
	return gxml_serializable_enum_construct_with_enum (GXML_TYPE_SERIALIZABLE_ENUM, type);
}


void gxml_serializable_enum_set_enum_type (GXmlSerializableEnum* self, GType type) {
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GType _tmp2_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = type;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	_vala_return_if_fail (_tmp1_, "type.is_a (Type.ENUM)");
	_tmp2_ = type;
	self->_enumtype = _tmp2_;
}


GType gxml_serializable_enum_get_enum_type (GXmlSerializableEnum* self) {
	GType result = 0UL;
	GType _tmp0_ = 0UL;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->_enumtype;
	result = _tmp0_;
	return result;
}


void gxml_serializable_enum_parse (GXmlSerializableEnum* self, const gchar* str, GError** error) {
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumValue* e = NULL;
	GType _tmp2_ = 0UL;
	const gchar* _tmp3_ = NULL;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GType _tmp7_ = 0UL;
	GEnumValue* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	_tmp0_ = self->_enumtype;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->_enumtype;
	_tmp3_ = str;
	_tmp4_ = gxml_enumeration_parse (_tmp2_, _tmp3_, &_inner_error_);
	e = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = e;
	if (_tmp5_ == NULL) {
		_g_free0 (e);
		return;
	}
	_tmp7_ = self->_enumtype;
	_tmp8_ = e;
	_tmp9_ = (*_tmp8_).value;
	_tmp10_ = gxml_enumeration_get_nick_camelcase (_tmp7_, _tmp9_, &_inner_error_);
	_tmp6_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (e);
		return;
	}
	_tmp11_ = _tmp6_;
	_tmp6_ = NULL;
	_g_free0 (self->_val);
	self->_val = _tmp11_;
	_g_free0 (_tmp6_);
	_g_free0 (e);
}


void gxml_serializable_enum_parse_integer (GXmlSerializableEnum* self, gint v, GError** error) {
	GType _tmp0_ = 0UL;
	gboolean _tmp1_ = FALSE;
	GEnumValue* e = NULL;
	GType _tmp2_ = 0UL;
	gint _tmp3_ = 0;
	GEnumValue* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GType _tmp7_ = 0UL;
	GEnumValue* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->_enumtype;
	_tmp1_ = g_type_is_a (_tmp0_, G_TYPE_ENUM);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->_enumtype;
	_tmp3_ = v;
	_tmp4_ = gxml_enumeration_parse_integer (_tmp2_, _tmp3_);
	e = _tmp4_;
	_tmp5_ = e;
	if (_tmp5_ == NULL) {
		_g_free0 (e);
		return;
	}
	_tmp7_ = self->_enumtype;
	_tmp8_ = e;
	_tmp9_ = (*_tmp8_).value;
	_tmp10_ = gxml_enumeration_get_nick_camelcase (_tmp7_, _tmp9_, &_inner_error_);
	_tmp6_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (e);
		return;
	}
	_tmp11_ = _tmp6_;
	_tmp6_ = NULL;
	_g_free0 (self->_val);
	self->_val = _tmp11_;
	_g_free0 (_tmp6_);
	_g_free0 (e);
}


gint gxml_serializable_enum_to_integer (GXmlSerializableEnum* self, GError** error) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	GEnumValue* e = NULL;
	GType _tmp3_ = 0UL;
	const gchar* _tmp4_ = NULL;
	GEnumValue* _tmp5_ = NULL;
	GEnumValue* _tmp6_ = NULL;
	GEnumValue* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->_val;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		GError* _tmp2_ = NULL;
		_tmp1_ = _ ("Value can't be parsed to a valid enumeration's value. Value is not set");
		_tmp2_ = g_error_new_literal (GXML_SERIALIZABLE_ENUM_ERROR, GXML_SERIALIZABLE_ENUM_ERROR_INVALID_VALUE_ERROR, _tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp3_ = self->_enumtype;
	_tmp4_ = self->_val;
	_tmp5_ = gxml_enumeration_parse (_tmp3_, _tmp4_, &_inner_error_);
	e = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return 0;
	}
	_tmp6_ = e;
	if (_tmp6_ == NULL) {
		const gchar* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		_tmp7_ = _ ("Value can't be parsed to a valid enumeration's value");
		_tmp8_ = g_error_new_literal (GXML_SERIALIZABLE_ENUM_ERROR, GXML_SERIALIZABLE_ENUM_ERROR_INVALID_VALUE_ERROR, _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (e);
		return 0;
	}
	_tmp9_ = e;
	_tmp10_ = (*_tmp9_).value;
	result = _tmp10_;
	_g_free0 (e);
	return result;
}


static gchar* gxml_serializable_enum_real_get_serializable_property_value (GXmlSerializableProperty* base) {
	GXmlSerializableEnum * self;
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableEnum*) base;
	_tmp0_ = self->_val;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


static void gxml_serializable_enum_real_set_serializable_property_value (GXmlSerializableProperty* base, const gchar* val) {
	GXmlSerializableEnum * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (GXmlSerializableEnum*) base;
	_tmp0_ = val;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->_val);
	self->_val = _tmp1_;
}


gchar* gxml_serializable_enum_to_string (GXmlSerializableEnum* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->_val;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


GXmlSerializableEnum* gxml_serializable_enum_construct (GType object_type) {
	GXmlSerializableEnum * self = NULL;
	self = (GXmlSerializableEnum*) g_object_new (object_type, NULL);
	return self;
}


GXmlSerializableEnum* gxml_serializable_enum_new (void) {
	return gxml_serializable_enum_construct (GXML_TYPE_SERIALIZABLE_ENUM);
}


static GObject * gxml_serializable_enum_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GXmlSerializableEnum * self;
	parent_class = G_OBJECT_CLASS (gxml_serializable_enum_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_ENUM, GXmlSerializableEnum);
	gxml_init_init ();
	return obj;
}


static void gxml_serializable_enum_class_init (GXmlSerializableEnumClass * klass) {
	gxml_serializable_enum_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gxml_serializable_enum_constructor;
	G_OBJECT_CLASS (klass)->finalize = gxml_serializable_enum_finalize;
}


static void gxml_serializable_enum_gxml_serializable_property_interface_init (GXmlSerializablePropertyIface * iface) {
	gxml_serializable_enum_gxml_serializable_property_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_serializable_property_value = (gchar* (*)(GXmlSerializableProperty*)) gxml_serializable_enum_real_get_serializable_property_value;
	iface->set_serializable_property_value = (void (*)(GXmlSerializableProperty*, const gchar*)) gxml_serializable_enum_real_set_serializable_property_value;
}


static void gxml_serializable_enum_instance_init (GXmlSerializableEnum * self) {
	self->_val = NULL;
}


static void gxml_serializable_enum_finalize (GObject* obj) {
	GXmlSerializableEnum * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_SERIALIZABLE_ENUM, GXmlSerializableEnum);
	_g_free0 (self->_val);
	G_OBJECT_CLASS (gxml_serializable_enum_parent_class)->finalize (obj);
}


/**
 * Represent any value as string but a list of enum values by default to select from.
 * property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}.
 *
 * This class makes easy to create enumerations with its representation to string,
 * but limited to the actual values of the enumeration, making it flexible for
 * values not supported now but possible because some extensions. Can be added
 * an extension element in the enumeration and return it when the supported values
 * are not met with the string representation in the property.
 */
GType gxml_serializable_enum_get_type (void) {
	static volatile gsize gxml_serializable_enum_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_enum_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializableEnumClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_enum_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlSerializableEnum), 0, (GInstanceInitFunc) gxml_serializable_enum_instance_init, NULL };
		static const GInterfaceInfo gxml_serializable_property_info = { (GInterfaceInitFunc) gxml_serializable_enum_gxml_serializable_property_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gxml_serializable_enum_type_id;
		gxml_serializable_enum_type_id = g_type_register_static (G_TYPE_OBJECT, "GXmlSerializableEnum", &g_define_type_info, 0);
		g_type_add_interface_static (gxml_serializable_enum_type_id, GXML_TYPE_SERIALIZABLE_PROPERTY, &gxml_serializable_property_info);
		g_once_init_leave (&gxml_serializable_enum_type_id__volatile, gxml_serializable_enum_type_id);
	}
	return gxml_serializable_enum_type_id__volatile;
}



