/* Enumeration.c generated by valac 0.44.3, the Vala compiler
 * generated from Enumeration.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 2 -*- */
/* Serializable.vala
 *
 + Copyright (C) 2013  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#define GXML_TYPE_ENUMERATION (gxml_enumeration_get_type ())
#define GXML_ENUMERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ENUMERATION, GXmlEnumeration))
#define GXML_ENUMERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ENUMERATION, GXmlEnumerationClass))
#define GXML_IS_ENUMERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ENUMERATION))
#define GXML_IS_ENUMERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ENUMERATION))
#define GXML_ENUMERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ENUMERATION, GXmlEnumerationClass))

typedef struct _GXmlEnumeration GXmlEnumeration;
typedef struct _GXmlEnumerationClass GXmlEnumerationClass;
typedef struct _GXmlEnumerationPrivate GXmlEnumerationPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
typedef struct _GXmlParamSpecEnumeration GXmlParamSpecEnumeration;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GXmlEnumeration {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GXmlEnumerationPrivate * priv;
};

struct _GXmlEnumerationClass {
	GTypeClass parent_class;
	void (*finalize) (GXmlEnumeration *self);
};

typedef enum  {
	GXML_ENUMERATION_ERROR_INVALID_VALUE,
	GXML_ENUMERATION_ERROR_INVALID_TEXT
} GXmlEnumerationError;
#define GXML_ENUMERATION_ERROR gxml_enumeration_error_quark ()
struct _GXmlParamSpecEnumeration {
	GParamSpec parent_instance;
};

/**
   * Errors when de/serializing enumerations.
   */

static gpointer gxml_enumeration_parent_class = NULL;

gpointer gxml_enumeration_ref (gpointer instance);
void gxml_enumeration_unref (gpointer instance);
GParamSpec* gxml_param_spec_enumeration (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void gxml_value_set_enumeration (GValue* value,
                                 gpointer v_object);
void gxml_value_take_enumeration (GValue* value,
                                  gpointer v_object);
gpointer gxml_value_get_enumeration (const GValue* value);
GType gxml_enumeration_get_type (void) G_GNUC_CONST;
gchar* gxml_enumeration_get_nick (GType enumeration,
                                  gint val,
                                  GError** error);
gchar* gxml_enumeration_get_string (GType enumeration,
                                    gint val,
                                    gboolean use_nick,
                                    gboolean camelcase,
                                    GError** error);
gchar* gxml_enumeration_get_nick_camelcase (GType enumeration,
                                            gint val,
                                            GError** error);
void gxml_init_init (void);
static GEnumValue* _g_enum_value_dup (GEnumValue* self);
GQuark gxml_enumeration_error_quark (void);
GEnumValue* gxml_enumeration_parse (GType enumeration,
                                    const gchar* val,
                                    GError** error);
GEnumValue* gxml_enumeration_to_array (GType enumeration,
                                       gint* result_length1);
GEnumValue* gxml_enumeration_parse_integer (GType enumeration,
                                            gint val);
static GEnumValue* _vala_array_dup1 (GEnumValue* self,
                              int length);
gchar** gxml_enumeration_to_string_array (GType enumeration,
                                          gint* result_length1,
                                          GError** error);
static GEnumValue* _vala_array_dup2 (GEnumValue* self,
                              int length);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
GXmlEnumeration* gxml_enumeration_new (void);
GXmlEnumeration* gxml_enumeration_construct (GType object_type);
static void gxml_enumeration_finalize (GXmlEnumeration * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

/**
 * Introspect an enumeration to get value's nick name.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @enumeration.
 */
gchar*
gxml_enumeration_get_nick (GType enumeration,
                           gint val,
                           GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = gxml_enumeration_get_string (enumeration, val, TRUE, FALSE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
 * Introspect an enumeration to get value's nick name and transform
 * to camel case representation.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @param enumeration.
 */
gchar*
gxml_enumeration_get_nick_camelcase (GType enumeration,
                                     gint val,
                                     GError** error)
{
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	_tmp1_ = gxml_enumeration_get_string (enumeration, val, FALSE, TRUE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

/**
 * Transform enumeration's value to its string representation.
 *
 * Returns: an string representing an enumeration's value.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer to parse an enum value of type @enumeration.
 * @param use_nick makes to returns value's nick name in {@link GLib.EnumClass}
 * @param camelcase makes to returns value's nick name in {@link GLib.EnumClass}
 * as camel case representation. If @use_nick is set this take no effect.
 */
static GEnumValue*
_g_enum_value_dup (GEnumValue* self)
{
	GEnumValue* dup;
	dup = g_new0 (GEnumValue, 1);
	memcpy (dup, self, sizeof (GEnumValue));
	return dup;
}

static gpointer
__g_enum_value_dup0 (gpointer self)
{
	return self ? _g_enum_value_dup (self) : NULL;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
gxml_enumeration_get_string (GType enumeration,
                             gint val,
                             gboolean use_nick,
                             gboolean camelcase,
                             GError** error)
{
	gchar* result = NULL;
	gchar* camel = NULL;
	gchar* _tmp0_;
	GEnumClass* enumc = NULL;
	GTypeClass* _tmp1_;
	GEnumValue* enumv = NULL;
	GEnumClass* _tmp2_;
	GEnumValue* _tmp3_;
	GEnumValue* _tmp4_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GError* _inner_error0_ = NULL;
	_vala_return_val_if_fail (g_type_is_a (enumeration, G_TYPE_ENUM), "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp0_ = g_strdup ("");
	camel = _tmp0_;
	_tmp1_ = g_type_class_ref (enumeration);
	enumc = (GEnumClass*) _tmp1_;
	_tmp2_ = enumc;
	_tmp3_ = __g_enum_value_dup0 (g_enum_get_value (_tmp2_, val));
	enumv = _tmp3_;
	_tmp4_ = enumv;
	if (_tmp4_ == NULL) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (GXML_ENUMERATION_ERROR, GXML_ENUMERATION_ERROR_INVALID_VALUE, _ ("value is invalid"));
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		_g_free0 (camel);
		return NULL;
	}
	if (use_nick) {
		GEnumValue* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = enumv;
		_tmp8_ = (*_tmp7_).value_nick;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GEnumValue* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = enumv;
		_tmp10_ = (*_tmp9_).value_nick;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		_g_free0 (camel);
		return result;
	}
	if (camelcase) {
		GEnumValue* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = enumv;
		_tmp14_ = (*_tmp13_).value_nick;
		_tmp12_ = _tmp14_ != NULL;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gchar** sp = NULL;
		GEnumValue* _tmp15_;
		const gchar* _tmp16_;
		gchar** _tmp17_;
		gchar** _tmp18_;
		gint sp_length1;
		gint _sp_size_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp15_ = enumv;
		_tmp16_ = (*_tmp15_).value_nick;
		_tmp18_ = _tmp17_ = g_strsplit (_tmp16_, "-", 0);
		sp = _tmp18_;
		sp_length1 = _vala_array_length (_tmp17_);
		_sp_size_ = sp_length1;
		_tmp19_ = sp;
		_tmp19__length1 = sp_length1;
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp19_;
			s_collection_length1 = _tmp19__length1;
			for (s_it = 0; s_it < _tmp19__length1; s_it = s_it + 1) {
				gchar* _tmp20_;
				gchar* s = NULL;
				_tmp20_ = g_strdup (s_collection[s_it]);
				s = _tmp20_;
				{
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					gchar* _tmp26_;
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					const gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					_tmp21_ = camel;
					_tmp22_ = s;
					_tmp23_ = g_strdup_printf ("%c", string_get (_tmp22_, (glong) 0));
					_tmp24_ = _tmp23_;
					_tmp25_ = g_utf8_strup (_tmp24_, (gssize) -1);
					_tmp26_ = _tmp25_;
					_tmp27_ = s;
					_tmp28_ = s;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = string_slice (_tmp27_, (glong) 1, (glong) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = string_to_string (_tmp32_);
					_tmp34_ = g_strconcat (_tmp26_, _tmp33_, NULL);
					_tmp35_ = _tmp34_;
					_tmp36_ = g_strconcat (_tmp21_, _tmp35_, NULL);
					_g_free0 (camel);
					camel = _tmp36_;
					_g_free0 (_tmp35_);
					_g_free0 (_tmp32_);
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
					_g_free0 (s);
				}
			}
		}
		sp = (_vala_array_free (sp, sp_length1, (GDestroyNotify) g_free), NULL);
	} else {
		GEnumValue* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		_tmp37_ = enumv;
		_tmp38_ = (*_tmp37_).value_name;
		_tmp39_ = g_strdup (_tmp38_);
		_g_free0 (camel);
		camel = _tmp39_;
	}
	result = camel;
	_g_free0 (enumv);
	_g_type_class_unref0 (enumc);
	return result;
}

/**
 * Parse @val to an enumeration's value.
 * 
 * Returns: an {@link GLib.EnumValue} representing an enumeration's value.
 * 
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val a string to parse an enum value of type @param enumeration.
 * as camel case representation. If @use_nick is set this take no effect.
 */
GEnumValue*
gxml_enumeration_parse (GType enumeration,
                        const gchar* val,
                        GError** error)
{
	GEnumValue* result = NULL;
	GEnumClass* enumc = NULL;
	GTypeClass* _tmp0_;
	GEnumValue* enumv = NULL;
	GEnumClass* _tmp1_;
	GEnumValue* _tmp2_;
	gint _tmp2__length1;
	GEnumValue* _tmp24_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (val != NULL, NULL);
	_vala_return_val_if_fail (g_type_is_a (enumeration, G_TYPE_ENUM), "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp0_ = g_type_class_ref (enumeration);
	enumc = (GEnumClass*) _tmp0_;
	enumv = NULL;
	_tmp1_ = enumc;
	_tmp2_ = _tmp1_->values;
	_tmp2__length1 = _tmp1_->n_values;
	{
		GEnumValue* ev_collection = NULL;
		gint ev_collection_length1 = 0;
		gint _ev_collection_size_ = 0;
		gint ev_it = 0;
		ev_collection = _tmp2_;
		ev_collection_length1 = _tmp2__length1;
		for (ev_it = 0; ev_it < _tmp2__length1; ev_it = ev_it + 1) {
			GEnumValue ev = {0};
			ev = ev_collection[ev_it];
			{
				GEnumValue _tmp3_;
				const gchar* _tmp4_;
				GEnumValue _tmp7_;
				const gchar* _tmp8_;
				gchar* nick = NULL;
				GEnumValue _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				gboolean _tmp21_;
				_tmp3_ = ev;
				_tmp4_ = _tmp3_.value_name;
				if (g_strcmp0 (val, _tmp4_) == 0) {
					GEnumValue _tmp5_;
					GEnumValue* _tmp6_;
					_tmp5_ = ev;
					_tmp6_ = __g_enum_value_dup0 (&_tmp5_);
					_g_free0 (enumv);
					enumv = _tmp6_;
				}
				_tmp7_ = ev;
				_tmp8_ = _tmp7_.value_nick;
				if (g_strcmp0 (val, _tmp8_) == 0) {
					GEnumValue _tmp9_;
					GEnumValue* _tmp10_;
					_tmp9_ = ev;
					_tmp10_ = __g_enum_value_dup0 (&_tmp9_);
					_g_free0 (enumv);
					enumv = _tmp10_;
				}
				_tmp11_ = ev;
				_tmp12_ = gxml_enumeration_get_nick_camelcase (enumeration, _tmp11_.value, &_inner_error0_);
				nick = _tmp12_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (enumv);
					_g_type_class_unref0 (enumc);
					return NULL;
				}
				_tmp13_ = nick;
				if (g_strcmp0 (val, _tmp13_) == 0) {
					GEnumValue _tmp14_;
					GEnumValue* _tmp15_;
					_tmp14_ = ev;
					_tmp15_ = __g_enum_value_dup0 (&_tmp14_);
					_g_free0 (enumv);
					enumv = _tmp15_;
				}
				_tmp16_ = g_utf8_strdown (val, (gssize) -1);
				_tmp17_ = _tmp16_;
				_tmp18_ = nick;
				_tmp19_ = g_utf8_strdown (_tmp18_, (gssize) -1);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strcmp0 (_tmp17_, _tmp20_) == 0;
				_g_free0 (_tmp20_);
				_g_free0 (_tmp17_);
				if (_tmp21_) {
					GEnumValue _tmp22_;
					GEnumValue* _tmp23_;
					_tmp22_ = ev;
					_tmp23_ = __g_enum_value_dup0 (&_tmp22_);
					_g_free0 (enumv);
					enumv = _tmp23_;
				}
				_g_free0 (nick);
			}
		}
	}
	_tmp24_ = enumv;
	if (_tmp24_ == NULL) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		_tmp25_ = g_type_name (enumeration);
		_tmp26_ = g_strconcat (_ ("text cannot be parsed to enumeration type:"), _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (GXML_ENUMERATION_ERROR, GXML_ENUMERATION_ERROR_INVALID_TEXT, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_inner_error0_ = _tmp29_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (enumv);
		_g_type_class_unref0 (enumc);
		return NULL;
	}
	result = enumv;
	_g_type_class_unref0 (enumc);
	return result;
}

/**
 * Transform an enumeration in an array of {@link GLib.EnumValue}.
 * 
 * Returns: an array of {@link GLib.EnumValue} representing an enumeration.
 * 
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 */
GEnumValue*
gxml_enumeration_to_array (GType enumeration,
                           gint* result_length1)
{
	GEnumValue* result = NULL;
	GEnumClass* enumc = NULL;
	GTypeClass* _tmp0_;
	GEnumValue* _tmp1_;
	gint _tmp1__length1;
	GEnumValue* _tmp2_;
	gint _tmp2__length1;
	_vala_return_val_if_fail (g_type_is_a (enumeration, G_TYPE_ENUM), "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp0_ = g_type_class_ref (enumeration);
	enumc = (GEnumClass*) _tmp0_;
	_tmp1_ = enumc->values;
	_tmp1__length1 = enumc->n_values;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	_g_type_class_unref0 (enumc);
	return result;
}

/**
 * From a integer valuer calculates a valid {@link GLib.EnumValue} for a
 * {@link GLib.Type}. 
 *
 * Returns: a {@link GLib.EnumValue} or null if fails.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 * @param val an integer in a valid range in the enumeration.
 */
static GEnumValue*
_vala_array_dup1 (GEnumValue* self,
                  int length)
{
	return g_memdup (self, length * sizeof (GEnumValue));
}

GEnumValue*
gxml_enumeration_parse_integer (GType enumeration,
                                gint val)
{
	GEnumValue* result = NULL;
	GEnumValue* vals = NULL;
	gint _tmp0_ = 0;
	GEnumValue* _tmp1_;
	GEnumValue* _tmp2_;
	gint _tmp2__length1;
	gint vals_length1;
	gint _vals_size_;
	GEnumValue* _tmp3_;
	gint _tmp3__length1;
	gxml_init_init ();
	if (!g_type_is_a (enumeration, G_TYPE_ENUM)) {
		result = NULL;
		return result;
	}
	_tmp1_ = gxml_enumeration_to_array (enumeration, &_tmp0_);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp0_) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp0_;
	vals = _tmp2_;
	vals_length1 = _tmp2__length1;
	_vals_size_ = vals_length1;
	_tmp3_ = vals;
	_tmp3__length1 = vals_length1;
	if (_tmp3_ == NULL) {
		result = NULL;
		vals = (g_free (vals), NULL);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GEnumValue* _tmp6_;
				gint _tmp6__length1;
				GEnumValue e = {0};
				GEnumValue* _tmp7_;
				gint _tmp7__length1;
				GEnumValue _tmp8_;
				GEnumValue _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = vals;
				_tmp6__length1 = vals_length1;
				if (!(i < _tmp6__length1)) {
					break;
				}
				_tmp7_ = vals;
				_tmp7__length1 = vals_length1;
				_tmp8_ = _tmp7_[i];
				e = _tmp8_;
				_tmp9_ = e;
				if (_tmp9_.value == val) {
					GEnumValue* _tmp10_;
					_tmp10_ = __g_enum_value_dup0 (&e);
					result = _tmp10_;
					vals = (g_free (vals), NULL);
					return result;
				}
			}
		}
	}
	result = NULL;
	vals = (g_free (vals), NULL);
	return result;
}

/**
 * Transform an enumeration in an array of strings representing enumeration values.
 *
 * Returns: an array of strings representing an enumeration.
 *
 * @param enumeration a {@link GLib.Type} of type {@link GLib.Type.ENUM}
 */
static GEnumValue*
_vala_array_dup2 (GEnumValue* self,
                  int length)
{
	return g_memdup (self, length * sizeof (GEnumValue));
}

static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar**
gxml_enumeration_to_string_array (GType enumeration,
                                  gint* result_length1,
                                  GError** error)
{
	gchar** result = NULL;
	GEnumValue* vals = NULL;
	gint _tmp0_ = 0;
	GEnumValue* _tmp1_;
	GEnumValue* _tmp2_;
	gint _tmp2__length1;
	gint vals_length1;
	gint _vals_size_;
	gchar** s = NULL;
	gchar** _tmp3_;
	gint s_length1;
	gint _s_size_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GError* _inner_error0_ = NULL;
	_vala_return_val_if_fail (g_type_is_a (enumeration, G_TYPE_ENUM), "enumeration.is_a (Type.ENUM)", NULL);
	gxml_init_init ();
	_tmp1_ = gxml_enumeration_to_array (enumeration, &_tmp0_);
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup2 (_tmp1_, _tmp0_) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp0_;
	vals = _tmp2_;
	vals_length1 = _tmp2__length1;
	_vals_size_ = vals_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	s = _tmp3_;
	s_length1 = 0;
	_s_size_ = s_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GEnumValue* _tmp6_;
				gint _tmp6__length1;
				gchar* _tmp7_ = NULL;
				GEnumValue* _tmp8_;
				gint _tmp8__length1;
				GEnumValue _tmp9_;
				gchar* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				gchar* _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = vals;
				_tmp6__length1 = vals_length1;
				if (!(i < _tmp6__length1)) {
					break;
				}
				_tmp8_ = vals;
				_tmp8__length1 = vals_length1;
				_tmp9_ = _tmp8_[i];
				_tmp10_ = gxml_enumeration_get_nick_camelcase (enumeration, _tmp9_.value, &_inner_error0_);
				_tmp7_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					s = (_vala_array_free (s, s_length1, (GDestroyNotify) g_free), NULL);
					vals = (g_free (vals), NULL);
					return NULL;
				}
				_tmp11_ = s;
				_tmp11__length1 = s_length1;
				_tmp12_ = _tmp7_;
				_tmp7_ = NULL;
				_vala_array_add2 (&s, &s_length1, &_s_size_, _tmp12_);
				_g_free0 (_tmp7_);
			}
		}
	}
	_tmp13_ = s;
	_tmp13__length1 = s_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	vals = (g_free (vals), NULL);
	return result;
}

GXmlEnumeration*
gxml_enumeration_construct (GType object_type)
{
	GXmlEnumeration* self = NULL;
	self = (GXmlEnumeration*) g_type_create_instance (object_type);
	return self;
}

GXmlEnumeration*
gxml_enumeration_new (void)
{
	return gxml_enumeration_construct (GXML_TYPE_ENUMERATION);
}

static void
gxml_value_enumeration_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gxml_value_enumeration_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gxml_enumeration_unref (value->data[0].v_pointer);
	}
}

static void
gxml_value_enumeration_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gxml_enumeration_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gxml_value_enumeration_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gxml_value_enumeration_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GXmlEnumeration * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gxml_enumeration_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gxml_value_enumeration_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	GXmlEnumeration ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gxml_enumeration_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gxml_param_spec_enumeration (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	GXmlParamSpecEnumeration* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GXML_TYPE_ENUMERATION), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gxml_value_get_enumeration (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION), NULL);
	return value->data[0].v_pointer;
}

void
gxml_value_set_enumeration (GValue* value,
                            gpointer v_object)
{
	GXmlEnumeration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GXML_TYPE_ENUMERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gxml_enumeration_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gxml_enumeration_unref (old);
	}
}

void
gxml_value_take_enumeration (GValue* value,
                             gpointer v_object)
{
	GXmlEnumeration * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GXML_TYPE_ENUMERATION));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GXML_TYPE_ENUMERATION));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gxml_enumeration_unref (old);
	}
}

static void
gxml_enumeration_class_init (GXmlEnumerationClass * klass,
                             gpointer klass_data)
{
	gxml_enumeration_parent_class = g_type_class_peek_parent (klass);
	((GXmlEnumerationClass *) klass)->finalize = gxml_enumeration_finalize;
}

static void
gxml_enumeration_instance_init (GXmlEnumeration * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
gxml_enumeration_finalize (GXmlEnumeration * obj)
{
	GXmlEnumeration * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GXML_TYPE_ENUMERATION, GXmlEnumeration);
	g_signal_handlers_destroy (self);
}

/**
 * Convenient static methods for enumeration serialization to string.
 * 
 * Enumerations have a set of utility methods to better represent on
 * serialisation/deserialization.
 * 
 * Enumerations could be converted to string using its definition on {@link GLib.EnumClass},
 * by taking its nick name directly or converting to its camel case representation.
 * 
 * Any enumeration value type in a <code>GLib.Object</code>'s property could be
 * deserialized from its definition given on {@link GLib.EnumClass} (name and
 * nick) or from its camel case representation.
 */
GType
gxml_enumeration_get_type (void)
{
	static volatile gsize gxml_enumeration_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_enumeration_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gxml_value_enumeration_init, gxml_value_enumeration_free_value, gxml_value_enumeration_copy_value, gxml_value_enumeration_peek_pointer, "p", gxml_value_enumeration_collect_value, "p", gxml_value_enumeration_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GXmlEnumerationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_enumeration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlEnumeration), 0, (GInstanceInitFunc) gxml_enumeration_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gxml_enumeration_type_id;
		gxml_enumeration_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GXmlEnumeration", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gxml_enumeration_type_id__volatile, gxml_enumeration_type_id);
	}
	return gxml_enumeration_type_id__volatile;
}

gpointer
gxml_enumeration_ref (gpointer instance)
{
	GXmlEnumeration * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gxml_enumeration_unref (gpointer instance)
{
	GXmlEnumeration * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GXML_ENUMERATION_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

GQuark
gxml_enumeration_error_quark (void)
{
	return g_quark_from_static_string ("gxml-enumeration-error-quark");
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

