/* Node.c generated by valac 0.44.3, the Vala compiler
 * generated from Node.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 0; tab-width: 2 -*- */
/* ObjectModel.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;
typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_TEXT (gxml_text_get_type ())
#define GXML_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_TEXT, GXmlText))
#define GXML_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_TEXT))
#define GXML_TEXT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_TEXT, GXmlTextIface))

typedef struct _GXmlText GXmlText;
typedef struct _GXmlTextIface GXmlTextIface;

#define GXML_TYPE_NODE_LIST (gxml_node_list_get_type ())
#define GXML_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE_LIST, GXmlNodeList))
#define GXML_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_NODE_LIST, GXmlNodeListClass))
#define GXML_IS_NODE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE_LIST))
#define GXML_IS_NODE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_NODE_LIST))
#define GXML_NODE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_NODE_LIST, GXmlNodeListClass))

typedef struct _GXmlNodeList GXmlNodeList;
typedef struct _GXmlNodeListClass GXmlNodeListClass;
typedef struct _GXmlNodeListPrivate GXmlNodeListPrivate;
enum  {
	GXML_NODE_LIST_0_PROPERTY,
	GXML_NODE_LIST_NUM_PROPERTIES
};
static GParamSpec* gxml_node_list_properties[GXML_NODE_LIST_NUM_PROPERTIES];

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlTextIface {
	GTypeInterface parent_iface;
	gchar* (*get_str) (GXmlText* self);
	void (*set_str) (GXmlText* self, const gchar* value);
};

struct _GXmlNodeList {
	GeeArrayList parent_instance;
	GXmlNodeListPrivate * priv;
};

struct _GXmlNodeListClass {
	GeeArrayListClass parent_class;
};

static gpointer gxml_node_list_parent_class = NULL;

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_node_get (GXmlNode* self,
                         const gchar* key);
static GXmlNode* gxml_node_real_get (GXmlNode* self,
                              const gchar* key);
GeeBidirList* gxml_node_get_children_nodes (GXmlNode* self);
gchar* gxml_node_get_name (GXmlNode* self);
GXmlElementList* gxml_node_get_elements_by_property_value (GXmlNode* self,
                                                           const gchar* property,
                                                           const gchar* value);
static GXmlElementList* gxml_node_real_get_elements_by_property_value (GXmlNode* self,
                                                                const gchar* property,
                                                                const gchar* value);
GXmlElementList* gxml_element_list_new (void);
GXmlElementList* gxml_element_list_construct (GType object_type);
GType gxml_element_get_type (void) G_GNUC_CONST;
GeeMap* gxml_node_get_attrs (GXmlNode* self);
gchar* gxml_node_get_value (GXmlNode* self);
GXmlElementList* gxml_node_get_elements_by_name (GXmlNode* self,
                                                 const gchar* name);
static GXmlElementList* gxml_node_real_get_elements_by_name (GXmlNode* self,
                                                      const gchar* name);
GXmlElementList* gxml_node_get_elements_by_name_ns (GXmlNode* self,
                                                    const gchar* name,
                                                    const gchar* ns);
static GXmlElementList* gxml_node_real_get_elements_by_name_ns (GXmlNode* self,
                                                         const gchar* name,
                                                         const gchar* ns);
GeeList* gxml_node_get_namespaces (GXmlNode* self);
gchar* gxml_namespace_get_uri (GXmlNamespace* self);
gchar* gxml_node_to_string (GXmlNode* self);
gboolean gxml_node_set_namespace (GXmlNode* self,
                                  const gchar* uri,
                                  const gchar* prefix);
gchar* gxml_node_ns_prefix (GXmlNode* self);
static gchar* gxml_node_real_ns_prefix (GXmlNode* self);
gchar* gxml_namespace_get_prefix (GXmlNamespace* self);
gchar* gxml_node_ns_uri (GXmlNode* self);
static gchar* gxml_node_real_ns_uri (GXmlNode* self);
gboolean gxml_node_copy (GXmlDocument* doc,
                         GXmlNode* node,
                         GXmlNode* source,
                         gboolean deep);
void gxml_element_set_attr (GXmlElement* self,
                            const gchar* name,
                            const gchar* value);
GXmlNode* gxml_document_create_element (GXmlDocument* self,
                                        const gchar* name,
                                        GError** error);
GType gxml_text_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_document_create_text (GXmlDocument* self,
                                     const gchar* text);
void gxml_node_set_value (GXmlNode* self,
                          const gchar* value);
GXmlNodeType gxml_node_get_type_node (GXmlNode* self);
GXmlDocument* gxml_node_get_document (GXmlNode* self);
GXmlNode* gxml_node_get_parent (GXmlNode* self);
GType gxml_node_list_get_type (void) G_GNUC_CONST;
GXmlNode* gxml_node_list_get (GXmlNodeList* self,
                              gint index);
GXmlNode** gxml_node_list_to_array (GXmlNodeList* self,
                                    gint* result_length1);
GXmlNodeList* gxml_node_list_new (void);
GXmlNodeList* gxml_node_list_construct (GType object_type);

/**
   * Get first child with given name, or null. 
   */
static GXmlNode*
gxml_node_real_get (GXmlNode* self,
                    const gchar* key)
{
	GXmlNode* result = NULL;
	g_return_val_if_fail (key != NULL, NULL);
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp0_;
		GeeBidirList* _tmp1_;
		gint _child_size = 0;
		GeeBidirList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = gxml_node_get_children_nodes (self);
		_tmp1_ = _tmp0_;
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			GXmlNode* child = NULL;
			GeeBidirList* _tmp5_;
			gpointer _tmp6_;
			GXmlNode* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gboolean _tmp11_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp5_ = _child_list;
			_tmp6_ = gee_list_get ((GeeList*) _tmp5_, _child_index);
			child = (GXmlNode*) _tmp6_;
			_tmp7_ = child;
			_tmp8_ = gxml_node_get_name (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strcmp0 (_tmp10_, key) == 0;
			_g_free0 (_tmp10_);
			if (_tmp11_) {
				result = child;
				_g_object_unref0 (_child_list);
				return result;
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = NULL;
	return result;
}

GXmlNode*
gxml_node_get (GXmlNode* self,
               const gchar* key)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get (self, key);
}

/**
   * Search all child {@link GXml.Element} with a given property's name and with
   * value contained in text.
   */
static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GXmlElementList*
gxml_node_real_get_elements_by_property_value (GXmlNode* self,
                                               const gchar* property,
                                               const gchar* value)
{
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_;
	g_return_val_if_fail (property != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp1_;
		GeeBidirList* _tmp2_;
		gint _child_size = 0;
		GeeBidirList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _child_index = 0;
		_tmp1_ = gxml_node_get_children_nodes (self);
		_tmp2_ = _tmp1_;
		_child_list = _tmp2_;
		_tmp3_ = _child_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_child_size = _tmp5_;
		_child_index = -1;
		while (TRUE) {
			GXmlNode* child = NULL;
			GeeBidirList* _tmp6_;
			gpointer _tmp7_;
			GXmlNode* _tmp8_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp6_ = _child_list;
			_tmp7_ = gee_list_get ((GeeList*) _tmp6_, _child_index);
			child = (GXmlNode*) _tmp7_;
			_tmp8_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp9_;
				GXmlNode* _tmp10_;
				GXmlElementList* _tmp11_;
				GeeCollection* _tmp12_;
				GeeCollection* _tmp13_;
				GXmlNode* _tmp14_;
				GeeMap* _tmp15_;
				GeeMap* _tmp16_;
				GeeMap* _tmp17_;
				gboolean _tmp18_;
				GXmlNode* cls = NULL;
				GXmlNode* _tmp19_;
				GeeMap* _tmp20_;
				GeeMap* _tmp21_;
				GeeMap* _tmp22_;
				gpointer _tmp23_;
				GXmlNode* _tmp24_;
				GXmlNode* _tmp25_;
				GXmlNode* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				gchar* _tmp29_;
				gboolean _tmp30_;
				_tmp9_ = list;
				_tmp10_ = child;
				_tmp11_ = gxml_node_get_elements_by_property_value (_tmp10_, property, value);
				_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp11_) : NULL;
				if (_tmp12_ == NULL) {
					_g_object_unref0 (_tmp11_);
				}
				_tmp13_ = _tmp12_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp9_) : NULL, _tmp13_);
				_g_object_unref0 (_tmp13_);
				_tmp14_ = child;
				_tmp15_ = gxml_node_get_attrs (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_ == NULL;
				_g_object_unref0 (_tmp17_);
				if (_tmp18_) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp19_ = child;
				_tmp20_ = gxml_node_get_attrs (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp23_ = gee_map_get (_tmp22_, property);
				_tmp24_ = (GXmlNode*) _tmp23_;
				_g_object_unref0 (_tmp22_);
				cls = _tmp24_;
				_tmp25_ = cls;
				if (_tmp25_ == NULL) {
					_g_object_unref0 (cls);
					_g_object_unref0 (child);
					continue;
				}
				_tmp26_ = cls;
				_tmp27_ = gxml_node_get_value (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = _tmp28_;
				_tmp30_ = string_contains (_tmp29_, value);
				_g_free0 (_tmp29_);
				if (_tmp30_) {
					GXmlElementList* _tmp31_;
					GXmlNode* _tmp32_;
					_tmp31_ = list;
					_tmp32_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GXML_TYPE_ELEMENT, GXmlElement));
				}
				_g_object_unref0 (cls);
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}

GXmlElementList*
gxml_node_get_elements_by_property_value (GXmlNode* self,
                                          const gchar* property,
                                          const gchar* value)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_property_value (self, property, value);
}

/**
   * Search all child {@link GXml.Element} with a given name.
   */
static GXmlElementList*
gxml_node_real_get_elements_by_name (GXmlNode* self,
                                     const gchar* name)
{
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_ELEMENT)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_DOCUMENT);
	}
	if (!_tmp1_) {
		result = list;
		return result;
	}
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp2_;
		GeeBidirList* _tmp3_;
		gint _child_size = 0;
		GeeBidirList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _child_index = 0;
		_tmp2_ = gxml_node_get_children_nodes (self);
		_tmp3_ = _tmp2_;
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			GXmlNode* child = NULL;
			GeeBidirList* _tmp7_;
			gpointer _tmp8_;
			GXmlNode* _tmp9_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp7_ = _child_list;
			_tmp8_ = gee_list_get ((GeeList*) _tmp7_, _child_index);
			child = (GXmlNode*) _tmp8_;
			_tmp9_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp10_;
				GXmlNode* _tmp11_;
				GXmlElementList* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				GXmlNode* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gboolean _tmp19_;
				_tmp10_ = list;
				_tmp11_ = child;
				_tmp12_ = gxml_node_get_elements_by_name (_tmp11_, name);
				_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp12_) : NULL;
				if (_tmp13_ == NULL) {
					_g_object_unref0 (_tmp12_);
				}
				_tmp14_ = _tmp13_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp10_) : NULL, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_tmp15_ = child;
				_tmp16_ = gxml_node_get_name (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strcmp0 (name, _tmp18_) == 0;
				_g_free0 (_tmp18_);
				if (_tmp19_) {
					GXmlElementList* _tmp20_;
					GXmlNode* _tmp21_;
					_tmp20_ = list;
					_tmp21_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GXML_TYPE_ELEMENT, GXmlElement));
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}

GXmlElementList*
gxml_node_get_elements_by_name (GXmlNode* self,
                                const gchar* name)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_name (self, name);
}

/**
   * Search all child {@link GXml.Element} with a given name and namespace URI.
   */
static GXmlElementList*
gxml_node_real_get_elements_by_name_ns (GXmlNode* self,
                                        const gchar* name,
                                        const gchar* ns)
{
	GXmlElementList* result = NULL;
	GXmlElementList* list = NULL;
	GXmlElementList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gxml_element_list_new ();
	list = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_ELEMENT)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (self, GXML_TYPE_DOCUMENT);
	}
	if (!_tmp1_) {
		result = list;
		return result;
	}
	{
		GeeBidirList* _child_list = NULL;
		GeeBidirList* _tmp2_;
		GeeBidirList* _tmp3_;
		gint _child_size = 0;
		GeeBidirList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _child_index = 0;
		_tmp2_ = gxml_node_get_children_nodes (self);
		_tmp3_ = _tmp2_;
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			GXmlNode* child = NULL;
			GeeBidirList* _tmp7_;
			gpointer _tmp8_;
			GXmlNode* _tmp9_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp7_ = _child_list;
			_tmp8_ = gee_list_get ((GeeList*) _tmp7_, _child_index);
			child = (GXmlNode*) _tmp8_;
			_tmp9_ = child;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, GXML_TYPE_ELEMENT)) {
				GXmlElementList* _tmp10_;
				GXmlNode* _tmp11_;
				GXmlElementList* _tmp12_;
				GeeCollection* _tmp13_;
				GeeCollection* _tmp14_;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				GXmlNode* _tmp17_;
				GeeList* _tmp18_;
				GeeList* _tmp19_;
				GeeList* _tmp20_;
				gboolean _tmp21_;
				gboolean _tmp28_ = FALSE;
				GXmlNode* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				_tmp10_ = list;
				_tmp11_ = child;
				_tmp12_ = gxml_node_get_elements_by_name (_tmp11_, name);
				_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp12_) : NULL;
				if (_tmp13_ == NULL) {
					_g_object_unref0 (_tmp12_);
				}
				_tmp14_ = _tmp13_;
				gee_collection_add_all (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GEE_TYPE_COLLECTION) ? ((GeeCollection*) _tmp10_) : NULL, _tmp14_);
				_g_object_unref0 (_tmp14_);
				_tmp17_ = child;
				_tmp18_ = gxml_node_get_namespaces (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_ == NULL;
				_g_object_unref0 (_tmp20_);
				if (_tmp21_) {
					GXmlNode* _tmp22_;
					GeeList* _tmp23_;
					GeeList* _tmp24_;
					GeeList* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					_tmp22_ = child;
					_tmp23_ = gxml_node_get_namespaces (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp25_ = _tmp24_;
					_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp16_ = _tmp27_ != 0;
					_g_object_unref0 (_tmp25_);
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					_tmp15_ = ns == NULL;
				} else {
					_tmp15_ = FALSE;
				}
				if (!_tmp15_) {
					_g_object_unref0 (child);
					continue;
				}
				_tmp29_ = child;
				_tmp30_ = gxml_node_get_name (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (name, _tmp32_) == 0;
				_g_free0 (_tmp32_);
				if (_tmp33_) {
					GXmlNode* _tmp34_;
					GeeList* _tmp35_;
					GeeList* _tmp36_;
					GeeList* _tmp37_;
					gpointer _tmp38_;
					GXmlNamespace* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp34_ = child;
					_tmp35_ = gxml_node_get_namespaces (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = _tmp36_;
					_tmp38_ = gee_list_get (_tmp37_, 0);
					_tmp39_ = (GXmlNamespace*) _tmp38_;
					_tmp40_ = gxml_namespace_get_uri (_tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = _tmp41_;
					_tmp28_ = g_strcmp0 (_tmp42_, ns) == 0;
					_g_free0 (_tmp42_);
					_g_object_unref0 (_tmp39_);
					_g_object_unref0 (_tmp37_);
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					GXmlElementList* _tmp43_;
					GXmlNode* _tmp44_;
					_tmp43_ = list;
					_tmp44_ = child;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, GXML_TYPE_ELEMENT, GXmlElement));
				}
			}
			_g_object_unref0 (child);
		}
		_g_object_unref0 (_child_list);
	}
	result = list;
	return result;
}

GXmlElementList*
gxml_node_get_elements_by_name_ns (GXmlNode* self,
                                   const gchar* name,
                                   const gchar* ns)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_elements_by_name_ns (self, name, ns);
}

/**
   * Node's string representation.
   */
gchar*
gxml_node_to_string (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->to_string (self);
}

/**
   * Set a namespace to this node.
   *
   * Search for existing document's namespaces and applies it if found or creates
   * a new one, appending to document's namespaces collection.
   */
gboolean
gxml_node_set_namespace (GXmlNode* self,
                         const gchar* uri,
                         const gchar* prefix)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_NODE_GET_INTERFACE (self)->set_namespace (self, uri, prefix);
}

/**
   * Node's defaults namespace's prefix.
   *
   * This allways returns first {@link GXml.Namespace}'s prefix in {@link GXml.Node}'s
    * namespaces collection.
   */
static gchar*
gxml_node_real_ns_prefix (GXmlNode* self)
{
	gchar* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gpointer _tmp3_;
	GXmlNamespace* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_first (_tmp2_);
	_tmp4_ = (GXmlNamespace*) _tmp3_;
	_tmp5_ = gxml_namespace_get_prefix (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}

gchar*
gxml_node_ns_prefix (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_prefix (self);
}

/**
   * Node's defaults namespace's URI.
   *
   * This allways returns first {@link GXml.Namespace}'s URI in {@link GXml.Node}'s
   * namespaces collection.
   */
static gchar*
gxml_node_real_ns_uri (GXmlNode* self)
{
	gchar* result = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	gpointer _tmp3_;
	GXmlNamespace* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	_tmp0_ = gxml_node_get_namespaces (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_list_first (_tmp2_);
	_tmp4_ = (GXmlNamespace*) _tmp3_;
	_tmp5_ = gxml_namespace_get_uri (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	result = _tmp7_;
	return result;
}

gchar*
gxml_node_ns_uri (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->ns_uri (self);
}

/**
   * Copy a {@link GXml.Node} relaying on {@link GXml.Document} to other {@link GXml.Node}.
   *
   * {@link node} could belongs from different {@link GXml.Document}, while source is a node
   * belonging to given document.
   *
   * Only {@link GXml.Element} objects are supported. For attributes, use
   * {@link GXml.Element.set_attr} method, passing source's name and value as arguments.
   *
   * @param doc a {@link GXml.Document} owning destiny node
   * @param node a {@link GXml.Element} to copy nodes to
   * @param source a {@link GXml.Element} to copy nodes from, it could be holded by different {@link GXml.Document}
   */
gboolean
gxml_node_copy (GXmlDocument* doc,
                GXmlNode* node,
                GXmlNode* source,
                gboolean deep)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (doc != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_DOCUMENT)) {
		result = FALSE;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (source, GXML_TYPE_ELEMENT)) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (node, GXML_TYPE_ELEMENT);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			GeeIterator* _p_it = NULL;
			GeeMap* _tmp1_;
			GeeMap* _tmp2_;
			GeeMap* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeCollection* _tmp6_;
			GeeIterator* _tmp7_;
			GeeIterator* _tmp8_;
			_tmp1_ = gxml_node_get_attrs (source);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_map_get_values (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = _tmp5_;
			_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
			_tmp8_ = _tmp7_;
			_g_object_unref0 (_tmp6_);
			_g_object_unref0 (_tmp3_);
			_p_it = _tmp8_;
			while (TRUE) {
				GeeIterator* _tmp9_;
				GXmlNode* p = NULL;
				GeeIterator* _tmp10_;
				gpointer _tmp11_;
				GXmlNode* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				GXmlNode* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp9_ = _p_it;
				if (!gee_iterator_next (_tmp9_)) {
					break;
				}
				_tmp10_ = _p_it;
				_tmp11_ = gee_iterator_get (_tmp10_);
				p = (GXmlNode*) _tmp11_;
				_tmp12_ = p;
				_tmp13_ = gxml_node_get_name (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = _tmp14_;
				_tmp16_ = p;
				_tmp17_ = gxml_node_get_value (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = _tmp18_;
				gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (node, GXML_TYPE_ELEMENT, GXmlElement), _tmp15_, _tmp19_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (p);
			}
			_g_object_unref0 (_p_it);
		}
		if (!deep) {
			result = TRUE;
			return result;
		}
		{
			GeeBidirList* _c_list = NULL;
			GeeBidirList* _tmp20_;
			GeeBidirList* _tmp21_;
			gint _c_size = 0;
			GeeBidirList* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			gint _c_index = 0;
			_tmp20_ = gxml_node_get_children_nodes (source);
			_tmp21_ = _tmp20_;
			_c_list = _tmp21_;
			_tmp22_ = _c_list;
			_tmp23_ = gee_collection_get_size ((GeeCollection*) _tmp22_);
			_tmp24_ = _tmp23_;
			_c_size = _tmp24_;
			_c_index = -1;
			while (TRUE) {
				GXmlNode* c = NULL;
				GeeBidirList* _tmp25_;
				gpointer _tmp26_;
				GXmlNode* _tmp27_;
				GXmlNode* _tmp46_;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp25_ = _c_list;
				_tmp26_ = gee_list_get ((GeeList*) _tmp25_, _c_index);
				c = (GXmlNode*) _tmp26_;
				_tmp27_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, GXML_TYPE_ELEMENT)) {
					GXmlNode* _tmp28_;
					gchar* _tmp29_;
					gchar* _tmp30_;
					gchar* _tmp31_;
					gboolean _tmp32_;
					_tmp28_ = c;
					_tmp29_ = gxml_node_get_name (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = _tmp30_;
					_tmp32_ = _tmp31_ == NULL;
					_g_free0 (_tmp31_);
					if (_tmp32_) {
						_g_object_unref0 (c);
						continue;
					}
					{
						GXmlNode* e = NULL;
						GXmlNode* _tmp33_;
						gchar* _tmp34_;
						gchar* _tmp35_;
						gchar* _tmp36_;
						GXmlNode* _tmp37_;
						GXmlNode* _tmp38_;
						GeeBidirList* _tmp39_;
						GeeBidirList* _tmp40_;
						GeeBidirList* _tmp41_;
						GXmlNode* _tmp42_;
						GXmlNode* _tmp43_;
						GXmlNode* _tmp44_;
						_tmp33_ = c;
						_tmp34_ = gxml_node_get_name (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = _tmp35_;
						_tmp37_ = gxml_document_create_element (doc, _tmp36_, &_inner_error0_);
						_tmp38_ = _tmp37_;
						_g_free0 (_tmp36_);
						e = _tmp38_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch0_g_error;
						}
						_tmp39_ = gxml_node_get_children_nodes (node);
						_tmp40_ = _tmp39_;
						_tmp41_ = _tmp40_;
						_tmp42_ = e;
						gee_collection_add ((GeeCollection*) _tmp41_, _tmp42_);
						_g_object_unref0 (_tmp41_);
						_tmp43_ = e;
						_tmp44_ = c;
						gxml_node_copy (doc, _tmp43_, _tmp44_, deep);
						_g_object_unref0 (e);
					}
					goto __finally0;
					__catch0_g_error:
					{
						g_clear_error (&_inner_error0_);
						_inner_error0_ = NULL;
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						gboolean _tmp45_ = FALSE;
						_g_object_unref0 (c);
						_g_object_unref0 (_c_list);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return _tmp45_;
					}
				}
				_tmp46_ = c;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, GXML_TYPE_TEXT)) {
					GXmlNode* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					gchar* _tmp50_;
					gboolean _tmp51_;
					GXmlNode* t = NULL;
					GXmlNode* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					gchar* _tmp55_;
					GXmlNode* _tmp56_;
					GXmlNode* _tmp57_;
					GeeBidirList* _tmp58_;
					GeeBidirList* _tmp59_;
					GeeBidirList* _tmp60_;
					GXmlNode* _tmp61_;
					_tmp47_ = c;
					_tmp48_ = gxml_node_get_value (_tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = _tmp49_;
					_tmp51_ = _tmp50_ == NULL;
					_g_free0 (_tmp50_);
					if (_tmp51_) {
						g_warning ("Node.vala:203: %s", _ ("Text node with NULL string"));
						_g_object_unref0 (c);
						continue;
					}
					_tmp52_ = c;
					_tmp53_ = gxml_node_get_value (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = _tmp54_;
					_tmp56_ = gxml_document_create_text (doc, _tmp55_);
					_tmp57_ = _tmp56_;
					_g_free0 (_tmp55_);
					t = _tmp57_;
					_tmp58_ = gxml_node_get_children_nodes (node);
					_tmp59_ = _tmp58_;
					_tmp60_ = _tmp59_;
					_tmp61_ = t;
					gee_collection_add ((GeeCollection*) _tmp60_, _tmp61_);
					_g_object_unref0 (_tmp60_);
					_g_object_unref0 (t);
				}
				_g_object_unref0 (c);
			}
			_g_object_unref0 (_c_list);
		}
	}
	result = FALSE;
	return result;
}

GeeList*
gxml_node_get_namespaces (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_namespaces (self);
}

GeeBidirList*
gxml_node_get_children_nodes (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_children_nodes (self);
}

GeeMap*
gxml_node_get_attrs (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_attrs (self);
}

gchar*
gxml_node_get_name (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_name (self);
}

gchar*
gxml_node_get_value (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_value (self);
}

void
gxml_node_set_value (GXmlNode* self,
                     const gchar* value)
{
	g_return_if_fail (self != NULL);
	GXML_NODE_GET_INTERFACE (self)->set_value (self, value);
}

GXmlNodeType
gxml_node_get_type_node (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return GXML_NODE_GET_INTERFACE (self)->get_type_node (self);
}

GXmlDocument*
gxml_node_get_document (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_document (self);
}

GXmlNode*
gxml_node_get_parent (GXmlNode* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_NODE_GET_INTERFACE (self)->get_parent (self);
}

static void
gxml_node_default_init (GXmlNodeIface * iface,
                        gpointer iface_data)
{
	/**
	   * Collection of Namespaces applied to this {@link GXml.Node}.
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("namespaces", "namespaces", "namespaces", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Collection of {@link GXml.Node} as children.
	   *
	   * Depends on {@link GXml.Node} type, this children could be different, like,
	   * elements, element's contents or properties.
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("children-nodes", "children-nodes", "children-nodes", GEE_TYPE_BIDIR_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Attributes in this {@link GXml.Node}.
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("attrs", "attrs", "attrs", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Node's name. The meaning differs, depending on node's type.
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Node's value. The meaning differs, depending on node's type.
	   */
	g_object_interface_install_property (iface, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Node's type as a enumeration.
	   */
	g_object_interface_install_property (iface, g_param_spec_enum ("type-node", "type-node", "type-node", GXML_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Node's XML document holding this node.
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("document", "document", "document", GXML_TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Node's XML document holding this node.
	   */
	g_object_interface_install_property (iface, g_param_spec_object ("parent", "parent", "parent", GXML_TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	iface->get = gxml_node_real_get;
	iface->get_elements_by_property_value = gxml_node_real_get_elements_by_property_value;
	iface->get_elements_by_name = gxml_node_real_get_elements_by_name;
	iface->get_elements_by_name_ns = gxml_node_real_get_elements_by_name_ns;
	iface->ns_prefix = gxml_node_real_ns_prefix;
	iface->ns_uri = gxml_node_real_ns_uri;
}

/**
 * Base interface providing basic functionalities for DOM1 interfaces.
 */
GType
gxml_node_get_type (void)
{
	static volatile gsize gxml_node_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_node_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_node_type_id;
		gxml_node_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlNode", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_node_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_node_type_id__volatile, gxml_node_type_id);
	}
	return gxml_node_type_id__volatile;
}

GXmlNode*
gxml_node_list_get (GXmlNodeList* self,
                    gint index)
{
	GXmlNode* result = NULL;
	gpointer _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = GEE_ABSTRACT_LIST_CLASS (gxml_node_list_parent_class)->get ((GeeAbstractList*) G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_ARRAY_LIST, GeeArrayList), index);
	result = (GXmlNode*) _tmp0_;
	return result;
}

GXmlNode**
gxml_node_list_to_array (GXmlNodeList* self,
                         gint* result_length1)
{
	GXmlNode** result = NULL;
	gint _tmp0_ = 0;
	gpointer* _tmp1_;
	GXmlNode** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = gee_collection_to_array (G_TYPE_CHECK_INSTANCE_CAST (self, GEE_TYPE_COLLECTION, GeeCollection), &_tmp0_);
	_tmp2_ = (GXmlNode**) _tmp1_;
	_tmp2__length1 = (_tmp0_ * sizeof (GXmlNode*)) / sizeof (GXmlNode*);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

GXmlNodeList*
gxml_node_list_construct (GType object_type)
{
	GXmlNodeList * self = NULL;
	self = (GXmlNodeList*) gee_array_list_construct (object_type, GXML_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	return self;
}

GXmlNodeList*
gxml_node_list_new (void)
{
	return gxml_node_list_construct (GXML_TYPE_NODE_LIST);
}

static void
gxml_node_list_class_init (GXmlNodeListClass * klass,
                           gpointer klass_data)
{
	gxml_node_list_parent_class = g_type_class_peek_parent (klass);
}

static void
gxml_node_list_instance_init (GXmlNodeList * self,
                              gpointer klass)
{
}

/**
 * Convenient class for a list of {@link GXml.Node} objects based on
 * {@link Gee.ArrayList}, with good support for bindings.
 */
GType
gxml_node_list_get_type (void)
{
	static volatile gsize gxml_node_list_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_node_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlNodeListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_node_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GXmlNodeList), 0, (GInstanceInitFunc) gxml_node_list_instance_init, NULL };
		GType gxml_node_list_type_id;
		gxml_node_list_type_id = g_type_register_static (GEE_TYPE_ARRAY_LIST, "GXmlNodeList", &g_define_type_info, 0);
		g_once_init_leave (&gxml_node_list_type_id__volatile, gxml_node_list_type_id);
	}
	return gxml_node_list_type_id__volatile;
}

