/* SerializableProperty.c generated by valac 0.44.3, the Vala compiler
 * generated from SerializableProperty.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/* SerializableProperty.vala
 *
 * Copyright (C) 2015  Daniel Espinosa <esodan@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *      Daniel Espinosa <esodan@gmail.com>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#define GXML_TYPE_SERIALIZABLE_PROPERTY (gxml_serializable_property_get_type ())
#define GXML_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializableProperty))
#define GXML_IS_SERIALIZABLE_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY))
#define GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_SERIALIZABLE_PROPERTY, GXmlSerializablePropertyIface))

typedef struct _GXmlSerializableProperty GXmlSerializableProperty;
typedef struct _GXmlSerializablePropertyIface GXmlSerializablePropertyIface;

#define GXML_TYPE_NODE (gxml_node_get_type ())
#define GXML_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NODE, GXmlNode))
#define GXML_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NODE))
#define GXML_NODE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NODE, GXmlNodeIface))

typedef struct _GXmlNode GXmlNode;
typedef struct _GXmlNodeIface GXmlNodeIface;

#define GXML_TYPE_ELEMENT_LIST (gxml_element_list_get_type ())
#define GXML_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementList))
#define GXML_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))
#define GXML_IS_ELEMENT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT_LIST))
#define GXML_IS_ELEMENT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GXML_TYPE_ELEMENT_LIST))
#define GXML_ELEMENT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GXML_TYPE_ELEMENT_LIST, GXmlElementListClass))

typedef struct _GXmlElementList GXmlElementList;
typedef struct _GXmlElementListClass GXmlElementListClass;

#define GXML_TYPE_NAMESPACE (gxml_namespace_get_type ())
#define GXML_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_NAMESPACE, GXmlNamespace))
#define GXML_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_NAMESPACE))
#define GXML_NAMESPACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_NAMESPACE, GXmlNamespaceIface))

typedef struct _GXmlNamespace GXmlNamespace;
typedef struct _GXmlNamespaceIface GXmlNamespaceIface;
typedef enum  {
	GXML_NODE_TYPE_INVALID = 0,
	GXML_NODE_TYPE_ELEMENT = 1,
	GXML_NODE_TYPE_ATTRIBUTE,
	GXML_NODE_TYPE_TEXT,
	GXML_NODE_TYPE_CDATA_SECTION,
	GXML_NODE_TYPE_ENTITY_REFERENCE,
	GXML_NODE_TYPE_ENTITY,
	GXML_NODE_TYPE_PROCESSING_INSTRUCTION,
	GXML_NODE_TYPE_COMMENT,
	GXML_NODE_TYPE_DOCUMENT,
	GXML_NODE_TYPE_DOCUMENT_TYPE,
	GXML_NODE_TYPE_DOCUMENT_FRAGMENT,
	GXML_NODE_TYPE_NOTATION
} GXmlNodeType;

#define GXML_TYPE_NODE_TYPE (gxml_node_type_get_type ())

#define GXML_TYPE_DOCUMENT (gxml_document_get_type ())
#define GXML_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_DOCUMENT, GXmlDocument))
#define GXML_IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_DOCUMENT))
#define GXML_DOCUMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_DOCUMENT, GXmlDocumentIface))

typedef struct _GXmlDocument GXmlDocument;
typedef struct _GXmlDocumentIface GXmlDocumentIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GXML_TYPE_ELEMENT (gxml_element_get_type ())
#define GXML_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ELEMENT, GXmlElement))
#define GXML_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ELEMENT))
#define GXML_ELEMENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ELEMENT, GXmlElementIface))

typedef struct _GXmlElement GXmlElement;
typedef struct _GXmlElementIface GXmlElementIface;

#define GXML_TYPE_ATTRIBUTE (gxml_attribute_get_type ())
#define GXML_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttribute))
#define GXML_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GXML_TYPE_ATTRIBUTE))
#define GXML_ATTRIBUTE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GXML_TYPE_ATTRIBUTE, GXmlAttributeIface))

typedef struct _GXmlAttribute GXmlAttribute;
typedef struct _GXmlAttributeIface GXmlAttributeIface;

struct _GXmlNamespaceIface {
	GTypeInterface parent_iface;
	gchar* (*get_uri) (GXmlNamespace* self);
	gchar* (*get_prefix) (GXmlNamespace* self);
};

struct _GXmlDocumentIface {
	GTypeInterface parent_iface;
	GXmlNode* (*create_element) (GXmlDocument* self, const gchar* name, GError** error);
	GXmlNode* (*create_text) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_comment) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_cdata) (GXmlDocument* self, const gchar* text);
	GXmlNode* (*create_pi) (GXmlDocument* self, const gchar* target, const gchar* data);
	gboolean (*save) (GXmlDocument* self, GCancellable* cancellable, GError** error);
	gboolean (*save_as) (GXmlDocument* self, GFile* f, GCancellable* cancellable, GError** error);
	gboolean (*get_indent) (GXmlDocument* self);
	void (*set_indent) (GXmlDocument* self, gboolean value);
	gboolean (*get_ns_top) (GXmlDocument* self);
	void (*set_ns_top) (GXmlDocument* self, gboolean value);
	gboolean (*get_prefix_default_ns) (GXmlDocument* self);
	void (*set_prefix_default_ns) (GXmlDocument* self, gboolean value);
	gboolean (*get_backup) (GXmlDocument* self);
	void (*set_backup) (GXmlDocument* self, gboolean value);
	GXmlNode* (*get_root) (GXmlDocument* self);
	GFile* (*get_file) (GXmlDocument* self);
	void (*set_file) (GXmlDocument* self, GFile* value);
};

struct _GXmlNodeIface {
	GTypeInterface parent_iface;
	GXmlNode* (*get) (GXmlNode* self, const gchar* key);
	GXmlElementList* (*get_elements_by_property_value) (GXmlNode* self, const gchar* property, const gchar* value);
	GXmlElementList* (*get_elements_by_name) (GXmlNode* self, const gchar* name);
	GXmlElementList* (*get_elements_by_name_ns) (GXmlNode* self, const gchar* name, const gchar* ns);
	gchar* (*to_string) (GXmlNode* self);
	gboolean (*set_namespace) (GXmlNode* self, const gchar* uri, const gchar* prefix);
	gchar* (*ns_prefix) (GXmlNode* self);
	gchar* (*ns_uri) (GXmlNode* self);
	GeeList* (*get_namespaces) (GXmlNode* self);
	GeeBidirList* (*get_children_nodes) (GXmlNode* self);
	GeeMap* (*get_attrs) (GXmlNode* self);
	gchar* (*get_name) (GXmlNode* self);
	gchar* (*get_value) (GXmlNode* self);
	void (*set_value) (GXmlNode* self, const gchar* value);
	GXmlNodeType (*get_type_node) (GXmlNode* self);
	GXmlDocument* (*get_document) (GXmlNode* self);
	GXmlNode* (*get_parent) (GXmlNode* self);
};

struct _GXmlSerializablePropertyIface {
	GTypeInterface parent_iface;
	gchar* (*get_serializable_property_value) (GXmlSerializableProperty* self);
	void (*set_serializable_property_value) (GXmlSerializableProperty* self, const gchar* val);
	gboolean (*deserialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
	GXmlNode* (*serialize_property) (GXmlSerializableProperty* self, GXmlNode* property_node, GParamSpec* prop, gboolean nick, GError** error);
};

struct _GXmlElementIface {
	GTypeInterface parent_iface;
	void (*normalize) (GXmlElement* self);
	void (*set_attr) (GXmlElement* self, const gchar* name, const gchar* value);
	GXmlNode* (*get_attr) (GXmlElement* self, const gchar* name);
	void (*remove_attr) (GXmlElement* self, const gchar* name);
	void (*remove_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	void (*set_ns_attr) (GXmlElement* self, const gchar* ns, const gchar* name, const gchar* value);
	GXmlNode* (*get_ns_attr) (GXmlElement* self, const gchar* name, const gchar* uri);
	gchar* (*get_tag_name) (GXmlElement* self);
	gchar* (*get_content) (GXmlElement* self);
	void (*set_content) (GXmlElement* self, const gchar* value);
};

struct _GXmlAttributeIface {
	GTypeInterface parent_iface;
	GXmlNamespace* (*get_namespace) (GXmlAttribute* self);
	void (*set_namespace) (GXmlAttribute* self, GXmlNamespace* value);
	gchar* (*get_prefix) (GXmlAttribute* self);
};

GType gxml_element_list_get_type (void) G_GNUC_CONST;
GType gxml_namespace_get_type (void) G_GNUC_CONST;
GType gxml_node_type_get_type (void) G_GNUC_CONST;
GType gxml_document_get_type (void) G_GNUC_CONST;
GType gxml_node_get_type (void) G_GNUC_CONST;
GType gxml_serializable_property_get_type (void) G_GNUC_CONST;
gchar* gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self);
void gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self,
                                                                 const gchar* val);
gboolean gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self,
                                                          GXmlNode* property_node,
                                                          GParamSpec* prop,
                                                          gboolean nick,
                                                          GError** error);
static gboolean gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self,
                                                               GXmlNode* property_node,
                                                               GParamSpec* prop,
                                                               gboolean nick,
                                                               GError** error);
gboolean gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self,
                                                                                        GXmlNode* property_node,
                                                                                        GParamSpec* prop,
                                                                                        gboolean nick,
                                                                                        GError** error);
GXmlNode* gxml_serializable_property_serialize_property (GXmlSerializableProperty* self,
                                                         GXmlNode* property_node,
                                                         GParamSpec* prop,
                                                         gboolean nick,
                                                         GError** error);
static GXmlNode* gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self,
                                                              GXmlNode* property_node,
                                                              GParamSpec* prop,
                                                              gboolean nick,
                                                              GError** error);
GXmlNode* gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self,
                                                                                       GXmlNode* element,
                                                                                       GParamSpec* prop,
                                                                                       gboolean nick,
                                                                                       GError** error);
GType gxml_element_get_type (void) G_GNUC_CONST;
void gxml_element_set_attr (GXmlElement* self,
                            const gchar* name,
                            const gchar* value);
GType gxml_attribute_get_type (void) G_GNUC_CONST;
gchar* gxml_node_get_name (GXmlNode* self);
gchar* gxml_node_get_value (GXmlNode* self);

/**
  * Value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  */
gchar*
gxml_serializable_property_get_serializable_property_value (GXmlSerializableProperty* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->get_serializable_property_value (self);
}

/**
  * Set value to be set to a {@link GXml.Attribute}, to be added to a {@link GXml.Element}
  *
  * If value is set to @null then the property will be ignored by default and no
  * property will be set to given {@link GXml.Element}.
  *
  * Some implementations stores the value without any convertion at all; then if the value,
  * from XML property, makes no sense for the property type, you should take care
  * to use the provided API from them to convert it.
  */
void
gxml_serializable_property_set_serializable_property_value (GXmlSerializableProperty* self,
                                                            const gchar* val)
{
	g_return_if_fail (self != NULL);
	GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->set_serializable_property_value (self, val);
}

/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name provided in @param prop or its nick if @nick is true,
   * if not set, then {@link GLib.ParamSpec} name should used. If @param nick is set to true,
   * then {@link GLib.ParamSpec} nick is used as name.
   */
static gboolean
gxml_serializable_property_real_deserialize_property (GXmlSerializableProperty* self,
                                                      GXmlNode* property_node,
                                                      GParamSpec* prop,
                                                      gboolean nick,
                                                      GError** error)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	_tmp0_ = gxml_serializable_property_default_serializable_property_deserialize_property (self, property_node, prop, nick, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_;
	return result;
}

gboolean
gxml_serializable_property_deserialize_property (GXmlSerializableProperty* self,
                                                 GXmlNode* property_node,
                                                 GParamSpec* prop,
                                                 gboolean nick,
                                                 GError** error)
{
	g_return_val_if_fail (self != NULL, FALSE);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->deserialize_property (self, property_node, prop, nick, error);
}

/**
   * Serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}, using {@link GLib.ParamSpec}
   * name or nick, if @param nick is set to true, as the attribute's name.
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} should not be modified.
   */
static GXmlNode*
gxml_serializable_property_real_serialize_property (GXmlSerializableProperty* self,
                                                    GXmlNode* property_node,
                                                    GParamSpec* prop,
                                                    gboolean nick,
                                                    GError** error)
{
	GXmlNode* result = NULL;
	GXmlNode* _tmp0_ = NULL;
	GXmlNode* _tmp1_;
	GXmlNode* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (property_node != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp1_ = gxml_serializable_property_default_serializable_property_serialize_property (self, property_node, prop, nick, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GXmlNode*
gxml_serializable_property_serialize_property (GXmlSerializableProperty* self,
                                               GXmlNode* property_node,
                                               GParamSpec* prop,
                                               gboolean nick,
                                               GError** error)
{
	g_return_val_if_fail (self != NULL, NULL);
	return GXML_SERIALIZABLE_PROPERTY_GET_INTERFACE (self)->serialize_property (self, property_node, prop, nick, error);
}

/**
   * Default serialization method to add a {@link GXml.Attribute} to a {@link GXml.Element}
   *
   * If {@link GXml.SerializableProperty.get_serializable_property_value} returns null
   * given {@link GXml.Node} is not modified.
   */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GXmlNode*
gxml_serializable_property_default_serializable_property_serialize_property (GXmlSerializableProperty* self,
                                                                             GXmlNode* element,
                                                                             GParamSpec* prop,
                                                                             gboolean nick,
                                                                             GError** error)
{
	GXmlNode* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* name = NULL;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GXmlNode* _tmp17_;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		GXmlNode* _tmp3_;
		_tmp3_ = _g_object_ref0 (element);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_strdup ("");
	name = _tmp4_;
	if (nick) {
		const gchar* _tmp7_;
		_tmp7_ = g_param_spec_get_nick (prop);
		_tmp6_ = _tmp7_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp8_;
		_tmp8_ = g_param_spec_get_nick (prop);
		_tmp5_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = g_param_spec_get_nick (prop);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (name);
		name = _tmp10_;
	} else {
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_param_spec_get_name (prop);
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (name);
		name = _tmp12_;
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (element, GXML_TYPE_ELEMENT)) {
		GXmlNode* _tmp13_;
		g_warning ("SerializableProperty.vala:92: %s", _ ("Trying to serialize to a non GXmlElement!"));
		_tmp13_ = _g_object_ref0 (element);
		result = _tmp13_;
		_g_free0 (name);
		return result;
	}
	_tmp14_ = name;
	_tmp15_ = gxml_serializable_property_get_serializable_property_value (self);
	_tmp16_ = _tmp15_;
	gxml_element_set_attr (G_TYPE_CHECK_INSTANCE_CAST (element, GXML_TYPE_ELEMENT, GXmlElement), _tmp14_, _tmp16_);
	_g_free0 (_tmp16_);
	_tmp17_ = _g_object_ref0 (element);
	result = _tmp17_;
	_g_free0 (name);
	return result;
}

/**
   * Tryies to deserialize from a {@link GXml.Node} searching a {@link GXml.Attribute}
   * with the name in @param prop or from its nick if @nick is true.
   */
gboolean
gxml_serializable_property_default_serializable_property_deserialize_property (GXmlSerializableProperty* self,
                                                                               GXmlNode* property_node,
                                                                               GParamSpec* prop,
                                                                               gboolean nick,
                                                                               GError** error)
{
	gboolean result = FALSE;
	GXmlAttribute* attr = NULL;
	GXmlAttribute* _tmp1_;
	GXmlAttribute* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* name = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	GXmlAttribute* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	g_return_val_if_fail (property_node != NULL, FALSE);
	g_return_val_if_fail (prop != NULL, FALSE);
	attr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (property_node, GXML_TYPE_ATTRIBUTE)) {
		GXmlAttribute* _tmp0_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (property_node, GXML_TYPE_ATTRIBUTE, GXmlAttribute));
		_g_object_unref0 (attr);
		attr = _tmp0_;
	}
	_tmp1_ = attr;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp2_ = attr;
	_tmp3_ = gxml_node_get_name ((GXmlNode*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ == NULL;
	_g_free0 (_tmp5_);
	if (_tmp6_) {
		const gchar* _tmp7_;
		_tmp7_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) self));
		g_warning (_ ("XML Attribute name is not set, when deserializing to: %s"), _tmp7_);
		result = FALSE;
		_g_object_unref0 (attr);
		return result;
	}
	_tmp8_ = g_strdup ("");
	name = _tmp8_;
	if (nick) {
		const gchar* _tmp11_;
		_tmp11_ = g_param_spec_get_nick (prop);
		_tmp10_ = _tmp11_ != NULL;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp12_;
		_tmp12_ = g_param_spec_get_nick (prop);
		_tmp9_ = g_strcmp0 (_tmp12_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = g_param_spec_get_nick (prop);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (name);
		name = _tmp14_;
	} else {
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = g_param_spec_get_name (prop);
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (name);
		name = _tmp16_;
	}
	_tmp17_ = attr;
	_tmp18_ = gxml_node_get_name ((GXmlNode*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
	_tmp22_ = _tmp21_;
	_tmp23_ = name;
	_tmp24_ = g_utf8_strdown (_tmp23_, (gssize) -1);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strcmp0 (_tmp22_, _tmp25_) == 0;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
	if (_tmp26_) {
		GXmlAttribute* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = attr;
		_tmp28_ = gxml_node_get_value ((GXmlNode*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		gxml_serializable_property_set_serializable_property_value (self, _tmp30_);
		_g_free0 (_tmp30_);
	}
	result = TRUE;
	_g_free0 (name);
	_g_object_unref0 (attr);
	return result;
}

static void
gxml_serializable_property_default_init (GXmlSerializablePropertyIface * iface,
                                         gpointer iface_data)
{
	iface->deserialize_property = gxml_serializable_property_real_deserialize_property;
	iface->serialize_property = gxml_serializable_property_real_serialize_property;
}

/**
 * Represent any property to be added as a {@link GXml.Attribute} to a {@link GXml.Element}
 *
 * The actual value stored and returned by {@link GXml.SerializableProperty.get_serializable_property_value}
 * is the actual string in the XML property, this means may the value could differ from the spected value
 * on some implementations like {@link GXml.SerializableInt}. Take a look in each implementations about
 * retured values.
 *
 * Implementations of {@link GXml.SerializableProperty}, could be used to provide more flexibility
 * when parsing {@link GXml.Attribute} properties values and to exclude to be serialized if they have not
 * been created in the holding objects.
 */
GType
gxml_serializable_property_get_type (void)
{
	static volatile gsize gxml_serializable_property_type_id__volatile = 0;
	if (g_once_init_enter (&gxml_serializable_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GXmlSerializablePropertyIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gxml_serializable_property_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gxml_serializable_property_type_id;
		gxml_serializable_property_type_id = g_type_register_static (G_TYPE_INTERFACE, "GXmlSerializableProperty", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gxml_serializable_property_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gxml_serializable_property_type_id__volatile, gxml_serializable_property_type_id);
	}
	return gxml_serializable_property_type_id__volatile;
}

