/* build_tools_preferences.c generated by valac 0.21.1.31-3473e, the Vala compiler
 * generated from build_tools_preferences.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The preferences of the default and personal build tools.*/
/* For the configuration of a single build tool, see build_tool_dialog.vala.*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _BuildToolsPreferencesPrivate BuildToolsPreferencesPrivate;

#define BUILD_TOOLS_PREFERENCES_TYPE_BUILD_TOOL_COLUMN (build_tools_preferences_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block4Data Block4Data;

#define TYPE_BUILD_TOOLS (build_tools_get_type ())
#define BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS, BuildTools))
#define BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS, BuildToolsClass))
#define IS_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS))
#define IS_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS))
#define BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS, BuildToolsClass))

typedef struct _BuildTools BuildTools;
typedef struct _BuildToolsClass BuildToolsClass;

#define TYPE_DEFAULT_BUILD_TOOLS (default_build_tools_get_type ())
#define DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildTools))
#define DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))
#define IS_DEFAULT_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_BUILD_TOOLS))
#define IS_DEFAULT_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_BUILD_TOOLS))
#define DEFAULT_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_BUILD_TOOLS, DefaultBuildToolsClass))

typedef struct _DefaultBuildTools DefaultBuildTools;
typedef struct _DefaultBuildToolsClass DefaultBuildToolsClass;

#define TYPE_PERSONAL_BUILD_TOOLS (personal_build_tools_get_type ())
#define PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildTools))
#define PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))
#define IS_PERSONAL_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PERSONAL_BUILD_TOOLS))
#define IS_PERSONAL_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PERSONAL_BUILD_TOOLS))
#define PERSONAL_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PERSONAL_BUILD_TOOLS, PersonalBuildToolsClass))

typedef struct _PersonalBuildTools PersonalBuildTools;
typedef struct _PersonalBuildToolsClass PersonalBuildToolsClass;
typedef struct _Block5Data Block5Data;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define TYPE_BUILD_TOOL (build_tool_get_type ())

#define TYPE_BUILD_JOB (build_job_get_type ())

#define TYPE_POST_PROCESSOR_TYPE (post_processor_type_get_type ())
typedef struct _BuildJob BuildJob;
typedef struct _BuildTool BuildTool;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _build_tool_free0(var) ((var == NULL) ? NULL : (var = (build_tool_free (var), NULL)))

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _Block8Data Block8Data;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _BuildToolsPreferences {
	GObject parent_instance;
	BuildToolsPreferencesPrivate * priv;
};

struct _BuildToolsPreferencesClass {
	GObjectClass parent_class;
};

struct _BuildToolsPreferencesPrivate {
	GtkDialog* _dialog;
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	GtkTreeView* _default_view;
	GtkTreeView* _personal_view;
};

typedef enum  {
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS
} BuildToolsPreferencesBuildToolColumn;

struct _Block4Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkTreeSelection* default_select;
	GtkTreeSelection* personal_select;
};

struct _Block5Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkTreeViewColumn* label_column;
	GtkListStore* store;
	BuildTools* build_tools;
};

struct _Block6Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkTreeView* view;
	BuildTools* build_tools;
};

struct _Block7Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkTreeView* view;
	BuildTools* build_tools;
};

typedef enum  {
	POST_PROCESSOR_TYPE_ALL_OUTPUT = 0,
	POST_PROCESSOR_TYPE_LATEX,
	POST_PROCESSOR_TYPE_LATEXMK,
	POST_PROCESSOR_TYPE_NO_OUTPUT,
	POST_PROCESSOR_TYPE_N_POST_PROCESSORS
} PostProcessorType;

struct _BuildJob {
	PostProcessorType post_processor;
	gchar* command;
};

struct _BuildTool {
	gchar* _description;
	gchar* extensions;
	gchar* label;
	gchar* icon;
	gchar* files_to_open;
	gboolean enabled;
	GeeArrayList* jobs;
	gint id;
};

struct _Block8Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block9Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

struct _Block10Data {
	int _ref_count_;
	BuildToolsPreferences * self;
	GtkTreeSelection* select;
	GtkWidget* widget;
};


static gpointer build_tools_preferences_parent_class = NULL;

GType build_tools_preferences_get_type (void) G_GNUC_CONST;
#define BUILD_TOOLS_PREFERENCES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesPrivate))
enum  {
	BUILD_TOOLS_PREFERENCES_DUMMY_PROPERTY
};
static GType build_tools_preferences_build_tool_column_get_type (void) G_GNUC_UNUSED;
GType main_window_get_type (void) G_GNUC_CONST;
BuildToolsPreferences* build_tools_preferences_new (MainWindow* main_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type, MainWindow* main_window);
static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_default_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self);
static void build_tools_preferences_init_views (BuildToolsPreferences* self);
static GtkGrid* build_tools_preferences_get_default_grid (BuildToolsPreferences* self);
static GtkGrid* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
GType build_tools_get_type (void) G_GNUC_CONST;
static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, BuildTools* build_tools);
GType default_build_tools_get_type (void) G_GNUC_CONST;
DefaultBuildTools* default_build_tools_get_default (void);
GType personal_build_tools_get_type (void) G_GNUC_CONST;
PersonalBuildTools* personal_build_tools_get_default (void);
static void __lambda65_ (Block4Data* _data4_);
static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select);
static void ___lambda65__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda66_ (Block4Data* _data4_);
static void ___lambda66__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, BuildTools* build_tools);
static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, BuildTools* build_tools);
static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar);
GtkGrid* utils_get_dialog_component (const gchar* title, GtkWidget* widget);
static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda54_ (Block5Data* _data5_, const gchar* path_string);
void build_tools_set_enabled (BuildTools* self, gint tool_num, gboolean enabled);
static void ___lambda54__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self);
static void __lambda55_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column);
static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, BuildTools* build_tools, gint build_tool_num);
static void ___lambda55__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget);
static void __lambda68_ (Block6Data* _data6_);
gint utils_get_selected_row (GtkTreeView* view, GtkTreeIter* iter);
static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda69_ (Block7Data* _data7_);
GType build_tool_get_type (void) G_GNUC_CONST;
GType build_job_get_type (void) G_GNUC_CONST;
GType post_processor_type_get_type (void) G_GNUC_CONST;
BuildJob* build_job_dup (const BuildJob* self);
void build_job_free (BuildJob* self);
void build_job_copy (const BuildJob* self, BuildJob* dest);
void build_job_destroy (BuildJob* self);
BuildTool* build_tool_dup (const BuildTool* self);
void build_tool_free (BuildTool* self);
void build_tool_copy (const BuildTool* self, BuildTool* dest);
void build_tool_destroy (BuildTool* self);
BuildTool* build_tools_get_build_tool (BuildTools* self, gint tool_num);
void personal_build_tools_add (PersonalBuildTools* self, BuildTool* tool);
static void ___lambda69__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda70_ (BuildToolsPreferences* self);
GType build_tool_dialog_get_type (void) G_GNUC_CONST;
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent);
BuildToolDialog* build_tool_dialog_construct (GType object_type, GtkWindow* parent);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void ___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void __lambda71_ (BuildToolsPreferences* self);
void personal_build_tools_delete (PersonalBuildTools* self, gint tool_num);
static void ___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda72_ (Block8Data* _data8_);
static void ___lambda72__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda73_ (Block8Data* _data8_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model, GtkTreeIter* iter);
void personal_build_tools_move_up (PersonalBuildTools* self, gint tool_num);
static void ___lambda73__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda74_ (Block9Data* _data9_);
static void ___lambda74__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void __lambda75_ (Block9Data* _data9_);
void personal_build_tools_move_down (PersonalBuildTools* self, gint tool_num);
static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, BuildTools* build_tools);
GeeIterator* build_tools_iterator (BuildTools* self);
gchar* build_tool_get_description (BuildTool *self);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self, BuildTools* build_tools, gint build_tool_num);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda67_ (Block10Data* _data10_);
static void ___lambda67__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self);
static void build_tools_preferences_finalize (GObject* obj);


static GType build_tools_preferences_build_tool_column_get_type (void) {
	static volatile gsize build_tools_preferences_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_build_tool_column_type_id__volatile)) {
		static const GEnumValue values[] = {{BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED", "enabled"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL", "label"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType build_tools_preferences_build_tool_column_type_id;
		build_tools_preferences_build_tool_column_type_id = g_enum_register_static ("BuildToolsPreferencesBuildToolColumn", values);
		g_once_init_leave (&build_tools_preferences_build_tool_column_type_id__volatile, build_tools_preferences_build_tool_column_type_id);
	}
	return build_tools_preferences_build_tool_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BuildToolsPreferences* build_tools_preferences_construct (GType object_type, MainWindow* main_window) {
	BuildToolsPreferences * self = NULL;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkGrid* hgrid = NULL;
	GtkGrid* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	GtkGrid* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkBox* _tmp11_ = NULL;
	GtkBox* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GtkDialog* _tmp14_ = NULL;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (BuildToolsPreferences*) g_object_new (object_type, NULL);
	_tmp0_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_default_store);
	self->priv->_default_store = _tmp0_;
	_tmp1_ = build_tools_preferences_get_new_store (self);
	_g_object_unref0 (self->priv->_personal_store);
	self->priv->_personal_store = _tmp1_;
	build_tools_preferences_update_default_store (self);
	build_tools_preferences_update_personal_store (self);
	build_tools_preferences_init_views (self);
	_tmp2_ = _ ("Build Tools");
	_tmp3_ = main_window;
	_tmp4_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp2_, (GtkWindow*) _tmp3_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_dialog);
	self->priv->_dialog = _tmp4_;
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp5_);
	hgrid = _tmp5_;
	gtk_orientable_set_orientation ((GtkOrientable*) hgrid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (hgrid, (guint) 10);
	_tmp6_ = build_tools_preferences_get_default_grid (self);
	_tmp7_ = _tmp6_;
	gtk_container_add ((GtkContainer*) hgrid, (GtkWidget*) _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = build_tools_preferences_get_personal_grid (self);
	_tmp9_ = _tmp8_;
	gtk_container_add ((GtkContainer*) hgrid, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_dialog;
	_tmp11_ = (GtkBox*) gtk_dialog_get_content_area (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	content_area = _tmp12_;
	gtk_box_pack_start (content_area, (GtkWidget*) hgrid, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) content_area);
	_tmp13_ = self->priv->_dialog;
	gtk_dialog_run (_tmp13_);
	_tmp14_ = self->priv->_dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp14_);
	_g_object_unref0 (content_area);
	_g_object_unref0 (hgrid);
	return self;
}


BuildToolsPreferences* build_tools_preferences_new (MainWindow* main_window) {
	return build_tools_preferences_construct (TYPE_BUILD_TOOLS_PREFERENCES, main_window);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->personal_select);
		_g_object_unref0 (_data4_->default_select);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void __lambda65_ (Block4Data* _data4_) {
	BuildToolsPreferences * self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->default_select, _data4_->personal_select);
}


static void ___lambda65__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda65_ (self);
}


static void __lambda66_ (Block4Data* _data4_) {
	BuildToolsPreferences * self;
	self = _data4_->self;
	build_tools_preferences_on_view_selection_changed (self, _data4_->personal_select, _data4_->default_select);
}


static void ___lambda66__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda66_ (self);
}


static void build_tools_preferences_init_views (BuildToolsPreferences* self) {
	Block4Data* _data4_;
	GtkListStore* _tmp0_ = NULL;
	DefaultBuildTools* _tmp1_ = NULL;
	DefaultBuildTools* _tmp2_ = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkListStore* _tmp4_ = NULL;
	PersonalBuildTools* _tmp5_ = NULL;
	PersonalBuildTools* _tmp6_ = NULL;
	GtkTreeView* _tmp7_ = NULL;
	GtkTreeView* _tmp8_ = NULL;
	GtkTreeSelection* _tmp9_ = NULL;
	GtkTreeSelection* _tmp10_ = NULL;
	GtkTreeView* _tmp11_ = NULL;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeSelection* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = default_build_tools_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = build_tools_preferences_get_new_view (self, _tmp0_, (BuildTools*) _tmp2_);
	_g_object_unref0 (self->priv->_default_view);
	self->priv->_default_view = _tmp3_;
	_g_object_unref0 (_tmp2_);
	_tmp4_ = self->priv->_personal_store;
	_tmp5_ = personal_build_tools_get_default ();
	_tmp6_ = _tmp5_;
	_tmp7_ = build_tools_preferences_get_new_view (self, _tmp4_, (BuildTools*) _tmp6_);
	_g_object_unref0 (self->priv->_personal_view);
	self->priv->_personal_view = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp8_ = self->priv->_default_view;
	_tmp9_ = gtk_tree_view_get_selection (_tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_data4_->default_select = _tmp10_;
	_tmp11_ = self->priv->_personal_view;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_data4_->personal_select = _tmp13_;
	g_signal_connect_data (_data4_->default_select, "changed", (GCallback) ___lambda65__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	g_signal_connect_data (_data4_->personal_select, "changed", (GCallback) ___lambda66__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}


static GtkGrid* build_tools_preferences_get_default_grid (BuildToolsPreferences* self) {
	GtkGrid* result = NULL;
	BuildTools* default_build_tools = NULL;
	DefaultBuildTools* _tmp0_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkToolButton* _tmp2_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp5_ = NULL;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp6_ = NULL;
	GtkWidget* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GtkGrid* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = default_build_tools_get_default ();
	default_build_tools = (BuildTools*) _tmp0_;
	_tmp1_ = self->priv->_default_view;
	_tmp2_ = build_tools_preferences_get_properties_button (self, _tmp1_, default_build_tools);
	properties_button = _tmp2_;
	_tmp3_ = self->priv->_default_view;
	_tmp4_ = build_tools_preferences_get_copy_button (self, _tmp3_, default_build_tools);
	copy_button = _tmp4_;
	_tmp5_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp5_);
	toolbar = _tmp5_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp6_ = self->priv->_default_view;
	_tmp7_ = build_tools_preferences_join_view_and_toolbar (self, _tmp6_, toolbar);
	join = _tmp7_;
	_tmp8_ = _ ("Default build tools");
	_tmp9_ = utils_get_dialog_component (_tmp8_, join);
	result = _tmp9_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (default_build_tools);
	return result;
}


static GtkGrid* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self) {
	GtkGrid* result = NULL;
	BuildTools* personal_build_tools = NULL;
	PersonalBuildTools* _tmp0_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkToolButton* _tmp2_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp5_ = NULL;
	GtkToolButton* _tmp6_ = NULL;
	GtkToolButton* _tmp7_ = NULL;
	GtkToolButton* _tmp8_ = NULL;
	GtkToolButton* _tmp9_ = NULL;
	GtkToolButton* _tmp10_ = NULL;
	GtkToolButton* _tmp11_ = NULL;
	GtkToolButton* _tmp12_ = NULL;
	GtkToolButton* _tmp13_ = NULL;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp14_ = NULL;
	GtkWidget* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	GtkGrid* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = personal_build_tools_get_default ();
	personal_build_tools = (BuildTools*) _tmp0_;
	_tmp1_ = self->priv->_personal_view;
	_tmp2_ = build_tools_preferences_get_properties_button (self, _tmp1_, personal_build_tools);
	properties_button = _tmp2_;
	_tmp3_ = self->priv->_personal_view;
	_tmp4_ = build_tools_preferences_get_copy_button (self, _tmp3_, personal_build_tools);
	copy_button = _tmp4_;
	_tmp5_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp5_);
	toolbar = _tmp5_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
	_tmp6_ = build_tools_preferences_get_add_button (self);
	_tmp7_ = _tmp6_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp7_, -1);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = build_tools_preferences_get_remove_button (self);
	_tmp9_ = _tmp8_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp9_, -1);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = build_tools_preferences_get_up_button (self);
	_tmp11_ = _tmp10_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp11_, -1);
	_g_object_unref0 (_tmp11_);
	_tmp12_ = build_tools_preferences_get_down_button (self);
	_tmp13_ = _tmp12_;
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp13_, -1);
	_g_object_unref0 (_tmp13_);
	_tmp14_ = self->priv->_personal_view;
	_tmp15_ = build_tools_preferences_join_view_and_toolbar (self, _tmp14_, toolbar);
	join = _tmp15_;
	_tmp16_ = _ ("Personal build tools");
	_tmp17_ = utils_get_dialog_component (_tmp16_, join);
	result = _tmp17_;
	_g_object_unref0 (join);
	_g_object_unref0 (toolbar);
	_g_object_unref0 (copy_button);
	_g_object_unref0 (properties_button);
	_g_object_unref0 (personal_build_tools);
	return result;
}


static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self, GtkTreeView* view, GtkToolbar* toolbar) {
	GtkWidget* result = NULL;
	GtkTreeView* _tmp0_ = NULL;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp1_ = NULL;
	GtkScrolledWindow* _tmp2_ = NULL;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_ = NULL;
	GtkStyleContext* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	GtkToolbar* _tmp6_ = NULL;
	GtkToolbar* _tmp7_ = NULL;
	GtkToolbar* _tmp8_ = NULL;
	GtkStyleContext* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GtkStyleContext* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkBox* box = NULL;
	GtkBox* _tmp13_ = NULL;
	GtkToolbar* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (toolbar != NULL, NULL);
	_tmp0_ = view;
	g_object_set ((GtkWidget*) _tmp0_, "expand", TRUE, NULL);
	_tmp1_ = view;
	_tmp2_ = utils_add_scrollbar ((GtkWidget*) _tmp1_);
	scrolled_window = _tmp2_;
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 350, 200);
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) scrolled_window);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	context = _tmp4_;
	_tmp5_ = context;
	gtk_style_context_set_junction_sides (_tmp5_, GTK_JUNCTION_BOTTOM);
	_tmp6_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp6_, GTK_ICON_SIZE_MENU);
	_tmp7_ = toolbar;
	gtk_toolbar_set_style (_tmp7_, GTK_TOOLBAR_ICONS);
	_tmp8_ = toolbar;
	_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
	_tmp10_ = _g_object_ref0 (_tmp9_);
	_g_object_unref0 (context);
	context = _tmp10_;
	_tmp11_ = context;
	gtk_style_context_add_class (_tmp11_, GTK_STYLE_CLASS_INLINE_TOOLBAR);
	_tmp12_ = context;
	gtk_style_context_set_junction_sides (_tmp12_, GTK_JUNCTION_TOP);
	_tmp13_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp13_);
	box = _tmp13_;
	gtk_box_pack_start (box, (GtkWidget*) scrolled_window, TRUE, TRUE, (guint) 0);
	_tmp14_ = toolbar;
	gtk_box_pack_start (box, (GtkWidget*) _tmp14_, FALSE, TRUE, (guint) 0);
	result = (GtkWidget*) box;
	_g_object_unref0 (context);
	_g_object_unref0 (scrolled_window);
	return result;
}


static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self) {
	GtkListStore* result = NULL;
	GtkListStore* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
	result = _tmp0_;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->label_column);
		_g_object_unref0 (_data5_->store);
		_g_object_unref0 (_data5_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda54_ (Block5Data* _data5_, const gchar* path_string) {
	BuildToolsPreferences * self;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean enabled = FALSE;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkListStore* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	gboolean _tmp9_ = FALSE;
	gint num = 0;
	const gchar* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	BuildTools* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	self = _data5_->self;
	g_return_if_fail (path_string != NULL);
	_tmp0_ = _data5_->store;
	_tmp1_ = path_string;
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _tmp0_, &_tmp2_, _tmp1_);
	iter = _tmp2_;
	_tmp3_ = _data5_->store;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp3_) : NULL);
	model = _tmp4_;
	_tmp5_ = iter;
	gtk_tree_model_get (model, &_tmp5_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, &enabled, -1);
	_tmp6_ = enabled;
	enabled = !_tmp6_;
	_tmp7_ = _data5_->store;
	_tmp8_ = iter;
	_tmp9_ = enabled;
	gtk_list_store_set (_tmp7_, &_tmp8_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp9_, -1);
	_tmp10_ = path_string;
	_tmp11_ = atoi (_tmp10_);
	num = _tmp11_;
	_tmp12_ = _data5_->build_tools;
	_tmp13_ = enabled;
	build_tools_set_enabled (_tmp12_, num, _tmp13_);
	_g_object_unref0 (model);
}


static void ___lambda54__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender, const gchar* path, gpointer self) {
	__lambda54_ (self, path);
}


static void __lambda55_ (Block5Data* _data5_, GtkTreePath* path, GtkTreeViewColumn* column) {
	BuildToolsPreferences * self;
	GtkTreeViewColumn* _tmp0_ = NULL;
	self = _data5_->self;
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = column;
	if (_tmp0_ == _data5_->label_column) {
		gint build_tool_num = 0;
		GtkTreePath* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		BuildTools* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp1_ = path;
		_tmp3_ = gtk_tree_path_get_indices_with_depth (_tmp1_, &_tmp2_);
		_tmp4_ = _tmp3_[0];
		build_tool_num = _tmp4_;
		_tmp5_ = _data5_->build_tools;
		_tmp6_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp5_, _tmp6_);
	}
}


static void ___lambda55__gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	__lambda55_ (self, path, column);
}


static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self, GtkListStore* store, BuildTools* build_tools) {
	GtkTreeView* result = NULL;
	Block5Data* _data5_;
	GtkListStore* _tmp0_ = NULL;
	GtkListStore* _tmp1_ = NULL;
	BuildTools* _tmp2_ = NULL;
	BuildTools* _tmp3_ = NULL;
	GtkTreeView* view = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	GtkTreeViewColumn* enabled_column = NULL;
	GtkTreeViewColumn* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp8_ = NULL;
	GtkTreeViewColumn* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp11_ = NULL;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp12_ = NULL;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp13_ = NULL;
	GtkTreeSelection* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = store;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->store);
	_data5_->store = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->build_tools);
	_data5_->build_tools = _tmp3_;
	_tmp4_ = _data5_->store;
	_tmp5_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	view = _tmp5_;
	gtk_tree_view_set_rules_hint (view, TRUE);
	_tmp6_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp6_);
	enabled_column = _tmp6_;
	_tmp7_ = _ ("Enabled");
	gtk_tree_view_column_set_title (enabled_column, _tmp7_);
	gtk_tree_view_append_column (view, enabled_column);
	_tmp8_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp8_);
	toggle_renderer = _tmp8_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) enabled_column, (GtkCellRenderer*) toggle_renderer, FALSE);
	gtk_tree_view_column_set_attributes (enabled_column, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, NULL);
	_tmp9_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp9_);
	_data5_->label_column = _tmp9_;
	_tmp10_ = _ ("Label");
	gtk_tree_view_column_set_title (_data5_->label_column, _tmp10_);
	gtk_tree_view_append_column (view, _data5_->label_column);
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp11_);
	pixbuf_renderer = _tmp11_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "stock-id", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, NULL);
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	text_renderer = _tmp12_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, NULL);
	gtk_tree_view_set_tooltip_column (view, (gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION);
	_tmp13_ = gtk_tree_view_get_selection (view);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	select = _tmp14_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda54__gtk_cell_renderer_toggle_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (view, "row-activated", (GCallback) ___lambda55__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (toggle_renderer);
	_g_object_unref0 (enabled_column);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self, GtkTreeSelection* select, GtkTreeSelection* other_select) {
	GList* selected_items = NULL;
	GtkTreeSelection* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (select != NULL);
	g_return_if_fail (other_select != NULL);
	_tmp0_ = select;
	_tmp1_ = gtk_tree_selection_get_selected_rows (_tmp0_, NULL);
	selected_items = _tmp1_;
	_tmp2_ = selected_items;
	_tmp3_ = g_list_length (_tmp2_);
	if (_tmp3_ > ((guint) 0)) {
		GtkTreeSelection* _tmp4_ = NULL;
		_tmp4_ = other_select;
		gtk_tree_selection_unselect_all (_tmp4_);
	}
	__g_list_free__gtk_tree_path_free0_0 (selected_items);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->view);
		_g_object_unref0 (_data6_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda68_ (Block6Data* _data6_) {
	BuildToolsPreferences * self;
	gint build_tool_num = 0;
	GtkTreeView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = _data6_->self;
	_tmp0_ = _data6_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	build_tool_num = _tmp1_;
	_tmp2_ = build_tool_num;
	if (0 <= _tmp2_) {
		BuildTools* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		_tmp3_ = _data6_->build_tools;
		_tmp4_ = build_tool_num;
		build_tools_preferences_open_build_tool (self, _tmp3_, _tmp4_);
	}
}


static void ___lambda68__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda68_ (self);
}


static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self, GtkTreeView* view, BuildTools* build_tools) {
	GtkToolButton* result = NULL;
	Block6Data* _data6_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	BuildTools* _tmp2_ = NULL;
	BuildTools* _tmp3_ = NULL;
	GtkToolButton* properties_button = NULL;
	GtkToolButton* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data6_->view);
	_data6_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data6_->build_tools);
	_data6_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	properties_button = _tmp4_;
	gtk_tool_button_set_icon_name (properties_button, "document-properties-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) properties_button, "Edit the properties");
	_tmp5_ = _data6_->view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp5_, (GtkWidget*) properties_button);
	g_signal_connect_data (properties_button, "clicked", (GCallback) ___lambda68__gtk_tool_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	result = properties_button;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->view);
		_g_object_unref0 (_data7_->build_tools);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}


static void __lambda69_ (Block7Data* _data7_) {
	BuildToolsPreferences * self;
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	BuildTool* tool = NULL;
	BuildTools* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	BuildTool* _tmp5_ = NULL;
	BuildTool* _tmp6_ = NULL;
	BuildTool* _tmp7_ = NULL;
	BuildTool* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	BuildTool* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	PersonalBuildTools* personal_build_tools = NULL;
	PersonalBuildTools* _tmp13_ = NULL;
	PersonalBuildTools* _tmp14_ = NULL;
	BuildTool* _tmp15_ = NULL;
	BuildTool _tmp16_ = {0};
	self = _data7_->self;
	_tmp0_ = _data7_->view;
	_tmp1_ = utils_get_selected_row (_tmp0_, NULL);
	selected_row = _tmp1_;
	_tmp2_ = selected_row;
	if (_tmp2_ < 0) {
		return;
	}
	_tmp3_ = _data7_->build_tools;
	_tmp4_ = selected_row;
	_tmp5_ = build_tools_get_build_tool (_tmp3_, _tmp4_);
	tool = _tmp5_;
	_tmp6_ = tool;
	g_return_if_fail (_tmp6_ != NULL);
	_tmp7_ = tool;
	(*_tmp7_).enabled = FALSE;
	_tmp8_ = tool;
	_tmp9_ = _ ("%s [copy]");
	_tmp10_ = tool;
	_tmp11_ = (*_tmp10_).label;
	_tmp12_ = g_strdup_printf (_tmp9_, _tmp11_);
	_g_free0 ((*_tmp8_).label);
	(*_tmp8_).label = _tmp12_;
	_tmp13_ = personal_build_tools_get_default ();
	personal_build_tools = _tmp13_;
	_tmp14_ = personal_build_tools;
	_tmp15_ = tool;
	_tmp16_ = *_tmp15_;
	personal_build_tools_add (_tmp14_, &_tmp16_);
	build_tools_preferences_update_personal_store (self);
	_g_object_unref0 (personal_build_tools);
	_build_tool_free0 (tool);
}


static void ___lambda69__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda69_ (self);
}


static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self, GtkTreeView* view, BuildTools* build_tools) {
	GtkToolButton* result = NULL;
	Block7Data* _data7_;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeView* _tmp1_ = NULL;
	BuildTools* _tmp2_ = NULL;
	BuildTools* _tmp3_ = NULL;
	GtkToolButton* copy_button = NULL;
	GtkToolButton* _tmp4_ = NULL;
	GtkTreeView* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	g_return_val_if_fail (build_tools != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = view;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data7_->view);
	_data7_->view = _tmp1_;
	_tmp2_ = build_tools;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data7_->build_tools);
	_data7_->build_tools = _tmp3_;
	_tmp4_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp4_);
	copy_button = _tmp4_;
	gtk_tool_button_set_icon_name (copy_button, "edit-copy-symbolic");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) copy_button, "Create a copy");
	_tmp5_ = _data7_->view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp5_, (GtkWidget*) copy_button);
	g_signal_connect_data (copy_button, "clicked", (GCallback) ___lambda69__gtk_tool_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	result = copy_button;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


static void __lambda70_ (BuildToolsPreferences* self) {
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_ = NULL;
	BuildToolDialog* _tmp1_ = NULL;
	BuildToolDialog* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = build_tool_dialog_create_personal_build_tool (_tmp2_);
	if (_tmp3_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static void ___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda70_ (self);
}


static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	add_button = _tmp0_;
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
	_tmp1_ = _ ("Add...");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _tmp1_);
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda70__gtk_tool_button_clicked, self, 0);
	result = add_button;
	return result;
}


static void __lambda71_ (BuildToolsPreferences* self) {
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* label = NULL;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	GtkMessageDialog* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	GtkDialog* _tmp20_ = NULL;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ == (-1)) {
		return;
	}
	_tmp4_ = self->priv->_personal_store;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp4_) : NULL);
	model = _tmp5_;
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, &label, -1);
	_tmp8_ = self->priv->_dialog;
	_tmp9_ = _ ("Do you really want to delete the build tool \"%s\"?");
	_tmp10_ = label;
	_tmp11_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _tmp9_, _tmp10_);
	g_object_ref_sink (_tmp11_);
	dialog = (GtkDialog*) _tmp11_;
	_tmp12_ = dialog;
	gtk_dialog_add_buttons (_tmp12_, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_DELETE, GTK_RESPONSE_YES, NULL);
	_tmp13_ = dialog;
	_tmp14_ = gtk_dialog_run (_tmp13_);
	if (_tmp14_ == ((gint) GTK_RESPONSE_YES)) {
		GtkListStore* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		PersonalBuildTools* _tmp17_ = NULL;
		PersonalBuildTools* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		_tmp15_ = self->priv->_personal_store;
		_tmp16_ = iter;
		gtk_list_store_remove (_tmp15_, &_tmp16_);
		_tmp17_ = personal_build_tools_get_default ();
		_tmp18_ = _tmp17_;
		_tmp19_ = selected_row;
		personal_build_tools_delete (_tmp18_, _tmp19_);
		_g_object_unref0 (_tmp18_);
	}
	_tmp20_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp20_);
	_g_object_unref0 (dialog);
	_g_object_unref0 (model);
	_g_free0 (label);
}


static void ___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda71_ (self);
}


static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	GtkToolButton* remove_button = NULL;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	remove_button = _tmp0_;
	gtk_tool_button_set_icon_name (remove_button, "list-remove-symbolic");
	_tmp1_ = _ ("Remove");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) remove_button, _tmp1_);
	_tmp2_ = self->priv->_personal_view;
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp2_, (GtkWidget*) remove_button);
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda71__gtk_tool_button_clicked, self, 0);
	result = remove_button;
	return result;
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->up_button);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void __lambda72_ (Block8Data* _data8_) {
	BuildToolsPreferences * self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	self = _data8_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data8_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = row_num;
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, _tmp10_ > 0);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda72__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda72_ (self);
}


static void __lambda73_ (Block8Data* _data8_) {
	BuildToolsPreferences * self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data8_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ > 0) {
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_up = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp5_, &iter_up);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			PersonalBuildTools* _tmp10_ = NULL;
			PersonalBuildTools* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_up;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = personal_build_tools_get_default ();
			_tmp11_ = _tmp10_;
			_tmp12_ = selected_row;
			personal_build_tools_move_up (_tmp11_, _tmp12_);
			_g_object_unref0 (_tmp11_);
			g_signal_emit_by_name (_data8_->select, "changed");
		}
	}
}


static void ___lambda73__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda73_ (self);
}


static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block8Data* _data8_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data8_->up_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data8_->up_button, "go-up-symbolic");
	_tmp1_ = _ ("Move up");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data8_->up_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data8_->select = _tmp3_;
	g_signal_connect_data (_data8_->select, "changed", (GCallback) ___lambda72__gtk_tree_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_data (_data8_->up_button, "clicked", (GCallback) ___lambda73__gtk_tool_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data8_->up_button);
	result = _tmp4_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->down_button);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void __lambda74_ (Block9Data* _data9_) {
	BuildToolsPreferences * self;
	GList* selected_rows = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkTreePath* path_selected = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	GtkTreePath* _tmp5_ = NULL;
	gint row_num = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	gint nb_rows = 0;
	GtkTreeModel* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	self = _data9_->self;
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data9_->select, NULL);
	selected_rows = _tmp0_;
	_tmp1_ = selected_rows;
	_tmp2_ = g_list_length (_tmp1_);
	if (_tmp2_ == ((guint) 0)) {
		gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
		__g_list_free__gtk_tree_path_free0_0 (selected_rows);
		return;
	}
	_tmp3_ = selected_rows;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp4_);
	path_selected = _tmp5_;
	_tmp6_ = path_selected;
	_tmp8_ = gtk_tree_path_get_indices_with_depth (_tmp6_, &_tmp7_);
	_tmp9_ = _tmp8_[0];
	row_num = _tmp9_;
	_tmp10_ = self->priv->_personal_store;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, GTK_TYPE_TREE_MODEL) ? ((GtkTreeModel*) _tmp10_) : NULL);
	model = _tmp11_;
	_tmp12_ = model;
	_tmp13_ = gtk_tree_model_iter_n_children (_tmp12_, NULL);
	nb_rows = _tmp13_;
	_tmp14_ = row_num;
	_tmp15_ = nb_rows;
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, _tmp14_ < (_tmp15_ - 1));
	_g_object_unref0 (model);
	_gtk_tree_path_free0 (path_selected);
	__g_list_free__gtk_tree_path_free0_0 (selected_rows);
}


static void ___lambda74__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda74_ (self);
}


static void __lambda75_ (Block9Data* _data9_) {
	BuildToolsPreferences * self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	self = _data9_->self;
	_tmp0_ = self->priv->_personal_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	iter_selected = _tmp1_;
	selected_row = _tmp2_;
	_tmp3_ = selected_row;
	if (_tmp3_ >= 0) {
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp4_ = {0};
		GtkListStore* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = iter_selected;
		iter_down = _tmp4_;
		_tmp5_ = self->priv->_personal_store;
		_tmp6_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp5_, &iter_down);
		if (_tmp6_) {
			GtkListStore* _tmp7_ = NULL;
			GtkTreeIter _tmp8_ = {0};
			GtkTreeIter _tmp9_ = {0};
			PersonalBuildTools* _tmp10_ = NULL;
			PersonalBuildTools* _tmp11_ = NULL;
			gint _tmp12_ = 0;
			_tmp7_ = self->priv->_personal_store;
			_tmp8_ = iter_selected;
			_tmp9_ = iter_down;
			gtk_list_store_swap (_tmp7_, &_tmp8_, &_tmp9_);
			_tmp10_ = personal_build_tools_get_default ();
			_tmp11_ = _tmp10_;
			_tmp12_ = selected_row;
			personal_build_tools_move_down (_tmp11_, _tmp12_);
			_g_object_unref0 (_tmp11_);
			g_signal_emit_by_name (_data9_->select, "changed");
		}
	}
}


static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	__lambda75_ (self);
}


static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self) {
	GtkToolButton* result = NULL;
	Block9Data* _data9_;
	GtkToolButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkTreeView* _tmp2_ = NULL;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkToolButton* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_data9_->down_button = _tmp0_;
	gtk_tool_button_set_icon_name (_data9_->down_button, "go-down-symbolic");
	_tmp1_ = _ ("Move down");
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data9_->down_button, _tmp1_);
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
	_tmp2_ = self->priv->_personal_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_data9_->select = _tmp3_;
	g_signal_connect_data (_data9_->select, "changed", (GCallback) ___lambda74__gtk_tree_selection_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	g_signal_connect_data (_data9_->down_button, "clicked", (GCallback) ___lambda75__gtk_tool_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data9_->down_button);
	result = _tmp4_;
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}


static void build_tools_preferences_update_default_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_ = NULL;
	DefaultBuildTools* _tmp1_ = NULL;
	DefaultBuildTools* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_default_store;
	_tmp1_ = default_build_tools_get_default ();
	_tmp2_ = _tmp1_;
	build_tools_preferences_update_store (self, _tmp0_, (BuildTools*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self) {
	GtkListStore* _tmp0_ = NULL;
	PersonalBuildTools* _tmp1_ = NULL;
	PersonalBuildTools* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_personal_store;
	_tmp1_ = personal_build_tools_get_default ();
	_tmp2_ = _tmp1_;
	build_tools_preferences_update_store (self, _tmp0_, (BuildTools*) _tmp2_);
	_g_object_unref0 (_tmp2_);
}


static void build_tools_preferences_update_store (BuildToolsPreferences* self, GtkListStore* store, BuildTools* build_tools) {
	GtkListStore* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = store;
	gtk_list_store_clear (_tmp0_);
	{
		GeeIterator* _tool_it = NULL;
		BuildTools* _tmp1_ = NULL;
		GeeIterator* _tmp2_ = NULL;
		_tmp1_ = build_tools;
		_tmp2_ = build_tools_iterator (_tmp1_);
		_tool_it = _tmp2_;
		while (TRUE) {
			GeeIterator* _tmp3_ = NULL;
			gboolean _tmp4_ = FALSE;
			BuildTool tool = {0};
			GeeIterator* _tmp5_ = NULL;
			gpointer _tmp6_ = NULL;
			BuildTool* _tmp7_ = NULL;
			BuildTool _tmp8_ = {0};
			BuildTool _tmp9_ = {0};
			gchar* description = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp14_ = NULL;
			GtkTreeIter _tmp15_ = {0};
			GtkListStore* _tmp16_ = NULL;
			GtkTreeIter _tmp17_ = {0};
			BuildTool _tmp18_ = {0};
			gboolean _tmp19_ = FALSE;
			BuildTool _tmp20_ = {0};
			const gchar* _tmp21_ = NULL;
			BuildTool _tmp22_ = {0};
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			_tmp3_ = _tool_it;
			_tmp4_ = gee_iterator_next (_tmp3_);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = _tool_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			_tmp7_ = (BuildTool*) _tmp6_;
			build_tool_copy (_tmp7_, &_tmp8_);
			_tmp9_ = _tmp8_;
			_build_tool_free0 (_tmp7_);
			tool = _tmp9_;
			_tmp10_ = build_tool_get_description (&tool);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_markup_escape_text (_tmp11_, (gssize) (-1));
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			description = _tmp13_;
			_tmp14_ = store;
			gtk_list_store_append (_tmp14_, &_tmp15_);
			iter = _tmp15_;
			_tmp16_ = store;
			_tmp17_ = iter;
			_tmp18_ = tool;
			_tmp19_ = _tmp18_.enabled;
			_tmp20_ = tool;
			_tmp21_ = _tmp20_.icon;
			_tmp22_ = tool;
			_tmp23_ = _tmp22_.label;
			_tmp24_ = description;
			gtk_list_store_set (_tmp16_, &_tmp17_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp19_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, _tmp21_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, _tmp23_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp24_, -1);
			_g_free0 (description);
			build_tool_destroy (&tool);
		}
		_g_object_unref0 (_tool_it);
	}
}


static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self, BuildTools* build_tools, gint build_tool_num) {
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_ = NULL;
	BuildToolDialog* _tmp1_ = NULL;
	gboolean edited = FALSE;
	BuildToolDialog* _tmp2_ = NULL;
	BuildTools* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (build_tools != NULL);
	_tmp0_ = self->priv->_dialog;
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_);
	dialog = _tmp1_;
	_tmp2_ = dialog;
	_tmp3_ = build_tools;
	_tmp4_ = build_tool_num;
	_tmp5_ = build_tool_dialog_open_build_tool (_tmp2_, _tmp3_, _tmp4_);
	edited = _tmp5_;
	_tmp6_ = edited;
	if (_tmp6_) {
		build_tools_preferences_update_personal_store (self);
	}
	_g_object_unref0 (dialog);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		BuildToolsPreferences * self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda67_ (Block10Data* _data10_) {
	BuildToolsPreferences * self;
	gboolean row_selected = FALSE;
	gint _tmp0_ = 0;
	GtkWidget* _tmp1_ = NULL;
	self = _data10_->self;
	_tmp0_ = gtk_tree_selection_count_selected_rows (_data10_->select);
	row_selected = _tmp0_ > 0;
	_tmp1_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp1_, row_selected);
}


static void ___lambda67__gtk_tree_selection_changed (GtkTreeSelection* _sender, gpointer self) {
	__lambda67_ (self);
}


static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self, GtkTreeView* view, GtkWidget* widget) {
	Block10Data* _data10_;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkTreeView* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (view != NULL);
	g_return_if_fail (widget != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data10_->widget);
	_data10_->widget = _tmp1_;
	_tmp2_ = _data10_->widget;
	gtk_widget_set_sensitive (_tmp2_, FALSE);
	_tmp3_ = view;
	_tmp4_ = gtk_tree_view_get_selection (_tmp3_);
	_data10_->select = _tmp4_;
	g_signal_connect_data (_data10_->select, "changed", (GCallback) ___lambda67__gtk_tree_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void build_tools_preferences_class_init (BuildToolsPreferencesClass * klass) {
	build_tools_preferences_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BuildToolsPreferencesPrivate));
	G_OBJECT_CLASS (klass)->finalize = build_tools_preferences_finalize;
}


static void build_tools_preferences_instance_init (BuildToolsPreferences * self) {
	self->priv = BUILD_TOOLS_PREFERENCES_GET_PRIVATE (self);
}


static void build_tools_preferences_finalize (GObject* obj) {
	BuildToolsPreferences * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences);
	_g_object_unref0 (self->priv->_dialog);
	_g_object_unref0 (self->priv->_default_store);
	_g_object_unref0 (self->priv->_personal_store);
	_g_object_unref0 (self->priv->_default_view);
	_g_object_unref0 (self->priv->_personal_view);
	G_OBJECT_CLASS (build_tools_preferences_parent_class)->finalize (obj);
}


GType build_tools_preferences_get_type (void) {
	static volatile gsize build_tools_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BuildToolsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolsPreferences), 0, (GInstanceInitFunc) build_tools_preferences_instance_init, NULL };
		GType build_tools_preferences_type_id;
		build_tools_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolsPreferences", &g_define_type_info, 0);
		g_once_init_leave (&build_tools_preferences_type_id__volatile, build_tools_preferences_type_id);
	}
	return build_tools_preferences_type_id__volatile;
}



