// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_DATAPROXY_H
#define _LIBGDA_UIMM_DATAPROXY_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda-ui/gdaui-data-proxy.h>
#include <glibmm/interface.h>


// Gtk class forward declarations.
#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiDataProxy GdauiDataProxy;
typedef struct _GdauiDataProxyClass GdauiDataProxyClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class DataProxy_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gtk
{

class ActionGroup;

}

namespace Gnome
{

// Gnome::Gda class forward declarations.
namespace Gda
{

class DataProxy;

}

namespace GdaUI
{

/** @addtogroup libgda_uimmEnums libgda_uimm Enums and Flags */

/**
 * @ingroup libgda_uimmEnums
 */
enum Action
{
  ACTION_NEW_DATA,
  ACTION_WRITE_MODIFIED_DATA,
  ACTION_DELETE_SELECTED_DATA,
  ACTION_UNDELETE_SELECTED_DATA,
  ACTION_RESET_DATA,
  ACTION_MOVE_FIRST_RECORD,
  ACTION_MOVE_PREV_RECORD,
  ACTION_MOVE_NEXT_RECORD,
  ACTION_MOVE_LAST_RECORD,
  ACTION_MOVE_FIRST_CHUNCK,
  ACTION_MOVE_PREV_CHUNCK,
  ACTION_MOVE_NEXT_CHUNCK,
  ACTION_MOVE_LAST_CHUNCK
};

} // namespace GdaUI

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::GdaUI::Action> : public Glib::Value_Enum<Gnome::GdaUI::Action>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{

/**
 * @ingroup libgda_uimmEnums
 */
enum DataProxyWriteMode
{
  DATA_PROXY_WRITE_ON_DEMAND,
  DATA_PROXY_WRITE_ON_ROW_CHANGE,
  DATA_PROXY_WRITE_ON_VALUE_ACTIVATED,
  DATA_PROXY_WRITE_ON_VALUE_CHANGE
};

} // namespace GdaUI

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::GdaUI::DataProxyWriteMode> : public Glib::Value_Enum<Gnome::GdaUI::DataProxyWriteMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{


/** DataProxy - Modifying data in a Gome::Gda::DataModel.
 * The DataProxy interface is implemented by widgets which allow modifications
 * to a Gnome::Gda::DataModel  (through a Gnome::Gda::DataProxy  to actually
 * proxy the changes before they are written to the data model).
 */

class DataProxy :
  public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataProxy CppObjectType;
  typedef DataProxy_Class CppClassType;
  typedef GdauiDataProxy BaseObjectType;
  typedef GdauiDataProxyIface BaseClassType;

private:
  friend class DataProxy_Class;
  static CppClassType dataproxy_class_;

  // noncopyable
  DataProxy(const DataProxy&);
  DataProxy& operator=(const DataProxy&);

protected:
  DataProxy(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit DataProxy(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit DataProxy(GdauiDataProxy* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataProxy();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdauiDataProxy*       gobj()       { return reinterpret_cast<GdauiDataProxy*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdauiDataProxy* gobj() const { return reinterpret_cast<GdauiDataProxy*>(gobject_); }

private:


  // gmmproc thinks this function should be wrapped here, but it is wrapped in
  // DataProxyInfo.
  

public:
  
  /** Get a pointer to the Gda::DataProxy being used by @a iface
   * 
   * @newin{4,2}
   * @return A Gda::DataProxy pointer.
   */
  Glib::RefPtr<Gnome::Gda::DataProxy> get_proxy();
  
  /** Get a pointer to the Gda::DataProxy being used by @a iface
   * 
   * @newin{4,2}
   * @return A Gda::DataProxy pointer.
   */
  Glib::RefPtr<const Gnome::Gda::DataProxy> get_proxy() const;
  
  /** Each widget imlplementing the Gdaui::DataProxy interface provides actions. Actions can be triggered
   * using the perform_action() method, but using this method allows for the creation of
   * toolbars, menus, etc calling these actions.
   * 
   * The actions are among: 
   * <itemizedlist><listitem>Data edition actions: "ActionNew", "ActionCommit", 
   * "ActionDelete, "ActionUndelete, "ActionReset", </listitem>
   * <listitem>Record by record moving: "ActionFirstRecord", "ActionPrevRecord", 
   * "ActionNextRecord", "ActionLastRecord",</listitem>
   * <listitem>Chuncks of records moving: "ActionFirstChunck", "ActionPrevChunck", 
   * "ActionNextChunck", "ActionLastChunck".</listitem>
   * <listitem>Filtering: "ActionFilter"</listitem></itemizedlist>
   * 
   * @newin{4,2}
   * @return The Gtk::ActionGroup with all the possible actions on the widget.
   */
  Glib::RefPtr<Gtk::ActionGroup> get_actions_group();
  
  /** Each widget imlplementing the Gdaui::DataProxy interface provides actions. Actions can be triggered
   * using the perform_action() method, but using this method allows for the creation of
   * toolbars, menus, etc calling these actions.
   * 
   * The actions are among: 
   * <itemizedlist><listitem>Data edition actions: "ActionNew", "ActionCommit", 
   * "ActionDelete, "ActionUndelete, "ActionReset", </listitem>
   * <listitem>Record by record moving: "ActionFirstRecord", "ActionPrevRecord", 
   * "ActionNextRecord", "ActionLastRecord",</listitem>
   * <listitem>Chuncks of records moving: "ActionFirstChunck", "ActionPrevChunck", 
   * "ActionNextChunck", "ActionLastChunck".</listitem>
   * <listitem>Filtering: "ActionFilter"</listitem></itemizedlist>
   * 
   * @newin{4,2}
   * @return The Gtk::ActionGroup with all the possible actions on the widget.
   */
  Glib::RefPtr<const Gtk::ActionGroup> get_action_group() const;
  
  /** Forces the widget to perform the selected @a action, as if the user
   * had pressed on the corresponding action button in the @a iface widget,
   * if the corresponding action is possible and if the @a iface widget
   * supports the action.
   * 
   * @newin{4,2}
   * @param action A Gdaui::Action action.
   */
  void perform_action(Action action);
  
  /** Sets if the data entry in the @a iface widget at @a column (in the data model @a iface operates on)
   * can be edited or not.
   * 
   * @newin{4,2}
   * @param column Column number of the data.
   * @param editable Set to <tt>true</tt> to make the column editable.
   */
  void set_editable(int column, bool editable);
  
  /** Sets if the data entry in the @a iface widget at @a column (in the data model @a iface operates on) must show its
   * actions menu or not.
   * 
   * @newin{4,2}
   * @param column Column number of the data, or -1 to apply the setting to all the columns.
   * @param show_actions Set to <tt>true</tt> if the actions menu must be shown.
   */
  void show_actions(int column, bool show_actions);
  
  /** Specifies the way the modifications stored in the Gda::DataProxy used internally by @a iface are written back to
   * the Gda::DataModel which holds the data displayed in @a iface.
   * 
   * @newin{4,2}
   * @param mode The requested Gdaui::DataProxyWriteMode mode.
   * @return <tt>true</tt> if the proposed mode has been taken into account.
   */
  bool set_write_mode(DataProxyWriteMode mode);
  
  /** Get the way the modifications stored in the Gda::DataProxy used internally by @a iface are written back to
   * the Gda::DataModel which holds the data displayed in @a iface.
   * 
   * @newin{4,2}
   * @return The write mode used by @a iface.
   */
  DataProxyWriteMode get_write_mode() const;

 
  /**
   * @par Prototype:
   * <tt>void on_my_%proxy_changed(const Glib::RefPtr<Gnome::Gda::DataProxy>& proxy)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<Gnome::Gda::DataProxy>& > signal_proxy_changed();


    virtual Glib::RefPtr<Gnome::Gda::DataProxy> get_proxy_vfunc() const;

    virtual void set_editable_vfunc(int column, bool editable);

    virtual void show_actions_vfunc(int column, bool show_actions);

    virtual Glib::RefPtr<Gtk::ActionGroup> get_action_group_vfunc() const;

    virtual bool set_write_mode_vfunc(DataProxyWriteMode mode);


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_proxy_changed(const Glib::RefPtr<Gnome::Gda::DataProxy>& proxy);


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::DataProxy
   */
  Glib::RefPtr<Gnome::GdaUI::DataProxy> wrap(GdauiDataProxy* object, bool take_copy = false);

} // namespace Glib


#endif /* _LIBGDA_UIMM_DATAPROXY_H */

