// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDA_UIMM_LOGIN_H
#define _LIBGDA_UIMM_LOGIN_H


#include <glibmm.h>

/* libgda-uimm - a C++ wrapper for libgda-ui
 *
 * Copyright (c) 2010 libgda-uimm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgda/gda-config.h>
#include <libgda-ui/gdaui-login.h>
#include <gtkmm/box.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdauiLogin GdauiLogin;
typedef struct _GdauiLoginClass GdauiLoginClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{ class Login_Class; } // namespace GdaUI

} // namespace Gnome
namespace Gnome
{

// Gnome::Gda class forward declartions.
namespace Gda
{

}

namespace GdaUI
{

/** @addtogroup libgda_uimmEnums libgda_uimm Enums and Flags */

/**
 * @ingroup libgda_uimmEnums
 * @par Bitwise operators:
 * <tt>%LoginMode operator|(LoginMode, LoginMode)</tt><br>
 * <tt>%LoginMode operator&(LoginMode, LoginMode)</tt><br>
 * <tt>%LoginMode operator^(LoginMode, LoginMode)</tt><br>
 * <tt>%LoginMode operator~(LoginMode)</tt><br>
 * <tt>%LoginMode& operator|=(LoginMode&, LoginMode)</tt><br>
 * <tt>%LoginMode& operator&=(LoginMode&, LoginMode)</tt><br>
 * <tt>%LoginMode& operator^=(LoginMode&, LoginMode)</tt><br>
 */
enum LoginMode
{
  LOGIN_ENABLE_CONTROL_CENTRE_MODE = 1 << 0,
  LOGIN_HIDE_DSN_SELECTION_MODE = 1 << 1,
  LOGIN_HIDE_DIRECT_CONNECTION_MODE = 1 << 2
};

/** @ingroup libgda_uimmEnums */
inline LoginMode operator|(LoginMode lhs, LoginMode rhs)
  { return static_cast<LoginMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgda_uimmEnums */
inline LoginMode operator&(LoginMode lhs, LoginMode rhs)
  { return static_cast<LoginMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgda_uimmEnums */
inline LoginMode operator^(LoginMode lhs, LoginMode rhs)
  { return static_cast<LoginMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgda_uimmEnums */
inline LoginMode operator~(LoginMode flags)
  { return static_cast<LoginMode>(~static_cast<unsigned>(flags)); }

/** @ingroup libgda_uimmEnums */
inline LoginMode& operator|=(LoginMode& lhs, LoginMode rhs)
  { return (lhs = static_cast<LoginMode>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgda_uimmEnums */
inline LoginMode& operator&=(LoginMode& lhs, LoginMode rhs)
  { return (lhs = static_cast<LoginMode>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgda_uimmEnums */
inline LoginMode& operator^=(LoginMode& lhs, LoginMode rhs)
  { return (lhs = static_cast<LoginMode>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace GdaUI

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::GdaUI::LoginMode> : public Glib::Value_Flags<Gnome::GdaUI::LoginMode>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace GdaUI
{


/** Login - Connection opening dialog.
 * The Login widget can be used when the user needs to enter data to open a
 * connection. It can be customized in several ways:
 *
 *   - Data source (DSN) selection can be shown or hidden.
 *   - The button to launch the control center to declare new data sources can
 *   be shown or hidden.
 *   - The form to open a connection not using a DSN can be shown or hidden.
 */

class Login :
  public Gtk::Box
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Login CppObjectType;
  typedef Login_Class CppClassType;
  typedef GdauiLogin BaseObjectType;
  typedef GdauiLoginClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Login();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Login_Class;
  static CppClassType login_class_;

  // noncopyable
  Login(const Login&);
  Login& operator=(const Login&);

protected:
  explicit Login(const Glib::ConstructParams& construct_params);
  explicit Login(GdauiLogin* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdauiLogin*       gobj()       { return reinterpret_cast<GdauiLogin*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdauiLogin* gobj() const { return reinterpret_cast<GdauiLogin*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_changed(bool is_valid);


private:


public:
  
  /** Creates a new login widget which enables the user to specify connection parameters.
   * 
   * @newin{4,2}
   * @param dsn A data source name, or <tt>0</tt>.
   * @return A new widget.
   */

    explicit Login(const Glib::ustring& dsn);


public:
  
  /** Set how @a login operates
   * 
   * @newin{4,2}
   * @param mode A flag.
   */
  void set_mode(LoginMode mode);
  
  /** Get the information specified in @a login as a pointer to a (read-only) Gda::DsnInfo.
   * If the connection is not specified by a DSN, then the 'name' attribute of the returned
   * Gda::DsnInfo will be <tt>0</tt>, and otherwise it will contain the name of the selected DSN.
   * 
   * Retuns: (transfer none): a pointer to a (read-only) Gda::DsnInfo.
   * 
   * @newin{4,2}
   */
  const GdaDsnInfo* get_connection_information();
  
  /** Changes the information displayed in @a login, to represent @a dsn.
   * If @a login's mode has Gda::UI_LOGIN_HIDE_DSN_SELECTION_MODE, then
   * the DSN information is extracted and displayed in the direct login area.
   * 
   * If @a dsn is not a declared data source name, then a warning is shown and the result
   * is the same as having passed <tt>0</tt> for the @a dsn argument.
   * 
   * In any case @a login's mode (set by set_mode()) is not changed.
   * @param dsn A data source name, or <tt>0</tt>.
   */
  void set_dsn(const Glib::ustring& dsn);
  
  /** Changes the information displayed in @a login, to represent @a cinfo.
   * If @a login's mode has Gda::UI_LOGIN_HIDE_DIRECT_CONNECTION_MODE, then
   * if @a cinfo->name is not <tt>0</tt> it is displayed in the DSN selector, otherwise
   * a warning is shown and the result
   * is the same as having passed <tt>0</tt> for the @a cinfo argument.
   * 
   * In any case @a login's mode (set by set_mode()) is not changed.
   * @param cinfo A pointer to a structure representing the information to display.
   */
  void set_connection_information(const GdaDsnInfo * cinfo);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%changed(bool is_valid)</tt>
   */

  Glib::SignalProxy1< void,bool > signal_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_dsn() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_dsn() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<LoginMode> property_mode() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<LoginMode> property_mode() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<bool> property_valid() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


};

} // namespace GdaUI

} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::GdaUI::Login
   */
  Gnome::GdaUI::Login* wrap(GdauiLogin* object, bool take_copy = false);
} //namespace Glib


#endif /* _LIBGDA_UIMM_LOGIN_H */

