#include <libglademm/xml.h>
#include <gtkmm.h>
#include <iostream>

//This could be a member method (you might use get_widget_derived) instead,
//but I'm trying to keep this example simple. murrayc.
void on_menu_item_activated()
{
  std::cout << "menu item activated" << std::endl;
}

int main (int argc, char **argv)
{
  Gtk::Main kit(argc, argv);

  //Load the Glade file and instiate its widgets:
  Glib::RefPtr<Gnome::Glade::Xml> refXml;
  try
  {
    refXml = Gnome::Glade::Xml::create("example.glade");
  }
  catch(const Gnome::Glade::XmlError& ex)
  {
    std::cerr << ex.what() << std::endl;
    return 1;
  }

  //Get the Glade-instantiated Dialog:
  Gtk::Dialog* pDialog = 0;
  refXml->get_widget("DialogBasic", pDialog);
  if(pDialog)
  {
    //Get the Glade-instantiated Button, and connect a signal handler:
    Gtk::Button* pButton = 0;
    refXml->get_widget("quit_button", pButton);
    if(pButton)
      pButton->signal_clicked().connect(SigC::slot(*pDialog, &Gtk::Dialog::hide)); //hide() will cause main::run() to end.

    //Connect signal handlers for the menu items:

    Gtk::MenuItem* pMenuItem = 0;
    refXml->get_widget("menu_file_new", pMenuItem);
    if(pMenuItem)
      pMenuItem->signal_activate().connect( SigC::slot(&on_menu_item_activated) );

    refXml->get_widget("menu_file_save", pMenuItem);
    if(pMenuItem)
      pMenuItem->signal_activate().connect( SigC::slot(&on_menu_item_activated) );

    refXml->get_widget("menu_file_quit", pMenuItem);
    if(pMenuItem)
      pMenuItem->signal_activate().connect(SigC::slot(*pDialog, &Gtk::Dialog::hide)); //hide() will cause main::run() to end.

    kit.run(*pDialog);
  }

  return 0;
}

