//$Id: examplewindow.cc,v 1.2 2004/02/13 17:10:43 murrayc Exp $ -*- c++ -*-

/* gtkmm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow()
: m_bCheckBox(0)
{
  // Sets the border width of the window.
  set_border_width(10);

  //Get Glade UI:
  m_refGlade = Gnome::Glade::Xml::create("example.glade");
  m_refGlade->reparent_widget("vbox", *this);

  m_pVariablesMap = new Gnome::Glade::VariablesMap(m_refGlade);
  m_pVariablesMap->connect_widget("entry", m_strEntry);
  m_pVariablesMap->connect_widget("checkbox", m_bCheckBox);

  //Connect button's signal handler:
  Gtk::Button* pButton = 0;
  m_refGlade->get_widget("button", pButton);
  if(pButton)
    pButton->signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button_clicked) );

  show_all_children();
}

ExampleWindow::~ExampleWindow()
{
  if(m_pVariablesMap)
  {
    delete m_pVariablesMap;
    m_pVariablesMap = 0;
  }
}

void ExampleWindow::on_button_clicked()
{
  if(m_pVariablesMap)
    m_pVariablesMap->transfer_widgets_to_variables();

  std::cout << "Variable values: " << std::endl <<
    "  m_strEntry: " << m_strEntry << std::endl <<
    "  m_bCheckBox: " << (m_bCheckBox ? "true" : "false") << std::endl;
}
