/* GNOME-DB Configurator
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtklabel.h>
#include <gtk/gtknotebook.h>
#include <libgnomedb/gnome-db-config.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomedb/gnome-db-util.h>
#include "database-capplet.h"
#include "dsn-config.h"
#include "provider-config.h"

#define DSN_PAGE      "DSN_Page"
#define PROVIDER_PAGE "Provider_Page"

/*
 * Public functions
 */

GtkWidget *
database_capplet_new (void)
{
	GtkWidget *capplet;
	GtkWidget *dsn;
	GtkWidget *provider;

	capplet = gnome_db_new_notebook_widget ();

	/* data source configuration page */
	dsn = dsn_config_new ();
	g_object_set_data (G_OBJECT (capplet), DSN_PAGE, dsn);
	gtk_notebook_append_page (GTK_NOTEBOOK (capplet), dsn,
				  gtk_label_new (_("Data Sources")));

	/* providers configuration page */
	provider = provider_config_new ();
	g_object_set_data (G_OBJECT (capplet), PROVIDER_PAGE, provider);
	gtk_notebook_append_page (GTK_NOTEBOOK (capplet), provider,
				  gtk_label_new (_("Providers")));

	return capplet;
}
