/* GNOME-DB Components
 * Copyright (C) 2000-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkdialog.h>
#include <gtk/gtkstock.h>
#include <libgnomedb/libgnomedb.h>
#include <libgnomedb/db-shell.h>
#include <libgnomeui/gnome-client.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomeui/gnome-window-icon.h>
#include "database-capplet.h"

#include "../libgnomedb/gnome-db-window.h"

static void
druid_finished_cb (GnomeDbDsnConfigDruid *druid, gboolean error, gpointer user_data)
{
	const GdaDataSourceInfo *dsn_info;

	if (!error) {
		dsn_info = gnome_db_dsn_config_druid_get_dsn (druid);
		if (dsn_info) {
			gnome_db_config_save_data_source (dsn_info->name,
							  dsn_info->provider,
							  dsn_info->cnc_string,
							  dsn_info->description,
							  dsn_info->username,
							  dsn_info->password);
		}
		else
			gnome_db_show_error (_("No valid data source info was created"));
	}

	gtk_widget_destroy (GTK_WIDGET (user_data));
}

static void
edit_delete_cb (GtkWidget *shell, gpointer user_data)
{
	database_capplet_delete (GTK_WIDGET (user_data));
}

static void
edit_properties_cb (GtkWidget *shell, gpointer user_data)
{
	database_capplet_edit_properties (GTK_WIDGET (user_data));
}

static void
file_new_cb (GtkWidget *shell, gpointer user_data)
{
	GtkWidget *druid, *dialog;
	GdkPixbuf *icon;

	/* create the window to contain the druid */
	dialog = gtk_dialog_new_with_buttons (
		_("New data source"),
		GTK_WINDOW (shell),
		0, NULL);

	icon = gdk_pixbuf_new_from_file (LIBGNOMEDB_ICONSDIR "/gnome-db.png", NULL);
	if (icon) {
		gtk_window_set_icon (GTK_WINDOW (dialog), icon);
		g_object_unref (icon);
	}
	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);

	druid = gnome_db_dsn_config_druid_new ();
	g_signal_connect (G_OBJECT (druid), "finished",
			  G_CALLBACK (druid_finished_cb), dialog);
	gtk_widget_show (druid);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), druid, TRUE, TRUE, 0);

	/* run the dialog */
	gtk_widget_show (dialog);
}

static void
window_closed_cb (GnomeDbWindow *window, gpointer user_data)
{
	gnome_db_main_quit ();
}

static void
create_main_window (gpointer user_data)
{
	GtkWidget *window;
	GtkWidget *capplet;

	capplet = database_capplet_new ();
        gtk_container_set_border_width (GTK_CONTAINER (capplet), 6);

	/* create the dialog */
	window = db_shell_new (_("Database Properties"), capplet, NULL,
			       (DbShellCallbackFunc) file_new_cb,
			       (DbShellCallbackFunc) edit_delete_cb,
			       (DbShellCallbackFunc) edit_properties_cb,
			       capplet);
	gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);

	g_signal_connect (G_OBJECT (window), "close",
			  G_CALLBACK (window_closed_cb), NULL);
}

int
main (int argc, char *argv[])
{
	GnomeClient *session_client;

	bindtextdomain (GETTEXT_PACKAGE, LIBGNOMEDB_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	gnome_db_init ("gnome-database-properties", VERSION, argc, argv);

	/* session management */
	session_client = gnome_master_client ();
	gnome_client_set_restart_style (session_client, GNOME_RESTART_NEVER);

	/* application loop */
	gnome_db_main_run ((GdaInitFunc) create_main_window, NULL);

	return 0;
}
